/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.SaveSyntaxGenerator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.ISpssVarFormatter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class SortCasesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
IVarMoveHandler,
ListSelectionListener,
ActionListener,
FocusListener {
    private static final String SORT_CASES_ASCENDING_KEY = "IDS_ASCENDING";
    private static final String SORT_CASES_DESCENDING_KEY = "IDS_DESCENDING";
    private static final String ASCENDING_VARS_LOOKUP = "_ascending_vars";
    private static final String SORTED_DATA_FILE_NAME = "SORTED_DATA_FILE_NAME";
    private final String APPEND_ASCENDING = " -- " + this.getResString("IDS_ASCENDING");
    private final String APPEND_DESCENDING = " -- " + this.getResString("IDS_DESCENDING");
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton arrowButton;
    private JRadioButton mAscendingRadio;
    private JRadioButton mDescendingRadio;
    private SpssButtonGroup mButtonGroup;
    private SortListFormatter mFormatter;
    private JCheckBox mSaveSortedDataFileCheck;
    private FileTextField mNewDataFilePath;
    private JButton mDataFileBroweButton;
    private JCheckBox mCreateIndexCheck;
    private String mEncryptFilePassword = null;

    public SortCasesDlg(JFrame jFrame) {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SORT_CASES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_sort";
    }

    @Override
    public String generateSyntax() {
        PesFile pesFile;
        boolean bl;
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer(SyntaxUtil.startSyntax().toString());
        stringBuffer.append(SyntaxUtil.getMainCommand("SORT CASES BY"));
        int n2 = this.mTargetVarList.getModel().getSize();
        for (n = 0; n < n2; ++n) {
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(n);
            char c = this.mFormatter.getAscendingVars().contains(iSpssVariable) ? (char)'A' : 'D';
            object = " " + iSpssVariable.getName() + "(" + c + ")";
            stringBuffer.append((String)object);
        }
        n = this.mSaveSortedDataFileCheck.isSelected() ? 1 : 0;
        boolean bl2 = bl = this.mCreateIndexCheck.isEnabled() && this.mCreateIndexCheck.isSelected();
        if (n != 0) {
            PassEncrypt passEncrypt;
            String string;
            String string2;
            stringBuffer.append("\n  /OUTFILE=");
            stringBuffer.append(CharacterUtil.smartQuote((String)this.mNewDataFilePath.getText()));
            if (bl) {
                stringBuffer.append(" INDEX=YES");
                stringBuffer.append(" SIZE=DEFAULT");
            }
            if (this.mEncryptFilePassword != null && this.mEncryptFilePassword.length() > 0 && (string2 = SaveSyntaxGenerator.getEncryptFileSyntax((String)(string = new String((byte[])(object = (Object)(passEncrypt = new PassEncrypt()).encryptPrintableString(this.mEncryptFilePassword.getBytes(), "'\"")))), (boolean)true)) != null) {
                stringBuffer.append(string2);
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (n != 0 && (pesFile = PES_Repository.getPesFile((String)this.mNewDataFilePath.getText())) != null && (object = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "data_sort_cases";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableSaveSortedDataPanel();
        this.enableOkPaste(this.isSaveSortedDataOK());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableSaveSortedDataPanel();
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0 && this.isSaveSortedDataOK());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ISpssVariable iSpssVariable = (ISpssVariable)this.mTargetVarList.getSelectedValue();
        if (iSpssVariable != null) {
            this.mAscendingRadio.setEnabled(true);
            this.mDescendingRadio.setEnabled(true);
            if (this.mFormatter.getAscendingVars().contains(iSpssVariable)) {
                this.mAscendingRadio.setSelected(true);
                this.mDescendingRadio.setSelected(false);
            } else {
                this.mAscendingRadio.setSelected(false);
                this.mDescendingRadio.setSelected(true);
            }
        } else {
            this.mAscendingRadio.setEnabled(false);
            this.mDescendingRadio.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mDataFileBroweButton) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.DataWithEncryption, FileLocationsUtil.getDataFilesDirectoryPath(), true);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_SORT_SAVE_SORTED_DATA_DIALOG_TITLE"));
            String string = this.getResString("IDS_SORT_SAVE_SORTED_DATA_FILE_FILTER_EXTN");
            remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_SORT_SAVE_SORTED_DATA_FILE_FILTER"), string));
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            int n = remoteFileChooser.showSaveDialog((Component)((Object)this));
            if (n == 0) {
                String string2 = remoteFileChooser.getSelectedFilePath();
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                int n2 = string2.indexOf(string);
                if (n2 == -1) {
                    string2 = string2.concat(string);
                }
                this.mNewDataFilePath.setText(string2);
                this.mNewDataFilePath.setToolTipText(string2);
                this.mEncryptFilePassword = remoteFileChooser.isEncryptFileWithPassword() ? remoteFileChooser.getEncryptFilePassword() : null;
            }
            this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0 && this.isSaveSortedDataOK());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mButtonGroup.setSelected(this.mAscendingRadio.getModel(), true);
        this.mNewDataFilePath.setEnabled(false);
        this.mNewDataFilePath.setText("");
        this.mDataFileBroweButton.setEnabled(false);
        this.mSaveSortedDataFileCheck.setSelected(false);
        this.mSaveSortedDataFileCheck.setEnabled(false);
        this.mCreateIndexCheck.setSelected(false);
        this.mEncryptFilePassword = null;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableSaveSortedDataPanel();
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0 && this.isSaveSortedDataOK());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getSource();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (bl) {
            ISpssVariable[] iSpssVariableArray = this.mTargetVarList.getSelectedValues();
            if (object == this.mAscendingRadio) {
                this.mFormatter.getAscendingVars().addAll(Arrays.asList(iSpssVariableArray));
            } else if (object == this.mDescendingRadio) {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    this.mFormatter.getAscendingVars().remove(iSpssVariable);
                }
            }
            this.mTargetVarList.repaint();
        }
        this.enableSaveSortedDataPanel();
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0 && this.isSaveSortedDataOK());
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        boolean bl = true;
        if (this.mTargetVarList.getModel().getSize() + iSpssVariableArray.length > 64 && variableList instanceof TargetVariableList) {
            bl = false;
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("IDS_SORT_EXCEEDS_MAX_VARS"), VersionInfo.getAppVersionString());
        } else if (this.mAscendingRadio.isSelected()) {
            this.mFormatter.getAscendingVars().addAll(Arrays.asList(iSpssVariableArray));
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupLists(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mFormatter.setAscendingVarArray(this.getDialogDataModel().getVarArray(this.mTargetVarList.getIdentifier() + ASCENDING_VARS_LOOKUP));
        this.mSrcVarList.setSelectedIndex(0);
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0 && this.isSaveSortedDataOK());
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putVarArray(this.mTargetVarList.getIdentifier() + ASCENDING_VARS_LOOKUP, this.mFormatter.getAscendingVars().toArray(new ISpssVariable[this.mFormatter.getAscendingVars().size()]));
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        if (!FileValidator.validatePath((Component)((Object)this), this.mNewDataFilePath.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
            this.mNewDataFilePath.requestFocus();
            this.mNewDataFilePath.selectAll();
            return false;
        }
        return true;
    }

    private void setupLists(JPanel jPanel) {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectionMode(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SORT_CASES_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets);
        this.mVarMoveHandler = this;
        this.arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.arrowButton.setVarMoveHandler(this.mVarMoveHandler);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.arrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SORT_BY");
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setIdentifier("SortCasesTargetList");
        this.mTargetVarList.setSelectionMode(1);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.addListSelectionListener(this);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mTargetVarList.getModel().addListDataListener(this);
        jLabel2.setLabelFor(this.mTargetVarList);
        this.mFormatter = new SortListFormatter();
        this.mTargetVarList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, SORT_CASES_ASCENDING_KEY);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, SORT_CASES_DESCENDING_KEY);
        this.mAscendingRadio = new JRadioButton(toggleButtonAction);
        this.mDescendingRadio = new JRadioButton(toggleButtonAction2);
        JComponent[] jComponentArray = new JComponent[]{this.mAscendingRadio, this.mDescendingRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_SORT_ORDER"));
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mAscendingRadio);
        this.mButtonGroup.add(this.mDescendingRadio);
        this.mButtonGroup.setSelected(this.mAscendingRadio.getModel(), true);
        this.mAscendingRadio.addItemListener(this);
        this.mDescendingRadio.addItemListener(this);
        this.arrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.arrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mAscendingRadio.setEnabled(false);
        this.mDescendingRadio.setEnabled(false);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setupSaveSortedDataPanel(), gridBagConstraints, 0, 3, 3, 1, n, insets);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SORT_SAVE_SORTED_DATA_CHECK");
        this.mSaveSortedDataFileCheck = new JCheckBox(toggleButtonAction);
        this.mSaveSortedDataFileCheck.addItemListener(this);
        this.mSaveSortedDataFileCheck.setEnabled(false);
        this.mSaveSortedDataFileCheck.setSelected(false);
        this.mNewDataFilePath = new FileTextField();
        this.mNewDataFilePath.setEditable(false);
        this.mNewDataFilePath.setEnabled(false);
        this.mNewDataFilePath.setText("");
        this.mNewDataFilePath.setOpaque(false);
        this.mNewDataFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mNewDataFilePath.setAction(new TextFieldAction(this, SORTED_DATA_FILE_NAME));
        this.mNewDataFilePath.setToolTipText(this.mNewDataFilePath.getText());
        this.mDataFileBroweButton = DialogUtil.createButton(this, "IDS_SORT_SAVE_SORTED_DATA_BROWSE_BUTTON", null);
        this.mDataFileBroweButton.setEnabled(false);
        this.mDataFileBroweButton.addActionListener(this);
    }

    private JPanel setupSaveSortedDataPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSaveSortedDataFileCheck, this.mDataFileBroweButton, this.mNewDataFilePath};
        JPanel jPanel = PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_SORT_SAVE_SORTED_DATA_PANEL_TITLE"));
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, 0, 0);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SORT_INDEX_CREATE_CHECK");
        this.mCreateIndexCheck = new JCheckBox(toggleButtonAction);
        this.mCreateIndexCheck.addItemListener(this);
        this.mCreateIndexCheck.setEnabled(false);
        this.mCreateIndexCheck.setSelected(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        insets.set(0, n * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCreateIndexCheck, gridBagConstraints, 0, 2, 3, 1, 18, insets);
        return jPanel;
    }

    private void enableSaveSortedDataPanel() {
        this.mSaveSortedDataFileCheck.setEnabled(this.mTargetVarList.getModel().getSize() > 0 && RemoteFileChooser.enableSaveInModeler());
        if (this.mSaveSortedDataFileCheck.isSelected() && this.mSaveSortedDataFileCheck.isEnabled()) {
            this.mDataFileBroweButton.setEnabled(true);
            this.mNewDataFilePath.setEnabled(true);
            this.mCreateIndexCheck.setEnabled(true);
        } else {
            this.mDataFileBroweButton.setEnabled(false);
            this.mNewDataFilePath.setEnabled(false);
            this.mCreateIndexCheck.setEnabled(false);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.arrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mButtonGroup);
        vector.add(this.mSaveSortedDataFileCheck);
        vector.add(this.mDataFileBroweButton);
        vector.add(this.mCreateIndexCheck);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private boolean isSaveSortedDataOK() {
        boolean bl = !this.mSaveSortedDataFileCheck.isSelected() || this.mSaveSortedDataFileCheck.isSelected() && this.mNewDataFilePath.getText().length() > 0;
        return bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private class SortListFormatter
    implements ISpssVarFormatter {
        private HashSet<ISpssVariable> mAscendingVars = new HashSet();

        private SortListFormatter() {
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            String string;
            boolean bl = this.getVarList().getModel().getShowVarLabels();
            String string2 = iSpssVariable.getName();
            String string3 = iSpssVariable.getLabel();
            if (bl && string3.length() > 0) {
                String string4 = this.getAscendingVars().contains(iSpssVariable) ? SortCasesDlg.this.APPEND_ASCENDING : SortCasesDlg.this.APPEND_DESCENDING;
                string = string3 + " [" + string2 + "]" + string4;
            } else {
                String string5 = this.getAscendingVars().contains(iSpssVariable) ? SortCasesDlg.this.getResString("IDS_IDUPC_ASC_SUFFIX_CHAR") : SortCasesDlg.this.getResString("IDS_IDUPC_DESC_SUFFIX_CHAR");
                string = string2 + string5;
            }
            return string;
        }

        @Override
        public boolean getShowIcons() {
            return true;
        }

        @Override
        public TargetVariableList getVarList() {
            return SortCasesDlg.this.mTargetVarList;
        }

        public HashSet<ISpssVariable> getAscendingVars() {
            return this.mAscendingVars;
        }

        public void setAscendingVarArray(ISpssVariable[] iSpssVariableArray) {
            if (iSpssVariableArray != null) {
                iSpssVariableArray = this.reconcileVars(iSpssVariableArray);
                this.mAscendingVars.clear();
                this.mAscendingVars = new HashSet<ISpssVariable>(Arrays.asList(iSpssVariableArray));
            }
        }

        private DialogDataModel getDDM() {
            DialogDataModel dialogDataModel = null;
            BaseProcedureDialog baseProcedureDialog = this.findParentDialog(SortCasesDlg.this.mTargetVarList);
            if (baseProcedureDialog != null) {
                dialogDataModel = baseProcedureDialog.getDialogDataModel();
            }
            return dialogDataModel;
        }

        private BaseProcedureDialog findParentDialog(Component component) {
            Container container;
            for (container = component.getParent(); container != null && !(container instanceof BaseProcedureDialog); container = container.getParent()) {
            }
            return container != null ? (BaseProcedureDialog)((Object)container) : null;
        }

        private ISpssVariable[] reconcileVars(ISpssVariable[] iSpssVariableArray) {
            if (!CommandLine.isClementineCaller()) {
                return iSpssVariableArray;
            }
            LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc == null) {
                return iSpssVariableArray;
            }
            DialogDataModel dialogDataModel = this.getDDM();
            if (dialogDataModel == null) {
                return iSpssVariableArray;
            }
            ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray(SortCasesDlg.this.mTargetVarList.getIdentifier() + SortCasesDlg.ASCENDING_VARS_LOOKUP);
            if (iSpssVariableArray2 == null || iSpssVariableArray2.length == 0) {
                return iSpssVariableArray;
            }
            ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                int n = iSpssDataSrc.findVarIndex(iSpssVariable.getId());
                if (n <= -1) continue;
                ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(n);
                arrayList.add(iSpssVariable2);
            }
            return arrayList.toArray(new ISpssVariable[arrayList.size()]);
        }
    }
}

