/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data;

import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RepositoryCredentialListDlg
extends BaseSpssDialog
implements FocusListener {
    private Window mParent;
    private JButton mCancelButton;
    private JButton mOkButton;
    private List<String> mCredentials;
    private JList mCredList;
    private DefaultListModel mListModel;
    private JScrollPane mCredListScrollPane;
    private String selectedCredName;
    private StringTextField mCredNameField;

    public RepositoryCredentialListDlg(JDialog jDialog, List<String> list) {
        super(jDialog, jDialog.getTitle() + " ", true, ResUtil.getBundle(DataResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), DataResBundle.getImageFolder());
        this.mParent = jDialog;
        this.mCredentials = list;
        this.initUI();
    }

    public RepositoryCredentialListDlg(JFrame jFrame, List list) {
        super(jFrame, jFrame.getTitle() + " ", true, ResUtil.getBundle(DataResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), DataResBundle.getImageFolder());
        this.mParent = jFrame;
        this.mCredentials = list;
        this.initUI();
    }

    private void initUI() {
        this.initVars();
        this.setupUI();
        this.setTitle(this.getTitle() + this.getResString("IDS_REPS_CRED_DIALOG_TITLE"));
        this.pack();
    }

    private void setupUI() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 4;
        Insets insets = new Insets(n2, n2, n2, n2);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REPS_CRED_DIALOG_TABLE_LABEL");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        jLabel.setLabelFor(this.mCredList);
        DialogUtil.addUsingGBL(jPanel, this.mCredListScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REPS_CRED_DIALOG_FILTER_TEXT")));
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_REPS_CRED_DIALOG_FILTER_LABEL");
        jLabel2.setLabelFor((Component)((Object)this.mCredNameField));
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mCredNameField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    private void initVars() {
        this.mCredList = new JList();
        this.mListModel = new DefaultListModel();
        for (String string : this.mCredentials) {
            this.mListModel.addElement(string);
        }
        this.mCredList.setModel(this.mListModel);
        this.mCredList.setSelectionMode(0);
        this.mCredList.setSelectedIndex(0);
        this.mCredList.addFocusListener(this);
        this.mCredList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    RepositoryCredentialListDlg.this.performOkAction();
                }
            }
        });
        this.mCredListScrollPane = new JScrollPane(this.mCredList);
        this.mCredNameField = new StringTextField();
        this.mCredNameField.setColumns(26);
        this.mCredNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RepositoryCredentialListDlg.this.filterChanged(RepositoryCredentialListDlg.this.mCredNameField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RepositoryCredentialListDlg.this.filterChanged(RepositoryCredentialListDlg.this.mCredNameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RepositoryCredentialListDlg.this.filterChanged(RepositoryCredentialListDlg.this.mCredNameField.getText());
            }
        });
    }

    private void filterChanged(String string) {
        this.mListModel.clear();
        for (String string2 : this.mCredentials) {
            if (!string2.contains(string)) continue;
            this.mListModel.addElement(string2);
        }
    }

    private void performOkAction() {
        this.selectedCredName = (String)this.mCredList.getSelectedValue();
        this.dispose();
    }

    private void performCancelAction() {
        this.selectedCredName = null;
        this.dispose();
    }

    public String getSelectedCredName() {
        return this.selectedCredName;
    }

    private void setActionInfo(AbstractAction abstractAction, String string) {
        abstractAction.putValue("Name", this.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string;
            Integer n = this.getDlgAccessKey(string2 = string2.replaceFirst("IDS_", "IDK_") + "_KEY");
            if (n != null) {
                abstractAction.putValue("MnemonicKey", n);
            }
        }
    }

    public void doHelp() {
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        this.mCancelButton = new JButton(new CancelAction());
        this.mOkButton = new JButton(new OkAction());
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createHorizontalStrut(n));
            jPanel.add(this.mOkButton);
        } else {
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createHorizontalStrut(n));
            jPanel.add(this.mCancelButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
        if (focusEvent.getSource().equals(this.mCredList)) {
            this.mCredListScrollPane.setBorder(border);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        LineBorder lineBorder = new LineBorder(Color.GRAY);
        if (focusEvent.getSource().equals(this.mCredList)) {
            this.mCredListScrollPane.setBorder(lineBorder);
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            RepositoryCredentialListDlg.this.setActionInfo(this, "IDS_OK");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RepositoryCredentialListDlg.this.performOkAction();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            RepositoryCredentialListDlg.this.setActionInfo(this, "IDS_CANCEL");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RepositoryCredentialListDlg.this.performCancelAction();
        }
    }
}

