/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.DatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.ComparatorFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class NewCustomAttributeDlg
extends BaseDialog
implements DocumentListener,
IVarMoveHandler,
ListDataListener {
    private static final String IDS_DISPLAY_CHECK = "IDS_NEW_CUST_ATTRIB_DISPLAY_CHECK";
    private static final String HIDE = "IDS_NEW_CUST_ATTRIB_HIDE";
    private static final String SHOW = "IDS_NEW_CUST_ATTRIB_DISPLAY";
    private SrcVariableList mSourceVarList;
    private TargetVariableList mTargetList;
    private ArrowButton mArrowButton;
    private ContextEnabledTextField mAttributeNameText;
    private ContextEnabledTextField mAttributeValueText;
    private JCheckBox mDisplayInEditorCheck;
    private JButton mDisplayButton;
    private PlainList mDefinedAttributeList;
    private JScrollPane mAttributeScrollPane;
    private JButton mOKButton;
    private String mNewAttributeName = null;
    private DataFrame mParentFrame;

    public NewCustomAttributeDlg(DataFrame dataFrame) throws HeadlessException {
        super((JFrame)dataFrame, true, ResUtil.getBundle(DataResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), DataResBundle.getImageFolder());
        Point point;
        Object object;
        this.mParentFrame = dataFrame;
        this.setTitle(this.getResString("IDS_NEW_CUST_ATTRIB_TITLE"));
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.mSourceVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            object = this.mSourceVarList.getModel().getElementAt(i);
            int n2 = object.getAttributes().size();
            for (int j = 0; j < n2; ++j) {
                String string = object.getAttributes().name(j);
                hashSet.add(string);
            }
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        this.updateModel(stringArray);
        object = ProcedureDlgMgr.getMgr().getDialogSize("data_new_custom_attributes");
        if (object != null) {
            this.setSize((Dimension)object);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("data_new_custom_attributes")) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(dataFrame);
        }
        this.mTargetList.getModel().addListDataListener(this);
        this.setVisible(true);
    }

    private void updateModel(String[] stringArray) {
        Arrays.sort(stringArray, ComparatorFactory.getCaseInsensitiveStringComparator());
        ((DefaultListModel)this.mDefinedAttributeList.getModel()).removeAllElements();
        for (String string : stringArray) {
            ((DefaultListModel)this.mDefinedAttributeList.getModel()).addElement(string);
        }
    }

    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            DialogUtil.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this);
        }
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        return true;
    }

    public String getNewAttributeName() {
        return this.mNewAttributeName;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mOKButton.setEnabled(this.mAttributeNameText.getText().length() > 0 && this.mTargetList.getModel().getSize() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mOKButton.setEnabled(this.mAttributeNameText.getText().length() > 0 && this.mTargetList.getModel().getSize() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mOKButton.setEnabled(this.mAttributeNameText.getText().length() > 0 && this.mTargetList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mOKButton.setEnabled(this.mAttributeNameText.getText().length() > 0 && this.mTargetList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mOKButton.setEnabled(this.mAttributeNameText.getText().length() > 0 && this.mTargetList.getModel().getSize() > 0);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_new_custom_attr_dlg");
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        this.mOKButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.left + insets.right;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOKButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mOKButton);
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        this.getRootPane().setDefaultButton(this.mOKButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setTabTraversalPolicy();
        this.pack();
    }

    private void setupViewPanel(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSourceVarList);
        jScrollPane.setPreferredSize(this.mSourceVarList.getMinimumSize());
        jScrollPane.setMinimumSize(this.mSourceVarList.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = new JLabel(this.getResString("IDS_NEW_CUST_ATTRIB_SELECT_LABEL"));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_NEW_CUST_ATTRIB_VARLIST_LABEL");
        jLabel2.setLabelFor(this.mSourceVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_NEW_CUST_ATTRIB_TARGETLIST_LABEL");
        jLabel3.setLabelFor(this.mTargetList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 1, 1, 1, n, insets);
        jScrollPane = new JScrollPane(this.mTargetList);
        jScrollPane.setPreferredSize(this.mTargetList.getMinimumSize());
        jScrollPane.setMinimumSize(this.mTargetList.getPreferredSize());
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 2, 1, 1, n, insets);
        Insets insets3 = new Insets(n2, insets.left, insets.bottom, insets.right);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_NEW_CUST_ATTRIB_NAME");
        jLabel4.setLabelFor((Component)this.mAttributeNameText);
        DialogUtil.addUsingGBL(jPanel2, jLabel4, gridBagConstraints, 0, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mAttributeNameText, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_NEW_CUST_ATTRIB_VALUE");
        jLabel5.setLabelFor((Component)this.mAttributeValueText);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel5, gridBagConstraints, 0, 4, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mAttributeValueText, gridBagConstraints, 1, 4, 1, 1, n, insets3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        insets3.left = n2 * 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDisplayInEditorCheck, gridBagConstraints, 0, 4, 1, 1, n, insets3);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, SHOW){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = NewCustomAttributeDlg.this.mDisplayButton.getText();
                if (string.equals(NewCustomAttributeDlg.this.getResString(NewCustomAttributeDlg.HIDE))) {
                    NewCustomAttributeDlg.this.mDisplayButton.setText(NewCustomAttributeDlg.this.getResString(NewCustomAttributeDlg.SHOW));
                    if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                        this.putValue("MnemonicKey", NewCustomAttributeDlg.this.getDlgAccessKey("IDK_NEW_CUST_ATTRIB_DISPLAY_KEY"));
                    }
                    NewCustomAttributeDlg.this.mAttributeScrollPane.setVisible(false);
                } else {
                    NewCustomAttributeDlg.this.mDisplayButton.setText(NewCustomAttributeDlg.this.getResString(NewCustomAttributeDlg.HIDE));
                    if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                        this.putValue("MnemonicKey", NewCustomAttributeDlg.this.getDlgAccessKey("IDK_NEW_CUST_ATTRIB_HIDE_KEY"));
                    }
                    NewCustomAttributeDlg.this.mAttributeScrollPane.setVisible(true);
                }
                NewCustomAttributeDlg.this.mAttributeScrollPane.revalidate();
                NewCustomAttributeDlg.this.pack();
            }
        };
        this.mDisplayButton = new JButton(toggleButtonAction);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDisplayButton, gridBagConstraints, 0, 5, 1, 1, n, insets3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mAttributeScrollPane, gridBagConstraints, 0, 6, 2, 1, n, insets3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets3.left = insets.left;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 3, 1, n, insets3);
        gridBagConstraints.fill = 1;
        insets3.left = n2 * 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.4;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 3, 1, n, insets3);
        this.mArrowButton.registerVariableList(this.mSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSourceVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetList);
        vector.add(this.mAttributeNameText);
        vector.add(this.mAttributeValueText);
        vector.add(this.mDisplayInEditorCheck);
        vector.add(this.mDisplayButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mSourceVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSourceVarList.loadFromActiveDataset();
        this.mTargetList = new TargetVariableList();
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setVarMoveHandler(this);
        this.mAttributeNameText = new ContextEnabledTextField();
        this.mAttributeNameText.getDocument().addDocumentListener(this);
        this.mAttributeValueText = new ContextEnabledTextField();
        this.mDefinedAttributeList = new PlainList("IDS_ATTRIBUTE_DISPLAY");
        this.mDefinedAttributeList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), 80));
        this.mAttributeScrollPane = new JScrollPane(this.mDefinedAttributeList);
        this.mAttributeScrollPane.setVisible(false);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_DISPLAY_CHECK);
        this.mDisplayInEditorCheck = new JCheckBox(toggleButtonAction);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mSourceVarList.setSelectedIndex(0);
        this.mDisplayInEditorCheck.setSelected(true);
        this.mOKButton.setEnabled(false);
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewCustomAttributeDlg.this.doHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewCustomAttributeDlg.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = VarNameValidator.validateSPSSName((String)NewCustomAttributeDlg.this.mAttributeNameText.getText(), (boolean)true).asInt();
            if (n == 0) {
                int n2;
                Object object;
                Object object2;
                Serializable serializable;
                boolean bl = true;
                LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                NewCustomAttributeDlg.this.mNewAttributeName = NewCustomAttributeDlg.this.mAttributeNameText.getText().trim();
                int n3 = NewCustomAttributeDlg.this.mTargetList.getModel().getSize();
                Vector<Object> vector = new Vector<Object>(n3);
                for (int i = 0; i < n3; ++i) {
                    serializable = new Vector<String>();
                    ((Vector)serializable).add(0, NewCustomAttributeDlg.this.mAttributeValueText.getText());
                    object2 = NewCustomAttributeDlg.this.mTargetList.getModel().getElementAt(i);
                    object = object2.getAttributes();
                    int n4 = object.size();
                    for (n2 = 0; n2 < n4; ++n2) {
                        String string = object.name(n2);
                        if (NewCustomAttributeDlg.this.mNewAttributeName.length() <= 0 || !NewCustomAttributeDlg.this.mNewAttributeName.equalsIgnoreCase(string)) continue;
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)NewCustomAttributeDlg.this), MessageFormat.format(NewCustomAttributeDlg.this.getResString("ERR_NEW_CUST_ATTRIB_SAME_VARNAME"), NewCustomAttributeDlg.this.mNewAttributeName), VersionInfo.getAppVersionString());
                        bl = false;
                        break;
                    }
                    if (!bl) break;
                    object.put(NewCustomAttributeDlg.this.mNewAttributeName, (Vector)serializable);
                    object2.setAttributes(object);
                    vector.addElement(object2);
                }
                if (bl) {
                    VarViewTable varViewTable;
                    if (NewCustomAttributeDlg.this.mDisplayInEditorCheck.isSelected() && ((Vector)(object2 = ((VarViewTableModel)(serializable = (VarViewTableModel)(varViewTable = (VarViewTable)NewCustomAttributeDlg.this.mParentFrame.getDataView().getDataTable(1)).getModel())).getDisplayedAttributes())).indexOf(object = "@" + NewCustomAttributeDlg.this.mNewAttributeName) == -1) {
                        ((Vector)object2).add(object);
                        IDatasourceAttributes iDatasourceAttributes = iSpssDataSrc.getAttributes();
                        n2 = 0;
                        if (iDatasourceAttributes == null) {
                            iDatasourceAttributes = new DatasourceAttributes();
                            n2 = 1;
                        }
                        iDatasourceAttributes.put("$VariableView2", (Vector)object2);
                        if (n2 != 0) {
                            iSpssDataSrc.setAttributes(iDatasourceAttributes);
                        }
                        varViewTable.updateDisplayedAttributes();
                        DataMgr.getDataMgr().sendDataSrcExtensionsMsg(iSpssDataSrc.getDataSetId(), iDatasourceAttributes.toString(), ExtensionType.kDatasetAttributes, 1);
                    }
                    iSpssDataSrc.setModified(true);
                    DataMgr.getDataMgr().sendModifyVarsMsg(iSpssDataSrc.getDataSetId(), vector, false);
                    ProcedureDlgMgr.getMgr().saveDialogSize("data_new_custom_attributes", NewCustomAttributeDlg.this.getSize());
                    ProcedureDlgMgr.getMgr().saveDialogLocation("data_new_custom_attributes", NewCustomAttributeDlg.this.getLocation());
                    NewCustomAttributeDlg.this.dispose();
                }
            } else if (n > 3 && n < 8) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)NewCustomAttributeDlg.this), NewCustomAttributeDlg.this.getResString("ERR_NEW_CUST_ATTRIB_ILLEGAL_CHARACTER"), VersionInfo.getAppVersionString());
            } else if (n == 1 || n == 3) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)NewCustomAttributeDlg.this), NewCustomAttributeDlg.this.getResString("ERR_NEW_CUST_ATTRIB_INVALID_VARNAME"), VersionInfo.getAppVersionString());
            } else if (n == 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)NewCustomAttributeDlg.this), NewCustomAttributeDlg.this.getResString("ERR_NEW_CUST_ATTRIB_SYSTEM_VARNAME"), VersionInfo.getAppVersionString());
            }
        }
    }
}

