/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.MultRespParam;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DefineMultRespSetsDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
DocumentListener,
IBasicACRListener {
    static final String DEFINE_MULTI_RESPONSE_SETS_HELP = "idh_idd_mrsets";
    static final String CO_VAR_COMBO = "IDS_REP_COVAR_TYPE";
    static final String VARIABLE_LABELS_KEY = "IDS_VARIABLE_LABELS";
    static final String LABELS_COUNTED_VALUE_KEY = "IDS_LABELS_COUNTED_VALUE";
    static final String USE_VAR_LABEL_AS_KEY = "IDS_USE_VAR_LABEL_AS";
    static final String COUNTED_VALUE_KEY = "IDS_COUNTED_VALUE";
    static final String DICHOTOMIES_KEY = "IDS_DICHOTOMIES";
    static final String CATEGORY_KEY = "IDS_CATEGORIES";
    static final String DIALOG_STATE_KEY = "DIALOG_STATE";
    static final String DELETE_STATE_KEY = "DELETE_STATE";
    static final String MULT_RESP_PARAM_LIST_KEY = "IDS_MULT_RESP_PARAM_LIST";
    private JLabel mCountedValLabel;
    private JLabel mSetNameLabel;
    private JLabel mSetLblLabel;
    private JLabel mMultRespSetLabel;
    private StringTextField mCountedValText;
    private StringTextField mSetLabelText;
    private StringTextField mSetNameText;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JRadioButton mDichotomyRadio;
    private JRadioButton mCategoryRadio;
    private JRadioButton mVariableLabelsRadio;
    private JRadioButton mLabelsOfCountedValRadio;
    private ArrowButton mSubArrowButton;
    private JCheckBox mVarLabelAsCheck;
    private SpssButtonGroup mButtonGroup;
    private SpssButtonGroup mVarButtonGroup;
    private BasicACRWidget mMultRespACRWidget;
    private Vector<Object> mTabOrder;
    private StringBuffer mBuffer;
    private ArrayList<String> mDisplayACRList;
    private ArrayList<String> mApplyACRList;
    private ArrayList<String> mOriginalACRList;
    private ArrayList<String> mDeleteACRList;
    private Map<String, MultRespParam> mMultRespMap;
    private String mSyntaxForCatValueLabel = "";
    private JLabel mCategoryLabel;
    LocallyUniqueId mDatasetId = null;

    public DefineMultRespSetsDlg(JFrame jFrame) {
        super(jFrame, true, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DEFINE_MULT_RESP_SETS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getIActionKey() {
        return "analyze_tables_mult_res_sets";
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (this.mMultRespACRWidget.isChangeEnabled() || this.mMultRespACRWidget.isAddEnabled()) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_DISCARD_CHANGES_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            bl = n == 0;
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.mDisplayACRList.size() > 0 || this.mDeleteACRList.size() > 0) {
            stringBuffer.append(this.generateSyntaxForValueLabel());
            stringBuffer.append("* ");
            stringBuffer.append(this.getResString("IDS_DEFINE_MULT_RESP_SETS_SYNTAX_TITLE"));
            stringBuffer.append(".");
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getMainCommand("MRSETS"));
        }
        for (String object : this.mDisplayACRList) {
            StringBuffer stringBuffer3 = new StringBuffer();
            for (int i = 0; i < this.getAttribute(object).getTargetStrLen(); ++i) {
                stringBuffer3.append(this.getAttribute(object).getTargetStr()[i].getName());
                stringBuffer3.append(" ");
            }
            if (this.getAttribute(object).getCatFlag().booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MCGROUP"));
                stringBuffer.append(" NAME=");
                stringBuffer.append(object);
                if (this.getAttribute(object).getSetLabel().length() > 0) {
                    stringBuffer.append(" LABEL=");
                    stringBuffer.append(CharacterUtil.smartQuote((String)this.getAttribute(object).getSetLabel()));
                }
                stringBuffer.append(" VARIABLES=");
                stringBuffer.append(stringBuffer3.toString().trim());
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MDGROUP"));
                stringBuffer.append(" NAME=");
                stringBuffer.append(object);
                if (this.mVariableLabelsRadio.isEnabled()) {
                    if (this.getAttribute(object).getSetLabel().length() > 0 && (this.mVariableLabelsRadio.isSelected() || this.mLabelsOfCountedValRadio.isSelected() && !this.getAttribute(object).getUseVarCheck().booleanValue())) {
                        stringBuffer.append(" LABEL=");
                        stringBuffer.append(CharacterUtil.smartQuote((String)this.getAttribute(object).getSetLabel()));
                    }
                    if (this.mLabelsOfCountedValRadio.isSelected() && this.getAttribute(object).getUseVarCheck().booleanValue()) {
                        stringBuffer.append(" LABELSOURCE=VARLABEL");
                    }
                }
                if (this.getAttribute(object).getVarLabelFlag().booleanValue()) {
                    stringBuffer.append(" CATEGORYLABELS=VARLABELS");
                } else {
                    stringBuffer.append(" CATEGORYLABELS=COUNTEDVALUES");
                }
                stringBuffer.append(" VARIABLES=");
                stringBuffer.append(stringBuffer3.toString().trim());
                stringBuffer.append(" VALUE=");
                if (this.getAttribute(object).getTargetStr()[0].getType() > 0) {
                    stringBuffer.append(CharacterUtil.smartQuote((String)this.getAttribute(object).getCountedValue()));
                } else {
                    stringBuffer.append(this.getAttribute(object).getCountedValue());
                }
            }
            stringBuffer2.append(object);
            stringBuffer2.append(" ");
        }
        if (this.mDeleteACRList.size() > 0) {
            Object object = "";
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/DELETE NAME=["));
            for (String string : this.mDeleteACRList) {
                object = (String)object + " " + string;
            }
            stringBuffer.append(((String)object).trim());
            stringBuffer.append("]");
        }
        if (stringBuffer2.toString().length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/DISPLAY NAME="));
            stringBuffer.append("[").append(stringBuffer2.toString().trim()).append("]");
        }
        if (this.mDisplayACRList.size() > 0 || this.mDeleteACRList.size() > 0) {
            stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mMultRespACRWidget.clearListModel();
        this.resetAllVars();
        this.retrieveExistingMRSets();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.doTargetVarChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.doTargetVarChange();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.doTargetVarChange();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCategoryRadio) {
            if (this.mCategoryRadio.isSelected()) {
                this.mCountedValLabel.setEnabled(false);
                this.mCountedValText.setEnabled(false);
                this.mCountedValText.setOpaque(false);
                this.mVariableLabelsRadio.setEnabled(false);
                this.mLabelsOfCountedValRadio.setEnabled(false);
                this.mCategoryLabel.setEnabled(false);
                if (this.mLabelsOfCountedValRadio.isSelected() && this.mLabelsOfCountedValRadio.isEnabled()) {
                    this.mVarLabelAsCheck.setEnabled(true);
                } else {
                    this.mVarLabelAsCheck.setEnabled(false);
                }
            }
        } else if (itemEvent.getSource() == this.mDichotomyRadio) {
            if (this.mDichotomyRadio.isSelected()) {
                this.mCountedValLabel.setEnabled(true);
                this.mCountedValText.setEnabled(true);
                this.mCountedValText.setOpaque(true);
                this.mCategoryLabel.setEnabled(true);
                this.mVariableLabelsRadio.setEnabled(true);
                this.mLabelsOfCountedValRadio.setEnabled(true);
                if (this.mLabelsOfCountedValRadio.isSelected() && this.mLabelsOfCountedValRadio.isEnabled()) {
                    this.mVarLabelAsCheck.setEnabled(true);
                } else {
                    this.mVarLabelAsCheck.setEnabled(false);
                }
            }
        } else if (itemEvent.getSource() == this.mLabelsOfCountedValRadio) {
            if (this.mLabelsOfCountedValRadio.isSelected()) {
                this.mVarLabelAsCheck.setEnabled(true);
            } else {
                this.mVarLabelAsCheck.setEnabled(false);
            }
            if (this.mVarLabelAsCheck.isSelected()) {
                this.mSetLabelText.setEnabled(false);
            } else {
                this.mSetLabelText.setEnabled(true);
            }
        } else if (itemEvent.getSource() == this.mVariableLabelsRadio) {
            if (this.mVariableLabelsRadio.isSelected()) {
                this.mSetLblLabel.setEnabled(true);
                this.mSetLabelText.setEnabled(true);
                this.mSetLabelText.setOpaque(true);
            }
        } else if (itemEvent.getSource() == this.mVarLabelAsCheck) {
            if (this.mVarLabelAsCheck.isSelected()) {
                this.mSetLblLabel.setEnabled(false);
                this.mSetLabelText.setEnabled(false);
                this.mSetLabelText.setOpaque(false);
                this.copyVarLabel();
            } else {
                this.mSetLblLabel.setEnabled(true);
                this.mSetLabelText.setEnabled(true);
                this.mSetLabelText.setOpaque(true);
            }
        }
        this.enableAddChangeRemoveButtons();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doTextChange(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doTextChange(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doTextChange(documentEvent);
    }

    @Override
    public String getDialogHelpID() {
        return DEFINE_MULTI_RESPONSE_SETS_HELP;
    }

    private void copyVarLabel() {
        if (this.mTargetVarList.getModel().getSize() > 0) {
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(0);
            String string = iSpssVariable.getLabel();
            this.mSetLabelText.setText(string);
        }
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        BasicACREvent.EventType eventType = basicACREvent.getEventType();
        if (eventType == BasicACREvent.EventType.addButtonPress) {
            this.handleAddButtonPress();
        } else if (eventType == BasicACREvent.EventType.changeButtonPress) {
            this.handleChangeButtonPress();
        } else if (eventType == BasicACREvent.EventType.removeButtonPress) {
            this.handleRemoveButtonPress();
        } else if (eventType == BasicACREvent.EventType.listSelectionValueChange) {
            this.handleMRSetListSelnChange(basicACREvent);
        }
    }

    private void handleMRSetListSelnChange(BasicACREvent basicACREvent) {
        ListSelectionEvent listSelectionEvent = (ListSelectionEvent)basicACREvent.getEvent();
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.mMultRespACRWidget.getListSelectedIndex();
        this.mSetNameText.getDocument().removeDocumentListener(this);
        this.mCountedValText.getDocument().removeDocumentListener(this);
        this.mSetLabelText.getDocument().removeDocumentListener(this);
        this.mTargetVarList.getModel().removeListDataListener(this);
        this.mTargetVarList.getModel().removeAll();
        if (n > -1) {
            this.setMRSETValues(n);
            this.mMultRespACRWidget.setRemoveEnabled(true);
        } else {
            this.mMultRespACRWidget.setRemoveEnabled(false);
            this.resetAllVars();
        }
        this.mMultRespACRWidget.setAddEnabled(false);
        this.mMultRespACRWidget.setChangeEnabled(false);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mSetNameText.getDocument().addDocumentListener(this);
        this.mCountedValText.getDocument().addDocumentListener(this);
        this.mSetLabelText.getDocument().addDocumentListener(this);
    }

    private void handleRemoveButtonPress() {
        int n = this.mMultRespACRWidget.getListSelectedIndex();
        if (n > -1) {
            this.itemsInListOnRemove(n);
            this.mMultRespACRWidget.removeListItemAt(n);
            this.enableOkPasteButton();
            this.loadSourcelist();
        }
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void handleChangeButtonPress() {
        int n;
        if (this.isValidSPSSVarName() && (n = this.mMultRespACRWidget.getListSelectedIndex()) > -1) {
            int n2;
            for (int i = 0; i < this.mMultRespACRWidget.getListItemCount(); ++i) {
                if (i == n || !this.mMultRespACRWidget.getListItemAt(i).toString().equals("$" + this.mSetNameText.getText())) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_SET_NAME_ALREADY_EXIST_MESSAGE"), VersionInfo.getAppVersionString());
                return;
            }
            if (!this.checkValueLabels()) {
                return;
            }
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.mTargetVarList.getModel().getSize()];
            for (n2 = 0; n2 < this.mTargetVarList.getModel().getSize(); n2 += 1) {
                iSpssVariableArray[n2] = this.mTargetVarList.getModel().getElementAt(n2);
            }
            if (this.sameVarTypeMessage()) {
                return;
            }
            this.loadSourcelist();
            for (n2 = 0; n2 < this.mSrcVarList.getModel().getSize(); n2 += 1) {
                for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
                    if (this.mSrcVarList.getModel().getElementAt(n2) != this.mTargetVarList.getModel().getElementAt(i)) continue;
                    this.mSrcVarList.getModel().removeElementAt(n2);
                }
            }
            String string = "";
            if (this.mCategoryRadio.isSelected()) {
                n2 = 1;
            } else {
                n2 = 0;
                string = this.mCountedValText.getText();
            }
            boolean bl = this.mVariableLabelsRadio.isSelected();
            boolean bl2 = this.mVarLabelAsCheck.isSelected();
            String string2 = this.mSetNameText.getText();
            String string3 = this.mSetLabelText.getText();
            if (string2.length() > 0) {
                this.resetAllVars();
                MultRespParam multRespParam = new MultRespParam(iSpssVariableArray, n2 != 0, string, bl, bl2, string2, string3);
                this.setAttribute("$" + string2, new MultRespParam(iSpssVariableArray, n2 != 0, string, bl, bl2, string2, string3));
                int n3 = this.mMultRespACRWidget.getListItemCount();
                for (int i = 0; i < n3; ++i) {
                    Object object = this.mMultRespACRWidget.getListItemAt(i);
                    if (this.mMultRespACRWidget.getAllowDuplicates() || !multRespParam.equals(object) || i == n) continue;
                    return;
                }
                String string4 = this.mMultRespACRWidget.getListItemAt(n).toString();
                this.mMultRespACRWidget.removeListItemAt(n);
                this.mApplyACRList.remove(string4.substring(1));
                this.mMultRespACRWidget.addListItemAt(n, multRespParam);
                this.mSrcVarList.setSelectedIndex(0);
                this.mSrcVarList.requestFocus();
                this.itemsInListOnChange(string4, string2);
                this.enableOkPasteButton();
            }
        }
    }

    private void handleAddButtonPress() {
        if (this.isValidSPSSVarName()) {
            int n;
            if (this.sameVarTypeMessage()) {
                return;
            }
            if (!this.checkValueLabels()) {
                this.mApplyACRList.remove(this.mSetNameText.getText());
                return;
            }
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.mTargetVarList.getModel().getSize()];
            for (n = 0; n < this.mTargetVarList.getModel().getSize(); n += 1) {
                iSpssVariableArray[n] = this.mTargetVarList.getModel().getElementAt(n);
            }
            if (!this.isValidCountedValueLength(iSpssVariableArray)) {
                return;
            }
            n = this.mCategoryRadio.isSelected() ? 1 : 0;
            String string = this.mCountedValText.getText();
            boolean bl = this.mVariableLabelsRadio.isSelected();
            boolean bl2 = this.mVarLabelAsCheck.isSelected();
            String string2 = this.mSetNameText.getText();
            String string3 = this.mSetLabelText.getText();
            boolean bl3 = false;
            if (n && string2.length() > 0 && this.mTargetVarList.getModel().getSize() >= 2) {
                bl3 = true;
            }
            if (!n && string.length() > 0 && string2.length() > 0 && this.mTargetVarList.getModel().getSize() >= 2) {
                bl3 = true;
            }
            if (bl3) {
                this.resetAllVars();
                MultRespParam multRespParam = new MultRespParam(iSpssVariableArray, n != 0, string, bl, bl2, string2, string3);
                this.setAttribute("$" + string2, new MultRespParam(iSpssVariableArray, n != 0, string, bl, bl2, string2, string3));
                int n2 = this.mMultRespACRWidget.getListItemCount();
                boolean bl4 = false;
                for (int i = 0; i < n2; ++i) {
                    Object object = this.mMultRespACRWidget.getListItemAt(i);
                    String string4 = "$" + string2;
                    if (!string4.equals(object.toString())) continue;
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    this.mMultRespACRWidget.clearItemListSelection();
                    this.mMultRespACRWidget.addListItemAt(n2, multRespParam);
                    this.mSrcVarList.setSelectedIndex(0);
                    this.mSrcVarList.requestFocus();
                    this.itemsInListOnAdd(multRespParam.toString());
                }
            }
            this.enableOkPasteButton();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(this.getResString("IDS_SET_DEFINATION_BORDER")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = this.setupSetDefinationPanel();
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel3 = this.setupVariableCodingPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 2, 3, 1, n, insets);
        jPanel3 = this.setupCatLabelSourcePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 3, 3, 1, n, insets);
        jPanel3 = this.setupNameLabelPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel4 = this.setupMultiRespPanel();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 0, 1, 4, n, insets);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        this.reset();
        super.loadDialogState();
    }

    private void setMRSETValues(int n) {
        String string = this.mMultRespACRWidget.getListItemAt(n).toString();
        if (string != null && this.getAttribute(string).getTargetStrLen() > 0) {
            for (int i = 0; i < this.getAttribute(string).getTargetStrLen(); ++i) {
                this.mTargetVarList.getModel().addElement(this.getAttribute(string).getTargetStr()[i]);
            }
        }
        this.loadSourcelist();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            for (int j = 0; j < this.mTargetVarList.getModel().getSize(); ++j) {
                if (!this.mSrcVarList.getModel().getElementAt(i).getName().equals(this.mTargetVarList.getModel().getElementAt(j).getName())) continue;
                vector.add(this.mSrcVarList.getModel().getElementAt(i));
            }
        }
        for (ISpssVariable iSpssVariable : vector) {
            this.mSrcVarList.getModel().removeElement(iSpssVariable);
        }
        if (this.getAttribute(string).getCatFlag().booleanValue()) {
            this.mCategoryRadio.setSelected(true);
        } else {
            this.mDichotomyRadio.setSelected(true);
            this.mCountedValText.setText(this.getAttribute(string).getCountedValue());
            if (this.getAttribute(string).getVarLabelFlag().booleanValue()) {
                this.mVariableLabelsRadio.setSelected(true);
            } else {
                this.mLabelsOfCountedValRadio.setSelected(true);
                this.mVarLabelAsCheck.setSelected(this.getAttribute(string).getUseVarCheck());
            }
        }
        this.mSetNameText.setText(this.getAttribute(string).getSetName());
        this.mSetLabelText.setText(this.getAttribute(string).getSetLabel());
    }

    private void enableOkPasteButton() {
        if (this.mDisplayACRList.size() > 0 || this.mDeleteACRList.size() > 0) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private boolean isValidCountedValueLength(ISpssVariable[] iSpssVariableArray) {
        if (iSpssVariableArray[0].getType() == 0) {
            return true;
        }
        int n = this.mCountedValText.getText().length();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            if (n <= iSpssVariable.getType()) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_COUNTED_VALUE_WIDER_MESSAGE"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    private boolean sameVarTypeMessage() {
        boolean bl = false;
        short s = this.mTargetVarList.getModel().getElementAt(0).getType();
        for (int i = 1; i < this.mTargetVarList.getModel().getSize(); ++i) {
            short s2 = this.mTargetVarList.getModel().getElementAt(i).getType();
            if ((s2 != 0 || s == 0) && (s2 == 0 || s != 0)) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (this.mDichotomyRadio.isSelected()) {
                if (this.mCountedValText.getText().length() > 1) {
                    if (s != 0) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_COUNTED_VALUE_WIDER_MESSAGE"), VersionInfo.getAppVersionString());
                        return true;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_VAR_TYPE_MESSAGE"), VersionInfo.getAppVersionString());
                    return true;
                }
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_VAR_TYPE_MESSAGE"), VersionInfo.getAppVersionString());
                return true;
            }
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_VAR_TYPE_MESSAGE"), VersionInfo.getAppVersionString());
            return true;
        }
        return false;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.loadSourcelist();
        this.mSubArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DICHOTOMIES_KEY);
        this.mButtonGroup = new SpssButtonGroup();
        this.mVarButtonGroup = new SpssButtonGroup();
        this.mDichotomyRadio = new JRadioButton(toggleButtonAction);
        this.mDichotomyRadio.addItemListener(this);
        this.mCategoryLabel = new JLabel(this.getResString("IDS_CATEGORY_LABELS_SOURCE"));
        toggleButtonAction = new ToggleButtonAction(this, CATEGORY_KEY);
        this.mCategoryRadio = new JRadioButton(toggleButtonAction);
        this.mCategoryRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, VARIABLE_LABELS_KEY);
        this.mVariableLabelsRadio = new JRadioButton(toggleButtonAction);
        this.mVariableLabelsRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, USE_VAR_LABEL_AS_KEY);
        this.mVarLabelAsCheck = new JCheckBox(toggleButtonAction);
        this.mVarLabelAsCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, LABELS_COUNTED_VALUE_KEY);
        this.mLabelsOfCountedValRadio = new JRadioButton(toggleButtonAction);
        this.mLabelsOfCountedValRadio.addItemListener(this);
        this.mCountedValLabel = DialogUtil.createLabel(this, COUNTED_VALUE_KEY);
        this.mCountedValText = new StringTextField("", 10);
        this.mCountedValText.setDocument(new NumericDocument());
        this.mCountedValLabel.setLabelFor((Component)((Object)this.mCountedValText));
        this.mCountedValText.getDocument().addDocumentListener(this);
        this.mSetNameLabel = DialogUtil.createLabel(this, "IDS_SET_NAME");
        this.mSetLblLabel = DialogUtil.createLabel(this, "IDS_SET_LABEL");
        this.mSetNameText = new StringTextField("", 10);
        this.mSetNameText.setDocument(new FixedLengthDocument(63));
        this.mSetNameText.getDocument().addDocumentListener(this);
        this.mSetNameLabel.setLabelFor((Component)((Object)this.mSetNameText));
        this.mSetLabelText = new StringTextField("", 20);
        this.mSetLblLabel.setLabelFor((Component)((Object)this.mSetLabelText));
        this.mSetLabelText.getDocument().addDocumentListener(this);
        this.mMultRespSetLabel = DialogUtil.createLabel(this, "IDS_MULT_RESP_SET");
        this.mMultRespACRWidget = new BasicACRWidget(MULT_RESP_PARAM_LIST_KEY);
        Dimension dimension = this.mMultRespACRWidget.getMinimumSize();
        this.mMultRespACRWidget.setListPreferredSize(new Dimension(dimension.width + 80, dimension.height));
        this.mMultRespSetLabel.setLabelFor(this.mMultRespACRWidget.getList());
        this.mMultRespACRWidget.setRemoveMnemonic(69);
        this.mMultRespACRWidget.addBasicACRListener(this);
        this.mBuffer = new StringBuffer();
        this.mDisplayACRList = new ArrayList();
        this.mApplyACRList = new ArrayList();
        this.mOriginalACRList = new ArrayList();
        this.mDeleteACRList = new ArrayList();
        this.mMultRespMap = new HashMap<String, MultRespParam>();
        this.mTabOrder = new Vector();
    }

    private void setDefaults() {
        this.mDichotomyRadio.setSelected(true);
        this.mVariableLabelsRadio.setSelected(true);
        this.mVarLabelAsCheck.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void resetAllVars() {
        this.mSetNameText.setText("");
        this.mCountedValText.setText("");
        this.mSetLabelText.setText("");
        this.mSetLabelText.setOpaque(true);
        this.mDichotomyRadio.setSelected(true);
        this.mVariableLabelsRadio.setSelected(true);
        this.mVarLabelAsCheck.setSelected(false);
        this.mTargetVarList.getModel().removeAll();
        this.loadSourcelist();
    }

    private JPanel setupSetDefinationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DEFINE_MULT_RESP_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSubArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_VARIABLES_IN_SET");
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 10 + 2));
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mSubArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private JPanel setupVariableCodingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        JLabel jLabel = new JLabel(this.getResString("IDS_VARIABLE_CODING"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        this.mButtonGroup.add(this.mDichotomyRadio);
        this.mButtonGroup.add(this.mCategoryRadio);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDichotomyRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 1, 1, 1, 10, new Insets(0, 0, 0, 0));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCountedValLabel, gridBagConstraints, 2, 1, 1, 1, n, new Insets(n2 + 5, 5, 0, 0));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mCountedValText), gridBagConstraints, 3, 1, 1, 1, n, new Insets(n2 + 5, 5, 0, 0));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCategoryRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setBounds(0, 0, 1, 500);
        jSeparator.setEnabled(true);
        jSeparator.setSize(1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 3, 3, 1, n, new Insets(10, 0, 0, 0));
        return jPanel;
    }

    private JPanel setupCatLabelSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setBounds(0, 0, 100, 100);
        jSeparator.setEnabled(true);
        jSeparator.setSize(1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.mVarButtonGroup.add(this.mVariableLabelsRadio);
        this.mVarButtonGroup.add(this.mLabelsOfCountedValRadio);
        DialogUtil.addUsingGBL(jPanel, this.mVariableLabelsRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLabelsOfCountedValRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVarLabelAsCheck, gridBagConstraints, 0, 3, 1, 1, n, new Insets(n2, 15, 0, 0));
        jSeparator = new JSeparator(0);
        jSeparator.setBounds(1, 1, 1, 500);
        jSeparator.setEnabled(true);
        jSeparator.setSize(1, 1);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 8, 5, 1, n, new Insets(n2, 0, 0, 0));
        return jPanel;
    }

    private JPanel setupNameLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSetNameLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSetNameText), gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSetLblLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSetLabelText), gridBagConstraints, 1, 1, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMultiRespPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(this.getResString("IDS_SETS_DEFINED_NOT_AVAILABLE_MESG"));
        jTextPane.setPreferredSize(new Dimension(200, 70));
        jTextPane.setMinimumSize(new Dimension(200, 70));
        jTextPane.setOpaque(false);
        jTextPane.setBorder(null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextPane, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMultRespSetLabel, gridBagConstraints, 1, 1, 1, 1, n, new Insets(n2, 90, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 11;
        DialogUtil.addUsingGBL(jPanel, this.mMultRespACRWidget, gridBagConstraints, 0, 2, 2, 2, n, insets);
        return jPanel;
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(this.mSubArrowButton);
        this.mTabOrder.add(this.mTargetVarList);
        this.mTabOrder.add(this.mButtonGroup);
        this.mTabOrder.add(this.mCountedValText);
        this.mTabOrder.add(this.mVarButtonGroup);
        this.mTabOrder.add(this.mVarLabelAsCheck);
        this.mTabOrder.add(this.mSetNameText);
        this.mTabOrder.add(this.mSetLabelText);
        this.mTabOrder.add(this.mMultRespACRWidget.getAddButton());
        this.mTabOrder.add(this.mMultRespACRWidget.getChangeButton());
        this.mTabOrder.add(this.mMultRespACRWidget.getList());
        this.mTabOrder.add(this.mMultRespACRWidget.getRemoveButton());
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private String generateSyntaxForValueLabel() {
        for (String string : this.mApplyACRList) {
            String string2 = "$" + string;
            if (this.getAttribute(string2).getTargetStrLen() <= 0 || this.mSyntaxForCatValueLabel.length() <= 0) continue;
            this.mBuffer.append(this.mSyntaxForCatValueLabel);
        }
        return this.mBuffer.toString();
    }

    private MultRespParam getAttribute(String string) {
        return this.mMultRespMap.get(string);
    }

    private void setAttribute(String string, MultRespParam multRespParam) {
        this.mMultRespMap.put(string, multRespParam);
    }

    private void doTargetVarChange() {
        this.enableAddChangeRemoveButtons();
        if (this.mVarLabelAsCheck.isEnabled() && this.mVarLabelAsCheck.isSelected()) {
            this.copyVarLabel();
        }
    }

    private void enableAddChangeRemoveButtons() {
        boolean bl;
        boolean bl2 = this.mSetNameText.getText().length() > 0;
        boolean bl3 = this.mCountedValText.getText().length() > 0;
        boolean bl4 = this.mTargetVarList.getModel().getSize() >= 2;
        boolean bl5 = bl = this.mMultRespACRWidget.getListSelectedIndex() > -1;
        if (this.mCategoryRadio.isSelected()) {
            this.mMultRespACRWidget.setChangeEnabled(bl2 && bl4 && bl);
            if (!bl) {
                this.mMultRespACRWidget.setAddEnabled(bl2 && bl4);
            }
        }
        if (this.mDichotomyRadio.isSelected()) {
            this.mMultRespACRWidget.setChangeEnabled(bl2 && bl3 && bl4 && bl);
            if (!bl) {
                this.mMultRespACRWidget.setAddEnabled(bl2 && bl3 && bl4);
            }
        }
        if (bl) {
            this.mMultRespACRWidget.setRemoveEnabled(true);
        } else {
            this.mMultRespACRWidget.setRemoveEnabled(false);
        }
    }

    private void doTextChange(DocumentEvent documentEvent) {
        boolean bl;
        String string = this.mSetNameText.getText();
        String string2 = this.mCountedValText.getText();
        boolean bl2 = string.length() > 0;
        boolean bl3 = string2.length() > 0;
        boolean bl4 = this.mTargetVarList.getModel().getSize() >= 2;
        boolean bl5 = bl = this.mMultRespACRWidget.getListSelectedIndex() > -1;
        if (documentEvent.getDocument() == this.mSetNameText.getDocument()) {
            if (this.mCategoryRadio.isSelected()) {
                this.mMultRespACRWidget.setChangeEnabled(bl2 && bl4 && bl);
                this.mMultRespACRWidget.setAddEnabled(bl2 && bl4);
            } else if (this.mDichotomyRadio.isSelected()) {
                this.mMultRespACRWidget.setChangeEnabled(bl2 && bl3 && bl4 && bl);
                this.mMultRespACRWidget.setAddEnabled(bl2 && bl3 && bl4);
            }
            for (int i = 0; i < this.mMultRespACRWidget.getListItemCount(); ++i) {
                if (!string.equalsIgnoreCase(this.mMultRespACRWidget.getListItemAt(i).toString().substring(1))) continue;
                this.mMultRespACRWidget.setAddEnabled(false);
                this.mMultRespACRWidget.setChangeEnabled(true);
            }
        } else if (documentEvent.getDocument() == this.mCountedValText.getDocument() || documentEvent.getDocument() == this.mSetLabelText.getDocument()) {
            if (this.mCategoryRadio.isSelected()) {
                this.mMultRespACRWidget.setChangeEnabled(bl2 && bl4 && bl);
                if (!bl) {
                    this.mMultRespACRWidget.setAddEnabled(bl2 && bl4);
                }
            }
            if (this.mDichotomyRadio.isSelected()) {
                this.mMultRespACRWidget.setChangeEnabled(bl2 && bl3 && bl4 && bl);
                if (!bl) {
                    this.mMultRespACRWidget.setAddEnabled(bl2 && bl3 && bl4);
                }
            }
        }
        if (bl) {
            this.mMultRespACRWidget.setRemoveEnabled(true);
        } else {
            this.mMultRespACRWidget.setRemoveEnabled(false);
        }
    }

    private boolean checkValueLabels() {
        if (this.mCategoryRadio.isSelected()) {
            return this.validateCategories();
        }
        if (this.mVariableLabelsRadio.isSelected()) {
            return this.validateDichotomyForVariableLabels();
        }
        return this.validateDichotomyForValueLabels();
    }

    private boolean validateCategories() {
        int n;
        VarListModel varListModel = this.mTargetVarList.getModel();
        boolean bl = false;
        block0: for (n = 0; n < varListModel.getSize() - 1; ++n) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(n);
            for (int i = n + 1; i < varListModel.getSize(); ++i) {
                SpssVariable spssVariable2 = (SpssVariable)varListModel.getElementAt(i);
                if (this.doValueLabelsMatch(spssVariable, spssVariable2)) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            this.mApplyACRList.add(this.mSetNameText.getText());
            return true;
        }
        n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_CATEGORIES_APPLY_CHANGES_TO_ALL_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        if (n == 0) {
            this.duplicateAllValueLabels(varListModel);
            this.mApplyACRList.add(this.mSetNameText.getText());
            return true;
        }
        return false;
    }

    private boolean doValueLabelsMatch(SpssVariable spssVariable, SpssVariable spssVariable2) {
        boolean bl = true;
        Set set = spssVariable.getValueLabels().getValueLabelEntries();
        Set set2 = spssVariable2.getValueLabels().getValueLabelEntries();
        for (Map.Entry entry : set) {
            OBS oBS = (OBS)entry.getKey();
            String string = (String)entry.getValue();
            for (Map.Entry entry2 : set2) {
                OBS oBS2 = (OBS)entry2.getKey();
                String string2 = (String)entry2.getValue();
                if (!oBS.equals((Object)oBS2) || string.equals(string2)) continue;
                return false;
            }
        }
        return bl;
    }

    private void duplicateAllValueLabels(VarListModel varListModel) {
        StringBuffer stringBuffer = new StringBuffer();
        SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(0);
        String string = this.createValueLabelSyntax(spssVariable.getValueLabels().getValueLabelEntries(), spssVariable.getFormat());
        stringBuffer.append("* Value Labels.\n");
        for (int i = 1; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable2 = (SpssVariable)varListModel.getElementAt(i);
            stringBuffer.append("VALUE LABELS ");
            stringBuffer.append(spssVariable2.getName());
            stringBuffer.append(string);
        }
        this.mSyntaxForCatValueLabel = stringBuffer.toString();
    }

    private String createValueLabelSyntax(Set<Map.Entry<OBS, String>> set, SPSS_Format sPSS_Format) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<OBS, String> entry : set) {
            stringBuffer.append(this.formatOneSyntaxValueLabel(entry.getKey(), entry.getValue(), sPSS_Format));
        }
        stringBuffer.append(".\n");
        return stringBuffer.toString();
    }

    private String createValueLabelSyntaxWithOverride(Set<Map.Entry<OBS, String>> set, OBS oBS, String string, SPSS_Format sPSS_Format) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (Map.Entry<OBS, String> entry : set) {
            if (entry.getKey().equals((Object)oBS)) {
                bl = true;
                stringBuffer.append(this.formatOneSyntaxValueLabel(oBS, string, sPSS_Format));
                continue;
            }
            stringBuffer.append(this.formatOneSyntaxValueLabel(entry.getKey(), entry.getValue(), sPSS_Format));
        }
        if (!bl) {
            stringBuffer.append(this.formatOneSyntaxValueLabel(oBS, string, sPSS_Format));
        }
        stringBuffer.append(".\n");
        return stringBuffer.toString();
    }

    private String formatOneSyntaxValueLabel(OBS oBS, String string, SPSS_Format sPSS_Format) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        String string2 = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
        string2 = UIToolResUtil.removeLocale((String)string2);
        if (sPSS_Format.getFormatType().isStringFormat()) {
            stringBuffer.append("\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append(" \"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private boolean validateDichotomyForVariableLabels() {
        int n;
        OBS oBS;
        VarListModel varListModel = this.mTargetVarList.getModel();
        try {
            oBS = new OBS(Double.parseDouble(this.mCountedValText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            oBS = new OBS(this.mCountedValText.getText());
        }
        String string = null;
        boolean bl = false;
        for (n = 0; n < varListModel.getSize(); ++n) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(n);
            IValueLabelMap iValueLabelMap = spssVariable.getValueLabels();
            String string2 = iValueLabelMap.get(oBS);
            if (string2 == null) continue;
            if (string == null) {
                string = string2;
                continue;
            }
            if (string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.mApplyACRList.add(this.mSetNameText.getText());
            return true;
        }
        n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_APPLY_CHANGES_TO_ALL_MESG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        if (n == 0) {
            this.duplicateCountedValueLabel(varListModel, oBS, string);
            this.mApplyACRList.add(this.mSetNameText.getText());
            return true;
        }
        return false;
    }

    private void duplicateCountedValueLabel(VarListModel varListModel, OBS oBS, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("* Value Labels.\n");
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            String string2 = this.createValueLabelSyntaxWithOverride(spssVariable.getValueLabels().getValueLabelEntries(), oBS, string, spssVariable.getFormat());
            stringBuffer.append("VALUE LABELS ");
            stringBuffer.append(spssVariable.getName());
            stringBuffer.append(string2);
        }
        this.mSyntaxForCatValueLabel = stringBuffer.toString();
    }

    private boolean validateDichotomyForValueLabels() {
        OBS oBS;
        VarListModel varListModel = this.mTargetVarList.getModel();
        try {
            oBS = new OBS(Double.parseDouble(this.mCountedValText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            oBS = new OBS(this.mCountedValText.getText());
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            IValueLabelMap iValueLabelMap = spssVariable.getValueLabels();
            String string = iValueLabelMap.get(oBS);
            if (string == null) {
                bl = true;
                break;
            }
            if (hashSet.add(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.mApplyACRList.add(this.mSetNameText.getText());
            return true;
        }
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DUPLICATE_LABEL_MESG"), VersionInfo.getAppVersionString());
        return false;
    }

    private void loadSourcelist() {
        this.mSrcVarList.loadFromActiveDataset();
    }

    private void retrieveExistingMRSets() {
        ISpssDataSrc iSpssDataSrc;
        Vector vector;
        int n;
        this.mTargetVarList.getModel().removeAll();
        this.mMultRespACRWidget.clearListModel();
        this.mOriginalACRList.clear();
        this.mApplyACRList.clear();
        this.mDeleteACRList.clear();
        this.mDisplayACRList.clear();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            this.mDatasetId = ((DataFrame)spssFrame).getDatasetId();
        }
        if (this.mDatasetId != null && (n = (vector = (iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.mDatasetId)).getVariableSets(ISpssDataSrc.VarSetsType.kMultipleResponseSets)).size()) > 0) {
            for (int i = 0; i < n; ++i) {
                String string;
                int n2;
                IVariableSet iVariableSet = (IVariableSet)vector.get(i);
                ISpssVariable[] iSpssVariableArray = new ISpssVariable[iVariableSet.getVariableNames().size()];
                for (int j = 0; j < iSpssVariableArray.length; ++j) {
                    String string2 = (String)iVariableSet.getVariableNames().get(j);
                    for (n2 = 0; n2 < iSpssDataSrc.columnCount(); n2 += 1) {
                        if (!string2.equalsIgnoreCase(iSpssDataSrc.getVariable(n2).getName())) continue;
                        iSpssVariableArray[j] = iSpssDataSrc.getVariable(n2);
                    }
                }
                String string3 = iVariableSet.getName(IVariableSet.ChangeCase.kNoChange).substring(1);
                this.mOriginalACRList.add("$" + string3);
                boolean bl = false;
                n2 = 1;
                boolean bl2 = false;
                if (iVariableSet.getType() == IVariableSet.VariableSetType.kMR_Category) {
                    bl = true;
                }
                String string4 = "0";
                if (iVariableSet.getType() == IVariableSet.VariableSetType.kMR_Dichotomy) {
                    bl = false;
                    string4 = iVariableSet.getValue();
                    string = iVariableSet.getFlags();
                    n2 = string.charAt(0) == '0' ? 1 : 0;
                    bl2 = string.charAt(1) != '0';
                }
                string = iVariableSet.getLabel();
                MultRespParam multRespParam = new MultRespParam(iSpssVariableArray, bl, string4, n2 != 0, bl2, string3, string);
                this.setAttribute("$" + string3, new MultRespParam(iSpssVariableArray, bl, string4, n2 != 0, bl2, string3, string));
                this.mMultRespACRWidget.addListItemAt(i, multRespParam);
            }
        }
    }

    private void itemsInListOnAdd(String string) {
        int n = -1;
        for (int i = 0; i < this.mDeleteACRList.size(); ++i) {
            if (!this.mDeleteACRList.get(i).equals(string)) continue;
            n = i;
            break;
        }
        this.mDisplayACRList.add(string);
        if (n > -1) {
            this.mDeleteACRList.remove(n);
        }
    }

    private void itemsInListOnChange(String string, String string2) {
        boolean bl = false;
        for (String string3 : this.mOriginalACRList) {
            if (!string3.equals(string)) continue;
            this.mDeleteACRList.add(string);
            bl = true;
            break;
        }
        if (string.equals("$" + string2)) {
            this.mDeleteACRList.remove(string);
        }
        if (bl) {
            this.mDisplayACRList.add("$" + string2);
        }
        for (int i = 0; i < this.mDisplayACRList.size(); ++i) {
            if (!this.mDisplayACRList.get(i).equals(string)) continue;
            this.mDisplayACRList.set(i, "$" + string2);
            break;
        }
    }

    private void itemsInListOnRemove(int n) {
        int n2;
        String string = this.mMultRespACRWidget.getListItemAt(n).toString();
        for (n2 = 0; n2 < this.mApplyACRList.size(); ++n2) {
            if (!("$" + this.mApplyACRList.get(n2)).equals(string)) continue;
            this.mApplyACRList.remove(n2);
        }
        for (n2 = 0; n2 < this.mDisplayACRList.size(); ++n2) {
            if (!this.mDisplayACRList.get(n2).equals(string)) continue;
            this.mDisplayACRList.remove(n2);
        }
        for (String string2 : this.mOriginalACRList) {
            if (!string2.equals(string)) continue;
            this.mDeleteACRList.add(string);
        }
    }

    private boolean isValidSPSSVarName() {
        boolean bl;
        String string = this.mSetNameText.getText();
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n != 3 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this);
            bl = false;
        } else {
            bl = true;
        }
        if (!bl) {
            this.mSetNameText.requestFocus();
            this.mSetNameText.selectAll();
        }
        return bl;
    }

    class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() < 64) {
                if (DefineMultRespSetsDlg.this.mTargetVarList.getModel().getSize() > 0) {
                    if (DefineMultRespSetsDlg.this.mTargetVarList.getModel().getElementAt(0).getType() > 0) {
                        if (string != null) {
                            super.insertString(n, string, attributeSet);
                        }
                    } else if (DefineMultRespSetsDlg.this.mTargetVarList.getModel().getElementAt(0).getType() == 0 && (string = string.trim()) != null && (string.matches("[0-9]*") || string.matches("-[0-9]*"))) {
                        super.insertString(n, string, attributeSet);
                    }
                } else if (string != null && (string.matches("[0-9]*") || string.matches("-[0-9]*"))) {
                    super.insertString(n, string, attributeSet);
                }
                if (this.getLength() > 64) {
                    this.remove(64, this.getLength() - 64);
                }
            }
        }
    }
}

