/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools.ToolItem;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools.ToolType;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class ToolPalette
extends JDialog {
    private BuilderFrame mOwner;
    private ToolboxDragAdapter mDragAdapter;
    private ToolboxKeyAdapter mKeyAdapter;
    private ToolItem mSelectedTool = null;
    private ToolItem mHighlightTool = null;
    private Border mSelectedBorder;
    private Border mHighlightBorder;
    private Border mStandardBorder;
    private JPanel mToolPanel;

    public ToolPalette(BuilderFrame builderFrame) throws HeadlessException {
        super((Frame)builderFrame, BuilderResUtil.getString("IDS_PALETTE_WIN_TITLE"));
        this.mOwner = builderFrame;
        this.setDefaultCloseOperation(1);
        this.init();
        this.setResizable(false);
        this.pack();
    }

    public ToolItem getSelectedTool() {
        return this.mSelectedTool;
    }

    public void reposition(BuilderFrame builderFrame) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = builderFrame.getBounds();
        Point point = new Point(rectangle.x - dimension.width, rectangle.y);
        point.x = Math.max(point.x, 0);
        this.setLocation(point);
    }

    public void enableButton(ToolType toolType, boolean bl) {
        ToolItem toolItem = this.getToolItem(toolType);
        if (toolItem != null) {
            toolItem.setEnabled(bl);
        }
    }

    public void selectTool(Object object) {
        ToolItem toolItem;
        if (object instanceof ToolItem && (toolItem = (ToolItem)object).isEnabled() && toolItem != this.mSelectedTool) {
            if (this.mSelectedTool != null) {
                this.mSelectedTool.setBorder(this.mStandardBorder);
            }
            this.mSelectedTool = toolItem;
            this.mSelectedTool.setBorder(this.mSelectedBorder);
            this.mSelectedTool.requestFocus();
        }
    }

    public ToolItem getToolItem(ToolType toolType) {
        for (Component component : this.mToolPanel.getComponents()) {
            if (!(component instanceof ToolItem) || ((ToolItem)component).getToolType() != toolType) continue;
            return (ToolItem)component;
        }
        return null;
    }

    private void init() {
        this.mStandardBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.mSelectedBorder = BorderFactory.createBevelBorder(1);
        this.mHighlightBorder = BorderFactory.createBevelBorder(0);
        DragPane dragPane = new DragPane();
        this.setGlassPane((Component)dragPane);
        this.mDragAdapter = new ToolboxDragAdapter(dragPane, "toolbox_drag");
        this.mKeyAdapter = new ToolboxKeyAdapter();
        this.mToolPanel = new JPanel(true);
        this.mToolPanel.setLayout(new BoxLayout(this.mToolPanel, 1));
        this.mToolPanel.setBorder(new EmptyBorder(2, 6, 4, 6));
        this.addTools(this.mToolPanel);
        this.getContentPane().add(this.mToolPanel);
        this.addKeyShortcuts();
    }

    private void addKeyShortcuts() {
        InputMap inputMap = this.mToolPanel.getInputMap(1);
        KeyStroke keyStroke = BuilderResUtil.getShortcut("IDK_CANVAS");
        inputMap.put(keyStroke, "FocusCanvas");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolPalette.this.mOwner.getCanvas().requestFocus();
            }
        };
        this.mToolPanel.getActionMap().put("FocusCanvas", abstractAction);
        keyStroke = BuilderResUtil.getShortcut("IDK_PROPS");
        inputMap.put(keyStroke, "FocusProps");
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolPalette.this.mOwner.focusPropertiesPanel();
            }
        };
        this.mToolPanel.getActionMap().put("FocusProps", abstractAction2);
        keyStroke = KeyStroke.getKeyStroke(9, 0);
        inputMap.put(keyStroke, "MoveDown");
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolPalette.this.moveFocus((Component)actionEvent.getSource(), false);
            }
        };
        this.mToolPanel.getActionMap().put("MoveDown", abstractAction3);
        keyStroke = KeyStroke.getKeyStroke(9, 1);
        inputMap.put(keyStroke, "MoveUp");
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolPalette.this.moveFocus((Component)actionEvent.getSource(), true);
            }
        };
        this.mToolPanel.getActionMap().put("MoveUp", abstractAction4);
    }

    private void addTools(JPanel jPanel) {
        MouseHandler mouseHandler = new MouseHandler();
        ToolItem toolItem = this.setupTool(jPanel, ToolType.SOURCE_VAR_LIST, mouseHandler);
        this.setupTool(jPanel, ToolType.TARGET_VAR_LIST, mouseHandler);
        this.setupTool(jPanel, ToolType.CHECKBOX_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.COMBO_BOX_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.LISTBOX_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.EDIT_TEXT_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.NUMBER_EDIT_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.STATIC_TEXT_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.ITEM_GROUP_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.RADIO_GROUP, mouseHandler);
        this.setupTool(jPanel, ToolType.CHECKBOX_GROUP_CONTROL, mouseHandler);
        this.setupTool(jPanel, ToolType.FILE_SYSTEM_BROWSER, mouseHandler);
        this.setupTool(jPanel, ToolType.SUB_DIALOG_BUTTON, mouseHandler);
        this.normalizeLabelWidths(jPanel);
        this.selectTool(toolItem);
    }

    private ToolItem setupTool(JPanel jPanel, ToolType toolType, MouseHandler mouseHandler) {
        ToolItem toolItem = new ToolItem(toolType);
        toolItem.addMouseListener(mouseHandler);
        toolItem.addMouseMotionListener(mouseHandler);
        toolItem.addMouseListener((MouseListener)((Object)this.mDragAdapter));
        toolItem.addMouseMotionListener((MouseMotionListener)((Object)this.mDragAdapter));
        toolItem.addKeyListener(this.mKeyAdapter);
        toolItem.setBorder(this.mStandardBorder);
        jPanel.add(toolItem);
        return toolItem;
    }

    private void updateHighlight(MouseEvent mouseEvent) {
        Component component = null;
        if (mouseEvent.getSource() instanceof ToolItem && mouseEvent.getID() != 505) {
            component = (ToolItem)mouseEvent.getSource();
        }
        if (component != null && !component.isEnabled()) {
            component = null;
        }
        if (component != this.mHighlightTool) {
            if (this.mHighlightTool != null) {
                if (this.mHighlightTool == this.mSelectedTool) {
                    this.mHighlightTool.setBorder(this.mSelectedBorder);
                } else {
                    this.mHighlightTool.setBorder(this.mStandardBorder);
                }
            }
            if (component != null) {
                ((JComponent)component).setBorder(this.mHighlightBorder);
            }
            this.mHighlightTool = component;
        }
    }

    private void normalizeLabelWidths(JPanel jPanel) {
        int n = 0;
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            JLabel jLabel = (JLabel)component;
            FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
            if (jLabel.getText() == null) continue;
            int n2 = fontMetrics.stringWidth(jLabel.getText()) + jLabel.getIconTextGap() + jLabel.getIcon().getIconWidth() + 10;
            n = n > n2 ? n : n2;
            arrayList.add(jLabel);
        }
        for (JLabel jLabel : arrayList) {
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width = n;
            jLabel.setMaximumSize(dimension);
            jLabel.setMinimumSize(dimension);
        }
    }

    private void moveFocus(Component component, boolean bl) {
        int n;
        int n2 = this.mToolPanel.getComponentCount();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (this.mToolPanel.getComponent(n) != component) continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            return;
        }
        n = bl ? (n3 > 0 ? n3 - 1 : n2 - 1) : (n3 < n2 - 1 ? n3 + 1 : 0);
        Component component2 = this.mToolPanel.getComponent(n);
        this.selectTool(component2);
    }

    private void doToolCopyToCanvas() {
        ToolType toolType;
        BuilderCanvas builderCanvas = this.mOwner.getCanvas();
        Rectangle rectangle = builderCanvas.getBounds();
        Point point = new Point(rectangle.width / 2 - 70, rectangle.height / 2 - 100);
        point.x = Math.max(point.x, 0);
        point.y = Math.max(point.y, 0);
        ToolItem toolItem = this.getSelectedTool();
        ToolType toolType2 = toolType = toolItem != null ? toolItem.getToolType() : null;
        if (toolType != null) {
            builderCanvas.createNewObject(toolType, point);
        }
    }

    class ToolboxKeyAdapter
    extends KeyAdapter {
        ToolboxKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            if (!(keyEvent.getSource() instanceof Component)) {
                return;
            }
            boolean bl2 = bl = (keyEvent.getModifiersEx() & 0x40) == 64;
            if (keyEvent.getKeyCode() == 9) {
                ToolPalette.this.moveFocus((Component)keyEvent.getSource(), bl);
            } else if (keyEvent.getKeyCode() == 38) {
                ToolPalette.this.moveFocus((Component)keyEvent.getSource(), true);
            } else if (keyEvent.getKeyCode() == 40) {
                ToolPalette.this.moveFocus((Component)keyEvent.getSource(), false);
            } else if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                ToolPalette.this.doToolCopyToCanvas();
            }
        }
    }

    class ToolboxDragAdapter
    extends ComponentDragAdapter {
        public ToolboxDragAdapter(DragPane dragPane, String string) {
            super(dragPane, string);
        }

        protected void startDrag(MouseEvent mouseEvent) {
            super.startDrag(mouseEvent);
            DragPane dragPane = ToolPalette.this.mOwner.getDragPane();
            Component component = mouseEvent.getComponent();
            BufferedImage bufferedImage = this.getDragImage(component);
            if (this.mTransferData == null) {
                this.acquireTransferData();
            }
            Point point = (Point)mouseEvent.getPoint().clone();
            SwingUtilities.convertPointToScreen(point, component);
            SwingUtilities.convertPointFromScreen(point, (Component)dragPane);
            dragPane.setDragImage(bufferedImage, false);
            dragPane.setDragPoint(point);
            dragPane.setVisible(true);
            dragPane.repaint();
        }

        protected void acquireTransferData() {
            this.mTransferData = ToolPalette.this.getSelectedTool();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (this.mTransferData != null) {
                DragPane dragPane = ToolPalette.this.mOwner.getDragPane();
                Component component = mouseEvent.getComponent();
                Point point = (Point)mouseEvent.getPoint().clone();
                SwingUtilities.convertPointToScreen(point, component);
                SwingUtilities.convertPointFromScreen(point, (Component)dragPane);
                dragPane.setDragPoint(point);
                dragPane.paintImmediately(dragPane.getBounds());
                dragPane.dragOver((DragDropAdapter)this);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (mouseEvent.getClickCount() > 1) {
                ToolPalette.this.doToolCopyToCanvas();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            Point point = (Point)mouseEvent.getPoint().clone();
            SwingUtilities.convertPointToScreen(point, component);
            DragPane dragPane = ToolPalette.this.mOwner.getDragPane();
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point, (Component)dragPane);
            dragPane.setVisible(false);
            dragPane.setDragImage(null, false);
            dragPane.setDragPoint(point);
            dragPane.fireDropEvent(new DropEvent(component, point2, (DragDropAdapter)this));
            super.mouseReleased(mouseEvent);
            this.mTransferData = null;
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ToolPalette.this.updateHighlight(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ToolPalette.this.updateHighlight(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ToolPalette.this.selectTool(mouseEvent.getSource());
        }
    }
}

