/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools.ToolType;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ToolItem
extends JLabel {
    private ToolType mToolType;

    public ToolItem(ToolType toolType) {
        this.mToolType = toolType;
        this.setFont(new Font("SansSerif", 0, 12));
        String string = this.getBaseId();
        this.setText(BuilderResUtil.getString(string));
        this.setToolTipText(BuilderResUtil.getString(string + "_TIP"));
        this.setIcon(new ImageIcon(BuilderResUtil.getImageResource(this.getToolIconFileName())));
    }

    public ToolType getToolType() {
        return this.mToolType;
    }

    private String getBaseId() {
        if (this.mToolType == ToolType.CHECKBOX_CONTROL) {
            return "IDS_CHECKBOX_TOOL";
        }
        if (this.mToolType == ToolType.CHECKBOX_GROUP_CONTROL) {
            return "IDS_CHECKBOX_GROUP_TOOL";
        }
        if (this.mToolType == ToolType.COMBO_BOX_CONTROL) {
            return "IDS_COMBOBOX_TOOL";
        }
        if (this.mToolType == ToolType.DIALOG_TAB_CONTROL) {
            return "IDS_DLG_TAB_TOOL";
        }
        if (this.mToolType == ToolType.EDIT_TEXT_CONTROL) {
            return "IDS_EDIT_TEXT_TOOL";
        }
        if (this.mToolType == ToolType.NUMBER_EDIT_CONTROL) {
            return "IDS_NUMBER_EDIT_TOOL";
        }
        if (this.mToolType == ToolType.LISTBOX_CONTROL) {
            return "IDS_LISTBOX_TOOL";
        }
        if (this.mToolType == ToolType.RADIO_GROUP) {
            return "IDS_RADIO_GROUP_TOOL";
        }
        if (this.mToolType == ToolType.SOURCE_VAR_LIST) {
            return "IDS_SRC_LIST_TOOL";
        }
        if (this.mToolType == ToolType.STATIC_TEXT_CONTROL) {
            return "IDS_STATIC_TEXT_TOOL";
        }
        if (this.mToolType == ToolType.SUB_DIALOG_BUTTON) {
            return "IDS_SUB_DLG_TOOL";
        }
        if (this.mToolType == ToolType.TARGET_VAR_LIST) {
            return "IDS_TARGET_LIST_TOOL";
        }
        if (this.mToolType == ToolType.FILE_SYSTEM_BROWSER) {
            return "IDS_FILE_SYSTEM_BROWSER_TOOL";
        }
        if (this.mToolType == ToolType.ITEM_GROUP_CONTROL) {
            return "IDS_ITEM_GROUP_TOOL";
        }
        assert (false);
        return null;
    }

    private String getToolIconFileName() {
        if (this.mToolType == ToolType.CHECKBOX_CONTROL) {
            return "check_box.png";
        }
        if (this.mToolType == ToolType.CHECKBOX_GROUP_CONTROL) {
            return "checkbox_group.png";
        }
        if (this.mToolType == ToolType.COMBO_BOX_CONTROL) {
            return "combo_box.png";
        }
        if (this.mToolType == ToolType.DIALOG_TAB_CONTROL) {
            return "tab_ctrl.png";
        }
        if (this.mToolType == ToolType.EDIT_TEXT_CONTROL) {
            return "edit_ctrl.png";
        }
        if (this.mToolType == ToolType.NUMBER_EDIT_CONTROL) {
            return "number_edit_ctrl.png";
        }
        if (this.mToolType == ToolType.LISTBOX_CONTROL) {
            return "list_box.png";
        }
        if (this.mToolType == ToolType.RADIO_GROUP) {
            return "radio_group.png";
        }
        if (this.mToolType == ToolType.SOURCE_VAR_LIST) {
            return "src_list.png";
        }
        if (this.mToolType == ToolType.STATIC_TEXT_CONTROL) {
            return "static_text.png";
        }
        if (this.mToolType == ToolType.SUB_DIALOG_BUTTON) {
            return "dlg_button.png";
        }
        if (this.mToolType == ToolType.TARGET_VAR_LIST) {
            return "target_list.png";
        }
        if (this.mToolType == ToolType.FILE_SYSTEM_BROWSER) {
            return "file_browser.png";
        }
        if (this.mToolType == ToolType.ITEM_GROUP_CONTROL) {
            return "item_group.png";
        }
        assert (false);
        return null;
    }
}

