/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.definition.VarListDefinition;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VariableFilterDlg
extends BaseDialog
implements ActionListener {
    private BuilderFrame mFrame;
    private VarListDefinition mVarListDef;
    private JCheckBox mNumericCheck;
    private JCheckBox mDateTimeCheck;
    private JCheckBox mStringCheck;
    private JCheckBox mNominalCheck;
    private JCheckBox mOrdinalCheck;
    private JCheckBox mScaleCheck;
    private JCheckBox mMRVarCheck;
    private JButton mOkButton;

    public VariableFilterDlg(BuilderFrame builderFrame, VarListDefinition varListDefinition) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_FILTER_DLG_TITLE"), true, ResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mVarListDef = varListDefinition;
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER_VARFILTER");
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BuilderResUtil.getString("IDS_VAR_TYPE")));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BuilderResUtil.getString("IDS_VAR_MEAS")));
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel4 = new JPanel(new GridBagLayout(), true);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BuilderResUtil.getString("IDS_VAR_SPECIAL")));
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        this.mStringCheck = new JCheckBox(BuilderResUtil.getString("IDS_STRING"), true);
        this.mStringCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_STRING"));
        jPanel2.add((Component)this.mStringCheck, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mNumericCheck = new JCheckBox(BuilderResUtil.getString("IDS_NUMERIC"), true);
        this.mNumericCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_NUMERIC"));
        jPanel2.add((Component)this.mNumericCheck, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.mDateTimeCheck = new JCheckBox(BuilderResUtil.getString("IDS_DATETIME"), true);
        this.mDateTimeCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_DATETIME"));
        jPanel2.add((Component)this.mDateTimeCheck, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        this.mNominalCheck = new JCheckBox(BuilderResUtil.getString("IDS_NOMINAL"), true);
        this.mNominalCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_NOMINAL"));
        jPanel3.add((Component)this.mNominalCheck, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mOrdinalCheck = new JCheckBox(BuilderResUtil.getString("IDS_ORDINAL"), true);
        this.mOrdinalCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_ORDINAL"));
        jPanel3.add((Component)this.mOrdinalCheck, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.mScaleCheck = new JCheckBox(BuilderResUtil.getString("IDS_SCALE"), true);
        this.mScaleCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_SCALE"));
        jPanel3.add((Component)this.mScaleCheck, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        this.mMRVarCheck = new JCheckBox(BuilderResUtil.getString("IDS_MRVARS"), false);
        this.mMRVarCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_MRVARS"));
        jPanel4.add((Component)this.mMRVarCheck, gridBagConstraints);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    private void loadData() {
        this.mNumericCheck.setSelected(this.mVarListDef.isIncluded(VarListDefinition.NUMERIC_BIT));
        this.mDateTimeCheck.setSelected(this.mVarListDef.isIncluded(VarListDefinition.DATETIME_BIT));
        this.mStringCheck.setSelected(this.mVarListDef.isIncluded(VarListDefinition.STRING_BIT));
        this.mNominalCheck.setSelected(this.mVarListDef.isIncluded(VarListDefinition.NOMINAL_BIT));
        this.mOrdinalCheck.setSelected(this.mVarListDef.isIncluded(VarListDefinition.ORDINAL_BIT));
        this.mScaleCheck.setSelected(this.mVarListDef.isIncluded(VarListDefinition.SCALE_BIT));
        this.mMRVarCheck.setSelected(this.mVarListDef.isIncluded(VarListDefinition.MRVARS_BIT));
        this.mNumericCheck.addActionListener(this);
        this.mDateTimeCheck.addActionListener(this);
        this.mStringCheck.addActionListener(this);
        this.mNominalCheck.addActionListener(this);
        this.mOrdinalCheck.addActionListener(this);
        this.mScaleCheck.addActionListener(this);
        this.mMRVarCheck.addActionListener(this);
    }

    private void enableOKButton() {
        boolean bl = !(!this.mNumericCheck.isSelected() && !this.mDateTimeCheck.isSelected() && !this.mStringCheck.isSelected() || !this.mNominalCheck.isSelected() && !this.mOrdinalCheck.isSelected() && !this.mScaleCheck.isSelected());
        this.mOkButton.setEnabled(bl || this.mMRVarCheck.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.enableOKButton();
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VariableFilterDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VariableFilterDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VariableFilterDlg.this.mVarListDef.includeFilterType(VarListDefinition.NUMERIC_BIT, VariableFilterDlg.this.mNumericCheck.isSelected());
            VariableFilterDlg.this.mVarListDef.includeFilterType(VarListDefinition.DATETIME_BIT, VariableFilterDlg.this.mDateTimeCheck.isSelected());
            VariableFilterDlg.this.mVarListDef.includeFilterType(VarListDefinition.STRING_BIT, VariableFilterDlg.this.mStringCheck.isSelected());
            VariableFilterDlg.this.mVarListDef.includeFilterType(VarListDefinition.MRVARS_BIT, VariableFilterDlg.this.mMRVarCheck.isSelected());
            VariableFilterDlg.this.mVarListDef.includeFilterType(VarListDefinition.NOMINAL_BIT, VariableFilterDlg.this.mNominalCheck.isSelected());
            VariableFilterDlg.this.mVarListDef.includeFilterType(VarListDefinition.ORDINAL_BIT, VariableFilterDlg.this.mOrdinalCheck.isSelected());
            VariableFilterDlg.this.mVarListDef.includeFilterType(VarListDefinition.SCALE_BIT, VariableFilterDlg.this.mScaleCheck.isSelected());
            VariableFilterDlg.this.mFrame.setModified(true);
            VariableFilterDlg.this.dispose();
        }
    }
}

