/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class RequiredAddOnsDlg
extends BaseDialog {
    private JList mList;
    private DialogDefinition mDialogDef;

    public RequiredAddOnsDlg(JFrame jFrame, DialogDefinition dialogDefinition) throws HeadlessException {
        super(jFrame, BuilderResUtil.getString("IDS_REQ_ADD_ONS_TITLE"), true, ResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), BuilderResBundle.getImageFolder());
        this.mDialogDef = dialogDefinition;
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER_ADDONS");
    }

    private void initialize() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = new JLabel(BuilderResUtil.getString("IDS_CHECK_ALL_REQUIRED"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        DefaultListModel<ListBoxItem> defaultListModel = new DefaultListModel<ListBoxItem>();
        this.mList = new JList(defaultListModel);
        this.mList.setCellRenderer(new CheckboxCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.mList);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Dimension dimension = new Dimension(260, 132);
        jScrollPane.setAlignmentX(0.0f);
        this.mList.setMinimumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        this.mList.setPrototypeCellValue(new ListBoxItem(AddOnType.Python));
        int n = this.mList.getFixedCellHeight();
        n = n < 18 ? 18 : n;
        this.mList.setFixedCellHeight(n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListBoxItem listBoxItem;
                if (mouseEvent.isConsumed() || mouseEvent.getClickCount() > 1) {
                    return;
                }
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                listBoxItem.setSelected(!(listBoxItem = (ListBoxItem)jList.getModel().getElementAt(n)).isSelected());
                jList.repaint(jList.getCellBounds(n, n));
                mouseEvent.consume();
            }
        });
        Set set = this.mDialogDef.getRequiredAddOns();
        ListBoxItem listBoxItem = new ListBoxItem(AddOnType.R);
        if (set.contains(AddOnType.R)) {
            listBoxItem.setSelected(true);
        }
        defaultListModel.addElement(listBoxItem);
        listBoxItem = new ListBoxItem(AddOnType.Python);
        if (set.contains(AddOnType.Python)) {
            listBoxItem.setSelected(true);
        }
        defaultListModel.addElement(listBoxItem);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JButton jButton = new JButton(new OKAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    static class ListBoxItem {
        String mLabel;
        boolean mIsSelected;
        AddOnType mType;

        public ListBoxItem(AddOnType addOnType) {
            this.mType = addOnType;
            if (addOnType == AddOnType.R) {
                this.mLabel = BuilderResUtil.getString("IDS_R_PROGRAMMABILITY");
            } else if (addOnType == AddOnType.Python) {
                this.mLabel = BuilderResUtil.getString("IDS_PYTHON_PROGRAMMABILITY");
            }
            this.mIsSelected = false;
        }

        public boolean isSelected() {
            return this.mIsSelected;
        }

        public void setSelected(boolean bl) {
            this.mIsSelected = bl;
        }

        public AddOnType getType() {
            return this.mType;
        }

        public String toString() {
            return this.mLabel;
        }

        public boolean equals(Object object) {
            return object instanceof ListBoxItem && object.toString().equals(this.mLabel);
        }
    }

    class CheckboxCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CheckboxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled());
            this.setSelected(((ListBoxItem)object).isSelected());
            this.setFont(jList.getFont());
            if (bl) {
                this.setForeground(jList.getSelectionForeground());
                if (bl2) {
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setBackground(Color.lightGray);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(object.toString());
            return this;
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RequiredAddOnsDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RequiredAddOnsDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Set set = RequiredAddOnsDlg.this.mDialogDef.getRequiredAddOns();
            set.clear();
            for (int i = 0; i < RequiredAddOnsDlg.this.mList.getModel().getSize(); ++i) {
                ListBoxItem listBoxItem = (ListBoxItem)RequiredAddOnsDlg.this.mList.getModel().getElementAt(i);
                if (!listBoxItem.isSelected()) continue;
                set.add(listBoxItem.getType());
            }
            RequiredAddOnsDlg.this.dispose();
        }
    }
}

