/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.ItemListTable;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RadioListDlg
extends JDialog {
    private ItemListTable mTable;
    private BuilderFrame mFrame;

    public RadioListDlg(BuilderFrame builderFrame, String string, CanvasObject canvasObject) throws HeadlessException {
        super(builderFrame, string, true);
        this.mFrame = builderFrame;
        this.init(canvasObject);
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    private void init(CanvasObject canvasObject) {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.mTable = new ItemListTable(this.mFrame, canvasObject);
        this.mTable.setBorder(BorderFactory.createEtchedBorder());
        this.mTable.getColumnModel().setColumnMargin(1);
        this.add(new JScrollPane(this.mTable));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(new JButton(new OKAction()));
        jPanel.add(new JButton(new CancelAction()));
        jPanel.add(new JButton(new HelpAction()));
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        this.add(jPanel);
        this.setPreferredSize(new Dimension(600, 200));
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "IDH_IDD_UIBUILDER_RADIOPROPS";
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RadioListDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RadioListDlg.this.mTable.isEditing()) {
                RadioListDlg.this.mTable.getCellEditor().stopCellEditing();
            }
            RadioListDlg.this.mTable.saveData();
            RadioListDlg.this.mFrame.setModified(true);
            RadioListDlg.this.dispose();
        }
    }
}

