/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.controls.ButtonEditCtrl;
import com.spss.java_client.ui.controls.IButtonEditListener;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.MenuLocationDialog;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.SyntaxDiagramDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CheckBoxGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CheckBoxObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ComboBoxObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.EditCtrlObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.FileSystemBrowserObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ISelectionListener;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ItemGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ListBoxObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.SrcListObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.StaticCtrlObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.SubDlgButtonObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.TargetListObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.AttrType;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.FileFilterDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.ItemListDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.RadioListDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.RequiredAddOnsDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.VariableFilterDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.syntax.SyntaxPrefManager;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.EditCtrlDefinition;
import com.spss.uitools.ui_builder.definition.FileSystemBrowserDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.SrcListDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.ui_builder.definition.VarListDefinition;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PropertiesPanel
extends JPanel
implements ISelectionListener,
CommandLocation.ResLoader {
    private static Font sItalicFont = null;
    private JLabel mLabel;
    private PropsTable mPropTable;
    private PropsModel mModel;
    private Vector<AttrType> mRowTypes;
    private DialogDefinition mDlgDef;
    SyntaxDiagramDlg mSyntaxDiagramDlg;

    public PropertiesPanel(DialogDefinition dialogDefinition) {
        this.mDlgDef = dialogDefinition;
        this.mRowTypes = new Vector();
        this.setLayout(new GridBagLayout());
        this.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertiesPanel.this.mPropTable.buildModel(null);
            }
        });
    }

    public DialogDefinition getDlgDef() {
        return this.mDlgDef;
    }

    public void setDlgDef(DialogDefinition dialogDefinition) {
        this.mDlgDef = dialogDefinition;
    }

    public void focusTable() {
        this.mPropTable.requestFocus();
    }

    public CanvasObject getSelectedObject() {
        return this.mModel.mCanvasObject;
    }

    public void launchControlEditor(PanelElementDefinition panelElementDefinition) {
        if (panelElementDefinition instanceof SubDlgButtonDefinition) {
            this.launchSubDlgEditor((SubDlgButtonDefinition)panelElementDefinition);
        } else if (panelElementDefinition instanceof VarListDefinition) {
            VariableFilterDlg variableFilterDlg = new VariableFilterDlg(this.getBuilderFrame(), (VarListDefinition)panelElementDefinition);
            variableFilterDlg.setVisible(true);
        } else if (panelElementDefinition instanceof RadioGroupDefinition) {
            RadioListDlg radioListDlg = new RadioListDlg(this.getBuilderFrame(), BuilderResUtil.getString("IDS_RADIO_DLG_TITLE"), this.mModel.mCanvasObject);
            radioListDlg.setVisible(true);
            this.refreshCanvas();
        } else if (panelElementDefinition instanceof ListDefinition) {
            if (!(this.mModel.mCanvasObject instanceof ComboBoxObject) && !(this.mModel.mCanvasObject instanceof ListBoxObject)) {
                return;
            }
            ItemListDlg itemListDlg = new ItemListDlg(this.getBuilderFrame(), BuilderResUtil.getString("IDS_LIST_DLG_TITLE"), this.mModel.mCanvasObject);
            itemListDlg.setVisible(true);
            this.refreshCanvas();
        } else if (panelElementDefinition instanceof FileSystemBrowserDefinition) {
            FileFilterDlg fileFilterDlg = new FileFilterDlg(this.getBuilderFrame(), (FileSystemBrowserObject)this.mModel.mCanvasObject);
            fileFilterDlg.setVisible(true);
        }
    }

    public BuilderFrame launchSubDlgEditor(SubDlgButtonDefinition subDlgButtonDefinition) {
        final BuilderFrame builderFrame = new BuilderFrame(subDlgButtonDefinition.getDialogDefinition());
        builderFrame.showEditor(this.getBuilderFrame());
        this.getBuilderFrame().setEnabled(false);
        builderFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (builderFrame.isModified()) {
                    PropertiesPanel.this.getBuilderFrame().setModified(true);
                }
                PropertiesPanel.this.getBuilderFrame().setEnabled(true);
            }
        });
        return builderFrame;
    }

    public void commitEdits() {
        if (this.mPropTable.isEditing() && !this.mPropTable.getCellEditor().stopCellEditing()) {
            this.mPropTable.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void selectionChanged(CanvasObject canvasObject) {
        this.mPropTable.buildModel(canvasObject);
        this.refreshLabel();
    }

    public String getString(String string) {
        return ResUtil.getString(string);
    }

    private BuilderFrame getBuilderFrame() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof BuilderFrame) {
            return (BuilderFrame)container;
        }
        return null;
    }

    private void refreshCanvas() {
        this.getBuilderFrame().getCanvas().revalidate();
        this.getBuilderFrame().getCanvas().repaint();
    }

    private void refreshLabel() {
        CanvasObject canvasObject = this.mModel.mCanvasObject;
        String string = "";
        if (canvasObject == null) {
            string = BuilderResUtil.getString("IDS_DLG_PROPS");
        } else if (canvasObject instanceof CheckBoxObject) {
            string = BuilderResUtil.getString("IDS_CHECKBOX_PROPS");
        } else if (canvasObject instanceof CheckBoxGroupObject) {
            string = BuilderResUtil.getString("IDS_CHECKBOX_GROUP_PROPS");
        } else if (canvasObject instanceof ItemGroupObject) {
            string = BuilderResUtil.getString("IDS_ITEM_GROUP_PROPS");
        } else if (canvasObject instanceof ComboBoxObject) {
            string = BuilderResUtil.getString("IDS_COMBO_PROPS");
        } else if (canvasObject instanceof ListBoxObject) {
            string = BuilderResUtil.getString("IDS_LIST_PROPS");
        } else if (canvasObject instanceof EditCtrlObject) {
            boolean bl;
            EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)canvasObject.getCtrlDef();
            EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
            boolean bl2 = bl = parseType == EditCtrlDefinition.ParseType.integer || parseType == EditCtrlDefinition.ParseType.number;
            string = bl ? BuilderResUtil.getString("IDS_NUMERIC_EDIT_PROPS") : BuilderResUtil.getString("IDS_EDIT_PROPS");
        } else if (canvasObject instanceof StaticCtrlObject) {
            string = BuilderResUtil.getString("IDS_STATIC_PROPS");
        } else if (canvasObject instanceof RadioGroupObject) {
            string = BuilderResUtil.getString("IDS_RADIO_GROUP_PROPS");
        } else if (canvasObject instanceof SrcListObject) {
            string = BuilderResUtil.getString("IDS_SRC_LIST_PROPS");
        } else if (canvasObject instanceof TargetListObject) {
            string = BuilderResUtil.getString("IDS_TGT_LIST_PROPS");
        } else if (canvasObject instanceof SubDlgButtonObject) {
            string = BuilderResUtil.getString("IDS_SUB_DLG_PROPS");
        } else if (canvasObject instanceof FileSystemBrowserObject) {
            string = BuilderResUtil.getString("IDS_FSB_PROPS");
        }
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            this.mLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mLabel.setText(string);
        }
    }

    private Font getItalicFont() {
        if (sItalicFont == null) {
            String string = BuilderResUtil.getString("IDS_ITALIC_VALUE");
            Font font = this.mModel == null || this.mModel.mCanvasObject == null ? new Font("SansSerif", 0, 12) : this.mModel.mCanvasObject.getFont();
            sItalicFont = string != null && string.equals("2") ? font.deriveFont(2) : font.deriveFont(0);
        }
        return sItalicFont;
    }

    private void adjustFont(int n, JComponent jComponent) {
        SubDlgButtonDefinition subDlgButtonDefinition;
        String string;
        AttrType attrType = this.mRowTypes.get(n);
        boolean bl = false;
        if (attrType == AttrType.launches && ((string = (subDlgButtonDefinition = (SubDlgButtonDefinition)this.mModel.mCanvasObject.getCtrlDef()).getDialogDefinition().getDialogTitle()) == null || string.length() == 0)) {
            bl = true;
        }
        if (attrType == AttrType.radioItems || attrType == AttrType.itemList || bl || attrType == AttrType.varFilters || attrType == AttrType.fileFilters || attrType == AttrType.requiredAddOns) {
            jComponent.setFont(this.getItalicFont());
            jComponent.setForeground(Color.gray);
        } else {
            jComponent.setFont(this.getBuilderFrame().getCanvas().getFont());
            jComponent.setForeground(Color.black);
        }
    }

    private void runMenuLocationDialog() {
        BuilderFrame builderFrame = this.getBuilderFrame();
        if (MenuLocationDialog.runMenuLocationDialog(builderFrame, builderFrame.getCanvas().getDialogDefinition().getCommandLocation())) {
            builderFrame.getCanvas().fireSelectionChange(null);
            builderFrame.setModified(true);
        }
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(4, 2, 2, 2), 0, 0);
        this.mLabel = new JLabel(BuilderResUtil.getString("IDS_DLG_PROPS"));
        this.mLabel.setHorizontalAlignment(10);
        this.mLabel.setFont(new Font("SansSerif", 1, 12));
        this.mLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_PROPERTIES"));
        this.add((Component)this.mLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 2, 2, 2), 0, 0);
        this.mModel = new PropsModel();
        this.mPropTable = new PropsTable(this.mModel);
        this.add((Component)new JScrollPane(this.mPropTable), gridBagConstraints);
        this.mLabel.setLabelFor(this.mPropTable);
        this.mPropTable.setBorder(BorderFactory.createEtchedBorder());
        this.mPropTable.setBackground(new Color(221, 221, 221));
        this.mPropTable.setFont(new Font("SansSerif", 0, 12));
        this.mPropTable.getColumnModel().setColumnMargin(1);
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = BuilderResUtil.getShortcut("IDK_CANVAS");
        inputMap.put(keyStroke, "FocusCanvas");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesPanel.this.getBuilderFrame().getCanvas().requestFocus();
            }
        };
        this.getActionMap().put("FocusCanvas", abstractAction);
        keyStroke = BuilderResUtil.getShortcut("IDK_TOOLS");
        inputMap.put(keyStroke, "FocusPalette");
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesPanel.this.getBuilderFrame().focusToolPalette();
            }
        };
        this.getActionMap().put("FocusPalette", abstractAction2);
    }

    private boolean findObjectIdInRadioButtonGroup(String string) {
        DialogDefinition dialogDefinition = this.getBuilderFrame().getCanvas().getDialogDefinition();
        if (dialogDefinition.getParentDefinition() != null) {
            dialogDefinition = dialogDefinition.getParentDefinition();
        }
        for (PanelDefinition panelDefinition : dialogDefinition.getPanels()) {
            for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
                if (!(panelElementDefinition instanceof RadioGroupDefinition)) continue;
                int n = ((RadioGroupDefinition)panelElementDefinition).radioItemCount();
                for (int j = 0; j < n; ++j) {
                    RadioItemDefinition radioItemDefinition = ((RadioGroupDefinition)panelElementDefinition).getRadioItem(j);
                    if (radioItemDefinition.getControlId().equals(string)) {
                        return true;
                    }
                    if (radioItemDefinition.getHasSubGroup()) {
                        int n2 = radioItemDefinition.getElementCount();
                        for (int k = 0; k < n2; ++k) {
                            String string2 = radioItemDefinition.getPanelElement(k).getControlId();
                            if (!string2.toString().equals(string)) continue;
                            return true;
                        }
                    }
                    if (!((RadioGroupDefinition)panelElementDefinition).getRadioItem(j).getControlId().equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    class ComboItem<T> {
        private T mData;
        private String mLabel;

        public ComboItem(String string, T t) {
            this.mLabel = string;
            this.mData = t;
        }

        public T getData() {
            return this.mData;
        }

        public void setData(T t) {
            this.mData = t;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public void setLabel(String string) {
            this.mLabel = string;
        }

        public String toString() {
            return this.mLabel;
        }
    }

    static class LimitedPlainDocument
    extends PlainDocument {
        private int mMaxCharacters;

        public LimitedPlainDocument(int n) {
            this.mMaxCharacters = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                String string2 = string.substring(0, this.mMaxCharacters).toUpperCase(ComponentState.getSPSSLocale());
                if (this.getLength() > 0) {
                    this.replace(0, this.mMaxCharacters, string2, attributeSet);
                } else {
                    super.insertString(0, string2, attributeSet);
                }
                if (n >= this.mMaxCharacters) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class HtmFilter
    extends RefFileFilter {
        HtmFilter() {
            super(BuilderResUtil.getString("IDS_HTM_FILTER_TYPE"), "htm;html", ";");
        }

        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName().toUpperCase();
                if (string.endsWith(".HTM") || string.endsWith(".HTML")) {
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return BuilderResUtil.getString("IDS_HTM_FILTER_TYPE");
        }
    }

    class DefCellRenderer
    extends DefaultTableCellRenderer {
        private Border mCellBorder = null;

        DefCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl && !bl2) {
                this.setBackground(Color.lightGray);
                this.setForeground(Color.black);
            }
            if (component instanceof JComponent && n2 == 1) {
                PropertiesPanel.this.adjustFont(n, (JComponent)component);
            }
            if (component instanceof JComponent) {
                if (this.mCellBorder == null) {
                    this.mCellBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
                }
                ((JComponent)component).setBorder(this.mCellBorder);
            }
            return component;
        }
    }

    class CheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JCheckBox mCheckBox;
        private CanvasObject mCanvasObject;
        private AttrType mAttrType;

        public CheckBoxEditor(CanvasObject canvasObject, AttrType attrType, String string) {
            this.mCanvasObject = canvasObject;
            this.mAttrType = attrType;
            this.mCheckBox = new JCheckBox(string);
            this.mCheckBox.setFont(this.mCanvasObject.getFont());
            this.mCheckBox.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCheckBox.isSelected() ? BuilderResUtil.getString("IDS_MULTI_ITEM") : BuilderResUtil.getString("IDS_SINGLE_ITEM");
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.mCheckBox;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mAttrType == AttrType.targetListType) {
                TargetListObject targetListObject = (TargetListObject)this.mCanvasObject;
                targetListObject.setIsMultiItemList(this.mCheckBox.isSelected());
                PropertiesPanel.this.refreshCanvas();
            }
        }
    }

    class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mComboBox;

        public ComboEditor(Object[] objectArray) {
            this.mComboBox = new JComboBox<Object>(objectArray);
            this.mComboBox.setEditable(false);
        }

        @Override
        public Object getCellEditorValue() {
            return this.mComboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.mComboBox;
        }
    }

    class NumberEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private SPSSTextField mTextField;

        public NumberEditor(SPSSTextField sPSSTextField) {
            super((JTextField)sPSSTextField);
            this.mTextField = sPSSTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mTextField.getUnformattedText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mTextField.setText(object != null ? object.toString() : "");
            return this.mTextField;
        }

        public void setEditCtrl(SPSSTextField sPSSTextField) {
            this.mTextField = sPSSTextField;
            this.editorComponent = sPSSTextField;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object object) {
                    NumberEditor.this.mTextField.setText(object != null ? object.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return NumberEditor.this.mTextField.getUnformattedText();
                }
            };
            this.mTextField.addActionListener((ActionListener)this.delegate);
        }
    }

    static class MnemonicEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTextField mTextField;

        public MnemonicEditor(JTextField jTextField) {
            super(jTextField);
            this.mTextField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            if (ComponentState.isBtdRtlOrLtr() && this.mTextField.getText() != null && this.mTextField.getText().length() > 0) {
                return ComponentState.removeBidiDirectionMarks((String)this.mTextField.getText());
            }
            return this.mTextField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 && ((String)object).indexOf(8206) == -1) {
                this.mTextField.setText(ComponentState.prepareStringForBidiRendering((String)((String)object)));
            } else {
                this.mTextField.setText(object != null ? object.toString() : "");
            }
            return this.mTextField;
        }
    }

    class PropsModel
    extends DefaultTableModel {
        private CanvasObject mCanvasObject = null;

        public void setCanvasObject(CanvasObject canvasObject) {
            this.mCanvasObject = canvasObject;
        }

        @Override
        public int getColumnCount() {
            return super.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return super.getRowCount();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (object2 != null && object2.equals(object)) {
                return;
            }
            boolean bl = true;
            if (n2 == 1) {
                bl = this.dispatchProperty(n, object);
            }
            if (bl) {
                super.setValueAt(object, n, n2);
            }
        }

        private boolean dispatchProperty(int n, Object object) {
            AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(n));
            if (this.mCanvasObject != null ? !this.dispatchControlProperties(object, attrType) : !this.dispatchDialogProperties(object, attrType)) {
                return false;
            }
            PropertiesPanel.this.getBuilderFrame().setModified(true);
            PropertiesPanel.this.refreshCanvas();
            return true;
        }

        private boolean dispatchControlProperties(Object object, AttrType attrType) {
            if (attrType == AttrType.elementId) {
                if (!this.setControlId(object.toString())) {
                    return false;
                }
            } else if (attrType == AttrType.title) {
                this.mCanvasObject.setControlTitle(object.toString());
            } else if (attrType == AttrType.tip) {
                this.setCtrlTip(object);
            } else if (attrType == AttrType.syntax) {
                this.setControlSyntax(object, true);
            } else if (attrType == AttrType.syntaxOff) {
                this.setControlSyntax(object, false);
            } else if (attrType == AttrType.subTitle) {
                if (!this.setPanelSubTitle(object)) {
                    return false;
                }
            } else if (attrType == AttrType.defaultValue) {
                this.setCtrlDefaultValue(object);
            } else if (attrType == AttrType.mnemonic) {
                if (!this.setCtrlMnemonic(object)) {
                    return false;
                }
            } else if (attrType == AttrType.copyMove) {
                if (!this.setSrcListCopyMoveState(object)) {
                    return false;
                }
            } else if (attrType != AttrType.targetListType) {
                if (attrType == AttrType.editType) {
                    if (!this.setEditType(object)) {
                        return false;
                    }
                } else if (attrType == AttrType.selectionType) {
                    this.setLBSelectionType(object);
                } else if (attrType == AttrType.minValue || attrType == AttrType.maxValue) {
                    if (!this.setMinMaxValue(attrType, object)) {
                        return false;
                    }
                } else if (attrType == AttrType.browserSystem) {
                    this.setBrowserSystem(object);
                } else if (attrType == AttrType.browserType) {
                    this.setBrowserType(object);
                } else if (attrType == AttrType.browserOp) {
                    this.setBrowserOp(object);
                } else if (attrType == AttrType.required) {
                    this.setIsRequired(object);
                } else {
                    return false;
                }
            }
            return true;
        }

        private void setLBSelectionType(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                ((ListBoxObject)this.mCanvasObject).getListDef().setSelectionType((ListBoxDefinition.SelectionType)comboItem.getData());
            }
        }

        private void setIsModeless(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.FALSE.equals(comboItem.getData());
                PropertiesPanel.this.mDlgDef.setIsModal(bl);
            }
        }

        private void setIsRequired(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                this.mCanvasObject.getCtrlDef().setRequired(bl);
            }
        }

        private void setControlSyntax(Object object, boolean bl) {
            String string = object.toString();
            if (this.mCanvasObject instanceof CheckBoxObject) {
                CheckBoxDefinition checkBoxDefinition = (CheckBoxDefinition)((CheckBoxObject)this.mCanvasObject).getCtrlDef();
                if (bl) {
                    checkBoxDefinition.setCheckedSyntax(string);
                } else {
                    checkBoxDefinition.setUncheckedSyntax(string);
                }
            } else if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                CheckBoxDefinition checkBoxDefinition = ((CheckBoxGroupDefinition)this.mCanvasObject.getCtrlDef()).getControllerCheckBox();
                if (bl) {
                    checkBoxDefinition.setCheckedSyntax(string);
                } else {
                    checkBoxDefinition.setUncheckedSyntax(string);
                }
            } else {
                this.mCanvasObject.setControlSyntax(string);
            }
        }

        private void setBrowserOp(Object object) {
            if (this.mCanvasObject instanceof FileSystemBrowserObject && object instanceof ComboItem) {
                FileSystemBrowserObject fileSystemBrowserObject = (FileSystemBrowserObject)this.mCanvasObject;
                FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                fileSystemBrowserDefinition.setOpenDialog(bl);
            }
        }

        private void setBrowserType(Object object) {
            if (this.mCanvasObject instanceof FileSystemBrowserObject && object instanceof ComboItem) {
                FileSystemBrowserObject fileSystemBrowserObject = (FileSystemBrowserObject)this.mCanvasObject;
                FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.TRUE.equals(comboItem.getData());
                fileSystemBrowserDefinition.setDirectoryBrowser(bl);
            }
        }

        private void setBrowserSystem(Object object) {
            if (this.mCanvasObject instanceof FileSystemBrowserObject && object instanceof ComboItem) {
                FileSystemBrowserObject fileSystemBrowserObject = (FileSystemBrowserObject)this.mCanvasObject;
                FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
                ComboItem comboItem = (ComboItem)object;
                boolean bl = Boolean.FALSE.equals(comboItem.getData());
                fileSystemBrowserDefinition.setServerFileSystem(bl);
            }
        }

        private boolean setMinMaxValue(AttrType attrType, Object object) {
            if (this.mCanvasObject instanceof EditCtrlObject) {
                EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
                if (!"".equals(object)) {
                    Double d = this.string2Value(object.toString(), parseType);
                    if (!Double.isNaN(d) && !this.validateMinMax(attrType, d)) {
                        return false;
                    }
                    if (attrType == AttrType.minValue) {
                        editCtrlDefinition.setMinValue(d.doubleValue());
                    } else {
                        editCtrlDefinition.setMaxValue(d.doubleValue());
                    }
                    this.validateEditDefault(editCtrlDefinition, editCtrlDefinition.getDefaultValue());
                } else if (attrType == AttrType.minValue) {
                    editCtrlDefinition.setMinValue(Double.NaN);
                } else {
                    editCtrlDefinition.setMaxValue(Double.NaN);
                }
            } else {
                return false;
            }
            return true;
        }

        private boolean validateMinMax(AttrType attrType, Double d) {
            if (this.mCanvasObject instanceof EditCtrlObject) {
                double d2;
                boolean bl = attrType == AttrType.minValue;
                EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                double d3 = d2 = bl ? editCtrlDefinition.getMaxValue() : editCtrlDefinition.getMinValue();
                if (bl && d >= d2 || !bl && d <= d2) {
                    SpssAlertOptionPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_INVALID_MIN_MAX"), VersionInfo.getAppVersionString());
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean setEditType(Object object) {
            if (this.mCanvasObject instanceof EditCtrlObject && object instanceof ComboItem) {
                EditCtrlDefinition.ParseType parseType;
                EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                EditCtrlDefinition.ParseType parseType2 = editCtrlDefinition.getParseType();
                boolean bl = parseType2 == EditCtrlDefinition.ParseType.integer || parseType2 == EditCtrlDefinition.ParseType.number;
                ComboItem comboItem = (ComboItem)object;
                if (bl) {
                    Long l;
                    String string;
                    boolean bl2 = Boolean.TRUE.equals(comboItem.getData());
                    parseType = bl2 ? EditCtrlDefinition.ParseType.integer : EditCtrlDefinition.ParseType.number;
                    Object object2 = bl2 ? new IntTextField() : new FloatTextField();
                    int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_MIN_VALUE"));
                    if (n > -1) {
                        if (bl2 && (string = this.getValueAt(n, 1).toString()).length() > 0) {
                            l = Math.round(this.string2Value(string, EditCtrlDefinition.ParseType.integer));
                            this.setValueAt(l.toString(), n, 1);
                        }
                        PropertiesPanel.this.mPropTable.mEditors.set(n, new NumberEditor((SPSSTextField)object2));
                    }
                    object2 = bl2 ? new IntTextField() : new FloatTextField();
                    n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_MAX_VALUE"));
                    if (n > -1) {
                        if (bl2 && (string = this.getValueAt(n, 1).toString()).length() > 0) {
                            l = Math.round(this.string2Value(string, EditCtrlDefinition.ParseType.integer));
                            this.setValueAt(l.toString(), n, 1);
                        }
                        PropertiesPanel.this.mPropTable.mEditors.set(n, new NumberEditor((SPSSTextField)object2));
                    }
                } else {
                    parseType = Boolean.TRUE.equals(comboItem.getData()) ? EditCtrlDefinition.ParseType.variableName : EditCtrlDefinition.ParseType.string;
                }
                editCtrlDefinition.setParseType(parseType);
                if (parseType == EditCtrlDefinition.ParseType.variableName) {
                    this.validateEditDefault(editCtrlDefinition, editCtrlDefinition.getDefaultValue());
                }
            } else {
                return false;
            }
            return true;
        }

        private int getRowForFirstColumnValue(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.getValueAt(i, 0);
                if (!object.toString().equals(string)) continue;
                return i;
            }
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean dispatchDialogProperties(Object object, AttrType attrType) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            if (attrType == AttrType.elementId) {
                String string = object.toString();
                String string2 = dialogDefinition.getDialogId();
                dialogDefinition.setDialogId("");
                if (string.length() > 0 && PropertiesPanel.this.getBuilderFrame().getCanvas().findCanvasObject(string) == null && !string.contains(" ")) {
                    dialogDefinition.setDialogId(string);
                    return true;
                }
                String string3 = "";
                string3 = string.length() == 0 ? BuilderResUtil.getString("IDS_MISSING_ID_WARNING") : (string.contains(" ") ? BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES") : BuilderResUtil.getString("IDS_DUPLICATE_ID_WARNING"));
                dialogDefinition.setDialogId(string2);
                SpssAlertOptionPane.showWarningMessageDialog(PropertiesPanel.this, string3, VersionInfo.getAppVersionString());
                return false;
            }
            if (attrType == AttrType.title) {
                String string = object.toString();
                dialogDefinition.setDialogTitle(string);
                String string4 = BuilderResUtil.getString("IDS_UIBUILDER_TITLE");
                if (string != null && string.length() > 0) {
                    string4 = string4 + " - " + dialogDefinition.getDialogTitle();
                }
                PropertiesPanel.this.getBuilderFrame().setTitle(string4);
                return true;
            }
            if (attrType == AttrType.helpFile) {
                dialogDefinition.setHelpFileName(object.toString());
                return true;
            }
            if (attrType == AttrType.customPath) {
                dialogDefinition.setCustomPropertiesFile(object.toString());
                return true;
            }
            if (attrType == AttrType.menuItem) {
                TraceSettings.trace1((String)("AttrType.menuItem: " + object.toString()), (int)15);
                return true;
            }
            if (attrType == AttrType.modal) {
                this.setIsModeless(object);
                return true;
            }
            if (attrType != AttrType.requiredAddOns) return false;
            return true;
        }

        private boolean setSrcListCopyMoveState(Object object) {
            if (!(this.mCanvasObject instanceof SrcListObject) || !(object instanceof ComboItem)) {
                return false;
            }
            ComboItem comboItem = (ComboItem)object;
            SrcListDefinition.TransferOp transferOp = Boolean.FALSE.equals(comboItem.getData()) ? SrcListDefinition.TransferOp.move : SrcListDefinition.TransferOp.copy;
            ((SrcListDefinition)this.mCanvasObject.getCtrlDef()).setTransferOp(transferOp);
            return true;
        }

        private boolean setCtrlMnemonic(Object object) {
            CanvasObject canvasObject = this.mCanvasObject;
            if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                canvasObject = (CheckBoxObject)this.mCanvasObject.getComponent(0);
            }
            if (canvasObject == null) {
                return false;
            }
            String string = object.toString();
            if (string.length() > 0) {
                Integer n = string.toUpperCase().charAt(0);
                canvasObject.getCtrlDef().setMnemonicKey(n);
            } else {
                canvasObject.getCtrlDef().setMnemonicKey(null);
            }
            return true;
        }

        private void setCtrlDefaultValue(Object object) {
            if (this.mCanvasObject instanceof EditCtrlObject) {
                EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)this.mCanvasObject.getCtrlDef();
                if (!this.validateEditDefault(editCtrlDefinition, object.toString())) {
                    return;
                }
                EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
                if (object.toString().length() > 0 && parseType == EditCtrlDefinition.ParseType.integer) {
                    Double d = this.string2Value(object.toString(), editCtrlDefinition.getParseType());
                    object = d.intValue();
                }
                editCtrlDefinition.setDefaultValue(object.toString());
            } else if (this.mCanvasObject instanceof FileSystemBrowserObject) {
                FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)((FileSystemBrowserObject)((PropertiesPanel)PropertiesPanel.this).mModel.mCanvasObject).getCtrlDef();
                fileSystemBrowserDefinition.setDefaultValue((String)object);
            } else if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                if (this.mCanvasObject instanceof CheckBoxObject) {
                    ((CheckBoxDefinition)this.mCanvasObject.getCtrlDef()).setDefaultState(((Boolean)comboItem.getData()).booleanValue());
                } else if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                    CheckBoxGroupObject checkBoxGroupObject = (CheckBoxGroupObject)this.mCanvasObject;
                    CheckBoxObject checkBoxObject = (CheckBoxObject)checkBoxGroupObject.getComponent(0);
                    ((CheckBoxDefinition)checkBoxObject.getCtrlDef()).setDefaultState(((Boolean)comboItem.getData()).booleanValue());
                }
            }
        }

        private boolean validateEditDefault(EditCtrlDefinition editCtrlDefinition, String string) {
            VarNameValidator.ValidNameCode validNameCode;
            boolean bl;
            if (string == null || string.length() == 0) {
                return true;
            }
            boolean bl2 = true;
            EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
            boolean bl3 = bl = parseType == EditCtrlDefinition.ParseType.integer || parseType == EditCtrlDefinition.ParseType.number;
            if (bl) {
                double d = editCtrlDefinition.getMinValue();
                double d2 = editCtrlDefinition.getMaxValue();
                Double d3 = this.string2Value(string, parseType);
                if (Double.isNaN(d3)) {
                    bl2 = false;
                } else {
                    if (!Double.isNaN(d) && d > d3) {
                        bl2 = false;
                    }
                    if (!Double.isNaN(d2) && d2 < d3) {
                        bl2 = false;
                    }
                }
            } else if (EditCtrlDefinition.ParseType.variableName == parseType && (validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true)) != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD && validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_SCRATCH && validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_SYSTEM && validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE) {
                bl2 = false;
            }
            if (!bl2) {
                SpssAlertOptionPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_INVALID_DEFAULT"), VersionInfo.getAppVersionString());
                final int n = this.getRowForFirstColumnValue(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
                if (n > -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PropertiesPanel.this.mPropTable.setValueAt("", n, 1);
                            PropertiesPanel.this.mPropTable.changeSelection(n, 1, false, false);
                            PropertiesPanel.this.focusTable();
                        }
                    });
                }
            }
            return bl2;
        }

        private Double string2Value(String string, EditCtrlDefinition.ParseType parseType) {
            Double d;
            NumberFormat numberFormat = NumberFormat.getNumberInstance(ComponentState.getSPSSLocale());
            try {
                d = string != null && string.length() > 0 ? numberFormat.parse(string).doubleValue() : Double.NaN;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                d = Double.NaN;
            }
            if (!Double.isNaN(d) && parseType == EditCtrlDefinition.ParseType.integer) {
                d = Math.floor(d);
            }
            return d;
        }

        private boolean setPanelSubTitle(Object object) {
            if (!(this.mCanvasObject instanceof CheckBoxGroupObject)) {
                return false;
            }
            CheckBoxGroupObject checkBoxGroupObject = (CheckBoxGroupObject)this.mCanvasObject;
            CheckBoxObject checkBoxObject = (CheckBoxObject)checkBoxGroupObject.getComponent(0);
            checkBoxObject.setControlTitle(object.toString());
            return true;
        }

        private void setCtrlTip(Object object) {
            if (this.mCanvasObject instanceof CheckBoxGroupObject) {
                CheckBoxGroupObject checkBoxGroupObject = (CheckBoxGroupObject)this.mCanvasObject;
                CheckBoxObject checkBoxObject = (CheckBoxObject)checkBoxGroupObject.getComponent(0);
                checkBoxObject.setControlTip(object.toString());
            } else {
                this.mCanvasObject.setControlTip(object.toString());
            }
        }

        private boolean setControlId(String string) {
            String string2;
            String string3 = string2 = this.mCanvasObject != null ? this.mCanvasObject.getControlId() : PropertiesPanel.this.mDlgDef.getDialogId();
            if (string2.equals(string)) {
                return false;
            }
            if (string != null && string.contains(" ")) {
                SpssAlertOptionPane.showWarningMessageDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), VersionInfo.getAppVersionString());
                return false;
            }
            this.mCanvasObject.setControlId("");
            if (string == null || string.length() <= 0 || PropertiesPanel.this.getBuilderFrame().getCanvas().findCanvasObject(string) != null || PropertiesPanel.this.findObjectIdInRadioButtonGroup(string)) {
                this.mCanvasObject.setControlId(string2);
                SpssAlertOptionPane.showWarningMessageDialog(PropertiesPanel.this, string == null || string.length() == 0 ? BuilderResUtil.getString("IDS_MISSING_EL_ID_WARNING") : BuilderResUtil.getString("IDS_DUPLICATE_ID_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
            this.mCanvasObject.setControlId(string);
            return true;
        }
    }

    class PropsTable
    extends JTable
    implements IButtonEditListener {
        private DefCellRenderer mCellRenderer;
        private Vector<TableCellRenderer> mRenderers;
        private Vector<TableCellEditor> mEditors;

        public PropsTable(PropsModel propsModel) {
            super(propsModel);
            this.mRenderers = new Vector();
            this.mEditors = new Vector();
            this.mCellRenderer = new DefCellRenderer();
            this.setAutoResizeMode(3);
            this.setAutoscrolls(true);
            this.getTableHeader().setResizingAllowed(true);
            this.setAutoCreateColumnsFromModel(false);
            this.setSelectionMode(0);
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_PROPERTY"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_VALUE"));
            this.addColumn(tableColumn);
            this.handleCellDelete();
            this.setupTableTabPolicy();
        }

        private boolean canDelete(AttrType attrType) {
            return attrType == AttrType.customPath || attrType == AttrType.defaultValue || attrType == AttrType.elementId || attrType == AttrType.helpFile || attrType == AttrType.maxValue || attrType == AttrType.minValue || attrType == AttrType.mnemonic || attrType == AttrType.subTitle || attrType == AttrType.syntax || attrType == AttrType.syntaxOff || attrType == AttrType.tip || attrType == AttrType.title;
        }

        public void buildModel(CanvasObject canvasObject) {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            this.mRenderers.clear();
            this.mEditors.clear();
            PropertiesPanel.this.mRowTypes.clear();
            Vector<String> vector = new Vector<String>();
            Vector<Vector<Object>> vector2 = new Vector<Vector<Object>>();
            vector.setSize(2);
            vector.set(0, BuilderResUtil.getString("IDS_PROPERTY_LABEL"));
            vector.set(1, BuilderResUtil.getString("IDS_VALUE_LABEL"));
            if (canvasObject != null) {
                this.setupRow(canvasObject.getControlId(), vector2, "IDS_IDENTIFIER", AttrType.elementId);
                this.setupRow(canvasObject.getControlTitle(), vector2, "IDS_TITLE", AttrType.title);
                if (!(canvasObject instanceof StaticCtrlObject) && !(canvasObject instanceof ItemGroupObject)) {
                    this.setupRow(canvasObject.getControlTip(), vector2, "IDS_TIP", AttrType.tip);
                }
                this.addControlProperties(vector2, canvasObject);
                this.addSyntaxProperty(canvasObject, vector2);
            } else {
                this.buildDialogProperties(vector2);
            }
            PropertiesPanel.this.mModel.setDataVector(vector2, vector);
            PropertiesPanel.this.mModel.setCanvasObject(canvasObject);
            int n = this.getColumnModel().getTotalColumnWidth();
            this.getColumnModel().getColumn(0).setPreferredWidth((int)((double)n * 0.33));
            this.getColumnModel().getColumn(1).setPreferredWidth((int)((double)n * 0.67));
            this.changeSelection(0, 0, false, false);
        }

        @Override
        public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
            return this.mCellRenderer;
        }

        @Override
        public boolean isCellSelected(int n, int n2) {
            return this.isRowSelected(n) && this.isColumnSelected(n2);
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            Component component;
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl && (component = this.getEditorComponent()) instanceof JTextField) {
                MouseEvent mouseEvent;
                final JTextField jTextField = (JTextField)component;
                jTextField.selectAll();
                if (eventObject instanceof MouseEvent && (mouseEvent = (MouseEvent)eventObject).getClickCount() > 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jTextField.selectAll();
                        }
                    });
                }
            }
            return bl;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            TableCellRenderer tableCellRenderer;
            if (n2 == 1) {
                tableCellRenderer = this.mRenderers.get(n);
                if (tableCellRenderer instanceof JComponent) {
                    PropertiesPanel.this.adjustFont(n, (JComponent)((Object)tableCellRenderer));
                }
            } else {
                tableCellRenderer = super.getCellRenderer(n, n2);
                if (tableCellRenderer instanceof JComponent) {
                    ((JComponent)((Object)tableCellRenderer)).setForeground(Color.black);
                }
            }
            if (tableCellRenderer instanceof JComponent) {
                ((JComponent)((Object)tableCellRenderer)).setBackground(Color.white);
            }
            return tableCellRenderer;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 1) {
                Object object;
                String string;
                TableCellEditor tableCellEditor = this.mEditors.get(n);
                Component component = tableCellEditor.getTableCellEditorComponent(this, string = (object = this.getValueAt(n, n2)) != null ? object.toString() : "", false, n, n2);
                if (component instanceof JComponent) {
                    PropertiesPanel.this.adjustFont(n, (JComponent)component);
                }
                return tableCellEditor;
            }
            return super.getCellEditor(n, n2);
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            super.columnMarginChanged(changeEvent);
        }

        @Override
        public void buttonPressed(long l, int n) {
            FileSystemBrowserDefinition fileSystemBrowserDefinition;
            final int n2 = (int)l;
            AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(n2));
            if (attrType == AttrType.launches) {
                if (!(PropertiesPanel.this.mModel.mCanvasObject instanceof SubDlgButtonObject)) {
                    return;
                }
                SubDlgButtonObject subDlgButtonObject = (SubDlgButtonObject)PropertiesPanel.this.mModel.mCanvasObject;
                final BuilderFrame builderFrame = PropertiesPanel.this.launchSubDlgEditor((SubDlgButtonDefinition)subDlgButtonObject.getCtrlDef());
                builderFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        SubDlgButtonObject subDlgButtonObject = (SubDlgButtonObject)PropertiesPanel.this.mModel.mCanvasObject;
                        String string = subDlgButtonObject.getDialogDefinition().getDialogTitle();
                        if (string == null || string.length() == 0) {
                            string = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
                        }
                        ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)PropsTable.this.mEditors.get(n2);
                        buttonEditCtrl.getTextField().setText(string);
                        if (builderFrame.isModified()) {
                            PropertiesPanel.this.getBuilderFrame().setModified(true);
                        }
                        PropertiesPanel.this.adjustFont(n2, buttonEditCtrl);
                    }
                });
            } else if (attrType == AttrType.radioItems) {
                if (!(PropertiesPanel.this.mModel.mCanvasObject instanceof RadioGroupObject)) {
                    return;
                }
                RadioListDlg radioListDlg = new RadioListDlg(PropertiesPanel.this.getBuilderFrame(), BuilderResUtil.getString("IDS_RADIO_DLG_TITLE"), PropertiesPanel.this.mModel.mCanvasObject);
                radioListDlg.setVisible(true);
                PropertiesPanel.this.refreshCanvas();
            } else if (attrType == AttrType.itemList) {
                if (!(PropertiesPanel.this.mModel.mCanvasObject instanceof ComboBoxObject) && !(PropertiesPanel.this.mModel.mCanvasObject instanceof ListBoxObject)) {
                    return;
                }
                ItemListDlg itemListDlg = new ItemListDlg(PropertiesPanel.this.getBuilderFrame(), BuilderResUtil.getString("IDS_LIST_DLG_TITLE"), PropertiesPanel.this.mModel.mCanvasObject);
                itemListDlg.setVisible(true);
                PropertiesPanel.this.refreshCanvas();
            } else if (attrType == AttrType.helpFile) {
                this.locateHelpFile(n2, n);
            } else if (attrType == AttrType.customPath) {
                this.locateCustomPropsFile(n2, n);
            } else if (attrType == AttrType.menuItem) {
                PropertiesPanel.this.runMenuLocationDialog();
            } else if (attrType == AttrType.syntax) {
                final BuilderFrame builderFrame = PropertiesPanel.this.getBuilderFrame();
                String string = this.getDialogSyntax();
                BuilderFrame.DialogDefinitionHelper dialogDefinitionHelper = new BuilderFrame.DialogDefinitionHelper();
                PropertiesPanel.this.mSyntaxDiagramDlg = new SyntaxDiagramDlg(builderFrame, string, dialogDefinitionHelper.getControlIds(this.getMainDialogDefinition()), SyntaxMgr.getStaticSyntaxCommands(), SyntaxPrefManager.getSyntaxEditorPreferences(), new SyntaxDiagramDlg.SyntaxDiagramDlgCallback(){

                    @Override
                    public void syntaxModifiedNotification() {
                        PropsTable.this.getMainDialogDefinition().setDialogSyntax(PropertiesPanel.this.mSyntaxDiagramDlg.getSyntax());
                        builderFrame.setModified(true);
                    }

                    @Override
                    public void showHelp() {
                        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER_SYNTEMPLATE");
                    }

                    @Override
                    public boolean showInvalidSyntaxWarning() {
                        int n = SpssAlertOptionPane.showConfirmDialog(PropertiesPanel.this, BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                        return n == 2;
                    }
                });
                PropertiesPanel.this.mSyntaxDiagramDlg.setVisible(true);
                if (PropertiesPanel.this.mSyntaxDiagramDlg.getModalResult()) {
                    builderFrame.getCanvas().fireSelectionChange(null);
                    builderFrame.setModified(true);
                }
            } else if (attrType == AttrType.varFilters) {
                VariableFilterDlg variableFilterDlg = new VariableFilterDlg(PropertiesPanel.this.getBuilderFrame(), (VarListDefinition)PropertiesPanel.this.mModel.mCanvasObject.getCtrlDef());
                variableFilterDlg.setVisible(true);
            } else if (attrType == AttrType.fileFilters) {
                FileFilterDlg fileFilterDlg = new FileFilterDlg(PropertiesPanel.this.getBuilderFrame(), (FileSystemBrowserObject)PropertiesPanel.this.mModel.mCanvasObject);
                fileFilterDlg.setVisible(true);
            } else if (attrType == AttrType.requiredAddOns) {
                DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
                RequiredAddOnsDlg requiredAddOnsDlg = new RequiredAddOnsDlg(PropertiesPanel.this.getBuilderFrame(), dialogDefinition);
                requiredAddOnsDlg.setVisible(true);
                String string = this.buildAddOnsValue(dialogDefinition);
                this.getModel().setValueAt(string, n2, 1);
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                buttonEditCtrl.getTextField().setText(string);
                PropertiesPanel.this.adjustFont(n2, buttonEditCtrl);
            } else if (attrType == AttrType.defaultValue && PropertiesPanel.this.mModel.mCanvasObject instanceof FileSystemBrowserObject && (fileSystemBrowserDefinition = (FileSystemBrowserDefinition)((FileSystemBrowserObject)PropertiesPanel.this.mModel.mCanvasObject).getCtrlDef()) != null) {
                this.locateDefaultFileBrowserFile(n2, n, fileSystemBrowserDefinition);
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n2);
                fileSystemBrowserDefinition.setDefaultValue(buttonEditCtrl.getTextField().getText());
            }
        }

        private String getDialogSyntax() {
            DialogDefinition dialogDefinition = this.getMainDialogDefinition();
            return dialogDefinition.getDialogSyntax();
        }

        private DialogDefinition getMainDialogDefinition() {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            if (dialogDefinition.isSubDialog()) {
                dialogDefinition = dialogDefinition.getParentDefinition();
            }
            return dialogDefinition;
        }

        private void setupRow(String string, Vector<Vector<Object>> vector, String string2, AttrType attrType) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString(string2));
            vector2.add(string);
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(this.getDefaultEditor(String.class));
            PropertiesPanel.this.mRowTypes.add(attrType);
        }

        private void addSyntaxProperty(CanvasObject canvasObject, Vector<Vector<Object>> vector) {
            if (canvasObject instanceof CheckBoxObject) {
                CheckBoxDefinition checkBoxDefinition = (CheckBoxDefinition)canvasObject.getCtrlDef();
                this.setupRow(checkBoxDefinition.getCheckedSyntax(), vector, "IDS_CHECKED_SYNTAX", AttrType.syntax);
                this.setupRow(checkBoxDefinition.getUncheckedSyntax(), vector, "IDS_UNCHECKED_SYNTAX", AttrType.syntaxOff);
            } else if (canvasObject instanceof CheckBoxGroupObject) {
                CheckBoxDefinition checkBoxDefinition = ((CheckBoxGroupDefinition)canvasObject.getCtrlDef()).getControllerCheckBox();
                this.setupRow(checkBoxDefinition.getCheckedSyntax(), vector, "IDS_CHECKED_SYNTAX", AttrType.syntax);
                this.setupRow(checkBoxDefinition.getUncheckedSyntax(), vector, "IDS_UNCHECKED_SYNTAX", AttrType.syntaxOff);
            } else if (this.generatesSyntax(canvasObject)) {
                this.setupRow(canvasObject.getControlSyntax(), vector, "IDS_SYNTAX", AttrType.syntax);
            }
        }

        private void handleCellDelete() {
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCellEditor tableCellEditor;
                    Component component;
                    int n = PropsTable.this.getSelectedRow();
                    int n2 = PropsTable.this.getSelectedColumn();
                    AttrType attrType = (AttrType)((Object)PropertiesPanel.this.mRowTypes.get(n));
                    if (n2 == 1 && PropsTable.this.canDelete(attrType) && PropsTable.this.editCellAt(n, n2) && (component = (tableCellEditor = PropsTable.this.getCellEditor()).getTableCellEditorComponent(PropsTable.this, "", false, n, n2)) instanceof JTextField) {
                        ((JTextField)component).setText("");
                    }
                }
            };
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "DeleteRow");
            this.getActionMap().put("DeleteRow", abstractAction);
        }

        private void setupTableTabPolicy() {
            InputMap inputMap = this.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 1);
            final Action action = this.getActionMap().get(inputMap.get(keyStroke));
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getRowCount();
                    int n2 = jTable.getColumnCount();
                    int n3 = jTable.getSelectedRow();
                    int n4 = jTable.getSelectedColumn();
                    if (n4 == n2 - 1 && n3 == n - 1) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    } else if (action != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
            final Action action2 = this.getActionMap().get(inputMap.get(keyStroke2));
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    if (n2 == 0 && n == 0) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    } else if (action2 != null) {
                        action2.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        }

        private void buildDialogProperties(Vector<Vector<Object>> vector) {
            String string;
            String string2;
            ButtonEditCtrl buttonEditCtrl;
            Vector<String> vector2;
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            String string3 = dialogDefinition.isSubDialog() ? "IDS_SUBDLG_ID" : "IDS_EXT_NAME";
            this.setupRow(dialogDefinition.getDialogId(), vector, string3, AttrType.elementId);
            if (!dialogDefinition.isSubDialog()) {
                vector2 = new Vector<String>();
                vector2.add(BuilderResUtil.getString("IDS_MENU_LOCATION"));
                vector2.add(dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)PropertiesPanel.this));
                vector.add(vector2);
                buttonEditCtrl = new ButtonEditCtrl(1);
                buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
                buttonEditCtrl.setReadOnlyEdit(true);
                buttonEditCtrl.addButtonListener(this);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(buttonEditCtrl);
                PropertiesPanel.this.mRowTypes.add(AttrType.menuItem);
            }
            this.setupRow(dialogDefinition.getDialogTitle(), vector, "IDS_TITLE", AttrType.title);
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_HELPFILE"));
            vector2.add(dialogDefinition.getHelpFileName());
            vector.add(vector2);
            buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.helpFile);
            if (!dialogDefinition.isSubDialog()) {
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_WEBAPP_PROPERTIES"));
                vector2.add(dialogDefinition.getCustomPropertiesFile());
                vector.add(vector2);
                buttonEditCtrl = new ButtonEditCtrl(1);
                buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
                buttonEditCtrl.setReadOnlyEdit(true);
                buttonEditCtrl.addButtonListener(this);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(buttonEditCtrl);
                PropertiesPanel.this.mRowTypes.add(AttrType.customPath);
                string2 = BuilderResUtil.getString("IDS_TRUE");
                string = BuilderResUtil.getString("IDS_FALSE");
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_MODELESS"));
                vector2.add(PropertiesPanel.this.mDlgDef.isModal() ? string : string2);
                vector.add(vector2);
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.FALSE), new ComboItem<Boolean>(string2, Boolean.TRUE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(objectArray));
                PropertiesPanel.this.mRowTypes.add(AttrType.modal);
            }
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_SYNTAX"));
            string2 = dialogDefinition.getDialogSyntax().replace("\n", "\\n");
            vector2.add(string2);
            vector.add(vector2);
            buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(PropertiesPanel.this.getBuilderFrame().getCanvas().getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.syntax);
            if (!dialogDefinition.isSubDialog()) {
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_REQUIRED_ADD_ONS"));
                string = this.buildAddOnsValue(dialogDefinition);
                vector2.add(string);
                vector.add(vector2);
                buttonEditCtrl = new ButtonEditCtrl(1);
                buttonEditCtrl.setReadOnlyEdit(true);
                buttonEditCtrl.addButtonListener(this);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(buttonEditCtrl);
                PropertiesPanel.this.mRowTypes.add(AttrType.requiredAddOns);
                PropertiesPanel.this.adjustFont(vector.size() - 1, buttonEditCtrl);
            }
        }

        private String buildAddOnsValue(DialogDefinition dialogDefinition) {
            HashMap<AddOnType, String> hashMap = new HashMap<AddOnType, String>();
            hashMap.put(AddOnType.R, BuilderResUtil.getString("IDS_R_PROGRAMMABILITY"));
            hashMap.put(AddOnType.Python, BuilderResUtil.getString("IDS_PYTHON_PROGRAMMABILITY"));
            StringBuilder stringBuilder = new StringBuilder();
            Set set = dialogDefinition.getRequiredAddOns();
            if (set.size() > 0) {
                for (AddOnType addOnType : set) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append((String)hashMap.get(addOnType));
                }
            } else {
                stringBuilder.append(BuilderResUtil.getString("IDS_NONE"));
            }
            return stringBuilder.toString();
        }

        private void addControlProperties(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            if (canvasObject instanceof SrcListObject) {
                this.addSrcListProperties(vector, canvasObject);
            } else if (canvasObject instanceof TargetListObject) {
                this.addTargetListProperties(vector, (TargetListObject)canvasObject);
            } else if (canvasObject instanceof SubDlgButtonObject) {
                this.addSubDlgButtonProperties(vector, (SubDlgButtonObject)canvasObject);
            } else if (canvasObject instanceof RadioGroupObject) {
                this.addRadioGroupProperties(vector, (RadioGroupObject)canvasObject);
            } else if (canvasObject instanceof ComboBoxObject) {
                this.addComboBoxProperties(vector, (ComboBoxObject)canvasObject);
            } else if (canvasObject instanceof ListBoxObject) {
                this.addListBoxProperties(vector, (ListBoxObject)canvasObject);
            } else if (canvasObject instanceof EditCtrlObject) {
                this.addEditCtrlProperties(vector, (EditCtrlObject)canvasObject);
            } else if (canvasObject instanceof CheckBoxObject) {
                this.addCheckboxProperties(vector, (CheckBoxObject)canvasObject);
            } else if (canvasObject instanceof CheckBoxGroupObject) {
                this.addCheckboxGroupProperties(vector, (CheckBoxGroupObject)canvasObject);
            } else if (canvasObject instanceof ItemGroupObject) {
                this.addItemGroupProperties(vector, (ItemGroupObject)canvasObject);
            } else if (canvasObject instanceof FileSystemBrowserObject) {
                this.addFSBProperties(vector, (FileSystemBrowserObject)canvasObject);
            }
        }

        private void addItemGroupProperties(Vector<Vector<Object>> vector, ItemGroupObject itemGroupObject) {
            this.addRequiredProperty(vector, itemGroupObject);
        }

        private void addRequiredProperty(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            String string = BuilderResUtil.getString("IDS_TRUE");
            String string2 = BuilderResUtil.getString("IDS_FALSE");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_IS_REQUIRED"));
            vector2.add(canvasObject.getCtrlDef().isRequired() ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string2, Boolean.FALSE), new ComboItem<Boolean>(string, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.required);
        }

        private void addFSBProperties(Vector<Vector<Object>> vector, FileSystemBrowserObject fileSystemBrowserObject) {
            FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)fileSystemBrowserObject.getCtrlDef();
            this.addMnemonicRow(vector, fileSystemBrowserObject);
            String string = BuilderResUtil.getString("IDS_OPEN");
            String string2 = BuilderResUtil.getString("IDS_SAVE");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_FILE_SYSTEM_OP"));
            vector2.add(fileSystemBrowserDefinition.isOpenDialog() ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string2, Boolean.FALSE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.browserOp);
            String string3 = BuilderResUtil.getString("IDS_LOCATE_FOLDER");
            String string4 = BuilderResUtil.getString("IDS_LOCATE_FILE");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_BROWSER_TYPE"));
            vector2.add(fileSystemBrowserDefinition.isDirectoryBrowser() ? string3 : string4);
            vector.add(vector2);
            objectArray = new Object[]{new ComboItem<Boolean>(string4, Boolean.FALSE), new ComboItem<Boolean>(string3, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.browserType);
            String string5 = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_FILE_FILTER"));
            vector2.add(string5);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(fileSystemBrowserObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.fileFilters);
            String string6 = BuilderResUtil.getString("IDS_CLIENT");
            String string7 = BuilderResUtil.getString("IDS_SERVER");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_FILE_SYSTEM_TYPE"));
            vector2.add(fileSystemBrowserDefinition.isServerFileSystemBrowser() ? string7 : string6);
            vector.add(vector2);
            objectArray = new Object[]{new ComboItem<Boolean>(string6, Boolean.TRUE), new ComboItem<Boolean>(string7, Boolean.FALSE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.browserSystem);
            this.addRequiredProperty(vector, fileSystemBrowserObject);
            string5 = fileSystemBrowserDefinition != null && fileSystemBrowserDefinition.getDefaultValue() != null ? fileSystemBrowserDefinition.getDefaultValue() : "";
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_DEFAULT"));
            vector2.add(string5);
            vector.add(vector2);
            buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(fileSystemBrowserObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(false);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.defaultValue);
        }

        private void addCheckboxGroupProperties(Vector<Vector<Object>> vector, CheckBoxGroupObject checkBoxGroupObject) {
            CheckBoxObject checkBoxObject = (CheckBoxObject)checkBoxGroupObject.getComponent(0);
            this.setupRow(checkBoxObject.getControlTitle(), vector, "IDS_CHECKBOX_TITLE", AttrType.subTitle);
            this.setupRow(checkBoxObject.getControlTip(), vector, "IDS_TIP", AttrType.tip);
            this.addMnemonicRow(vector, checkBoxObject);
            this.addDefaultCheckState(vector, checkBoxObject);
        }

        private void addCheckboxProperties(Vector<Vector<Object>> vector, CheckBoxObject checkBoxObject) {
            this.addMnemonicRow(vector, checkBoxObject);
            this.addDefaultCheckState(vector, checkBoxObject);
        }

        private void addSrcListProperties(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            SrcListDefinition srcListDefinition = (SrcListDefinition)canvasObject.getCtrlDef();
            this.addMnemonicRow(vector, canvasObject);
            String string = BuilderResUtil.getString("IDS_MOVE_VARS");
            String string2 = BuilderResUtil.getString("IDS_COPY_VARS");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_TRANSFER_OP"));
            vector2.add(srcListDefinition.getTransferOp() == SrcListDefinition.TransferOp.move ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.FALSE), new ComboItem<Boolean>(string2, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.copyMove);
            this.addVarFilterRow(vector, canvasObject);
        }

        private void addVarFilterRow(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            String string = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_VAR_FILTER"));
            vector2.add(string);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(canvasObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.varFilters);
        }

        private void addComboBoxProperties(Vector<Vector<Object>> vector, ComboBoxObject comboBoxObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_LIST"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(comboBoxObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.itemList);
            this.addMnemonicRow(vector, comboBoxObject);
        }

        private void addListBoxProperties(Vector<Vector<Object>> vector, ListBoxObject listBoxObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_LIST"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(listBoxObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.itemList);
            this.addMnemonicRow(vector, listBoxObject);
            ListBoxDefinition listBoxDefinition = listBoxObject.getListDef();
            String string = BuilderResUtil.getString("IDS_SINGLE_SELECT");
            String string2 = BuilderResUtil.getString("IDS_MULTIPLE_SELECT");
            String string3 = BuilderResUtil.getString("IDS_CHECK_SELECT");
            vector2 = new Vector();
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TYPE"));
            if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.single_select) {
                vector2.add(string);
            } else if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.multi_select) {
                vector2.add(string2);
            } else if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.checkbox_select) {
                vector2.add(string3);
            }
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<ListBoxDefinition.SelectionType>(string, ListBoxDefinition.SelectionType.single_select), new ComboItem<ListBoxDefinition.SelectionType>(string2, ListBoxDefinition.SelectionType.multi_select), new ComboItem<ListBoxDefinition.SelectionType>(string3, ListBoxDefinition.SelectionType.checkbox_select)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.selectionType);
        }

        private void addRadioGroupProperties(Vector<Vector<Object>> vector, RadioGroupObject radioGroupObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFINE_RADIOS"));
            vector2.add(BuilderResUtil.getString("IDS_SELECT_TO_EDIT"));
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(radioGroupObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.radioItems);
        }

        private void addSubDlgButtonProperties(Vector<Vector<Object>> vector, SubDlgButtonObject subDlgButtonObject) {
            String string = subDlgButtonObject.getDialogDefinition().getDialogTitle();
            boolean bl = string != null && string.length() > 0;
            String string2 = bl ? string : BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_SUB_DIALOG"));
            vector2.add(string2);
            vector.add(vector2);
            ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(1);
            buttonEditCtrl.setFont(subDlgButtonObject.getFont());
            buttonEditCtrl.setReadOnlyEdit(true);
            buttonEditCtrl.getTextField().setText(subDlgButtonObject.getDialogDefinition().getDialogTitle());
            buttonEditCtrl.addButtonListener(this);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(buttonEditCtrl);
            PropertiesPanel.this.mRowTypes.add(AttrType.launches);
            this.addMnemonicRow(vector, subDlgButtonObject);
        }

        private void addEditCtrlProperties(Vector<Vector<Object>> vector, EditCtrlObject editCtrlObject) {
            boolean bl;
            EditCtrlDefinition editCtrlDefinition = (EditCtrlDefinition)editCtrlObject.getCtrlDef();
            this.addMnemonicRow(vector, editCtrlObject);
            EditCtrlDefinition.ParseType parseType = editCtrlDefinition.getParseType();
            boolean bl2 = bl = parseType == EditCtrlDefinition.ParseType.integer || parseType == EditCtrlDefinition.ParseType.number;
            if (bl) {
                boolean bl3 = parseType == EditCtrlDefinition.ParseType.integer;
                String string = BuilderResUtil.getString("IDS_INTEGER");
                String string2 = BuilderResUtil.getString("IDS_NUMBER");
                Vector<String> vector2 = new Vector<String>();
                vector2.add(BuilderResUtil.getString("IDS_NUMBER_TYPE_FIELD"));
                vector2.add(bl3 ? string : string2);
                vector.add(vector2);
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string2, Boolean.FALSE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(objectArray));
                PropertiesPanel.this.mRowTypes.add(AttrType.editType);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
                vector2.add(editCtrlDefinition.getDefaultValue());
                vector.add(vector2);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                Object object = bl3 ? new IntTextField() : new FloatTextField();
                this.mEditors.add(new NumberEditor((SPSSTextField)object));
                PropertiesPanel.this.mRowTypes.add(AttrType.defaultValue);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_MIN_VALUE"));
                Double d = editCtrlDefinition.getMinValue();
                String string3 = !Double.isNaN(d) ? Double.toString(d) : "";
                vector2.add(UIToolResUtil.addLocale((String)string3));
                vector.add(vector2);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                object = bl3 ? new IntTextField() : new FloatTextField();
                this.mEditors.add(new NumberEditor((SPSSTextField)object));
                PropertiesPanel.this.mRowTypes.add(AttrType.minValue);
                vector2 = new Vector();
                vector2.add(BuilderResUtil.getString("IDS_MAX_VALUE"));
                Double d2 = editCtrlDefinition.getMaxValue();
                string3 = !Double.isNaN(d2) ? Double.toString(d2) : "";
                vector2.add(UIToolResUtil.addLocale((String)string3));
                vector.add(vector2);
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                object = bl3 ? new IntTextField() : new FloatTextField();
                this.mEditors.add(new NumberEditor((SPSSTextField)object));
                PropertiesPanel.this.mRowTypes.add(AttrType.maxValue);
            } else {
                String string = BuilderResUtil.getString("IDS_VARIABLE_NAME");
                String string4 = BuilderResUtil.getString("IDS_ANY");
                Vector<String> vector3 = new Vector<String>();
                vector3.add(BuilderResUtil.getString("IDS_TEXT_CONTENT_FIELD"));
                vector3.add(parseType == EditCtrlDefinition.ParseType.variableName ? string : string4);
                vector.add(vector3);
                Object[] objectArray = new Object[]{new ComboItem<Boolean>(string, Boolean.TRUE), new ComboItem<Boolean>(string4, Boolean.FALSE)};
                this.mRenderers.add(this.getDefaultRenderer(String.class));
                this.mEditors.add(new ComboEditor(objectArray));
                PropertiesPanel.this.mRowTypes.add(AttrType.editType);
                this.setupRow(editCtrlDefinition.getDefaultValue(), vector, "IDS_DEFAULT_VALUE", AttrType.defaultValue);
            }
            this.addRequiredProperty(vector, editCtrlObject);
        }

        private void addTargetListProperties(Vector<Vector<Object>> vector, TargetListObject targetListObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_LIST_TYPE"));
            vector2.add(BuilderResUtil.getString(targetListObject.isMultiItemList() ? "IDS_MULTI_ITEM" : "IDS_SINGLE_ITEM"));
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new CheckBoxEditor(targetListObject, AttrType.targetListType, BuilderResUtil.getString("IDS_MULTI_ITEM_PROMPT")));
            PropertiesPanel.this.mRowTypes.add(AttrType.targetListType);
            this.addMnemonicRow(vector, targetListObject);
            this.addRequiredProperty(vector, targetListObject);
            this.addVarFilterRow(vector, targetListObject);
        }

        private void addDefaultCheckState(Vector<Vector<Object>> vector, CheckBoxObject checkBoxObject) {
            String string = BuilderResUtil.getString("IDS_CHECKED");
            String string2 = BuilderResUtil.getString("IDS_UNCHECKED");
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_DEFAULT_VALUE"));
            vector2.add(((CheckBoxDefinition)checkBoxObject.getCtrlDef()).getDefaultState() ? string : string2);
            vector.add(vector2);
            Object[] objectArray = new Object[]{new ComboItem<Boolean>(string2, Boolean.FALSE), new ComboItem<Boolean>(string, Boolean.TRUE)};
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new ComboEditor(objectArray));
            PropertiesPanel.this.mRowTypes.add(AttrType.defaultValue);
        }

        private void addMnemonicRow(Vector<Vector<Object>> vector, CanvasObject canvasObject) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(BuilderResUtil.getString("IDS_MNEMONIC_KEY"));
            Integer n = canvasObject.getCtrlDef().getMnemonicKey();
            if (n != null) {
                vector2.add(new String(new char[]{(char)n.intValue()}));
            }
            vector.add(vector2);
            this.mRenderers.add(this.getDefaultRenderer(String.class));
            this.mEditors.add(new MnemonicEditor(new JTextField(new LimitedPlainDocument(1), "", 2)));
            PropertiesPanel.this.mRowTypes.add(AttrType.mnemonic);
        }

        private boolean generatesSyntax(CanvasObject canvasObject) {
            return !(canvasObject instanceof SrcListObject) && !(canvasObject instanceof StaticCtrlObject) && !(canvasObject instanceof SubDlgButtonObject);
        }

        private void locateCustomPropsFile(int n, int n2) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            this.getLocalFile(n, n2, BuilderResUtil.getString("IDS_BROWSE_PROP_TITLE"), dialogDefinition.getCustomPropertiesFile(), null);
        }

        private void locateHelpFile(int n, int n2) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            HtmFilter htmFilter = new HtmFilter();
            this.getLocalFile(n, n2, BuilderResUtil.getString("IDS_BROWSE_HELP_TITLE"), dialogDefinition.getHelpFileName(), (FileFilter)((Object)htmFilter));
        }

        private void locateDefaultFileBrowserFile(int n, int n2, FileSystemBrowserDefinition fileSystemBrowserDefinition) {
            DialogDefinition dialogDefinition = PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition();
            RemoteFileChooser.ChooserType chooserType = fileSystemBrowserDefinition.isDirectoryBrowser() ? RemoteFileChooser.ChooserType.OpenFolder : RemoteFileChooser.ChooserType.OpenFile;
            String string = fileSystemBrowserDefinition.isDirectoryBrowser() ? BuilderResUtil.getString("IDS_LOCATE_FOLDER") : BuilderResUtil.getString("IDS_LOCATE_FILE");
            this.getLocalFile(chooserType, n, n2, string, dialogDefinition.getHelpFileName(), null);
        }

        private void getLocalFile(int n, int n2, String string, String string2, FileFilter fileFilter) {
            this.getLocalFile(RemoteFileChooser.ChooserType.OpenFile, n, n2, string, string2, fileFilter);
        }

        private void getLocalFile(RemoteFileChooser.ChooserType chooserType, int n, int n2, String string, String string2, FileFilter fileFilter) {
            int n3;
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(chooserType, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false, false);
            remoteFileChooser.setDialogTitle(string);
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            remoteFileChooser.setMultiSelectionEnabled(false);
            if (fileFilter != null) {
                remoteFileChooser.setFileFilter(fileFilter);
            }
            String string3 = CommandExecutor.getUIExtensionsFolderPath() + File.separator + PropertiesPanel.this.getBuilderFrame().getCanvas().getDialogDefinition().getDialogId();
            String string4 = string2;
            if (string4.length() > 0) {
                File file;
                if (!string4.contains(File.separator)) {
                    string4 = string3 + File.separator + string4;
                }
                if ((file = new File(string4)).exists()) {
                    remoteFileChooser.setCurrentDirectory(file.getParentFile());
                    remoteFileChooser.setSelectedFile(file);
                }
            }
            if ((n3 = remoteFileChooser.showOpenDialog(this)) == 0) {
                File file = BuilderFrame.getCanonicalFileIfNotCanonical(remoteFileChooser.getSelectedFile());
                string4 = file != null ? file.getPath() : remoteFileChooser.getSelectedFile().getPath();
                if (string4.startsWith(string3)) {
                    string4 = remoteFileChooser.getSelectedFile().getName();
                }
                this.setValueAt(string4, n, n2);
                ButtonEditCtrl buttonEditCtrl = (ButtonEditCtrl)this.mEditors.get(n);
                if (string4 == null || string4.length() == 0) {
                    string4 = BuilderResUtil.getString("IDS_SELECT_TO_EDIT");
                }
                buttonEditCtrl.getTextField().setText(string4);
                PropertiesPanel.this.adjustFont(n, buttonEditCtrl);
            }
        }
    }
}

