/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ComboBoxObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ItemGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ListBoxObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.ComboCellEditor;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.PropertiesPanel;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ItemListTable
extends JTable {
    private BuilderFrame mOwner;
    private CanvasObject mCanvasObject;
    private Border mCellBorder = null;
    private TableCellRenderer mCellRenderer = new DefCellRenderer();
    private boolean mInLoadData;

    public ItemListTable(BuilderFrame builderFrame, CanvasObject canvasObject) {
        this.mOwner = builderFrame;
        this.mCanvasObject = canvasObject;
        this.mInLoadData = false;
        this.init();
        this.loadData();
    }

    public CanvasObject getCanvasObject() {
        return this.mCanvasObject;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        if (tableCellRenderer instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).setBackground(Color.white);
            if (this.mCellBorder == null) {
                this.mCellBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
            }
            ((JComponent)((Object)tableCellRenderer)).setBorder(this.mCellBorder);
        }
        return tableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3;
        TableCellEditor tableCellEditor = super.getCellEditor(n, n2);
        boolean bl = this.mCanvasObject instanceof RadioGroupObject;
        int n4 = n3 = bl ? this.columnIndex(ColType.mnemonic) : -1;
        if (n2 == n3 && tableCellEditor instanceof PropertiesPanel.MnemonicEditor) {
            Object object = this.getValueAt(n, n2);
            String string = object != null ? object.toString() : "";
            tableCellEditor.getTableCellEditorComponent(this, string, false, n, n2);
        }
        return tableCellEditor;
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        return this.mCellRenderer;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!super.isCellEditable(n, n2)) {
            return false;
        }
        return !(this.mCanvasObject instanceof RadioGroupObject) || n2 != this.columnIndex(ColType.hasSubGroup) || !(this.mCanvasObject.getParent() instanceof ItemGroupObject);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Component component;
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && (component = this.getEditorComponent()) instanceof JTextField) {
            MouseEvent mouseEvent;
            final JTextField jTextField = (JTextField)component;
            jTextField.selectAll();
            if (eventObject instanceof MouseEvent && (mouseEvent = (MouseEvent)eventObject).getClickCount() > 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jTextField.selectAll();
                    }
                });
            }
        }
        return bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3;
        int n4;
        int n5 = this.columnIndex(ColType.identifier);
        if (n5 == n2 && (this.checkForDupId(object.toString(), n, true) || this.checkForInvalidId(object.toString(), true) || this.checkDuplicateIdInRadioItemSubGroup(object.toString(), true))) {
            return;
        }
        super.setValueAt(object, n, n2);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        int n6 = this.columnIndex(ColType.isDefault);
        int n7 = n4 = this.mCanvasObject instanceof RadioGroupObject ? this.columnIndex(ColType.hasSubGroup) : -1;
        if (object != null && object.toString().length() > 0 && n == this.getRowCount() - 1) {
            n3 = this.getRowCount();
            defaultTableModel.setNumRows(n3 + 1);
            if (n2 != n6) {
                defaultTableModel.setValueAt(Boolean.FALSE, n, n6);
            }
            if (n4 > -1 && n2 != n4) {
                defaultTableModel.setValueAt(Boolean.FALSE, n, n4);
            }
            if (n2 != n5) {
                this.setDefaultIdentifier(n);
            }
        } else if ((object == null || object.toString().length() == 0) && this.rowEmpty(n) && n < this.getRowCount() - 1) {
            defaultTableModel.removeRow(n);
        }
        if (n2 == n6 && Boolean.TRUE.equals(object)) {
            for (n3 = 0; n3 < this.getRowCount() - 1; ++n3) {
                if (n3 == n || !Boolean.TRUE.equals(defaultTableModel.getValueAt(n3, n6))) continue;
                defaultTableModel.setValueAt(Boolean.FALSE, n3, n2);
                break;
            }
        }
        if (!this.mInLoadData && n2 == n4) {
            this.handleRadioItemSyntaxDefaults(n);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getTableHeader().setForeground(bl ? Color.black : Color.darkGray);
        super.setEnabled(bl);
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        super.columnMarginChanged(changeEvent);
    }

    private boolean checkForInvalidId(String string, boolean bl) {
        if (string != null && string.contains(" ")) {
            if (bl) {
                SpssAlertOptionPane.showWarningMessageDialog(this.mOwner, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), VersionInfo.getAppVersionString());
            }
            return true;
        }
        return false;
    }

    private boolean checkForDupId(String string, int n, boolean bl) {
        if (string.length() == 0 || this.mOwner.getCanvas().findCanvasObject(string) != null || this.hasId(string, n)) {
            if (bl) {
                SpssAlertOptionPane.showWarningMessageDialog(this.mOwner, string.length() == 0 ? BuilderResUtil.getString("IDS_MISSING_EL_ID_WARNING") : BuilderResUtil.getString("IDS_DUPLICATE_ID_WARNING"), VersionInfo.getAppVersionString());
            }
            return true;
        }
        return false;
    }

    private boolean checkDuplicateIdInRadioItemSubGroup(String string, boolean bl) {
        if (this.mCanvasObject instanceof RadioGroupObject) {
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            int n = radioGroupObject.radioItemCount();
            for (int i = 0; i < n; ++i) {
                RadioItemDefinition radioItemDefinition = radioGroupObject.getRadioItem(i);
                if (!radioItemDefinition.getHasSubGroup()) continue;
                int n2 = radioItemDefinition.getElementCount();
                for (int j = 0; j < n2; ++j) {
                    String string2 = radioItemDefinition.getPanelElement(j).getControlId();
                    if (!string.toString().equals(string2)) continue;
                    if (bl) {
                        SpssAlertOptionPane.showWarningMessageDialog(this.mOwner, string.toString().length() == 0 ? BuilderResUtil.getString("IDS_MISSING_EL_ID_WARNING") : BuilderResUtil.getString("IDS_DUPLICATE_ID_WARNING"), VersionInfo.getAppVersionString());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void handleRadioItemSyntaxDefaults(int n) {
        if (this.mCanvasObject instanceof RadioGroupObject && n > -1) {
            boolean bl;
            int n2 = this.columnIndex(ColType.hasSubGroup);
            int n3 = this.columnIndex(ColType.syntax);
            Object object = this.getValueAt(n, n2);
            Object object2 = this.getValueAt(n, n3);
            object2 = object2 == null ? "" : object2;
            boolean bl2 = bl = object != null && object.toString().equals("true");
            if (bl && object2.toString().length() == 0) {
                super.setValueAt(DialogDefinition.getSelfValue(), n, n3);
            } else if (!bl && object2.toString().equals(DialogDefinition.getSelfValue())) {
                super.setValueAt("", n, n3);
            }
        }
    }

    private boolean hasId(String string, int n) {
        int n2 = this.columnIndex(ColType.identifier);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object;
            if (i == n || (object = this.getValueAt(i, n2)) == null || !object.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void setDefaultIdentifier(int n) {
        int n2 = this.columnIndex(ColType.identifier);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        String string = this.mCanvasObject.getControlId();
        boolean bl = false;
        do {
            String string2;
            if (this.mCanvasObject instanceof RadioGroupObject) {
                string2 = "" + ((RadioGroupDefinition)this.mCanvasObject.getCtrlDef()).getNextSuffix();
            } else if (this.mCanvasObject instanceof ComboBoxObject || this.mCanvasObject instanceof ListBoxObject) {
                string2 = ((ListDefinition)this.mCanvasObject.getCtrlDef()).getNextSuffix();
            } else {
                return;
            }
            String string3 = string + "_" + string2;
            if (this.checkForDupId(string3, n, false)) continue;
            defaultTableModel.setValueAt(string3, n, n2);
            bl = true;
        } while (!bl);
    }

    private void loadData() {
        this.mInLoadData = true;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        if (this.mCanvasObject instanceof RadioGroupObject) {
            RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
            int n = radioGroupObject.radioItemCount();
            defaultTableModel.setColumnCount(7);
            defaultTableModel.setNumRows(n + 1);
            for (int i = 0; i < n; ++i) {
                RadioItemDefinition radioItemDefinition = radioGroupObject.getRadioItem(i);
                this.setValueAt(radioItemDefinition.getControlId(), i, this.columnIndex(ColType.identifier));
                this.setValueAt(radioItemDefinition.getTitle(), i, this.columnIndex(ColType.name));
                this.setValueAt(radioItemDefinition.getTip(), i, this.columnIndex(ColType.tip));
                Integer n2 = radioItemDefinition.getMnemonicKey();
                if (n2 != null) {
                    this.setValueAt(new String(new char[]{(char)n2.intValue()}), i, this.columnIndex(ColType.mnemonic));
                }
                this.setValueAt(radioItemDefinition.getHasSubGroup(), i, this.columnIndex(ColType.hasSubGroup));
                this.setValueAt(radioItemDefinition.getIsDefault(), i, this.columnIndex(ColType.isDefault));
                this.setValueAt(radioItemDefinition.getControlSyntax(), i, this.columnIndex(ColType.syntax));
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.isDefault));
            tableColumn.setCellEditor(new ComboCellEditor());
            tableColumn.setPreferredWidth(40);
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.mnemonic));
            tableColumn.setCellEditor(new PropertiesPanel.MnemonicEditor(new JTextField(new PropertiesPanel.LimitedPlainDocument(1), "", 2)));
            tableColumn = this.getColumnModel().getColumn(this.columnIndex(ColType.hasSubGroup));
            tableColumn.setCellEditor(new ComboCellEditor());
            tableColumn.setPreferredWidth(60);
        } else if (this.mCanvasObject instanceof ComboBoxObject || this.mCanvasObject instanceof ListBoxObject) {
            ListDefinition listDefinition = (ListDefinition)this.mCanvasObject.getCtrlDef();
            Vector vector = listDefinition.getListItems();
            int n = vector.size();
            defaultTableModel.setColumnCount(4);
            defaultTableModel.setNumRows(n + 1);
            for (int i = 0; i < n; ++i) {
                ListDefinition.ListItem listItem = (ListDefinition.ListItem)vector.get(i);
                this.setValueAt(listItem.getTitle(), i, this.columnIndex(ColType.name));
                this.setValueAt(listItem.getIdentifier(), i, this.columnIndex(ColType.identifier));
                this.setValueAt(listItem.isDefaultItem(), i, this.columnIndex(ColType.isDefault));
                this.setValueAt(listItem.getSyntax(), i, this.columnIndex(ColType.syntax));
            }
            this.getColumnModel().getColumn(this.columnIndex(ColType.isDefault)).setCellEditor(new ComboCellEditor());
        }
        this.mInLoadData = false;
    }

    protected void saveData() {
        block11: {
            block10: {
                Vector vector;
                int n;
                if (!(this.mCanvasObject instanceof RadioGroupObject)) break block10;
                RadioGroupObject radioGroupObject = (RadioGroupObject)this.mCanvasObject;
                int n2 = radioGroupObject.radioItemCount();
                HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
                Vector<RadioItemDefinition> vector2 = new Vector<RadioItemDefinition>();
                for (n = n2 - 1; n >= 0; --n) {
                    RadioItemDefinition radioItemDefinition = radioGroupObject.getRadioItem(n);
                    vector = radioGroupObject.getRadioComponents(radioItemDefinition);
                    hashMap.put(radioItemDefinition.getControlId(), vector);
                    vector2.add(0, radioGroupObject.removeRadioItem(n));
                }
                n = 0;
                for (int i = 0; i < this.getRowCount(); ++i) {
                    Iterator iterator;
                    Object object;
                    String string = this.getStringValue(i, this.columnIndex(ColType.name));
                    if (string == null || string.length() == 0) continue;
                    String string2 = this.getStringValue(i, this.columnIndex(ColType.tip));
                    String string3 = this.getStringValue(i, this.columnIndex(ColType.identifier));
                    String string4 = this.getStringValue(i, this.columnIndex(ColType.syntax));
                    radioGroupObject.addRadioItem(string, string2, null, -1);
                    RadioItemDefinition radioItemDefinition = radioGroupObject.getRadioItem(n);
                    radioItemDefinition.setControlId(string3);
                    radioItemDefinition.setControlSyntax(string4);
                    String string5 = this.getStringValue(i, this.columnIndex(ColType.mnemonic));
                    if (string5.length() > 0) {
                        object = (int)string5.toUpperCase().charAt(0);
                        radioItemDefinition.setMnemonicKey((Integer)object);
                    } else {
                        radioItemDefinition.setMnemonicKey(null);
                    }
                    object = this.getStringValue(i, this.columnIndex(ColType.hasSubGroup));
                    boolean bl = object != null && ((String)object).equalsIgnoreCase("true");
                    radioItemDefinition.setHasSubGroup(bl);
                    if (bl) {
                        Object object2;
                        RadioItemDefinition radioItemDefinition2 = null;
                        iterator = vector2.iterator();
                        while (iterator.hasNext()) {
                            object2 = (RadioItemDefinition)iterator.next();
                            if (!object2.getControlId().equals(string3)) continue;
                            radioItemDefinition2 = object2;
                            break;
                        }
                        if (radioItemDefinition2 != null) {
                            for (int j = 0; j < radioItemDefinition2.getElementCount(); ++j) {
                                radioItemDefinition.addPanelElement(radioItemDefinition2.getPanelElement(j));
                            }
                            radioItemDefinition2.removePanelElements();
                            vector = (Vector)hashMap.get(radioItemDefinition.getControlId());
                            iterator = vector.iterator();
                            while (iterator.hasNext()) {
                                object2 = (CanvasObject)iterator.next();
                                radioGroupObject.buildRadioSubItem((CanvasObject)object2, radioItemDefinition);
                            }
                        }
                    }
                    boolean bl2 = (iterator = this.getStringValue(i, this.columnIndex(ColType.isDefault))) != null && ((String)((Object)iterator)).equalsIgnoreCase("true");
                    radioItemDefinition.setIsDefault(bl2);
                    ++n;
                }
                break block11;
            }
            if (!(this.mCanvasObject instanceof ComboBoxObject) && !(this.mCanvasObject instanceof ListBoxObject)) break block11;
            ListDefinition listDefinition = (ListDefinition)this.mCanvasObject.getCtrlDef();
            Vector vector = listDefinition.getListItems();
            vector.clear();
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = this.getStringValue(i, this.columnIndex(ColType.name));
                if (string == null || string.length() == 0) continue;
                String string6 = this.getStringValue(i, this.columnIndex(ColType.identifier));
                String string7 = this.getStringValue(i, this.columnIndex(ColType.isDefault));
                String string8 = this.getStringValue(i, this.columnIndex(ColType.syntax));
                boolean bl = string7 != null && string7.equalsIgnoreCase("true");
                ListDefinition.ListItem listItem = new ListDefinition.ListItem(string, "", string6);
                listItem.setIsDefaultItem(bl);
                listItem.setSyntax(string8);
                vector.add(listItem);
            }
        }
    }

    private int columnIndex(ColType colType) {
        int n = 0;
        if (this.mCanvasObject instanceof RadioGroupObject) {
            if (colType == ColType.identifier) {
                n = 0;
            } else if (colType == ColType.name) {
                n = 1;
            } else if (colType == ColType.tip) {
                n = 2;
            } else if (colType == ColType.mnemonic) {
                n = 3;
            } else if (colType == ColType.hasSubGroup) {
                n = 4;
            } else if (colType == ColType.isDefault) {
                n = 5;
            } else if (colType == ColType.syntax) {
                n = 6;
            } else assert (false);
        } else if (this.mCanvasObject instanceof ComboBoxObject || this.mCanvasObject instanceof ListBoxObject) {
            if (colType == ColType.identifier) {
                n = 0;
            } else if (colType == ColType.name) {
                n = 1;
            } else if (colType == ColType.isDefault) {
                n = 2;
            } else if (colType == ColType.syntax) {
                n = 3;
            } else assert (false);
        } else assert (false);
        return n;
    }

    private String getStringValue(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        return object != null && object.toString().length() > 0 ? object.toString() : "";
    }

    private boolean rowEmpty(int n) {
        boolean bl = this.mCanvasObject instanceof RadioGroupObject;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (int i = 0; i < defaultTableModel.getColumnCount() - 1; ++i) {
            Object object;
            if (i == this.columnIndex(ColType.isDefault) || bl && i == this.columnIndex(ColType.hasSubGroup) || (object = defaultTableModel.getValueAt(n, i)) == null || object.toString().length() <= 0) continue;
            return false;
        }
        return true;
    }

    private void init() {
        int n = 0;
        this.setAutoscrolls(true);
        this.setBackground(new Color(221, 221, 221));
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setRowHeight(this.getRowHeight() + 2);
        TableColumn tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_IDENTIFIER"));
        this.addColumn(tableColumn);
        tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_NAME"));
        this.addColumn(tableColumn);
        if (this.mCanvasObject instanceof RadioGroupObject) {
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_TIP"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_MNEMONIC_KEY"));
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(n++);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_NESTED_GROUP"));
            this.addColumn(tableColumn);
        }
        tableColumn = new TableColumn(n++);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_DEFAULT"));
        this.addColumn(tableColumn);
        tableColumn = new TableColumn(n);
        tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_SYNTAX"));
        this.addColumn(tableColumn);
        this.setDefaultRenderer(String.class, this.mCellRenderer);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ItemListTable.this.getSelectedRow();
                int n2 = ItemListTable.this.getSelectedColumn();
                if (n > -1 && n2 > -1) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)ItemListTable.this.getModel();
                    if (n2 == ItemListTable.this.columnIndex(ColType.identifier)) {
                        defaultTableModel.removeRow(n);
                    } else {
                        defaultTableModel.setValueAt("", n, n2);
                    }
                }
            }
        };
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "DeleteRow");
        this.getActionMap().put("DeleteRow", abstractAction);
    }

    class DefCellRenderer
    extends DefaultTableCellRenderer {
        Border mBorder = null;

        DefCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl4 = bl3 = jTable.isEnabled() && jTable.isCellEditable(n, n2);
            if (bl && !bl2) {
                this.setBackground(Color.lightGray);
            } else if (!bl || !bl2) {
                this.setBackground(jTable.isEnabled() ? Color.white : Color.lightGray);
            }
            this.setForeground(bl3 ? Color.black : Color.darkGray);
            if (component instanceof JComponent) {
                if (this.mBorder == null) {
                    this.mBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
                }
                ((JComponent)component).setBorder(this.mBorder);
            }
            return component;
        }
    }

    static enum ColType {
        identifier,
        name,
        tip,
        mnemonic,
        hasSubGroup,
        isDefault,
        syntax;

    }
}

