/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.FileSystemBrowserObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.definition.FileSystemBrowserDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class FileFilterDlg
extends BaseDialog
implements ActionListener {
    private FileSystemBrowserObject mTargetBrowser;
    private BuilderFrame mFrame;
    private JButton mOKButton;
    private JCheckBox mAllFilesCheck;
    private JCheckBox mDataFilesCheck;
    private JCheckBox mCSFilesCheck;
    private JCheckBox mOtherFilesCheck;
    private FilterTable mTable;

    public FileFilterDlg(BuilderFrame builderFrame, FileSystemBrowserObject fileSystemBrowserObject) throws HeadlessException {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_FILE_FILTER_DLG_TITLE"), true, ResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), BuilderResBundle.getImageFolder());
        this.mFrame = builderFrame;
        this.mTargetBrowser = fileSystemBrowserObject;
        this.initialize();
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER_FILEFILTER");
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOKButton = new JButton(new OKAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOKButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOKButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOKButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOKButton);
        return jPanel;
    }

    private void loadData() {
        FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)this.mTargetBrowser.getCtrlDef();
        LinkedList linkedList = fileSystemBrowserDefinition.getFilterList();
        for (FileSystemBrowserDefinition.FilterItem filterItem : linkedList) {
            if (filterItem.getFilterType().equals((Object)FileSystemBrowserDefinition.FilterType.AllFiles)) {
                this.mAllFilesCheck.setSelected(true);
                continue;
            }
            if (filterItem.getFilterType().equals((Object)FileSystemBrowserDefinition.FilterType.DataFiles)) {
                this.mDataFilesCheck.setSelected(true);
                continue;
            }
            if (filterItem.getFilterType().equals((Object)FileSystemBrowserDefinition.FilterType.CSFiles)) {
                this.mCSFilesCheck.setSelected(true);
                continue;
            }
            if (!filterItem.getFilterType().equals((Object)FileSystemBrowserDefinition.FilterType.OtherFiles)) continue;
            this.mOtherFilesCheck.setSelected(true);
            this.mTable.placeGridRow(filterItem);
        }
        this.mTable.updateRows();
        this.updateTableEnable();
        this.enableOK();
    }

    private void initialize() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mAllFilesCheck = new JCheckBox(BuilderResUtil.getString("IDS_ALL_FILE_TYPES"));
        DialogUtil.addUsingGBL(jPanel, this.mAllFilesCheck, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        this.mDataFilesCheck = new JCheckBox(BuilderResUtil.getString("IDS_DATA_FILE"));
        DialogUtil.addUsingGBL(jPanel, this.mDataFilesCheck, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        this.mCSFilesCheck = new JCheckBox(BuilderResUtil.getString("IDS_CS_PLAN"));
        DialogUtil.addUsingGBL(jPanel, this.mCSFilesCheck, gridBagConstraints, 0, 2, 1, 1, 23, insets);
        this.mOtherFilesCheck = new JCheckBox(BuilderResUtil.getString("IDS_OTHER"));
        DialogUtil.addUsingGBL(jPanel, this.mOtherFilesCheck, gridBagConstraints, 0, 3, 1, 1, 23, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(insets.top + 2, insets.left + 18, insets.bottom + 2, insets.right + 18);
        this.mTable = new FilterTable();
        JScrollPane jScrollPane = new JScrollPane(this.mTable);
        jScrollPane.setPreferredSize(new Dimension(240, 100));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 4, 1, 1, 23, insets2);
        this.mTable.setEnabled(false);
        this.mAllFilesCheck.addActionListener(this);
        this.mDataFilesCheck.addActionListener(this);
        this.mCSFilesCheck.addActionListener(this);
        this.mOtherFilesCheck.addActionListener(this);
    }

    private void enableOK() {
        boolean bl = this.mAllFilesCheck.isSelected();
        boolean bl2 = this.mDataFilesCheck.isSelected();
        boolean bl3 = this.mCSFilesCheck.isSelected();
        boolean bl4 = this.mOtherFilesCheck.isSelected();
        if (bl4) {
            bl4 = this.mTable.hasValidRow();
        }
        this.mOKButton.setEnabled(bl || bl2 || bl3 || bl4);
    }

    private void updateTableEnable() {
        this.mTable.setEnabled(this.mOtherFilesCheck.isSelected());
        this.mTable.getTableHeader().invalidate();
        this.mTable.getTableHeader().repaint();
    }

    private boolean validateFilterString(String string, int n) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("*.") && string3.length() >= 3) continue;
            string2 = string3;
            break;
        }
        if (string2 != null) {
            String string4 = String.format(BuilderResUtil.getString("IDS_BAD_FILTER_WARNING"), string2);
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string4, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.enableOK();
        if (actionEvent.getSource() == this.mOtherFilesCheck) {
            this.updateTableEnable();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileFilterDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileFilterDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileSystemBrowserDefinition fileSystemBrowserDefinition = (FileSystemBrowserDefinition)FileFilterDlg.this.mTargetBrowser.getCtrlDef();
            LinkedList linkedList = fileSystemBrowserDefinition.getFilterList();
            linkedList.clear();
            FileFilterDlg.this.mTable.getCellEditor().stopCellEditing();
            if (FileFilterDlg.this.mAllFilesCheck.isSelected()) {
                linkedList.add(new FileSystemBrowserDefinition.FilterItem(BuilderResUtil.getString("IDS_ALL_FILE_TYPES"), "*.*", FileSystemBrowserDefinition.FilterType.AllFiles));
            }
            if (FileFilterDlg.this.mDataFilesCheck.isSelected()) {
                linkedList.add(new FileSystemBrowserDefinition.FilterItem(BuilderResUtil.getString("IDS_DATA_FILE"), "*.sav;*.zsav", FileSystemBrowserDefinition.FilterType.DataFiles));
            }
            if (FileFilterDlg.this.mCSFilesCheck.isSelected()) {
                linkedList.add(new FileSystemBrowserDefinition.FilterItem(BuilderResUtil.getString("IDS_CS_PLAN"), "*.csplan;*.csaplan", FileSystemBrowserDefinition.FilterType.CSFiles));
            }
            if (FileFilterDlg.this.mOtherFilesCheck.isSelected()) {
                this.saveGridRows(linkedList);
            }
            FileFilterDlg.this.mFrame.setModified(true);
            FileFilterDlg.this.dispose();
        }

        private void saveGridRows(LinkedList<FileSystemBrowserDefinition.FilterItem> linkedList) {
            int n = FileFilterDlg.this.mTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object object = FileFilterDlg.this.mTable.getValueAt(i, 0);
                Object object2 = FileFilterDlg.this.mTable.getValueAt(i, 1);
                if (object == null || object.toString().length() <= 0 || object2 == null || object2.toString().length() <= 0) continue;
                linkedList.add(new FileSystemBrowserDefinition.FilterItem(object.toString(), object2.toString(), FileSystemBrowserDefinition.FilterType.OtherFiles));
            }
        }
    }

    class FilterTable
    extends JTable {
        private DefaultTableModel mModel = new DefaultTableModel();

        FilterTable() {
            this.setModel(this.mModel);
            this.setAutoResizeMode(3);
            this.setAutoscrolls(true);
            this.getTableHeader().setResizingAllowed(true);
            this.setAutoCreateColumnsFromModel(false);
            this.setSelectionMode(0);
            this.mModel.setColumnCount(2);
            this.mModel.setNumRows(1);
            FilterCellRenderer filterCellRenderer = new FilterCellRenderer();
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_NAME"));
            tableColumn.setCellRenderer(filterCellRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(BuilderResUtil.getString("IDS_SUFFIX"));
            tableColumn.setCellRenderer(filterCellRenderer);
            tableColumn.setCellEditor(new FilterCellEditor());
            this.addColumn(tableColumn);
            this.setDefaultRenderer(String.class, new FilterCellRenderer());
            this.getTableHeader().setDefaultRenderer(new FilterCellRenderer());
            this.mModel.setValueAt("", 0, 0);
            this.mModel.setValueAt("", 0, 1);
            this.handleCellDelete();
            this.setupTableTabPolicy();
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            super.editingStopped(changeEvent);
            this.updateRows();
            FileFilterDlg.this.enableOK();
        }

        boolean hasValidRow() {
            int n = this.getRowCount();
            for (int i = n - 1; i >= 0; --i) {
                Object object = this.getValueAt(i, 0);
                Object object2 = this.getValueAt(i, 1);
                if (object == null || object.toString().length() <= 0 || object2 == null || object2.toString().length() <= 0) continue;
                return true;
            }
            return false;
        }

        void placeGridRow(FileSystemBrowserDefinition.FilterItem filterItem) {
            int n = this.getRowCount();
            this.mModel.insertRow(n - 1, new String[]{filterItem.getUserText(), filterItem.getFilterString()});
        }

        void updateRows() {
            int n = this.getRowCount();
            for (int i = n - 1; i >= 0; --i) {
                Object object = this.getValueAt(i, 0);
                Object object2 = this.getValueAt(i, 1);
                if (object != null && object.toString().length() != 0 || object2 != null && object2.toString().length() != 0) continue;
                this.mModel.removeRow(i);
            }
            this.mModel.addRow(new String[]{"", ""});
        }

        private void handleCellDelete() {
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = FilterTable.this.getSelectedRow();
                    int n2 = FilterTable.this.getSelectedColumn();
                    if (n >= 0 && n2 >= 0) {
                        FilterTable.this.setValueAt("", n, n2);
                        FilterTable.this.updateRows();
                        FileFilterDlg.this.enableOK();
                    }
                }
            };
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "DeleteCell");
            this.getActionMap().put("DeleteCell", abstractAction);
        }

        private void setupTableTabPolicy() {
            InputMap inputMap = this.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 1);
            final Action action = this.getActionMap().get(inputMap.get(keyStroke));
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getRowCount();
                    int n2 = jTable.getColumnCount();
                    int n3 = jTable.getSelectedRow();
                    int n4 = jTable.getSelectedColumn();
                    if (n4 == n2 - 1 && n3 == n - 1) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    } else if (action != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
            final Action action2 = this.getActionMap().get(inputMap.get(keyStroke2));
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    if (n2 == 0 && n == 0) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    } else if (action2 != null) {
                        action2.actionPerformed(actionEvent);
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        }
    }

    class FilterCellEditor
    extends DefaultCellEditor {
        public FilterCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.black));
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public boolean stopCellEditing() {
            String string;
            String string2 = string = this.getCellEditorValue() != null ? this.getCellEditorValue().toString() : "";
            if (string.length() > 0 && !FileFilterDlg.this.validateFilterString(string, FileFilterDlg.this.mTable.getEditingRow())) {
                ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }
    }

    class FilterCellRenderer
    extends DefaultTableCellRenderer {
        private Border mCellBorder = null;

        FilterCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!FileFilterDlg.this.mTable.isEnabled()) {
                component.setForeground(Color.gray);
            } else {
                component.setForeground(Color.black);
            }
            if (n == -1) {
                JTableHeader jTableHeader = jTable.getTableHeader();
                if (jTableHeader != null) {
                    if (FileFilterDlg.this.mTable.isEnabled()) {
                        this.setForeground(jTableHeader.getForeground());
                    }
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                ((JLabel)component).setHorizontalAlignment(0);
            } else {
                if (!FileFilterDlg.this.mTable.isEnabled()) {
                    this.setBackground(Color.white);
                }
                if (this.mCellBorder == null) {
                    this.mCellBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
                }
                ((JComponent)component).setBorder(this.mCellBorder);
            }
            return component;
        }
    }
}

