/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class TargetListObject
extends CanvasObject {
    private ImageIcon mItemImage;
    private ImageIcon mButtonImage;

    public TargetListObject(TargetListDefinition targetListDefinition) {
        super((PanelElementDefinition)targetListDefinition);
        try {
            this.mItemImage = new ImageIcon(BuilderResUtil.getImageResource("target_list_image.png"));
            this.mButtonImage = new ImageIcon(BuilderResUtil.getImageResource("arrow_button_image.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        String string = this.getControlTitle();
        int n2 = n = string != null && string.length() > 0 ? 20 : 0;
        n = this.isMultiItemList() ? (n += 100) : (n += 26);
        return new Dimension(this.getObjectWidth() + 40, n);
    }

    public boolean isMultiItemList() {
        return this.getDefinition().isMultiItemList();
    }

    public void setIsMultiItemList(boolean bl) {
        this.getDefinition().setIsMultiItemList(bl);
    }

    public TargetListDefinition getDefinition() {
        return (TargetListDefinition)this.getCtrlDef();
    }

    @Override
    void render(Graphics2D graphics2D) {
        String string = this.getControlTitle();
        boolean bl = string != null && string.length() > 0;
        int n = bl ? 20 : 0;
        Rectangle rectangle = this.getBounds();
        int n2 = this.mButtonImage.getIconHeight();
        int n3 = this.isMultiItemList() ? (rectangle.height - n2) / 2 : rectangle.height - n2;
        int n4 = rectangle.width - this.getObjectWidth();
        Insets insets = this.getBorder().getBorderInsets(this);
        Rectangle rectangle2 = new Rectangle(n4 + insets.left, insets.top + n, rectangle.width - insets.left - insets.right - n4, rectangle.height - insets.top - insets.bottom - n);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        graphics2D.setColor(Color.gray);
        graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        this.mItemImage.paintIcon(this, graphics2D, rectangle2.x + 2, rectangle2.y + 2);
        this.mButtonImage.paintIcon(this, graphics2D, 4, Math.max(n3, 0));
        if (bl) {
            this.renderTitle(graphics2D, n4 + insets.left, insets.top);
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 24;
        rectangle.grow(0, -n2);
        rectangle.x += n;
        rectangle.width -= n;
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }
}

