/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class SubDlgButtonObject
extends CanvasObject {
    private ImageIcon mItemImage;

    public SubDlgButtonObject(SubDlgButtonDefinition subDlgButtonDefinition) {
        super((PanelElementDefinition)subDlgButtonDefinition);
        try {
            this.mItemImage = new ImageIcon(BuilderResUtil.getImageResource("dlg_button_image.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DialogDefinition getDialogDefinition() {
        return ((SubDlgButtonDefinition)this.getCtrlDef()).getDialogDefinition();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.mItemImage.getIconWidth() + 4, this.mItemImage.getIconHeight() + 4);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        if (this.mItemImage != null) {
            this.mItemImage.paintIcon(this, graphics2D, insets.left, insets.top);
        }
        if (string != null && string.length() > 0) {
            this.renderTitle(graphics2D, insets.left, insets.top);
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        rectangle.grow(-n, -n2);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)0);
    }
}

