/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RadioGroupObject
extends CanvasObject {
    private static final int RADIO_HEIGHT = 24;
    private static final int GROUP_HEIGHT = 20;
    private static final int EMPTY_FILL_HEIGHT = 20;
    private static final String TITLE_FILLER = "title_filler";
    private RadioGroupDefinition mRadioDef;
    private ImageIcon mSelectedImage;
    private ImageIcon mUnselectedImage;

    public RadioGroupObject(RadioGroupDefinition radioGroupDefinition) {
        super((PanelElementDefinition)radioGroupDefinition);
        this.mRadioDef = radioGroupDefinition;
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.pad();
        try {
            this.mSelectedImage = new ImageIcon(BuilderResUtil.getImageResource("radio_selected_image.png"));
            this.mUnselectedImage = new ImageIcon(BuilderResUtil.getImageResource("radio_unselected_image.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int radioItemCount() {
        return this.mRadioDef.radioItemCount();
    }

    public void addRadioItem(String string, String string2, Integer n, int n2) {
        this.mRadioDef.addRadioItem(string, string2, n, n2);
        Component component = this.locateComponentAt(this.getRadioItemYPos(this.mRadioDef.radioItemCount() - 1));
        if (!(component instanceof Box.Filler)) {
            this.add(Box.createRigidArea(new Dimension(0, 24)));
        }
    }

    public RadioItemDefinition getRadioItem(int n) {
        return this.mRadioDef.getRadioItem(n);
    }

    public RadioItemDefinition removeRadioItem(int n) {
        if (n < 0 || n >= this.radioItemCount()) {
            return null;
        }
        RadioItemDefinition radioItemDefinition = this.getRadioItem(n);
        for (int i = 0; i < radioItemDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = radioItemDefinition.getPanelElement(i);
            Component component = this.findComponent(panelElementDefinition.getControlId());
            if (component == null) continue;
            this.remove(component.getParent());
        }
        Component component = this.locateComponentAt(this.getRadioItemYPos(n));
        if (component instanceof Box.Filler) {
            this.remove(component);
        }
        return this.mRadioDef.removeRadioItem(n);
    }

    public void insertSubElement(CanvasObject canvasObject, int n, Point point) {
        if (n < 0 || n >= this.radioItemCount()) {
            return;
        }
        RadioItemDefinition radioItemDefinition = this.getRadioItem(n);
        if (!radioItemDefinition.getHasSubGroup()) {
            return;
        }
        if (this.checkAddToSelf(canvasObject)) {
            return;
        }
        int n2 = this.getComponentIndex(n, point.y);
        int n3 = this.componentIndexToRadioSubIndex(n, n2);
        radioItemDefinition.insertPanelElement(canvasObject.getCtrlDef(), n3);
        this.addItemInternal(canvasObject, n2);
        canvasObject.setSelected(false);
        this.validate();
    }

    public void buildRadioSubItem(CanvasObject canvasObject, RadioItemDefinition radioItemDefinition) {
        if (!this.isValid()) {
            this.validate();
        }
        int n = this.getRadioItemIndex(radioItemDefinition);
        int n2 = this.getRadioItemYPos(n) + this.getRadioItemHeight(radioItemDefinition) + 2;
        Component component = this.locateComponentAt(n2);
        int n3 = Arrays.asList(this.getComponents()).indexOf(component);
        if (n3 == -1) {
            n3 = this.getComponentCount();
        }
        while (component instanceof CanvasObject && n3 < this.getComponentCount()) {
            component = this.getComponent(++n3);
        }
        this.addItemInternal(canvasObject, n3);
    }

    public void removeSubElement(CanvasObject canvasObject) {
        int n = this.getComponentPanelIndex(canvasObject);
        if (n < 0) {
            return;
        }
        this.removeInternal(canvasObject);
        canvasObject.getCtrlDef().getConstraints().insets = PanelElementDefinition.getStandardInsets();
        RadioItemDefinition radioItemDefinition = this.findRadioItemParent(canvasObject);
        if (radioItemDefinition != null) {
            radioItemDefinition.removePanelElement(canvasObject.getCtrlDef());
        } else {
            TraceSettings.trace1((String)"-->Lost the RadioItemDefinition!<--", (int)15);
        }
        this.invalidate();
    }

    private int getComponentPanelIndex(CanvasObject canvasObject) {
        int n = -1;
        for (Component component : this.getComponents()) {
            ++n;
            if (!(component instanceof RgoPanel)) continue;
            for (Component component2 : ((RgoPanel)component).getComponents()) {
                if (component2 != canvasObject) continue;
                return n;
            }
        }
        return n;
    }

    public Vector<CanvasObject> getRadioComponents(RadioItemDefinition radioItemDefinition) {
        Vector<CanvasObject> vector = new Vector<CanvasObject>();
        for (int i = 0; i < radioItemDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = radioItemDefinition.getPanelElement(i);
            Component component = this.findComponent(panelElementDefinition.getControlId());
            if (!(component instanceof CanvasObject)) continue;
            vector.add((CanvasObject)component);
        }
        return vector;
    }

    @Override
    public void validate() {
        this.checkFillers();
        super.validate();
    }

    public int pointToRadioIndex(Point point) {
        Rectangle rectangle = this.getBounds();
        if (!rectangle.contains(SwingUtilities.convertPoint(this, point, this.getParent()))) {
            return -1;
        }
        for (int i = 0; i < this.radioItemCount(); ++i) {
            int n = this.getRadioItemYPos(i);
            if (n + this.getRadioItemHeight(this.getRadioItem(i)) <= point.y) continue;
            return i;
        }
        return -1;
    }

    public boolean hasTitle() {
        String string = this.getControlTitle();
        return string != null && string.length() > 0;
    }

    public boolean hasGroupBox() {
        return this.hasTitle();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        for (int i = 0; i < this.radioItemCount(); ++i) {
            RadioItemDefinition radioItemDefinition = this.getRadioItem(i);
            n += this.getRadioItemHeight(radioItemDefinition);
        }
        if (this.hasGroupBox()) {
            n += 30;
        }
        return new Dimension(this.getObjectWidth(), n);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Object object;
        Object object2;
        Insets insets = this.getBorder().getBorderInsets(this);
        Rectangle rectangle = this.getBounds();
        boolean bl = this.hasGroupBox();
        int n = insets.left;
        int n2 = insets.top;
        rectangle.translate(-rectangle.x, -rectangle.y);
        rectangle.grow(-n, -n2);
        if (bl) {
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(rectangle.x, rectangle.y + 10, rectangle.width - 1, rectangle.height - 11);
            if (this.hasTitle() && this.getControlTitle().trim().length() > 0) {
                object2 = " " + this.getControlTitle() + " ";
                object = this.getFont();
                this.setFont((Font)object);
                graphics2D.setColor(this.getParent().getBackground());
                Rectangle rectangle2 = ((Font)object).getStringBounds((String)object2, graphics2D.getFontRenderContext()).getBounds();
                rectangle2.width = Math.min(rectangle2.width, rectangle.width - 3);
                Rectangle rectangle3 = new Rectangle(rectangle.x + 3, rectangle.y, rectangle2.width, 18);
                graphics2D.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                graphics2D.setColor(Color.black);
                CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle3, null, (String)object2, (int)2);
            }
            rectangle.x += 10;
            rectangle.width -= 10;
            rectangle.y += 20;
        }
        for (int i = 0; i < this.radioItemCount(); ++i) {
            object = this.getRadioItem(i);
            rectangle.height = 24;
            this.renderRadioItem(graphics2D, (RadioItemDefinition)object, rectangle, object.getIsDefault());
            rectangle.height = this.getRadioItemHeight((RadioItemDefinition)object);
            if (object.getHasSubGroup()) {
                object2 = new Rectangle(rectangle.x + 19, rectangle.y + 24 - 2, rectangle.width - 22, this.getRadioItemHeight((RadioItemDefinition)object) - 24 + 4);
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawRect(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
                graphics2D.setColor(Color.black);
            }
            rectangle.translate(0, rectangle.height);
        }
    }

    private void addItemInternal(CanvasObject canvasObject, int n) {
        Component component;
        if (n < this.getComponentCount() && (component = this.getComponent(n)) instanceof EmptyFiller) {
            this.remove(component);
        }
        canvasObject.setAlignmentX(0.0f);
        this.addPanelItem(canvasObject, n);
        this.invalidate();
    }

    private void addPanelItem(CanvasObject canvasObject, int n) {
        RgoPanel rgoPanel = new RgoPanel();
        rgoPanel.add(canvasObject);
        this.add((Component)rgoPanel, n);
    }

    private void removeInternal(CanvasObject canvasObject) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof RgoPanel)) continue;
            for (Component component2 : ((RgoPanel)component).getComponents()) {
                if (component2 != canvasObject) continue;
                this.remove(component);
                return;
            }
        }
    }

    protected void pad() {
        if (this.hasGroupBox()) {
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            this.getComponent(0).setName(TITLE_FILLER);
        }
        for (int i = 0; i < this.radioItemCount(); ++i) {
            this.add(Box.createRigidArea(new Dimension(0, 24)));
        }
    }

    private Component locateComponentAt(int n) {
        Component component = null;
        int n2 = this.getBorder().getBorderInsets((Component)this).top;
        for (Component component2 : this.getComponents()) {
            if ((n2 += component2.getPreferredSize().height) <= n) continue;
            component = component2;
            break;
        }
        return component;
    }

    private int getRadioItemYPos(int n) {
        if (n < 0 || n >= this.radioItemCount()) {
            return -1;
        }
        int n2 = this.getBorder().getBorderInsets((Component)this).top;
        if (this.hasGroupBox()) {
            n2 += 20;
        }
        for (int i = 0; i < n; ++i) {
            RadioItemDefinition radioItemDefinition = this.getRadioItem(i);
            n2 += this.getRadioItemHeight(radioItemDefinition);
        }
        return n2;
    }

    private int getRadioItemIndex(RadioItemDefinition radioItemDefinition) {
        for (int i = 0; i < this.radioItemCount(); ++i) {
            RadioItemDefinition radioItemDefinition2 = this.getRadioItem(i);
            if (radioItemDefinition2 != radioItemDefinition) continue;
            return i;
        }
        return 0;
    }

    private int getRadioItemHeight(RadioItemDefinition radioItemDefinition) {
        if (!radioItemDefinition.getHasSubGroup()) {
            return 24;
        }
        int n = 24;
        int n2 = radioItemDefinition.getElementCount();
        if (n2 == 0) {
            n += 20;
        }
        for (int i = 0; i < n2; ++i) {
            String string = radioItemDefinition.getPanelElement(i).getControlId();
            Component component = this.findComponent(string);
            if (component == null) continue;
            n += component.getPreferredSize().height;
        }
        return n;
    }

    private Component findComponent(String string) {
        for (Component component : this.getComponents()) {
            Component component2;
            RgoPanel rgoPanel;
            if (!(component instanceof RgoPanel) || (rgoPanel = (RgoPanel)component).getComponentCount() <= 1 || (component2 = rgoPanel.getComponent(1)).getName() == null || !component2.getName().equals(string)) continue;
            return component2;
        }
        return null;
    }

    private void renderRadioItem(Graphics2D graphics2D, RadioItemDefinition radioItemDefinition, Rectangle rectangle, boolean bl) {
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, (Icon)(bl ? this.mSelectedImage : this.mUnselectedImage), (String)radioItemDefinition.getTitle(), (int)2);
    }

    private void checkFillers() {
        if (this.getComponentCount() > 0 && this.getComponent(0).getHeight() == 0) {
            return;
        }
        this.manageTitleFiller();
        for (int i = 0; i < this.radioItemCount(); ++i) {
            RadioItemDefinition radioItemDefinition = this.getRadioItem(i);
            Component component = this.locateComponentAt(this.getRadioItemYPos(i));
            if (!(component instanceof Box.Filler)) continue;
            int n = this.getComponentZOrder(component) + 1;
            component = n > -1 && n < this.getComponentCount() ? this.getComponent(n) : null;
            boolean bl = component instanceof EmptyFiller;
            if (radioItemDefinition.getHasSubGroup()) {
                if (bl || radioItemDefinition.getElementCount() != 0) continue;
                this.add((Component)new EmptyFiller(20), n);
                continue;
            }
            if (!bl) continue;
            this.remove(n);
        }
    }

    private void manageTitleFiller() {
        if (this.getComponentCount() == 0) {
            return;
        }
        Component component = this.getComponent(0);
        boolean bl = component instanceof Box.Filler && component.getName() != null && component.getName().equals(TITLE_FILLER);
        boolean bl2 = this.hasGroupBox();
        if (bl2 && !bl) {
            this.add(Box.createRigidArea(new Dimension(0, 20)), 0);
            this.getComponent(0).setName(TITLE_FILLER);
        } else if (!bl2 && bl) {
            this.remove(0);
        }
    }

    private int getComponentIndex(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Rectangle rectangle = this.getComponent(i).getBounds();
            if (rectangle.y > n2 || !(rectangle.getMaxY() > (double)n2)) continue;
            n3 = i;
            if (this.getRadioItemYPos(n) + 24 < n2) break;
            ++n3;
            break;
        }
        if (n3 == -1) {
            n3 = this.getComponentCount();
            RadioItemDefinition radioItemDefinition = this.getRadioItem(n);
            int n4 = this.componentIndexToRadioSubIndex(n, n3);
            if (n4 > radioItemDefinition.getElementCount()) {
                n3 -= n4 - radioItemDefinition.getElementCount();
            }
        }
        return n3;
    }

    private int componentIndexToRadioSubIndex(int n, int n2) {
        if (!this.isValid()) {
            this.validate();
        }
        int n3 = this.getRadioItemYPos(n);
        int n4 = this.getComponentIndex(n, n3);
        return n2 - n4;
    }

    protected RadioItemDefinition findRadioItemParent(CanvasObject canvasObject) {
        for (int i = 0; i < this.radioItemCount(); ++i) {
            RadioItemDefinition radioItemDefinition = this.getRadioItem(i);
            for (int j = 0; j < radioItemDefinition.getElementCount(); ++j) {
                if (!radioItemDefinition.getPanelElement(j).getControlId().equals(canvasObject.getName())) continue;
                return radioItemDefinition;
            }
        }
        return null;
    }

    private boolean checkAddToSelf(Component component) {
        if (component instanceof Container) {
            for (Container container = this; container != null; container = container.getParent()) {
                if (container != component) continue;
                return true;
            }
        }
        return false;
    }

    public static class RgoPanel
    extends JPanel {
        public RgoPanel() {
            super(null);
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(28, 0)));
            this.setOpaque(false);
        }
    }

    class EmptyFiller
    extends Box.Filler {
        public EmptyFiller(int n) {
            super(new Dimension(0, n), new Dimension(0, n), new Dimension(Short.MAX_VALUE, n));
        }
    }
}

