/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.FileSystemBrowserDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class FileSystemBrowserObject
extends CanvasObject {
    private ImageIcon mItemImage;

    public FileSystemBrowserObject(FileSystemBrowserDefinition fileSystemBrowserDefinition) {
        super((PanelElementDefinition)fileSystemBrowserDefinition);
        try {
            this.mItemImage = new ImageIcon(BuilderResUtil.getImageResource("dlg_button_image.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        String string = this.getControlTitle();
        int n = string != null && string.length() > 0 ? 20 : 0;
        return new Dimension(this.getObjectWidth(), n + this.mItemImage.getIconHeight() + 34);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        Rectangle rectangle = this.getBounds();
        String string = this.getControlTitle();
        boolean bl = string != null && string.length() > 0;
        int n = bl ? 20 : 0;
        Rectangle rectangle2 = new Rectangle(insets.left, insets.top + n, rectangle.width - insets.left - insets.right, 26 - insets.top - insets.bottom);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        graphics2D.setColor(Color.gray);
        graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        if (bl) {
            this.renderTitle(graphics2D, insets.left, insets.top);
        }
        if (this.mItemImage != null) {
            this.mItemImage.paintIcon(this, graphics2D, insets.left, 30 + n);
            this.renderButtonTitle(graphics2D, insets.left, 30 + n);
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 24;
        rectangle.grow(-n, -n2);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    private void renderButtonTitle(Graphics2D graphics2D, int n, int n2) {
        String string = BuilderResUtil.getString("IDS_DEF_BROWSE_TITLE");
        if (string == null || string.length() == 0) {
            return;
        }
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        Rectangle rectangle = new Rectangle(0, 0, this.mItemImage.getIconWidth(), this.mItemImage.getIconHeight());
        rectangle.translate(0, n2);
        rectangle.grow(-n, 0);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)0);
    }
}

