/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.ItemGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ComboBoxObject
extends CanvasObject {
    private static ImageIcon sItemImage = null;
    private static ImageIcon sItemImageSmall = null;
    private static ImageIcon sItemImageSmaller = null;

    public ComboBoxObject(ComboBoxDefinition comboBoxDefinition) {
        super((PanelElementDefinition)comboBoxDefinition);
        try {
            if (sItemImage == null) {
                sItemImage = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image.png"));
            }
            if (sItemImageSmall == null) {
                sItemImageSmall = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image_small.png"));
            }
            if (sItemImageSmaller == null) {
                sItemImageSmaller = new ImageIcon(BuilderResUtil.getImageResource("combo_box_image_smaller.png"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ComboBoxDefinition getComboDef() {
        return (ComboBoxDefinition)this.getCtrlDef();
    }

    @Override
    public Dimension getPreferredSize() {
        String string = this.getControlTitle();
        int n = string != null && string.length() > 0 ? 20 : 0;
        return new Dimension(this.getObjectWidth(), n + 25);
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        boolean bl = string != null && string.length() > 0;
        Rectangle rectangle = this.getBounds();
        ImageIcon imageIcon = this.getImageIcon();
        int n = rectangle.height - imageIcon.getIconHeight() - insets.bottom;
        imageIcon.paintIcon(this, graphics2D, insets.left, n);
        if (bl) {
            this.renderTitle(graphics2D, insets.left, insets.top);
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y + 2);
        rectangle.height = 24;
        rectangle.grow(-n, -n2);
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }

    private ImageIcon getImageIcon() {
        if (this.getParent() instanceof ItemGroupObject) {
            return sItemImageSmall;
        }
        if (this.getParent().getParent() instanceof RadioGroupObject) {
            return sItemImageSmaller;
        }
        return sItemImage;
    }
}

