/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.CheckBoxGroupObject;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.uitools.ui_builder.definition.ControlDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class CanvasObject
extends JComponent {
    protected static final int TITLE_OFFSET = 20;
    private static Font sFont = new Font("SansSerif", 0, 12);
    private static Border sPlainBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static Color sSelectedBorderColor = new Color(81, 81, 189);
    private static Border sSelectedBorder = BorderFactory.createLineBorder(sSelectedBorderColor, 2);
    private PanelElementDefinition mCtrlDef;
    private boolean mSelected;

    public static Color getSelectedBorderColor() {
        return sSelectedBorderColor;
    }

    public CanvasObject(PanelElementDefinition panelElementDefinition) {
        this.mCtrlDef = panelElementDefinition;
        this.mSelected = false;
        this.setBorder(sPlainBorder);
        this.setFont(sFont);
        this.setFocusable(true);
        this.addFocusListener(new CanvasFocusListener());
        this.setName(panelElementDefinition.getControlId());
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.mSelected;
        this.mSelected = bl;
        if (bl2 != this.mSelected) {
            this.setBorder(this.mSelected ? sSelectedBorder : sPlainBorder);
            if (this.mSelected) {
                this.deselectOthers();
            }
        }
    }

    public Point getPosition() {
        return this.mCtrlDef.getPosition();
    }

    public void setPosition(Point point) {
        this.mCtrlDef.setPosition(point);
    }

    public void setControlTitle(String string) {
        this.mCtrlDef.setTitle(string);
    }

    public String getControlTitle() {
        return this.mCtrlDef.getTitle();
    }

    public void setControlTip(String string) {
        this.mCtrlDef.setTip(string);
        this.setToolTipText(string);
    }

    public String getControlTip() {
        return this.mCtrlDef.getTip();
    }

    public void setControlId(String string) {
        this.mCtrlDef.setControlId(string);
        this.setName(string);
    }

    public String getControlId() {
        return this.mCtrlDef.getControlId();
    }

    public String getControlSyntax() {
        if (this.mCtrlDef instanceof ControlDefinition) {
            return ((ControlDefinition)this.mCtrlDef).getControlSyntax();
        }
        if (this.mCtrlDef instanceof PanelDefinition) {
            return ((PanelDefinition)this.mCtrlDef).getPanelSyntax();
        }
        return null;
    }

    public void setControlSyntax(String string) {
        if (this.mCtrlDef instanceof ControlDefinition) {
            ((ControlDefinition)this.mCtrlDef).setControlSyntax(string);
        } else if (this.mCtrlDef instanceof PanelDefinition) {
            ((PanelDefinition)this.mCtrlDef).setPanelSyntax(string);
        }
    }

    public PanelElementDefinition getCtrlDef() {
        return this.mCtrlDef;
    }

    abstract void render(Graphics2D var1);

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (graphics instanceof Graphics2D) {
            this.render((Graphics2D)graphics);
        }
    }

    protected int getObjectWidth() {
        int n = 160;
        if (this.getParent() instanceof CheckBoxGroupObject) {
            n -= 20;
        }
        if (this.getParent() != null && this.getParent().getParent() instanceof RadioGroupObject) {
            n -= 40;
        }
        return n;
    }

    private void deselectOthers() {
        BuilderCanvas builderCanvas = this.getCanvas();
        if (builderCanvas != null) {
            builderCanvas.deselectItems(this);
            builderCanvas.fireSelectionChange(this);
        }
    }

    private BuilderCanvas getCanvas() {
        Container container;
        BuilderCanvas builderCanvas = null;
        for (container = this.getParent(); container != null && !(container instanceof BuilderCanvas); container = container.getParent()) {
        }
        if (container != null) {
            builderCanvas = (BuilderCanvas)container;
        }
        return builderCanvas;
    }

    class CanvasFocusListener
    extends FocusAdapter {
        CanvasFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            CanvasObject.this.setSelected(true);
        }
    }
}

