/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder;

import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.syntaxeditor.AUTO_COMPLETE_LEVEL;
import com.spss.shared.syntaxeditor.SyntaxCommand;
import com.spss.shared.syntaxeditor.SyntaxMasterPanel;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SyntaxDiagramDlg
extends BaseDialog
implements PopupMenuListener,
SyntaxMasterPanel.SyntaxCallback {
    private static final String ESCAPE_SEQUENCE = "%%";
    SyntaxDiagramDlgCallback mCallback;
    private boolean mModalResult = false;
    SyntaxMasterPanel mSyntaxMasterPanel;
    private boolean mIsIdPopupVisible;
    private ArrayList<String> mControlIDs;
    private String mSyntax;
    private JButton mOkButton;
    private JButton mCancelButton;
    private JButton mHelpButton;

    public SyntaxDiagramDlg(JFrame jFrame, String string, ArrayList<String> arrayList, ArrayList<SyntaxCommand> arrayList2, SyntaxEditorState syntaxEditorState, SyntaxDiagramDlgCallback syntaxDiagramDlgCallback) {
        super(jFrame, BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM"), true, BuilderResUtil.getLabels(), BuilderResBundle.getImageFolder());
        this.mCallback = syntaxDiagramDlgCallback;
        this.mSyntax = string;
        this.mControlIDs = arrayList;
        this.mIsIdPopupVisible = false;
        this.mSyntaxMasterPanel = new SyntaxMasterPanel((SyntaxMasterPanel.SyntaxCallback)this, arrayList2, !syntaxEditorState.isOptimizeRtoL());
        this.mSyntaxMasterPanel.removeSyntaxSplit();
        this.mSyntaxMasterPanel.removeNavigationPane();
        this.mSyntaxMasterPanel.removeErrorPane();
        this.mSyntaxMasterPanel.insertString(0, this.mSyntax);
        this.createControls();
        this.enableControls();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public ArrayList getUserAutoCompleteList(AUTO_COMPLETE_LEVEL aUTO_COMPLETE_LEVEL) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (aUTO_COMPLETE_LEVEL != AUTO_COMPLETE_LEVEL.subcommand) {
            String string = DialogDefinition.getEscapeSequence();
            for (String string2 : this.mControlIDs) {
                arrayList.add(string + string2 + string);
            }
        }
        return arrayList;
    }

    public boolean processDrop(DropTargetDropEvent dropTargetDropEvent) {
        return false;
    }

    public Object processNotification(int n, Object object) {
        if (n == 7) {
            return false;
        }
        if (n == 9) {
            return this.getUserAutoCompleteList((AUTO_COMPLETE_LEVEL)object);
        }
        return null;
    }

    public boolean getModalResult() {
        return this.mModalResult;
    }

    protected void init() {
        super.init();
    }

    private void createControls() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = insets;
        String string = this.getEscapeSequence();
        String string2 = BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM_DESC");
        String string3 = String.format(string2, string, string, string);
        JTextArea jTextArea = this.createStaticMultiLineLabel(string3);
        jPanel.add((Component)jTextArea, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        String string4 = BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM_DESC2");
        JTextArea jTextArea2 = this.createStaticMultiLineLabel(string4);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 4);
        jPanel2.add((Component)jLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)jTextArea2, gridBagConstraints2);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 6;
        jPanel.add((Component)this.mSyntaxMasterPanel, gridBagConstraints);
        this.mSyntaxMasterPanel.setPreferredSize(new Dimension(500, 300));
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSyntaxMasterPanel);
        vector.add(this.mOkButton);
        vector.add(this.mCancelButton);
        vector.add(this.mHelpButton);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JTextPane jTextPane = this.mSyntaxMasterPanel.getSyntaxTextPane();
        jTextPane.addMouseListener(new ContextMouseListener());
        jTextPane.getInputMap(2).put(KeyStroke.getKeyStroke(115, 2), "close_window");
        jTextPane.getActionMap().put("close_window", new OkAction());
        AbstractAction abstractAction = new CtrlUpDownAction(true);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(38, 2), "up_a_line");
        jTextPane.getActionMap().put("up_a_line", abstractAction);
        abstractAction = new CtrlUpDownAction(false);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(40, 2), "down_a_line");
        jTextPane.getActionMap().put("down_a_line", abstractAction);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard");
        abstractAction = new DeletePrevWordAction();
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(8, 2), "del_prev_word");
        jTextPane.getActionMap().put("del_prev_word", abstractAction);
        String string5 = UIToolResUtil.getString((String)"IDS_DELETE");
        Action action = jTextPane.getActionMap().get("delete-next");
        action = action != null ? action : jTextPane.getActionMap().get(string5);
        action.putValue("Name", string5);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(127, 0), string5);
        jTextPane.getActionMap().put(string5, action);
        String string6 = UIToolResUtil.getString((String)"IDS_SELECTALL");
        Action action2 = jTextPane.getActionMap().get("select-all");
        action2 = action2 != null ? action2 : jTextPane.getActionMap().get(string6);
        action2.putValue("Name", string6);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(65, 2), string6);
        jTextPane.getActionMap().put(string6, action2);
    }

    private JTextArea createStaticMultiLineLabel(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setForeground(UIManager.getColor("Panel.foreground"));
        jTextArea.setBackground(UIManager.getColor("Panel.background"));
        jTextArea.setFocusable(false);
        return jTextArea;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        this.mCancelButton = new JButton(new CancelAction());
        this.mHelpButton = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(this.mHelpButton);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    private void enableControls() {
    }

    private boolean validateInput() {
        String string = this.getSyntax();
        Vector vector = new Vector();
        if (string != null && string.length() > 0) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(string);
            if (stringBuffer.indexOf("%") < 0) {
                return true;
            }
            int n2 = string.length();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                n3 = 0;
                n4 = stringBuffer.indexOf("%", n6);
                if (n4 < 0) break;
                n = stringBuffer.charAt(n4);
                while (n4 >= 0 && n == 37) {
                    ++n3;
                    if (++n4 >= n2) break;
                    n = stringBuffer.charAt(n4);
                }
                n5 += n3;
                if (n3 != 0 && n3 != 2 && n3 != 4) {
                    return false;
                }
                n6 = n4;
            }
            if (n5 > 0 && n5 % 4 != 0) {
                return false;
            }
            n6 = 0;
            n = 0;
            while (n6 >= 0 && n6 < n2) {
                if ((n6 = stringBuffer.indexOf(ESCAPE_SEQUENCE, n6)) <= -1) continue;
                n = stringBuffer.indexOf(ESCAPE_SEQUENCE, n6 + 1);
                if (n == -1) {
                    n = stringBuffer.length();
                }
                if (this.mControlIDs.indexOf(stringBuffer.subSequence(n6 + 2, n).toString()) < 0) {
                    return false;
                }
                n6 = n + 2;
            }
        }
        return true;
    }

    public void doHelp() {
        this.mCallback.showHelp();
    }

    public String getSyntax() {
        return this.mSyntaxMasterPanel.getMainSpssSyntaxTextPane().getText();
    }

    protected boolean canDispose() {
        return !this.mIsIdPopupVisible;
    }

    private void showIdPopup() {
        JTextPane jTextPane = this.mSyntaxMasterPanel.getSyntaxTextPane();
        Point point = jTextPane.getCaret().getMagicCaretPosition();
        if (point == null) {
            point = new Point(0, 0);
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (String string : this.mControlIDs) {
            jPopupMenu.add(new InsertIdAction(string));
        }
        jPopupMenu.addPopupMenuListener(this);
        jPopupMenu.show(jTextPane, point.x + 4, point.y);
    }

    private void doContextMenu(MouseEvent mouseEvent) {
        JTextPane jTextPane = this.mSyntaxMasterPanel.getSyntaxTextPane();
        jTextPane.requestFocus();
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = jTextPane.getSelectedText();
        boolean bl = string != null && string.length() > 0;
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("Name", UIToolResUtil.getString((String)"IDS_CUT"));
        cutAction.setEnabled(bl);
        jPopupMenu.add(new JMenuItem(cutAction));
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("Name", UIToolResUtil.getString((String)"IDS_COPY"));
        copyAction.setEnabled(bl);
        jPopupMenu.add(new JMenuItem(copyAction));
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("Name", UIToolResUtil.getString((String)"IDS_PASTE"));
        pasteAction.setEnabled(this.isFlavorAvailable(DataFlavor.stringFlavor));
        jPopupMenu.add(new JMenuItem(pasteAction));
        Action action = jTextPane.getActionMap().get(UIToolResUtil.getString((String)"IDS_DELETE"));
        jPopupMenu.add(new JMenuItem(action));
        jPopupMenu.add(new JSeparator());
        Action action2 = jTextPane.getActionMap().get(UIToolResUtil.getString((String)"IDS_SELECTALL"));
        jPopupMenu.add(new JMenuItem(action2));
        jPopupMenu.show(jTextPane, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.mIsIdPopupVisible = false;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.mIsIdPopupVisible = false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.mIsIdPopupVisible = true;
    }

    public String getEscapeSequence() {
        return ESCAPE_SEQUENCE;
    }

    public boolean isFlavorAvailable(DataFlavor dataFlavor) {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (transferable == null) {
            return false;
        }
        return transferable.isDataFlavorSupported(dataFlavor);
    }

    public static interface SyntaxDiagramDlgCallback {
        public void syntaxModifiedNotification();

        public void showHelp();

        public boolean showInvalidSyntaxWarning();
    }

    class DeletePrevWordAction
    extends AbstractAction {
        DeletePrevWordAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n;
                JTextPane jTextPane = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getSyntaxTextPane();
                int n2 = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineStartDocOffset(SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineNumberFromPos(n));
                int n3 = n;
                for (n = jTextPane.getCaretPosition(); n > n2 && Character.isWhitespace(jTextPane.getText(n - 1, 1).charAt(0)); --n) {
                }
                while (n > n2 && !Character.isWhitespace(jTextPane.getText(n - 1, 1).charAt(0))) {
                    --n;
                }
                if (n3 != n) {
                    Document document = jTextPane.getDocument();
                    document.remove(n, n3 - n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    class CtrlUpDownAction
    extends AbstractAction {
        private boolean mIsUp;

        public CtrlUpDownAction(boolean bl) {
            this.mIsUp = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextPane jTextPane = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getSyntaxTextPane();
            int n = jTextPane.getCaretPosition();
            int n2 = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineNumberFromPos(n);
            int n3 = this.mIsUp ? (n2 > 0 ? n2 - 1 : n2) : (n2 < SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineCount() - 1 ? n2 + 1 : n2);
            int n4 = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineStartDocOffset(n3);
            jTextPane.setCaretPosition(n4);
        }
    }

    class ContextMouseListener
    extends MouseAdapter {
        ContextMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JTextComponent && mouseEvent.isPopupTrigger()) {
                mouseEvent.consume();
                SyntaxDiagramDlg.this.doContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JTextComponent && mouseEvent.isPopupTrigger()) {
                mouseEvent.consume();
                SyntaxDiagramDlg.this.doContextMenu(mouseEvent);
            }
        }
    }

    class InsertIdAction
    extends AbstractAction {
        private String mId;

        InsertIdAction(String string) {
            super(string);
            this.mId = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextPane jTextPane = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getSyntaxTextPane();
            int n = jTextPane.getCaretPosition();
            if (n > -1) {
                String string = SyntaxDiagramDlg.this.getEscapeSequence();
                jTextPane.replaceSelection(string + this.mId + string);
            }
        }
    }

    class IdMenuKeyListener
    extends KeyAdapter {
        IdMenuKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 && !SyntaxDiagramDlg.this.mIsIdPopupVisible) {
                int n = 128;
                if ((keyEvent.getModifiersEx() & n) == n) {
                    keyEvent.consume();
                    SyntaxDiagramDlg.this.showIdPopup();
                }
            } else if (keyEvent.getKeyCode() == 27 && SyntaxDiagramDlg.this.mIsIdPopupVisible) {
                keyEvent.consume();
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxDiagramDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxDiagramDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (!SyntaxDiagramDlg.this.validateInput() && (bl = SyntaxDiagramDlg.this.mCallback.showInvalidSyntaxWarning())) {
                return;
            }
            SyntaxDiagramDlg.this.mModalResult = true;
            SyntaxDiagramDlg.this.mCallback.syntaxModifiedNotification();
            SyntaxDiagramDlg.this.dispose();
        }
    }
}

