/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder;

import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class OpenDeployedDlg
extends BaseDialog {
    private String mSpecName = "";
    private String mSpecPath = "";
    private String mDeployPath = "";
    private JList mList;
    private SpssMultiLineLabel mWarningLabel;
    private OkAction mOkAction;

    public static String doOpenDeployedDlg(BuilderFrame builderFrame) {
        OpenDeployedDlg openDeployedDlg = new OpenDeployedDlg(builderFrame);
        openDeployedDlg.setVisible(true);
        if (openDeployedDlg.getSpecName().length() == 0) {
            return null;
        }
        String string = openDeployedDlg.getSpecPath();
        String string2 = string == null || string.length() == 0 ? CommandExecutor.getAppdataCustomDialogDirectoryForAllUsers() + File.separator + openDeployedDlg.getSpecName() : string + File.separator + openDeployedDlg.getSpecName();
        return string2;
    }

    public static String doRemoveDeployedDlg(BuilderFrame builderFrame) {
        OpenDeployedDlg openDeployedDlg = new OpenDeployedDlg(builderFrame);
        openDeployedDlg.setTitle(BuilderResUtil.getString("IDS_REMOVE_DEPLOYED_DLG_TITLE"));
        openDeployedDlg.setVisible(true);
        if (openDeployedDlg.getSpecName().length() == 0) {
            return null;
        }
        String string = openDeployedDlg.getDeployPath();
        String string2 = string == null || string.length() == 0 ? CommandExecutor.getUIExtensionsFolderPath() + File.separator + openDeployedDlg.getSpecName() : string + File.separator + openDeployedDlg.getSpecName();
        return string2;
    }

    OpenDeployedDlg(BuilderFrame builderFrame) {
        super((JFrame)builderFrame, BuilderResUtil.getString("IDS_OPEN_DEPLOYED_DLG_TITLE"), true, ResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), Locale.getDefault()), BuilderResBundle.getImageFolder());
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
        if (this.mList.getModel().getSize() > 0) {
            this.mList.setSelectedIndex(0);
        } else {
            this.mOkAction.setEnabled(false);
        }
    }

    public void doHelp() {
    }

    protected void initialize() {
        JPanel jPanel = this.getViewPanel();
        Dimension dimension = new Dimension(220, 160);
        this.mWarningLabel = new SpssMultiLineLabel("", null, dimension.width);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        JLabel jLabel = new JLabel(BuilderResUtil.getString("IDS_DEPLOYED_DIALOGS"));
        jLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_DEPLOYED_DIALOGS"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Vector<DeployedItem> vector = this.loadData();
        this.mList = new JList<DeployedItem>(vector);
        this.mList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.mList);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jLabel.setLabelFor(this.mList);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.mWarningLabel, gridBagConstraints);
        jScrollPane.setPreferredSize(dimension);
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1 && OpenDeployedDlg.this.mList.getSelectedValue() != null) {
                    new OkAction().actionPerformed(null);
                }
            }
        });
        jScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                OpenDeployedDlg.this.mWarningLabel.setMaxWidth(OpenDeployedDlg.this.mList.getWidth() + 10);
            }
        });
    }

    private Vector<DeployedItem> loadData() {
        Object object;
        String[] stringArray;
        Vector<DeployedItem> vector = new Vector<DeployedItem>();
        for (String string : stringArray = CommandExecutor.getSecondaryExtensionFolders()) {
            this.addFromPath(vector, new File(string), true);
        }
        String string = CommandExecutor.getAppdataCustomDialogDirectoryForAllUsers();
        if (string != null) {
            File object2 = new File(string);
            this.addFromPath(vector, object2, false);
        }
        if (System.getProperty("os.name", "Windows").toLowerCase().indexOf("win") >= 0) {
            object = new File(CommandExecutor.getAppdataCustomDialogDirectory());
            if (!object.exists()) {
                object.mkdirs();
            }
            this.addFromPath(vector, (File)object, false);
            File file = new File(CommandExecutor.getUIExtensionsFolderPath());
            if (!file.exists()) {
                file.mkdirs();
            }
            this.addFromPath(vector, file, false);
        } else {
            object = new File(CommandExecutor.getUIExtensionsFolderPath());
            if (!object.exists()) {
                object.mkdirs();
            }
            this.addFromPath(vector, (File)object, false);
            File file = new File(CommandExecutor.getAppdataCustomDialogDirectory());
            if (!file.exists()) {
                file.mkdirs();
            }
            this.addFromPath(vector, file, false);
        }
        if (this.hasDuplicates(vector)) {
            this.mWarningLabel.setText(BuilderResUtil.getString("IDS_ASTERISK_DESC"));
        }
        object = new DeployedItem[vector.size()];
        vector.toArray((T[])object);
        Arrays.sort(object, new ItemComparator());
        vector = new Vector<DeployedItem>(Arrays.asList(object));
        return vector;
    }

    private boolean hasDuplicates(Vector<DeployedItem> vector) {
        for (DeployedItem deployedItem : vector) {
            if (!deployedItem.isDuplicate()) continue;
            return true;
        }
        return false;
    }

    private void addFromPath(Vector<DeployedItem> vector, File file, boolean bl) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isDirectory() || !CommandExecutor.isClefFolder(file2)) continue;
            String string = bl ? file.getAbsolutePath() : "";
            DeployedItem deployedItem = new DeployedItem(file2.getName(), string, this.hasSpecName(vector, file2.getName()), file.getAbsolutePath());
            vector.add(deployedItem);
        }
    }

    private boolean hasSpecName(Vector<DeployedItem> vector, String string) {
        for (DeployedItem deployedItem : vector) {
            if (!deployedItem.getSpecName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkAction = new OkAction();
        JButton jButton = new JButton(this.mOkAction);
        JButton jButton2 = new JButton(new CancelAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                int n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private String getSpecName() {
        return this.mSpecName;
    }

    private String getSpecPath() {
        return this.mSpecPath;
    }

    private String getDeployPath() {
        return this.mDeployPath;
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OpenDeployedDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeployedItem deployedItem = (DeployedItem)OpenDeployedDlg.this.mList.getSelectedValue();
            OpenDeployedDlg.this.mSpecName = deployedItem.getSpecName();
            OpenDeployedDlg.this.mSpecPath = deployedItem.getSpecPath();
            OpenDeployedDlg.this.mDeployPath = deployedItem.getDeployPath();
            OpenDeployedDlg.this.dispose();
        }
    }

    class ItemComparator
    implements Comparator<DeployedItem> {
        ItemComparator() {
        }

        @Override
        public int compare(DeployedItem deployedItem, DeployedItem deployedItem2) {
            String string = deployedItem.getSpecName();
            if (deployedItem.getSpecPath() != null && deployedItem.getSpecPath().length() > 0) {
                string = string + " [" + deployedItem.getSpecPath() + "]";
            }
            String string2 = deployedItem2.getSpecName();
            if (deployedItem2.getSpecPath() != null && deployedItem2.getSpecPath().length() > 0) {
                string2 = string2 + " [" + deployedItem2.getSpecPath() + "]";
            }
            return string.compareTo(string2);
        }
    }

    class DeployedItem {
        private String mSpecName;
        private String mSpecPath;
        private boolean mIsDuplicate;
        private String mDeployedPath;

        DeployedItem(String string, String string2, boolean bl, String string3) {
            this.mSpecName = string;
            this.mSpecPath = string2;
            this.mIsDuplicate = bl;
            this.mDeployedPath = string3;
        }

        public boolean isDuplicate() {
            return this.mIsDuplicate;
        }

        public String getSpecName() {
            return this.mSpecName;
        }

        public String getSpecPath() {
            return this.mSpecPath;
        }

        public String getDeployPath() {
            return this.mDeployedPath;
        }

        public String toString() {
            String string = this.mIsDuplicate ? "* " : "";
            string = string + this.mSpecName;
            if (this.mSpecPath != null && this.mSpecPath.length() > 0) {
                string = string + " [" + this.mSpecPath + "]";
            }
            return string;
        }
    }
}

