/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.cf_integration.action.CFCommandAction;
import com.spss.java_client.ui.command.CustomCommandAction;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.controls.CFMenu;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.DummyAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.UserMenuAction;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.util.TreeUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MenuLocationDialogEx
extends BaseDialog
implements TreeSelectionListener,
DocumentListener,
CellEditorListener {
    private static final String DEFAULT_CDB_ICON = "defaultExtensionDialog.png";
    private static final int INSTALL_TO_ALL_FRAMES_INDEX = 0;
    private static final int INSTALL_TO_DATA_FRAMES_INDEX = 1;
    private static final int INSTALL_TO_SYNTAX_FRAMES_INDEX = 2;
    private static final int INSTALL_TO_VIEWER_FRAMES_INDEX = 3;
    public static final String SEPARATOR_ID = "SEPERATOR_198347622347324761938217312";
    private static boolean sWasModified;
    private CommandLocation mUserSelectionCommandLocation = new CommandLocation();
    private CommandLocation mMasterLocation;
    private NewMenuItemDefaultMutableTreeNode mNewMenuItemNode;
    private NewMenuDefaultMutableTreeNode mTopNewFolderNode;
    private boolean mInMoveOperation;
    private boolean mInTextUpdateOperation;
    private MenuTree mTree;
    private DefaultTreeModel mTreeModel;
    private JButton mAddButton;
    private JButton mDeleteButton;
    private JButton mMoveUpButton;
    private JButton mMoveDownButton;
    private JButton mEditButton;
    private JLabel mCustomLabel;
    private JButton mMoveUnderNewMenuButton = null;
    private JTextField mTitleField;
    private JCheckBox mSeparatorAboveCheckBox = null;
    private JCheckBox mSeparatorBelowCheckBox = null;
    private JLabel mIconImage;
    private JTextField mIconPathEdit;
    private JButton mOkButton;
    JLabel mTreeLabel;
    JLabel mInstallToComboboxLabel;
    private JComboBox mInstallToComboBox;
    private ImageIcon mNewMenuItemIcon;

    public static boolean runMenuLocationDialog(JFrame jFrame, CommandLocation commandLocation) {
        sWasModified = false;
        MenuLocationDialogEx menuLocationDialogEx = new MenuLocationDialogEx(jFrame, commandLocation);
        menuLocationDialogEx.setVisible(true);
        return sWasModified;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER_MENULOC");
    }

    protected MenuLocationDialogEx(JFrame jFrame, CommandLocation commandLocation) throws HeadlessException {
        super(jFrame, BuilderResUtil.getString("IDS_UIBUILDER_TITLE") + ": " + BuilderResUtil.getString("IDS_LOCATE_MENU_DLG_TITLE"), true, ResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), BuilderResBundle.getImageFolder());
        this.mUserSelectionCommandLocation.copyFrom(commandLocation);
        this.mMasterLocation = commandLocation;
        this.mNewMenuItemNode = null;
        this.mInMoveOperation = false;
        this.mInTextUpdateOperation = false;
        this.setup();
        this.loadMenuTree();
        this.setDefaults(commandLocation);
        this.stateChanged();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void enableOK(boolean bl) {
        this.mOkButton.setEnabled(bl);
    }

    private void initControls() {
        this.mInstallToComboboxLabel = new JLabel(BuilderResUtil.getString("IDS_MENU_LOCATION_INSTALL_TO_FRAME"));
        this.mInstallToComboboxLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_MENU_LOCATION_INSTALL_TO_FRAME"));
        this.mInstallToComboBox = new JComboBox();
        this.mInstallToComboBox.addItem(BuilderResUtil.getString("IDS_MENU_LOCATION_INSTALL_TO_ALL_FRAMES"));
        this.mInstallToComboBox.addItem(BuilderResUtil.getString("IDS_MENU_LOCATION_INSTALL_TO_DATA_FRAME"));
        this.mInstallToComboBox.addItem(BuilderResUtil.getString("IDS_MENU_LOCATION_INSTALL_TO_SYNTAX_FRAME"));
        this.mInstallToComboBox.addItem(BuilderResUtil.getString("IDS_MENU_LOCATION_INSTALL_TO_VIEWER_FRAME"));
        this.mInstallToComboboxLabel.setLabelFor(this.mInstallToComboBox);
        this.mInstallToComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuLocationDialogEx.this.saveSelectionsToCommandLocation();
                MenuLocationDialogEx.this.loadMenuTree();
                MenuLocationDialogEx.this.setDefaults(MenuLocationDialogEx.this.mUserSelectionCommandLocation);
            }
        });
        this.mTreeLabel = new JLabel(BuilderResUtil.getString("IDS_SPSS_MENUS"));
        this.mTreeLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_SPSS_MENUS"));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new MenuTreeItem("root"));
        this.mTreeModel = new DefaultTreeModel(defaultMutableTreeNode){

            @Override
            public void valueForPathChanged(TreePath treePath, Object object) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                MenuTreeItem menuTreeItem = MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode);
                menuTreeItem.setName(object.toString());
                this.nodeChanged(defaultMutableTreeNode);
            }
        };
        this.mTree = new MenuTree(this.mTreeModel);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
        this.mTree.getSelectionModel().setSelectionMode(2);
        this.mTree.setCellRenderer(new MenuTreeCellRenderer());
        this.mTree.setEditable(true);
        this.mTreeLabel.setLabelFor(this.mTree);
        this.mSeparatorAboveCheckBox = new JCheckBox(new SetSeparatorAction(true));
        this.mSeparatorAboveCheckBox.setMnemonic(BuilderResUtil.getAccessKey("IDK_DISPLAY_SEPARATOR_ABOVE"));
        this.mSeparatorBelowCheckBox = new JCheckBox(new SetSeparatorAction(false));
        this.mSeparatorBelowCheckBox.setMnemonic(BuilderResUtil.getAccessKey("IDK_DISPLAY_SEPARATOR_ABOVE"));
        this.mDeleteButton = new JButton(new DeleteAction());
        this.mEditButton = new JButton(new EditAction());
        this.mCustomLabel = new JLabel(BuilderResUtil.getString("IDS_MENU_LOCATION_CUSTOM_LABEL"));
        this.mMoveUnderNewMenuButton = new JButton(new MoveUnderNewMenuAction());
        this.mTree.addTreeSelectionListener(this);
        this.mTree.getCellEditor().addCellEditorListener(this);
        this.mTree.setInvokesStopCellEditing(true);
    }

    private void setup() {
        this.initControls();
        this.mNewMenuItemIcon = new ImageIcon(BuilderResUtil.getImageResource("cdbNewMenuItem.png"));
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mInstallToComboboxLabel);
        jPanel2.add(this.mInstallToComboBox);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTreeLabel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JPanel jPanel3 = this.createTreePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel4 = this.createMoveUnderNewMenuPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSeparatorAboveCheckBox, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSeparatorBelowCheckBox, gridBagConstraints, 0, 5, 1, 1, n, insets);
        this.addImagePanel(jPanel, 6);
        JPanel jPanel5 = this.createSideButtonPanel();
        gridBagConstraints.fill = 3;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 2, 2, 1, 1, n, insets);
    }

    private JPanel createTreePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mTree);
        jScrollPane.setPreferredSize(new Dimension(280, 200));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCustomLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        n = 24;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMoveUnderNewMenuButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createMoveUnderNewMenuPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCustomLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        n = 24;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMoveUnderNewMenuButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createSideButtonPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.mAddButton = new JButton(new AddAction());
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mEditButton = new JButton(new EditAction());
        DialogUtil.addUsingGBL(jPanel, this.mEditButton, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom + 20, insets.right));
        this.mMoveUpButton = new JButton(new MoveUpAction());
        DialogUtil.addUsingGBL(jPanel, this.mMoveUpButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mMoveDownButton = new JButton(new MoveDownAction());
        DialogUtil.addUsingGBL(jPanel, this.mMoveDownButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.mDeleteButton, "South");
        return jPanel2;
    }

    private void addImagePanel(JPanel jPanel, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, insets.left, 8, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, n, 2, 1, n2, insets2);
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, n, 1, 3, n2, insets2);
        String string = this.defaultExtensionDlgPath();
        JLabel jLabel = new JLabel(BuilderResUtil.getString("IDS_IMAGE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mIconImage = new JLabel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mIconImage, gridBagConstraints, 0, 0, 1, 1, 20, insets);
        this.mIconPathEdit = new JTextField();
        Dimension dimension = this.mIconPathEdit.getPreferredSize();
        if (dimension.width < 60) {
            dimension.width = 60;
            this.mIconPathEdit.setPreferredSize(dimension);
        }
        if (string != null) {
            this.mIconPathEdit.setText(string);
            this.mIconImage.setIcon(new ImageIcon(string));
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mIconPathEdit, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuLocationDialogEx.this.doImageFileBrowse();
            }
        };
        abstractAction.putValue("Name", BuilderResUtil.getString("IDS_BROWSE_BUTTON_TEXT"));
        abstractAction.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_BROWSE_BUTTON_TEXT"));
        JButton jButton = new JButton(abstractAction);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jButton, gridBagConstraints, 1, 1, 1, 1, n2, insets);
    }

    private void doImageFileBrowse() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        ImageFilesFilter imageFilesFilter = new ImageFilesFilter();
        remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_OPEN_IMAGE_TITLE"));
        remoteFileChooser.addChoosableFileFilter(imageFilesFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter(imageFilesFilter);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            File file = remoteFileChooser.getSelectedFile();
            ImageIcon imageIcon = new ImageIcon(file.getPath());
            if (imageIcon.getIconWidth() > 16 || imageIcon.getIconHeight() > 16) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), BuilderResUtil.getString("IDS_ICON_TOO_LARGE"), VersionInfo.getAppVersionString());
                return;
            }
            if (ComponentState.isBtdRtlOrLtr() && file.getPath() != null && file.getPath().length() > 0 && file.getPath().indexOf(8206) == -1) {
                this.mIconPathEdit.setText(ComponentState.preparePathForBidiDisplay((String)file.getPath()));
            } else {
                this.mIconPathEdit.setText(file.getPath());
            }
            this.mIconImage.setIcon(imageIcon);
        }
    }

    protected void loadMenuTree() {
        NewMenuItemDefaultMutableTreeNode newMenuItemDefaultMutableTreeNode = this.mNewMenuItemNode;
        JMenuBar jMenuBar = this.getMenuForSelectedInstallToSelection();
        if (jMenuBar != null) {
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
            defaultMutableTreeNode.removeAllChildren();
            this.mTreeModel.reload();
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                Object object;
                String string = jMenuBar.getMenu(i).getText();
                if ("Add-ons".equals(string)) continue;
                if ("Custom".equals(string)) {
                    bl = true;
                } else if (!bl && "Utilities".equals(string)) {
                    object = new MenuTreeItem("Custom");
                    ((MenuTreeItem)object).setGlobalCustomMenuItem(true);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
                    this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                }
                object = this.addMenu(defaultMutableTreeNode, jMenuBar.getMenu(i));
                if (this.mNewMenuItemNode == null || object == null) continue;
                this.createLinkToSeparators((DefaultMutableTreeNode)object, this.mNewMenuItemNode);
            }
            this.mTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private JMenuBar getMenuForSelectedInstallToSelection() {
        JMenuBar jMenuBar = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC);
        int n = this.mInstallToComboBox.getSelectedIndex();
        if (n == 2) {
            spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.SYNTAX_DOC);
            if (spssFrame == null) {
                spssFrame = new SyntaxFrame();
                jMenuBar = spssFrame.getMainMenuBar();
                spssFrame = null;
            } else {
                jMenuBar = spssFrame.getMainMenuBar();
            }
        } else if (n == 3) {
            spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.OUTPUT_DOC);
            if (spssFrame == null) {
                spssFrame = new ViewerFrame();
                jMenuBar = spssFrame.getMainMenuBar();
                spssFrame = null;
            } else {
                jMenuBar = spssFrame.getMainMenuBar();
            }
        } else {
            jMenuBar = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC).getMainMenuBar();
        }
        return jMenuBar;
    }

    private DefaultMutableTreeNode addMenu(DefaultMutableTreeNode defaultMutableTreeNode, JMenu jMenu) {
        String string;
        String string2 = string = jMenu.getAction() instanceof SpssAction ? ((SpssAction)jMenu.getAction()).getActionId() : null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = jMenu instanceof CFMenu ? this.createCFMenuNode((CFMenu)jMenu) : new DefaultMutableTreeNode(new MenuTreeItem(string != null ? string : jMenu.getText()));
        this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (component instanceof JMenu) {
                this.addMenu(defaultMutableTreeNode2, (JMenu)component);
                continue;
            }
            if (component instanceof JMenuItem) {
                this.addMenuItem(defaultMutableTreeNode2, (JMenuItem)component);
                continue;
            }
            if (!(component instanceof JPopupMenu.Separator)) continue;
            this.addSeparatorItem(defaultMutableTreeNode2, (JPopupMenu.Separator)component);
        }
        return defaultMutableTreeNode2;
    }

    private NewMenuDefaultMutableTreeNode createCFMenuNode(CFMenu cFMenu) {
        String string = cFMenu.getActionID();
        String string2 = cFMenu.getMenuName();
        String string3 = string != null ? string : this.makeActionID(string2);
        NewMenuDefaultMutableTreeNode newMenuDefaultMutableTreeNode = new NewMenuDefaultMutableTreeNode(new MenuTreeItem(string3, string2, false));
        return newMenuDefaultMutableTreeNode;
    }

    private void createLinkToSeparators(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        MenuTreeItem menuTreeItem = defaultMutableTreeNode2 != null ? (MenuTreeItem)defaultMutableTreeNode2.getUserObject() : null;
        boolean bl = menuTreeItem != null ? Boolean.valueOf(menuTreeItem.isExistingCFAction()) : null;
        String string = menuTreeItem != null && bl ? menuTreeItem.getActionID() : null;
        boolean bl2 = true;
        if (string != null) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                MenuTreeItem menuTreeItem2 = (MenuTreeItem)defaultMutableTreeNode3.getUserObject();
                if (defaultMutableTreeNode3 == defaultMutableTreeNode2) {
                    bl2 = false;
                }
                if (!menuTreeItem2.isCustomSeparator() || menuTreeItem2.getActionID() != string) continue;
                this.mNewMenuItemNode.addSeparatorLink(defaultMutableTreeNode3, bl2);
            }
        }
    }

    private void addMenuItem(DefaultMutableTreeNode defaultMutableTreeNode, JMenuItem jMenuItem) {
        String string;
        boolean bl = jMenuItem.getAction() instanceof CFCommandAction || jMenuItem.getAction() instanceof CustomCommandAction;
        boolean bl2 = jMenuItem.getAction() instanceof CFCommandAction;
        String string2 = string = jMenuItem.getAction() instanceof SpssAction ? ((SpssAction)jMenuItem.getAction()).getActionId() : null;
        MenuTreeItem menuTreeItem = bl ? new MenuTreeItem(string, jMenuItem.getText(), false) : new MenuTreeItem(string != null ? string : jMenuItem.getText());
        menuTreeItem.setIsExistingCF_OR_CustomAction(bl);
        menuTreeItem.setIsExistingCFAction(bl2);
        if (bl2) {
            menuTreeItem.setIsNative(((CFCommandAction)jMenuItem.getAction()).isNative());
        }
        boolean bl3 = bl2 && ((CFCommandAction)jMenuItem.getAction()).getActionId().equalsIgnoreCase(this.mMasterLocation.getCommandActionId());
        NewMenuItemDefaultMutableTreeNode newMenuItemDefaultMutableTreeNode = bl3 ? new NewMenuItemDefaultMutableTreeNode(menuTreeItem) : new NewMenuItemDefaultMutableTreeNode(menuTreeItem);
        this.mTreeModel.insertNodeInto(newMenuItemDefaultMutableTreeNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (bl3) {
            menuTreeItem.setIsNewCustomItem(true);
            this.mNewMenuItemNode = newMenuItemDefaultMutableTreeNode;
        }
    }

    private void addSeparatorItem(DefaultMutableTreeNode defaultMutableTreeNode, JPopupMenu.Separator separator) {
        Cloneable cloneable;
        MenuTreeItem menuTreeItem = new MenuTreeItem(SEPARATOR_ID);
        menuTreeItem.setIsCustomSeparator(separator instanceof CommandExecutor.SpssCustomSeparator);
        boolean bl = false;
        if (separator instanceof CommandExecutor.SpssCustomSeparator && ((CommandExecutor.SpssCustomSeparator)separator).getParentMenuItemContainer().getAction() instanceof CFCommandAction) {
            bl = ((CommandExecutor.SpssCustomSeparator)separator).getParentMenuItemContainer().getAction().getActionId().equalsIgnoreCase(this.mMasterLocation.getCommandActionId());
            cloneable = (CFCommandAction)((CommandExecutor.SpssCustomSeparator)separator).getParentMenuItemContainer().getAction();
            menuTreeItem.setId(((SpssAction)cloneable).getActionId());
        }
        if (!bl) {
            cloneable = new DefaultMutableTreeNode(menuTreeItem);
            this.mTreeModel.insertNodeInto((MutableTreeNode)((Object)cloneable), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
    }

    private void stateChanged() {
        this.setEnableStates();
    }

    private void setEnableStates() {
        boolean bl;
        if (this.mInMoveOperation || this.mInTextUpdateOperation) {
            return;
        }
        this.mTree.getSelectionModel().setSelectionMode(1);
        TreePath treePath = this.mTree.getSelectionPath();
        boolean bl2 = this.mTree.getSelectionPaths() != null && this.mTree.getSelectionPaths().length > 1;
        boolean bl3 = !bl2 && treePath != null && this.mNewMenuItemNode == null;
        boolean bl4 = this.isSelectedNodeNewMenuNode();
        this.mAddButton.setEnabled(bl3);
        boolean bl5 = treePath != null && this.mNewMenuItemNode != null && treePath.getLastPathComponent() == this.mNewMenuItemNode;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        defaultMutableTreeNode = this.isSelectedNodeNewMenuNode() ? this.mTopNewFolderNode : defaultMutableTreeNode;
        boolean bl6 = !bl2 && (bl5 || bl4);
        this.mDeleteButton.setEnabled(!bl2 && (bl5 || bl4));
        this.mEditButton.setEnabled(bl6);
        this.mSeparatorAboveCheckBox.setEnabled(bl6);
        this.mSeparatorBelowCheckBox.setEnabled(bl6);
        this.mMoveUnderNewMenuButton.setEnabled(!bl2 && this.getSelectedNode() != null && this.getMenuItem(this.getSelectedNode()).isNewCFMenu());
        this.mOkButton.setEnabled(this.mNewMenuItemNode != null);
        boolean bl7 = !bl2 && (bl5 || bl4);
        boolean bl8 = bl = !bl2 && (bl5 || bl4);
        if (this.mNewMenuItemNode != null) {
            bl7 = bl7 && this.getParentAfterMove(this.mNewMenuItemNode, true, null) != null;
            bl = bl && this.getParentAfterMove(this.mNewMenuItemNode, false, null) != null;
        }
        this.mMoveUpButton.setEnabled(bl7);
        this.mMoveDownButton.setEnabled(bl);
    }

    private void updateTreeItemText() {
        if (!this.mInTextUpdateOperation && this.mNewMenuItemNode != null) {
            String string = null;
            string = this.getTitleTextFromTreeNode() != null && this.getTitleTextFromTreeNode().length() > 0 ? (ComponentState.isDirOrFilePath((String)this.getTitleTextFromTreeNode()) || ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)this.getTitleTextFromTreeNode()) : this.getTitleTextFromTreeNode()) : this.getTitleTextFromTreeNode();
            MenuTreeItem menuTreeItem = this.mNewMenuItemNode.getMenuTreeItem();
            menuTreeItem.setName(string);
            this.mTreeModel.nodeChanged(this.mNewMenuItemNode);
        }
    }

    private String getTitleTextFromTreeNode() {
        return this.mNewMenuItemNode != null ? this.getMenuItem(this.mNewMenuItemNode).getName() : "";
    }

    protected DefaultMutableTreeNode getParentAfterMove(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, ISpssDataSrc.ReturnIndex returnIndex) {
        return this.getParentAfterMove(defaultMutableTreeNode, bl, returnIndex, false);
    }

    protected DefaultMutableTreeNode getParentAfterMove(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, ISpssDataSrc.ReturnIndex returnIndex, boolean bl2) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode4 == null) {
            assert (false);
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode5 = defaultMutableTreeNode2 = defaultMutableTreeNode4.getParent() != null ? (DefaultMutableTreeNode)defaultMutableTreeNode4.getParent() : null;
        if (returnIndex != null) {
            returnIndex.setIndex(-1);
        }
        int n = defaultMutableTreeNode4.getIndex(defaultMutableTreeNode);
        if (bl) {
            if (n > 0) {
                DefaultMutableTreeNode defaultMutableTreeNode6 = defaultMutableTreeNode.getPreviousSibling();
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode6.getUserObject();
                if (defaultMutableTreeNode6.isLeaf() && !menuTreeItem.isGlobalCustomMenuItem()) {
                    defaultMutableTreeNode3 = defaultMutableTreeNode4;
                    if (this.getMenuItem(defaultMutableTreeNode6).isExistingCustomOnlyAction()) {
                        defaultMutableTreeNode3 = this.getParentAfterMove(defaultMutableTreeNode6, bl, returnIndex, true);
                    } else if (returnIndex != null) {
                        returnIndex.setIndex(bl2 ? n : n - 1);
                    }
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode7 = defaultMutableTreeNode6.getLastLeaf();
                    defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode7.getParent();
                    if (defaultMutableTreeNode3 != null && returnIndex != null) {
                        returnIndex.setIndex(defaultMutableTreeNode3.getChildCount());
                    }
                }
            } else if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode3 = this.getPreviousParentAfterMove(defaultMutableTreeNode, returnIndex);
            }
        } else if (n < defaultMutableTreeNode4.getChildCount() - 1) {
            DefaultMutableTreeNode defaultMutableTreeNode8 = defaultMutableTreeNode.getNextSibling();
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode8.getUserObject();
            if (defaultMutableTreeNode8.isLeaf() && !menuTreeItem.isGlobalCustomMenuItem()) {
                defaultMutableTreeNode3 = defaultMutableTreeNode4;
                if (returnIndex != null) {
                    if (this.getMenuItem(defaultMutableTreeNode8).isExistingCustomOnlyAction()) {
                        defaultMutableTreeNode3 = this.getParentAfterMove(defaultMutableTreeNode8, bl, returnIndex, true);
                    } else if (returnIndex != null) {
                        returnIndex.setIndex(bl2 ? n : n + 1);
                    }
                }
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode9 = defaultMutableTreeNode8.getFirstLeaf();
                defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode9.getParent();
                if (defaultMutableTreeNode3 != null && returnIndex != null) {
                    returnIndex.setIndex(0);
                }
            }
        } else if (defaultMutableTreeNode2 != null) {
            defaultMutableTreeNode3 = this.getNextParentAfterMove(defaultMutableTreeNode, returnIndex);
        }
        return defaultMutableTreeNode3;
    }

    private int getIndexAfterExistingCustomOnlyAction(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode) + 1;
        int n2 = -1;
        for (int i = n; i < defaultMutableTreeNode3.getChildCount(); ++i) {
            if (this.getMenuItem((DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(i)).isExistingCustomOnlyAction()) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private int getIndexBeforeExistingCustomOnlyAction(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode) + 1;
        int n2 = 0;
        for (int i = defaultMutableTreeNode3.getChildCount() - 1; i >= 0; --i) {
            if (this.getMenuItem((DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(i)).isExistingCustomOnlyAction()) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private DefaultMutableTreeNode getNextParentAfterMove(DefaultMutableTreeNode defaultMutableTreeNode, ISpssDataSrc.ReturnIndex returnIndex) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3;
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode5 = defaultMutableTreeNode;
        for (defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent(); defaultMutableTreeNode3 != null && defaultMutableTreeNode3.getParent() != null && (n = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode5)) >= defaultMutableTreeNode3.getChildCount() - 1; defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent()) {
            defaultMutableTreeNode5 = defaultMutableTreeNode3;
        }
        if (defaultMutableTreeNode3 != null && (defaultMutableTreeNode2 = defaultMutableTreeNode5.getNextSibling()) != null) {
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode2.getUserObject();
            if (defaultMutableTreeNode2.isLeaf() && !menuTreeItem.isGlobalCustomMenuItem()) {
                defaultMutableTreeNode4 = defaultMutableTreeNode3;
                if (returnIndex != null) {
                    returnIndex.setIndex(n + 1);
                }
            } else {
                defaultMutableTreeNode4 = defaultMutableTreeNode2;
                if (returnIndex != null) {
                    returnIndex.setIndex(0);
                }
            }
        }
        return defaultMutableTreeNode4;
    }

    private DefaultMutableTreeNode getPreviousParentAfterMove(DefaultMutableTreeNode defaultMutableTreeNode, ISpssDataSrc.ReturnIndex returnIndex) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode;
        int n = 0;
        for (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent(); defaultMutableTreeNode2 != null && defaultMutableTreeNode2.getParent() != null && (n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode4)) <= 0 && defaultMutableTreeNode4 == defaultMutableTreeNode; defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) {
            defaultMutableTreeNode4 = defaultMutableTreeNode2;
        }
        if (defaultMutableTreeNode2 != null) {
            DefaultMutableTreeNode defaultMutableTreeNode5 = defaultMutableTreeNode4.getPreviousSibling();
            if (defaultMutableTreeNode5 != null) {
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode5.getUserObject();
                if (defaultMutableTreeNode5.isLeaf()) {
                    if (menuTreeItem.isGlobalCustomMenuItem()) {
                        defaultMutableTreeNode3 = defaultMutableTreeNode5;
                        if (returnIndex != null) {
                            returnIndex.setIndex(0);
                        }
                    } else {
                        defaultMutableTreeNode3 = defaultMutableTreeNode2;
                        if (returnIndex != null) {
                            returnIndex.setIndex(n);
                        }
                    }
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode6 = defaultMutableTreeNode5.getLastLeaf();
                    defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode6.getParent();
                    if (defaultMutableTreeNode3 != null && returnIndex != null) {
                        returnIndex.setIndex(defaultMutableTreeNode3.getChildCount());
                    }
                }
            } else if (defaultMutableTreeNode2.getParent() != null) {
                defaultMutableTreeNode3 = defaultMutableTreeNode2;
                if (returnIndex != null) {
                    returnIndex.setIndex(0);
                }
            }
        }
        return defaultMutableTreeNode3;
    }

    private void setDefaults(CommandLocation commandLocation) {
        this.setDefaultFrameCommandIndex();
        this.setDefaultSeparator(commandLocation);
        boolean bl = this.createNewMenuItemFromSavedCommandLocation(commandLocation);
        this.enableOK(bl);
        String string = commandLocation.getIconName();
        if (string != null && string.length() > 0) {
            if (ComponentState.isPathBidiProcessingNeeded((String)string)) {
                this.mIconPathEdit.setText(ComponentState.preparePathForBidiDisplay((String)string));
            } else {
                this.mIconPathEdit.setText(string);
            }
            if (!string.contains(File.separator)) {
                string = CommandExecutor.getUIExtensionsFolderPath() + File.separator + commandLocation.getCommandActionId() + File.separator + string;
            }
            this.mIconImage.setIcon(new ImageIcon(string));
        }
    }

    private boolean createNewMenuItemFromSavedCommandLocation(CommandLocation commandLocation) {
        boolean bl = false;
        String string = commandLocation.getCommandPath();
        if (string != null && string.length() > 0) {
            this.createMenuPathToNewMenuItemNode(string);
            DefaultMutableTreeNode defaultMutableTreeNode = this.commandPathToParentNode(string);
            if (defaultMutableTreeNode != null) {
                MenuTreeItem menuTreeItem = new MenuTreeItem(commandLocation.getCommandActionId(), commandLocation.getCommandTitle(), true);
                menuTreeItem.setIsNative(false);
                this.removeNewMenuItemNode(true);
                this.mNewMenuItemNode = new NewMenuItemDefaultMutableTreeNode(menuTreeItem);
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.findNodeById(defaultMutableTreeNode, commandLocation.getPreviousItemActionId());
                int n = defaultMutableTreeNode2 != null ? defaultMutableTreeNode.getIndex(defaultMutableTreeNode2) + 1 : commandLocation.getMenuItemOffset();
                int n2 = this.mTreeModel.getChildCount(defaultMutableTreeNode);
                if (n > n2 || n < 0) {
                    n = n2;
                }
                this.mTreeModel.insertNodeInto(this.mNewMenuItemNode, defaultMutableTreeNode, n);
                this.updateSeparatorSelection();
                TreePath treePath = new TreePath(this.mTreeModel.getPathToRoot(this.mNewMenuItemNode));
                this.mTree.scrollPathToVisible(treePath);
                int n3 = this.mTree.getRowForPath(treePath);
                if (n3 < 20) {
                    n3 = Math.max(n3 - 3, 0);
                    this.mTree.scrollRowToVisible(n3);
                }
                bl = true;
            } else {
                this.mNewMenuItemNode = null;
                this.mTopNewFolderNode = null;
            }
        }
        return bl;
    }

    private void setDefaultSeparator(CommandLocation commandLocation) {
        CommandLocation.CommandSeparator commandSeparator = commandLocation.getSeparator();
        this.mSeparatorAboveCheckBox.setSelected(commandSeparator == CommandLocation.CommandSeparator.above || commandSeparator == CommandLocation.CommandSeparator.both);
        this.mSeparatorBelowCheckBox.setSelected(commandSeparator == CommandLocation.CommandSeparator.below || commandSeparator == CommandLocation.CommandSeparator.both);
    }

    private void SetDefaultTitle(CommandLocation commandLocation) {
        if (commandLocation.getCommandTitle() != null && commandLocation.getCommandTitle().length() > 0) {
            if (ComponentState.isDirOrFilePath((String)commandLocation.getCommandTitle())) {
                if (ComponentState.isPathBidiProcessingNeeded((String)commandLocation.getCommandTitle())) {
                    this.mTitleField.setText(ComponentState.preparePathForBidiDisplay((String)commandLocation.getCommandTitle()));
                } else {
                    this.mTitleField.setText(commandLocation.getCommandTitle());
                }
            } else if (ComponentState.isBtdRtlOrLtr()) {
                this.mTitleField.setText(ComponentState.prepareStringForBidiRendering((String)commandLocation.getCommandTitle()));
            } else {
                this.mTitleField.setText(commandLocation.getCommandTitle());
            }
        } else {
            this.mTitleField.setText(commandLocation.getCommandTitle());
        }
    }

    private boolean saveSelectedInstallToFrameToCommandLocation() {
        boolean bl = false;
        CommandLocation.InstallToFrame installToFrame = CommandLocation.InstallToFrame.all;
        int n = this.mInstallToComboBox.getSelectedIndex();
        if (n == 1) {
            installToFrame = CommandLocation.InstallToFrame.data;
        }
        if (n == 2) {
            installToFrame = CommandLocation.InstallToFrame.syntax;
        }
        if (n == 3) {
            installToFrame = CommandLocation.InstallToFrame.ouput;
        }
        bl = this.mUserSelectionCommandLocation.getInstallToFrame() != installToFrame;
        this.mUserSelectionCommandLocation.setInstallToFrame(installToFrame);
        return bl;
    }

    private void setDefaultFrameCommandIndex() {
        int n = 0;
        if (this.mUserSelectionCommandLocation.getInstallToFrame() == CommandLocation.InstallToFrame.data) {
            n = 1;
        } else if (this.mUserSelectionCommandLocation.getInstallToFrame() == CommandLocation.InstallToFrame.syntax) {
            n = 2;
        } else if (this.mUserSelectionCommandLocation.getInstallToFrame() == CommandLocation.InstallToFrame.ouput) {
            n = 3;
        }
        this.mInstallToComboBox.setSelectedIndex(n);
    }

    private boolean saveSelectionsToCommandLocation() {
        Object object;
        Object object2;
        boolean bl = false;
        if (this.getTitleTextFromTreeNode() != null && this.getTitleTextFromTreeNode().length() > 0) {
            if (ComponentState.isDirOrFilePath((String)this.getTitleTextFromTreeNode())) {
                if (this.getTitleTextFromTreeNode().indexOf(8206) != -1) {
                    bl = !ComponentState.removeLRM((String)this.getTitleTextFromTreeNode()).equals(this.mUserSelectionCommandLocation.getCommandTitle());
                    this.mUserSelectionCommandLocation.setCommandTitle(ComponentState.removeLRM((String)this.getTitleTextFromTreeNode()));
                } else {
                    bl = !this.getTitleTextFromTreeNode().equals(this.mUserSelectionCommandLocation.getCommandTitle());
                    this.mUserSelectionCommandLocation.setCommandTitle(this.getTitleTextFromTreeNode());
                }
            } else if (ComponentState.isBtdRtlOrLtr()) {
                bl = !ComponentState.removeBidiDirectionMarks((String)this.getTitleTextFromTreeNode()).equals(this.mUserSelectionCommandLocation.getCommandTitle());
                this.mUserSelectionCommandLocation.setCommandTitle(ComponentState.removeBidiDirectionMarks((String)this.getTitleTextFromTreeNode()));
            } else {
                bl = !this.getTitleTextFromTreeNode().equals(this.mUserSelectionCommandLocation.getCommandTitle());
                this.mUserSelectionCommandLocation.setCommandTitle(this.getTitleTextFromTreeNode());
            }
        } else {
            bl = !this.getTitleTextFromTreeNode().equals(this.mUserSelectionCommandLocation.getCommandTitle());
            this.mUserSelectionCommandLocation.setCommandTitle(this.getTitleTextFromTreeNode());
        }
        CommandLocation.CommandSeparator commandSeparator = this.getSelectedCommandSeparator();
        bl |= commandSeparator != this.mUserSelectionCommandLocation.getSeparator();
        this.mUserSelectionCommandLocation.setSeparator(commandSeparator);
        int n = this.mUserSelectionCommandLocation.getMenuItemOffset();
        String string = "";
        String string2 = this.mUserSelectionCommandLocation.getCommandPath();
        if (this.mNewMenuItemNode != null) {
            object2 = new HashMap();
            TreeNode[] treeNodeArray = this.mNewMenuItemNode.getPath();
            for (int i = treeNodeArray.length - 1; i >= 0; --i) {
                object = (DefaultMutableTreeNode)treeNodeArray[i];
                if (object instanceof NewMenuItemDefaultMutableTreeNode) continue;
                if (!(object instanceof NewMenuDefaultMutableTreeNode)) break;
                MenuTreeItem menuTreeItem = (MenuTreeItem)((DefaultMutableTreeNode)object).getUserObject();
                ((HashMap)object2).put(this.makeActionID(menuTreeItem.getName()), menuTreeItem.getName());
            }
            this.mUserSelectionCommandLocation.setMenuActionIDToNameMap((HashMap)object2);
        }
        if (this.mNewMenuItemNode != null) {
            int n2;
            TreeNode[] treeNodeArray = this.mNewMenuItemNode.getPath();
            for (n2 = 1; n2 < treeNodeArray.length - 1; ++n2) {
                object2 = (DefaultMutableTreeNode)treeNodeArray[n2];
                if (string.length() > 0) {
                    string = string + ".";
                }
                object = (MenuTreeItem)((DefaultMutableTreeNode)object2).getUserObject();
                string = string + ((MenuTreeItem)object).getActionID();
            }
            this.mUserSelectionCommandLocation.setCommandPath(string);
            bl |= !string.equals(string2);
            n2 = this.getPrunedItemOffset(this.mTopNewFolderNode != null ? this.mTopNewFolderNode : this.mNewMenuItemNode);
            this.mUserSelectionCommandLocation.setMenuItemOffset(n2);
            bl |= n2 != n;
            String string3 = this.getPreviousActionID(this.mTopNewFolderNode != null ? this.mTopNewFolderNode : this.mNewMenuItemNode);
            this.mUserSelectionCommandLocation.setPreviousItemActionId(string3);
        } else {
            this.mUserSelectionCommandLocation.setCommandPath("");
            this.mUserSelectionCommandLocation.setMenuItemOffset(-1);
        }
        object2 = this.mUserSelectionCommandLocation.getIconName();
        object = null;
        object = this.mIconPathEdit.getText() != null && this.mIconPathEdit.getText().length() > 0 ? (ComponentState.isDirOrFilePath((String)this.mIconPathEdit.getText()) && this.mIconPathEdit.getText().indexOf(8206) != -1 ? ComponentState.removeLRM((String)this.mIconPathEdit.getText()) : (ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)this.mIconPathEdit.getText()) : this.mIconPathEdit.getText())) : this.mIconPathEdit.getText();
        this.mUserSelectionCommandLocation.setIconName((String)object);
        if (object2 != null) {
            bl |= !((String)object2).equals(object);
        }
        bl |= this.saveSelectedInstallToFrameToCommandLocation();
        if (this.mUserSelectionCommandLocation.getVersionNumber() == null || this.mUserSelectionCommandLocation.getVersionNumber() < 2) {
            this.mUserSelectionCommandLocation.setVersionNumber(Integer.valueOf(2));
        }
        boolean bl2 = this.isMemberOfGlobalCustomMenu(this.mTopNewFolderNode != null ? this.mTopNewFolderNode : this.mNewMenuItemNode);
        this.mUserSelectionCommandLocation.setInstallToGlobalCustomMenu(bl2);
        return bl;
    }

    private String makeActionID(String string) {
        return string.replaceAll("\\s", "") + "_id";
    }

    private CommandLocation.CommandSeparator getSelectedCommandSeparator() {
        CommandLocation.CommandSeparator commandSeparator = CommandLocation.CommandSeparator.none;
        if (this.mSeparatorAboveCheckBox.isSelected() && this.mSeparatorBelowCheckBox.isSelected()) {
            commandSeparator = CommandLocation.CommandSeparator.both;
        } else if (this.mSeparatorAboveCheckBox.isSelected()) {
            commandSeparator = CommandLocation.CommandSeparator.above;
        } else if (this.mSeparatorBelowCheckBox.isSelected()) {
            commandSeparator = CommandLocation.CommandSeparator.below;
        }
        return commandSeparator;
    }

    private String getPreviousActionID(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = this.getItemAbsoluteOffset(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        String string = null;
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode3.getUserObject();
                if (menuTreeItem == null || menuTreeItem.isCustomSeparator() || menuTreeItem.isSeparator()) continue;
                string = menuTreeItem.getActionID();
                break;
            }
        }
        return string;
    }

    private boolean isMemberOfGlobalCustomMenu(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        boolean bl = false;
        if (defaultMutableTreeNode != null && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) != null) {
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode2.getUserObject();
            bl = menuTreeItem.getActionID().equals("Custom");
        }
        return bl;
    }

    private int getPrunedItemOffset(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode = defaultMutableTreeNode.getParent();
        int n = -1;
        if (treeNode != null) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode2.getUserObject();
                if (menuTreeItem != null && !menuTreeItem.isCustomSeparator() && !menuTreeItem.isSeparator()) {
                    n = n == -1 ? 0 : ++n;
                }
                if (defaultMutableTreeNode2 == defaultMutableTreeNode) break;
            }
        }
        return n;
    }

    private int getItemAbsoluteOffset(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode = defaultMutableTreeNode.getParent();
        int n = -1;
        if (treeNode != null) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode2.getUserObject();
                if (menuTreeItem != null) {
                    n = n == -1 ? 0 : ++n;
                }
                if (defaultMutableTreeNode2 == defaultMutableTreeNode) break;
            }
        }
        return n;
    }

    private void createMenuPathToNewMenuItemNode(String string) {
        String[] stringArray = string.split("\\.");
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.findNodeById(defaultMutableTreeNode, string2);
            if (this.mTopNewFolderNode != null || defaultMutableTreeNode2 == null && this.mMasterLocation.getMenuActionIDToNameMap().get(string2) != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3;
                MenuTreeItem menuTreeItem = new MenuTreeItem(string2, (String)this.mMasterLocation.getMenuActionIDToNameMap().get(string2), true);
                NewMenuDefaultMutableTreeNode newMenuDefaultMutableTreeNode = new NewMenuDefaultMutableTreeNode(menuTreeItem);
                int n = this.mMasterLocation.getMenuItemOffset();
                if (this.mTopNewFolderNode == null && defaultMutableTreeNode != null && this.mMasterLocation.getPreviousItemActionId() != null && (defaultMutableTreeNode3 = this.findNodeById(defaultMutableTreeNode, this.mMasterLocation.getPreviousItemActionId())) != null) {
                    n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode3) + 1;
                }
                NewMenuDefaultMutableTreeNode newMenuDefaultMutableTreeNode2 = this.mTopNewFolderNode = this.mTopNewFolderNode == null ? newMenuDefaultMutableTreeNode : this.mTopNewFolderNode;
                if (defaultMutableTreeNode == null) continue;
                this.mTreeModel.insertNodeInto(newMenuDefaultMutableTreeNode, defaultMutableTreeNode, n);
                defaultMutableTreeNode = newMenuDefaultMutableTreeNode;
                continue;
            }
            if (defaultMutableTreeNode2 == null) continue;
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
    }

    private DefaultMutableTreeNode commandPathToParentNode(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        return this.findNodeById((DefaultMutableTreeNode)this.mTreeModel.getRoot(), string2);
    }

    private DefaultMutableTreeNode findNodeById(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode.getUserObject();
        if (menuTreeItem.getActionID().equals(string)) {
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        } else {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.findNodeById((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), string);
                if (defaultMutableTreeNode3 == null) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                break;
            }
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode findNodeByName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        MenuTreeItem menuTreeItem = this.getMenuItem(defaultMutableTreeNode);
        if (menuTreeItem.getName().equals(string)) {
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        } else {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.findNodeByName((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), string);
                if (defaultMutableTreeNode3 == null) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                break;
            }
        }
        return defaultMutableTreeNode2;
    }

    private boolean validateMenuPath() {
        boolean bl = true;
        if (this.mUserSelectionCommandLocation.getCommandTitle().indexOf(">") > 0) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String defaultExtensionDlgPath() {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            URL uRL = ResUtil.getImageResource(DEFAULT_CDB_ICON);
            if (uRL != null) {
                File file = new File(PrefsMgr.getPrefsMgr().getTempPath());
                if (!file.isDirectory()) {
                    file.mkdir();
                }
                File file2 = new File(file, DEFAULT_CDB_ICON);
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while (inputStream.read(byArray) != -1) {
                    fileOutputStream.write(byArray);
                }
                String string = file2.getAbsolutePath();
                return string;
            }
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private boolean validateImageFile() {
        String string = null;
        string = this.mIconPathEdit.getText() != null && this.mIconPathEdit.getText().length() > 0 ? (ComponentState.isDirOrFilePath((String)this.mIconPathEdit.getText()) && this.mIconPathEdit.getText().indexOf(8206) != -1 ? ComponentState.removeLRM((String)this.mIconPathEdit.getText()) : (ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)this.mIconPathEdit.getText()) : this.mIconPathEdit.getText())) : this.mIconPathEdit.getText();
        if (string != null && string.length() > 0) {
            File file;
            if (!string.contains(File.separator)) {
                string = SpecificationWriter.getDeploymentFolder() + File.separator + this.mUserSelectionCommandLocation.getCommandActionId() + File.separator + string;
            }
            if (!(file = new File(string)).exists()) {
                String string2 = BuilderResUtil.getString("IDS_MISSING_IMAGE_FILE");
                if (string2 == null) {
                    string2 = "Missing image file: %s";
                }
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), String.format(string2, string), VersionInfo.getAppVersionString());
                return false;
            }
            File file2 = BuilderFrame.getCanonicalFileIfNotCanonical(file);
            if (file2 != null) {
                if (file2.getPath() != null && file2.getPath().length() > 0 && ComponentState.isPathBidiProcessingNeeded((String)file2.getPath())) {
                    this.mIconPathEdit.setText(ComponentState.preparePathForBidiDisplay((String)file2.getPath()));
                } else {
                    this.mIconPathEdit.setText(file2.getPath());
                }
            }
        }
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.stateChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTreeItemText();
        this.stateChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTreeItemText();
        this.stateChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTreeItemText();
        this.stateChanged();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        Object object = this.mTree.getCellEditor().getCellEditorValue();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.mTree.getEditingPath() != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getEditingPath().getLastPathComponent();
        }
        if (defaultMutableTreeNode != null && (defaultMutableTreeNode == this.mNewMenuItemNode || defaultMutableTreeNode instanceof NewMenuDefaultMutableTreeNode)) {
            this.mInTextUpdateOperation = true;
            String string = this.doBidiProcessing(object.toString());
            this.getMenuItem(defaultMutableTreeNode).setName(string);
            this.mInTextUpdateOperation = false;
        }
    }

    private String doBidiProcessing(String string) {
        String string2 = null;
        string2 = string != null && string.length() > 0 ? (ComponentState.isDirOrFilePath((String)string.toString()) ? (string.toString().indexOf(8206) == -1 && ComponentState.isPathBidiProcessingNeeded((String)string.toString()) ? ComponentState.preparePathForBidiDisplay((String)string.toString()) : string.toString()) : (ComponentState.isBtdRtlOrLtr() ? ComponentState.prepareStringForBidiRendering((String)string.toString()) : string.toString())) : string.toString();
        return string2;
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    private void removeChildlessFolderNode() {
        if (this.mTopNewFolderNode != null && this.mTopNewFolderNode.getChildCount() == 0) {
            this.mTreeModel.removeNodeFromParent(this.mTopNewFolderNode);
            this.mTopNewFolderNode = null;
        }
    }

    private void removeNewItemSeparatorNodes() {
        if (this.mNewMenuItemNode != null) {
            ArrayList<DefaultMutableTreeNode> arrayList = this.mNewMenuItemNode.getSeparatorNodes();
            for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
                this.mTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            }
            this.mNewMenuItemNode.clearSeparatorNodes();
        }
    }

    private void updateSeparatorSelection() {
        this.mTree.cancelEditing();
        this.removeNewItemSeparatorNodes();
        this.addNewItemSeparatorNodes();
    }

    private void addNewItemSeparatorNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = this.mNewMenuItemNode != null ? (DefaultMutableTreeNode)this.mNewMenuItemNode.getParent() : null;
        if (defaultMutableTreeNode != null) {
            this.addNewItemSeparatorNodes(defaultMutableTreeNode);
        }
    }

    private void addNewItemSeparatorNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getIndex(this.mNewMenuItemNode);
        if (n >= 0) {
            this.addNewMenuSeparatorNodes(defaultMutableTreeNode);
        }
    }

    private void addNewMenuSeparatorNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getIndex(this.mNewMenuItemNode);
        if (this.mSeparatorAboveCheckBox.isSelected() || this.mSeparatorBelowCheckBox.isSelected()) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            CommandLocation.CommandSeparator commandSeparator = this.getSelectedCommandSeparator();
            if (this.mSeparatorBelowCheckBox.isSelected()) {
                defaultMutableTreeNode2 = this.createNewItemSeparatorNode();
                this.mNewMenuItemNode.addSeparatorLink(defaultMutableTreeNode2, true);
                this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n + 1);
            }
            if (this.mSeparatorAboveCheckBox.isSelected()) {
                defaultMutableTreeNode2 = this.createNewItemSeparatorNode();
                this.mNewMenuItemNode.addSeparatorLink(defaultMutableTreeNode2, false);
                this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
            }
        }
    }

    private DefaultMutableTreeNode createNewItemSeparatorNode() {
        MenuTreeItem menuTreeItem = new MenuTreeItem(SEPARATOR_ID);
        menuTreeItem.setIsCustomSeparator(true);
        menuTreeItem.setId(this.mNewMenuItemNode.getMenuTreeItem() != null && this.mNewMenuItemNode.getMenuTreeItem() instanceof MenuTreeItem ? this.mNewMenuItemNode.getMenuTreeItem().getActionID() : null);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(menuTreeItem);
        return defaultMutableTreeNode;
    }

    private MenuTreeItem getMenuItem(DefaultMutableTreeNode defaultMutableTreeNode) {
        return (MenuTreeItem)defaultMutableTreeNode.getUserObject();
    }

    private void removeNewMenuItemNode(boolean bl) {
        if (this.mNewMenuItemNode != null) {
            this.removeNewItemSeparatorNodes();
            this.mTreeModel.removeNodeFromParent(this.mNewMenuItemNode);
            if (bl) {
                this.mNewMenuItemNode = null;
            }
        }
    }

    private String generateNewMenuName(String string) {
        String string2 = string;
        int n = 0;
        if (this.mTopNewFolderNode != null) {
            String string3 = string2 = n > 0 ? string2 + "_" + n : string2;
            while (this.findNodeByName(this.mTopNewFolderNode, string2) != null) {
                string2 = string + "_" + ++n;
            }
        }
        return string2;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath treePath = this.mTree.getSelectionPath();
        return treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
    }

    private boolean isSelectedNodeNewMenuNode() {
        boolean bl = false;
        TreePath treePath = this.mTree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
            bl = defaultMutableTreeNode != null && defaultMutableTreeNode instanceof NewMenuDefaultMutableTreeNode && this.getMenuItem(defaultMutableTreeNode).isNewCFMenu();
        }
        return bl;
    }

    private void processMove(boolean bl) {
        this.mTree.cancelEditing();
        this.mInMoveOperation = true;
        TreePath treePath = this.mTree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getSelectedNode();
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2 = this.isSelectedNodeNewMenuNode() ? this.mTopNewFolderNode : defaultMutableTreeNode2;
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode2 == this.mNewMenuItemNode || defaultMutableTreeNode2 == this.mTopNewFolderNode)) {
                defaultMutableTreeNode2 = this.mTopNewFolderNode != null ? this.mTopNewFolderNode : this.mNewMenuItemNode;
                treePath = new TreePath(defaultMutableTreeNode2);
                this.removeNewItemSeparatorNodes();
                ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
                DefaultMutableTreeNode defaultMutableTreeNode4 = this.getParentAfterMove(defaultMutableTreeNode2, bl, returnIndex);
                if (defaultMutableTreeNode4 != null) {
                    this.mTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
                    this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode4, returnIndex.getIndex());
                    this.addNewMenuSeparatorNodes(defaultMutableTreeNode2 == this.mTopNewFolderNode ? this.mTopNewFolderNode : defaultMutableTreeNode4);
                    treePath = new TreePath(defaultMutableTreeNode2.getPath());
                    if (defaultMutableTreeNode2 == this.mTopNewFolderNode) {
                        for (int i = 0; i < this.mTopNewFolderNode.getChildCount(); ++i) {
                            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
                            this.getBranchNodes(this.mTopNewFolderNode, arrayList);
                            this.mTree.getSelectionModel().setSelectionMode(2);
                            this.expandToNewMenuItem();
                            if (arrayList.size() <= 0) continue;
                            TreeUtilities.setSelectedNodes((JTree)this.mTree, (Object[])arrayList.toArray(new DefaultMutableTreeNode[arrayList.size()]));
                        }
                    } else {
                        this.expandToNewMenuItem();
                        this.mTree.setSelectionPath(treePath);
                    }
                    this.mTree.scrollPathToVisible(treePath);
                }
                this.removeChildlessFolderNode();
            }
        }
        this.mInMoveOperation = false;
    }

    private void expandToNewMenuItem() {
        this.mTree.expandPath(new TreePath(((DefaultMutableTreeNode)this.mNewMenuItemNode.getParent()).getPath()));
    }

    private void getBranchNodes(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<DefaultMutableTreeNode> arrayList) {
        int n = defaultMutableTreeNode.getChildCount();
        arrayList.add(defaultMutableTreeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.getChildCount() > 0) {
                this.getBranchNodes(defaultMutableTreeNode2, arrayList);
                continue;
            }
            arrayList.add(defaultMutableTreeNode2);
        }
    }

    private JMenu findMenu(JComponent jComponent, String string) {
        if (string == null) {
            return null;
        }
        JMenu jMenu = null;
        Component[] componentArray = jComponent instanceof JMenu ? ((JMenu)jComponent).getMenuComponents() : jComponent.getComponents();
        for (Component component : componentArray) {
            String string2;
            if (!(component instanceof JMenu)) continue;
            JMenu jMenu2 = (JMenu)component;
            Action action = jMenu2.getAction();
            if (action instanceof DummyAction) {
                string2 = ((DummyAction)action).getActionId();
                if (string2 != null && string2.equalsIgnoreCase(string)) {
                    jMenu = jMenu2;
                }
            } else if (action instanceof UserMenuAction && (string2 = ((UserMenuAction)action).getActionId()) != null && string2.equalsIgnoreCase(string)) {
                jMenu = jMenu2;
            }
            if (jMenu == null) {
                jMenu = this.findMenu(jMenu2.getPopupMenu(), string);
            }
            if (jMenu != null) break;
        }
        return jMenu;
    }

    class NewMenuItemDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        DefaultMutableTreeNode mBeforeSeparator;
        DefaultMutableTreeNode mAfterSeparator;

        NewMenuItemDefaultMutableTreeNode(Object object) {
            super(object);
            this.mBeforeSeparator = null;
            this.mAfterSeparator = null;
        }

        public void addSeparatorLink(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
            if (bl) {
                this.mBeforeSeparator = defaultMutableTreeNode;
            } else {
                this.mAfterSeparator = defaultMutableTreeNode;
            }
        }

        public ArrayList<DefaultMutableTreeNode> getSeparatorNodes() {
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            if (this.mBeforeSeparator != null) {
                arrayList.add(this.mBeforeSeparator);
            }
            if (this.mAfterSeparator != null) {
                arrayList.add(this.mAfterSeparator);
            }
            return arrayList;
        }

        public boolean isLinkedSeperator(DefaultMutableTreeNode defaultMutableTreeNode) {
            boolean bl;
            boolean bl2 = this.mBeforeSeparator != null ? this.mBeforeSeparator == defaultMutableTreeNode : (bl = false);
            if (!bl) {
                bl = this.mAfterSeparator != null ? this.mAfterSeparator == defaultMutableTreeNode : false;
            }
            return bl;
        }

        public void clearSeparatorNodes() {
            this.mBeforeSeparator = null;
            this.mAfterSeparator = null;
        }

        public boolean isNative() {
            return this.getMenuTreeItem().isNative();
        }

        public MenuTreeItem getMenuTreeItem() {
            return (MenuTreeItem)this.getUserObject();
        }
    }

    class NewMenuDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        NewMenuDefaultMutableTreeNode(Object object) {
            super(object);
        }
    }

    class ImageFilesFilter
    extends FileFilter {
        ImageFilesFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".gif");
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_IMAGE_FILE_DESC");
        }
    }

    class MenuTree
    extends JTree {
        MenuTree(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public boolean isPathEditable(TreePath treePath) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode.getUserObject();
            return menuTreeItem.isNewCFMenu();
        }
    }

    class MenuTreeItem {
        private String mActionID;
        private String mName;
        private boolean mIsNewCustom;
        private boolean mIsExistingCF_OR_Custom;
        private boolean mIsExistingCFOnlyAction;
        private boolean mIsUDFMenu;
        private boolean mIsCustomSeparator;
        boolean mIsNative = false;

        MenuTreeItem(String string) {
            int n;
            this.mActionID = string;
            this.mIsUDFMenu = false;
            this.mIsNewCustom = false;
            this.mName = string.equals("separator") ? " ---" : (string.equals("root") ? string : ResUtil.getString(string));
            if (this.mName == null || this.mName.length() == 0) {
                this.mName = string;
            }
            if (this.mName.endsWith("...")) {
                this.mName = this.mName.substring(0, this.mName.length() - 3);
            }
            if ((n = this.mName.indexOf(";")) > -1) {
                int n2;
                this.mIsUDFMenu = this.mName.lastIndexOf(";") != n;
                this.mName = this.mName.substring(0, n);
                if (!this.mIsUDFMenu && (n2 = this.mName.lastIndexOf("-")) > -1) {
                    this.mName = this.mName.substring(0, n2);
                }
            }
        }

        MenuTreeItem(String string, String string2, boolean bl) {
            this.mActionID = string;
            this.mName = string2;
            this.mIsUDFMenu = false;
            this.mIsNewCustom = bl;
        }

        public String toString() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
            this.mActionID = MenuLocationDialogEx.this.makeActionID(this.mName);
        }

        public String getName() {
            return this.mName;
        }

        public String getActionID() {
            return this.mActionID;
        }

        public boolean isNewCFMenu() {
            return this.mIsNewCustom;
        }

        public void setIsNewCustomItem(boolean bl) {
            this.mIsNewCustom = bl;
        }

        public boolean isExistingCustomOnlyAction() {
            return this.mIsExistingCF_OR_Custom && !this.mIsExistingCFOnlyAction;
        }

        public boolean isExistingCF_OR_CustomAction() {
            return this.mIsExistingCF_OR_Custom;
        }

        public void setIsExistingCF_OR_CustomAction(boolean bl) {
            this.mIsExistingCF_OR_Custom = bl;
        }

        public boolean isExistingCFAction() {
            return this.mIsExistingCFOnlyAction;
        }

        public void setIsExistingCFAction(boolean bl) {
            this.mIsExistingCFOnlyAction = bl;
        }

        public boolean isGlobalCustomMenuItem() {
            return this.mIsUDFMenu;
        }

        public void setGlobalCustomMenuItem(boolean bl) {
            this.mIsUDFMenu = bl;
        }

        public boolean isSeparator() {
            return this.mName != null ? this.mName.equals(MenuLocationDialogEx.SEPARATOR_ID) : false;
        }

        public void setIsCustomSeparator(boolean bl) {
            this.mIsCustomSeparator = bl;
        }

        public boolean isCustomSeparator() {
            return this.mIsCustomSeparator;
        }

        public void setId(String string) {
            this.mActionID = string;
        }

        public boolean isNative() {
            return this.mIsNative;
        }

        public void setIsNative(boolean bl) {
            this.mIsNative = bl;
        }
    }

    class MenuTreeCellRenderer
    extends DefaultTreeCellRenderer {
        MenuTreeCellRenderer() {
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTreeCellRendererComponent(jTree, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, bl3, n, bl4);
            } else {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            if (object instanceof DefaultMutableTreeNode) {
                boolean bl5;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                String string = MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode).getName();
                boolean bl6 = MenuLocationDialogEx.this.mNewMenuItemNode != null && MenuLocationDialogEx.this.mNewMenuItemNode.isLinkedSeperator(defaultMutableTreeNode);
                boolean bl7 = MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode).isNewCFMenu() || bl6;
                boolean bl8 = MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode).isExistingCF_OR_CustomAction();
                boolean bl9 = MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode).isSeparator();
                boolean bl10 = MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode).isCustomSeparator();
                boolean bl11 = bl5 = bl8 && defaultMutableTreeNode instanceof NewMenuItemDefaultMutableTreeNode && !((NewMenuItemDefaultMutableTreeNode)defaultMutableTreeNode).isNative();
                string = bl9 ? (bl10 && !bl6 ? "*------------------------------" : "------------------------------") : (bl5 ? "*" + string : string);
                this.setText(string);
                this.setIcon(null);
                if (bl7) {
                    this.setIcon(MenuLocationDialogEx.this.mNewMenuItemIcon);
                }
                JList jList = new JList();
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            }
            return this;
        }
    }

    class MoveUnderNewMenuAction
    extends AbstractAction {
        MoveUnderNewMenuAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_MENU_LOCATION_MOVE_UNDER_NEW_MENU_BUTTON"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MENU_LOCATION_MOVE_UNDER_NEW_MENU_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialogEx.this.mTree.cancelEditing();
            TreePath treePath = MenuLocationDialogEx.this.mTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            String string = MenuLocationDialogEx.this.generateNewMenuName(BuilderResUtil.getString("IDS_MENU_LOCATION_NEW_MENU"));
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = MenuLocationDialogEx.this.getSelectedNode();
            MenuLocationDialogEx.this.removeNewItemSeparatorNodes();
            int n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
            MenuLocationDialogEx.this.mTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
            MenuTreeItem menuTreeItem = new MenuTreeItem(MenuLocationDialogEx.this.makeActionID(string), string, true);
            NewMenuDefaultMutableTreeNode newMenuDefaultMutableTreeNode = new NewMenuDefaultMutableTreeNode(menuTreeItem);
            newMenuDefaultMutableTreeNode.add(defaultMutableTreeNode2);
            MenuLocationDialogEx.this.addNewItemSeparatorNodes(newMenuDefaultMutableTreeNode);
            MenuLocationDialogEx.this.mTreeModel.insertNodeInto(newMenuDefaultMutableTreeNode, defaultMutableTreeNode, n);
            treePath = new TreePath(newMenuDefaultMutableTreeNode.getPath());
            if (MenuLocationDialogEx.this.mTopNewFolderNode == null || MenuLocationDialogEx.this.mTopNewFolderNode != null && MenuLocationDialogEx.this.mTopNewFolderNode == defaultMutableTreeNode2) {
                MenuLocationDialogEx.this.mTopNewFolderNode = newMenuDefaultMutableTreeNode;
            }
            MenuLocationDialogEx.this.mTree.setSelectionPath(treePath);
            MenuLocationDialogEx.this.expandToNewMenuItem();
            MenuLocationDialogEx.this.mTree.startEditingAtPath(new TreePath(newMenuDefaultMutableTreeNode.getPath()));
            MenuLocationDialogEx.this.stateChanged();
            MenuLocationDialogEx.this.enableOK(true);
        }

        private boolean branchContainsName(DefaultMutableTreeNode defaultMutableTreeNode, String string, int n) {
            string = n > 0 ? string + "_" + n : string;
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getLastLeaf();
            boolean bl = false;
            if (MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode).getName().equals(string)) {
                bl = true;
            } else {
                while (!bl && defaultMutableTreeNode2.getParent() != null && defaultMutableTreeNode2.getParent() != defaultMutableTreeNode) {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                    if (!MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode).getName().equals(string)) continue;
                    bl = true;
                }
            }
            return bl;
        }
    }

    class MoveDownAction
    extends AbstractAction {
        MoveDownAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_MOVE_DOWN"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MOVE_DOWN"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialogEx.this.processMove(false);
            MenuLocationDialogEx.this.setEnableStates();
        }
    }

    class MoveUpAction
    extends AbstractAction {
        MoveUpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_MOVE_UP"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MOVE_UP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialogEx.this.processMove(true);
            MenuLocationDialogEx.this.setEnableStates();
        }
    }

    class EditAction
    extends AbstractAction {
        EditAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_EDIT_MENU_ITEM"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_EDIT_MENU_ITEM"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MenuLocationDialogEx.this.getSelectedNode() != null) {
                MenuLocationDialogEx.this.mTree.startEditingAtPath(new TreePath(MenuLocationDialogEx.this.getSelectedNode().getPath()));
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_DELETE"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_DELETE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            TreePath treePath = MenuLocationDialogEx.this.mTree.getSelectionPath();
            boolean bl2 = MenuLocationDialogEx.this.mNewMenuItemNode != null && treePath.getLastPathComponent() == MenuLocationDialogEx.this.mNewMenuItemNode;
            boolean bl3 = MenuLocationDialogEx.this.isSelectedNodeNewMenuNode();
            boolean bl4 = bl = MenuLocationDialogEx.this.mTree.getSelectionPaths() != null && MenuLocationDialogEx.this.mTree.getSelectionPaths().length > 1;
            if (bl || bl2 && MenuLocationDialogEx.this.mTopNewFolderNode != null) {
                MenuLocationDialogEx.this.removeNewItemSeparatorNodes();
                MenuLocationDialogEx.this.mTreeModel.removeNodeFromParent(MenuLocationDialogEx.this.mTopNewFolderNode);
                MenuLocationDialogEx.this.mNewMenuItemNode = null;
                MenuLocationDialogEx.this.mTopNewFolderNode = null;
            } else if (bl2) {
                MenuLocationDialogEx.this.removeNewMenuItemNode(true);
            } else if (bl3) {
                DefaultMutableTreeNode defaultMutableTreeNode = MenuLocationDialogEx.this.getSelectedNode();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                if (MenuLocationDialogEx.this.getMenuItem(defaultMutableTreeNode3).isSeparator()) {
                    defaultMutableTreeNode3 = MenuLocationDialogEx.this.mNewMenuItemNode;
                    MenuLocationDialogEx.this.removeNewItemSeparatorNodes();
                }
                MenuLocationDialogEx.this.mTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                MenuLocationDialogEx.this.mTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
                MenuLocationDialogEx.this.expandToNewMenuItem();
                if (defaultMutableTreeNode == MenuLocationDialogEx.this.mTopNewFolderNode) {
                    if (defaultMutableTreeNode3 instanceof NewMenuDefaultMutableTreeNode) {
                        MenuLocationDialogEx.this.mTopNewFolderNode = (NewMenuDefaultMutableTreeNode)defaultMutableTreeNode3;
                    } else {
                        MenuLocationDialogEx.this.mTopNewFolderNode = null;
                    }
                }
                TreeUtilities.setSelectedNodes((JTree)MenuLocationDialogEx.this.mTree, (Object[])new DefaultMutableTreeNode[]{defaultMutableTreeNode3});
                if (defaultMutableTreeNode3 instanceof NewMenuItemDefaultMutableTreeNode) {
                    MenuLocationDialogEx.this.addNewItemSeparatorNodes();
                }
            }
            MenuLocationDialogEx.this.removeChildlessFolderNode();
            MenuLocationDialogEx.this.stateChanged();
            MenuLocationDialogEx.this.enableOK(false);
        }
    }

    class AddAction
    extends AbstractAction {
        AddAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_ADD"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_ADD"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = MenuLocationDialogEx.this.mTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            MenuLocationDialogEx.this.removeNewItemSeparatorNodes();
            String string = MenuLocationDialogEx.this.generateNewMenuName(BuilderResUtil.getString("IDS_MENU_LOCATION_NEW_MENU_ITEM"));
            String string2 = MenuLocationDialogEx.this.mUserSelectionCommandLocation.getCommandActionId();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode2.getUserObject();
            MenuTreeItem menuTreeItem2 = new MenuTreeItem(MenuLocationDialogEx.this.makeActionID(string), string, true);
            NewMenuItemDefaultMutableTreeNode newMenuItemDefaultMutableTreeNode = new NewMenuItemDefaultMutableTreeNode(menuTreeItem2);
            boolean bl = menuTreeItem.getActionID().equals("Custom");
            int n = -1;
            if (!bl && !menuTreeItem.isGlobalCustomMenuItem() && defaultMutableTreeNode2.isLeaf()) {
                n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
                MenuLocationDialogEx.this.mTreeModel.insertNodeInto(newMenuItemDefaultMutableTreeNode, defaultMutableTreeNode, n);
            } else {
                n = 0;
                MenuLocationDialogEx.this.mTreeModel.insertNodeInto(newMenuItemDefaultMutableTreeNode, defaultMutableTreeNode2, n);
            }
            MenuLocationDialogEx.this.mNewMenuItemNode = newMenuItemDefaultMutableTreeNode;
            if (n != -1) {
                MenuLocationDialogEx.this.addNewItemSeparatorNodes(defaultMutableTreeNode);
            }
            MenuLocationDialogEx.this.mTree.setSelectionPath(new TreePath(newMenuItemDefaultMutableTreeNode.getPath()));
            MenuLocationDialogEx.this.mTree.startEditingAtPath(new TreePath(MenuLocationDialogEx.this.mNewMenuItemNode.getPath()));
            MenuLocationDialogEx.this.stateChanged();
            MenuLocationDialogEx.this.enableOK(true);
        }

        private String getNewMenuName() {
            String string = null;
            string = MenuLocationDialogEx.this.getTitleTextFromTreeNode() != null && MenuLocationDialogEx.this.getTitleTextFromTreeNode().length() > 0 ? (ComponentState.isDirOrFilePath((String)MenuLocationDialogEx.this.getTitleTextFromTreeNode()) ? (MenuLocationDialogEx.this.getTitleTextFromTreeNode().indexOf(8206) != -1 ? ComponentState.removeLRM((String)MenuLocationDialogEx.this.getTitleTextFromTreeNode()) : MenuLocationDialogEx.this.getTitleTextFromTreeNode()) : (ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)MenuLocationDialogEx.this.getTitleTextFromTreeNode()) : MenuLocationDialogEx.this.getTitleTextFromTreeNode())) : MenuLocationDialogEx.this.getTitleTextFromTreeNode();
            return string;
        }
    }

    class SetSeparatorAction
    extends AbstractAction {
        SetSeparatorAction(boolean bl) {
            this.putValue("Name", bl ? BuilderResUtil.getString("IDS_DISPLAY_SEPARATOR_ABOVE") : BuilderResUtil.getString("IDS_DISPLAY_SEPARATOR_BELOW"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialogEx.this.updateSeparatorSelection();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialogEx.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialogEx.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MenuLocationDialogEx.this.validateImageFile()) {
                return;
            }
            sWasModified = MenuLocationDialogEx.this.saveSelectionsToCommandLocation();
            if (!MenuLocationDialogEx.this.validateMenuPath()) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)MenuLocationDialogEx.this), BuilderResUtil.getString("IDS_BAD_MENU_PATH"), VersionInfo.getAppVersionString());
                MenuLocationDialogEx.this.mTitleField.requestFocusInWindow();
                return;
            }
            MenuLocationDialogEx.this.mMasterLocation.copyFrom(MenuLocationDialogEx.this.mUserSelectionCommandLocation);
            MenuLocationDialogEx.this.dispose();
        }
    }
}

