/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.BuilderFrame;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MenuLocationDialog
extends BaseDialog
implements TreeSelectionListener,
DocumentListener,
CellEditorListener {
    private static final String DEFAULT_CDB_ICON = "defaultExtensionDialog.png";
    private static boolean sWasModified;
    private CommandLocation mCommandLocation = new CommandLocation();
    private CommandLocation mTargetLocation;
    private DefaultMutableTreeNode mTreeItem;
    private boolean mInMoveOperation;
    private boolean mInTextUpdateOperation;
    private MenuTree mTree;
    private DefaultTreeModel mTreeModel;
    private JButton mAddButton;
    private JButton mDeleteButton;
    private JButton mMoveUpButton;
    private JButton mMoveDownButton;
    private JTextField mTitleField;
    private JCheckBox mDividerCheck;
    private JComboBox mDividerCombo;
    private JLabel mIconImage;
    private JTextField mIconPathEdit;
    private JButton mOkButton;

    public static boolean runMenuLocationDialog(JFrame jFrame, CommandLocation commandLocation) {
        sWasModified = false;
        MenuLocationDialog menuLocationDialog = new MenuLocationDialog(jFrame, commandLocation);
        menuLocationDialog.setVisible(true);
        return sWasModified;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER_MENULOC");
    }

    protected MenuLocationDialog(JFrame jFrame, CommandLocation commandLocation) throws HeadlessException {
        super(jFrame, BuilderResUtil.getString("IDS_UIBUILDER_TITLE") + ": " + BuilderResUtil.getString("IDS_LOCATE_MENU_DLG_TITLE"), true, ResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), BuilderResBundle.getImageFolder());
        this.mCommandLocation.copyFrom(commandLocation);
        this.mTargetLocation = commandLocation;
        this.mTreeItem = null;
        this.mInMoveOperation = false;
        this.mInTextUpdateOperation = false;
        this.setup();
        this.loadMenuTree();
        this.dataToControls();
        this.stateChanged();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void enableOK(boolean bl) {
        this.mOkButton.setEnabled(bl);
    }

    private void setup() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JLabel jLabel = new JLabel(BuilderResUtil.getString("IDS_SPSS_MENUS"));
        jLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_SPSS_MENUS"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new MenuTreeItem("root"));
        this.mTreeModel = new DefaultTreeModel(defaultMutableTreeNode){

            @Override
            public void valueForPathChanged(TreePath treePath, Object object) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode.getUserObject();
                menuTreeItem.setName(object.toString());
                this.nodeChanged(defaultMutableTreeNode);
            }
        };
        this.mTree = new MenuTree(this.mTreeModel);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
        this.mTree.getSelectionModel().setSelectionMode(1);
        this.mTree.setCellRenderer(new MenuTreeCellRenderer());
        this.mTree.setEditable(true);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mTree);
        jScrollPane.setPreferredSize(new Dimension(280, 200));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
        jLabel.setLabelFor(this.mTree);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(6, 0, 6, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        JLabel jLabel2 = new JLabel(BuilderResUtil.getString("IDS_MENU_ITEM_TITLE"));
        jLabel2.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_MENU_ITEM_TITLE"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mTitleField = new JTextField();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mTitleField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mTitleField);
        this.mDividerCheck = new JCheckBox(new DividerCheckAction());
        this.mDividerCheck.setMnemonic(BuilderResUtil.getAccessKey("IDK_DISPLAY_DIVIDER"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDividerCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        String[] stringArray = new String[]{BuilderResUtil.getString("IDS_ABOVE"), BuilderResUtil.getString("IDS_BELOW"), BuilderResUtil.getString("IDS_BOTH")};
        this.mDividerCombo = new JComboBox<String>(stringArray);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDividerCombo, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.mDividerCombo.setEnabled(false);
        this.addImagePanel(jPanel);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mAddButton = new JButton(new AddAction());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel3, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        this.mMoveUpButton = new JButton(new MoveUpAction());
        DialogUtil.addUsingGBL(jPanel3, this.mMoveUpButton, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        this.mMoveDownButton = new JButton(new MoveDownAction());
        DialogUtil.addUsingGBL(jPanel3, this.mMoveDownButton, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        this.mDeleteButton = new JButton(new DeleteAction());
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDeleteButton, gridBagConstraints, 0, 3, 1, 1, 25, insets3);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel3);
        this.mTree.addTreeSelectionListener(this);
        this.mTitleField.getDocument().addDocumentListener(this);
        this.mTree.getCellEditor().addCellEditorListener(this);
    }

    private void addImagePanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, insets.left, 8, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 4, 1, 3, n, insets2);
        String string = this.defaultExtensionDlgPath();
        JLabel jLabel = new JLabel(BuilderResUtil.getString("IDS_IMAGE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mIconImage = new JLabel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mIconImage, gridBagConstraints, 0, 0, 1, 1, 20, insets);
        this.mIconPathEdit = new JTextField();
        Dimension dimension = this.mIconPathEdit.getPreferredSize();
        if (dimension.width < 60) {
            dimension.width = 60;
            this.mIconPathEdit.setPreferredSize(dimension);
        }
        if (string != null) {
            this.mIconPathEdit.setText(string);
            this.mIconImage.setIcon(new ImageIcon(string));
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mIconPathEdit, gridBagConstraints, 0, 1, 1, 1, n, insets);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuLocationDialog.this.doImageFileBrowse();
            }
        };
        abstractAction.putValue("Name", BuilderResUtil.getString("IDS_BROWSE_BUTTON_TEXT"));
        abstractAction.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_BROWSE_BUTTON_TEXT"));
        JButton jButton = new JButton(abstractAction);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private void doImageFileBrowse() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        ImageFilesFilter imageFilesFilter = new ImageFilesFilter();
        remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_OPEN_IMAGE_TITLE"));
        remoteFileChooser.addChoosableFileFilter(imageFilesFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter(imageFilesFilter);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            File file = remoteFileChooser.getSelectedFile();
            ImageIcon imageIcon = new ImageIcon(file.getPath());
            if (imageIcon.getIconWidth() > 16 || imageIcon.getIconHeight() > 16) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), BuilderResUtil.getString("IDS_ICON_TOO_LARGE"), VersionInfo.getAppVersionString());
                return;
            }
            if (ComponentState.isBtdRtlOrLtr() && file.getPath() != null && file.getPath().length() > 0 && file.getPath().indexOf(8206) == -1) {
                this.mIconPathEdit.setText(ComponentState.preparePathForBidiDisplay((String)file.getPath()));
            } else {
                this.mIconPathEdit.setText(file.getPath());
            }
            this.mIconImage.setIcon(imageIcon);
        }
    }

    private void loadMenuTree() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC);
        if (spssFrame == null) {
            return;
        }
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        MenuItemCache menuItemCache = spssFrame.getMenuTreeCache();
        for (int i = 0; i < menuItemCache.getItemCount(); ++i) {
            MenuItemCache menuItemCache2 = menuItemCache.getItem(i);
            if ("Add-ons".equals(menuItemCache2.getItemId())) continue;
            if ("Custom".equals(menuItemCache2.getItemId())) {
                bl = true;
            } else if (!bl && "Utilities".equals(menuItemCache2.getItemId())) {
                MenuTreeItem menuTreeItem = new MenuTreeItem("Custom");
                menuTreeItem.setIsUDFMenu(true);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(menuTreeItem);
                this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            this.addItem(defaultMutableTreeNode, menuItemCache2);
        }
        this.mTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    private void addItem(DefaultMutableTreeNode defaultMutableTreeNode, MenuItemCache menuItemCache) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new MenuTreeItem(menuItemCache.getItemId()));
        this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        for (int i = 0; i < menuItemCache.getItemCount(); ++i) {
            MenuItemCache menuItemCache2 = menuItemCache.getItem(i);
            this.addItem(defaultMutableTreeNode2, menuItemCache2);
        }
    }

    private void stateChanged() {
        boolean bl;
        if (this.mInMoveOperation || this.mInTextUpdateOperation) {
            return;
        }
        TreePath treePath = this.mTree.getSelectionPath();
        boolean bl2 = treePath != null && this.mTreeItem == null;
        boolean bl3 = this.mTitleField.getText().length() > 0;
        this.mAddButton.setEnabled(bl2 && bl3);
        if (treePath != null && this.mTreeItem != null && treePath.getLastPathComponent() == this.mTreeItem) {
            this.mDeleteButton.setEnabled(true);
        } else {
            this.mDeleteButton.setEnabled(false);
        }
        this.mOkButton.setEnabled(this.mTreeItem != null && bl3);
        boolean bl4 = this.mTreeItem != null;
        boolean bl5 = bl = this.mTreeItem != null;
        if (this.mTreeItem != null) {
            bl4 = this.getParentAfterMove(true, null) != null;
            bl = this.getParentAfterMove(false, null) != null;
        }
        this.mMoveUpButton.setEnabled(bl4);
        this.mMoveDownButton.setEnabled(bl);
    }

    private void updateTreeItemText() {
        if (!this.mInTextUpdateOperation && this.mTreeItem != null) {
            String string = null;
            string = this.mTitleField.getText() != null && this.mTitleField.getText().length() > 0 ? (ComponentState.isDirOrFilePath((String)this.mTitleField.getText()) || ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)this.mTitleField.getText()) : this.mTitleField.getText()) : this.mTitleField.getText();
            MenuTreeItem menuTreeItem = (MenuTreeItem)this.mTreeItem.getUserObject();
            menuTreeItem.setName(string);
            this.mTreeModel.nodeChanged(this.mTreeItem);
        }
    }

    protected DefaultMutableTreeNode getParentAfterMove(boolean bl, ISpssDataSrc.ReturnIndex returnIndex) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.mTreeItem.getParent();
        if (defaultMutableTreeNode3 == null) {
            assert (false);
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode = defaultMutableTreeNode3.getParent() != null ? (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent() : null;
        if (returnIndex != null) {
            returnIndex.setIndex(-1);
        }
        int n = defaultMutableTreeNode3.getIndex(this.mTreeItem);
        if (bl) {
            if (n > 0) {
                DefaultMutableTreeNode defaultMutableTreeNode5 = this.mTreeItem.getPreviousSibling();
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode5.getUserObject();
                if (defaultMutableTreeNode5.isLeaf() && !menuTreeItem.isUDFMenu()) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode3;
                    if (returnIndex != null) {
                        returnIndex.setIndex(n - 1);
                    }
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode6 = defaultMutableTreeNode5.getLastLeaf();
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode6.getParent();
                    if (defaultMutableTreeNode2 != null && returnIndex != null) {
                        returnIndex.setIndex(defaultMutableTreeNode2.getChildCount());
                    }
                }
            } else if (defaultMutableTreeNode != null) {
                defaultMutableTreeNode2 = this.getPreviousParentAfterMove(returnIndex);
            }
        } else if (n < defaultMutableTreeNode3.getChildCount() - 1) {
            DefaultMutableTreeNode defaultMutableTreeNode7 = this.mTreeItem.getNextSibling();
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode7.getUserObject();
            if (defaultMutableTreeNode7.isLeaf() && !menuTreeItem.isUDFMenu()) {
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                if (returnIndex != null) {
                    returnIndex.setIndex(n + 1);
                }
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode8 = defaultMutableTreeNode7.getFirstLeaf();
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode8.getParent();
                if (defaultMutableTreeNode2 != null && returnIndex != null) {
                    returnIndex.setIndex(0);
                }
            }
        } else if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode2 = this.getNextParentAfterMove(returnIndex);
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode getNextParentAfterMove(ISpssDataSrc.ReturnIndex returnIndex) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode4 = this.mTreeItem;
        for (defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.mTreeItem.getParent(); defaultMutableTreeNode2 != null && defaultMutableTreeNode2.getParent() != null && (n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode4)) >= defaultMutableTreeNode2.getChildCount() - 1; defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) {
            defaultMutableTreeNode4 = defaultMutableTreeNode2;
        }
        if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = defaultMutableTreeNode4.getNextSibling()) != null) {
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.isLeaf() && !menuTreeItem.isUDFMenu()) {
                defaultMutableTreeNode3 = defaultMutableTreeNode2;
                if (returnIndex != null) {
                    returnIndex.setIndex(n + 1);
                }
            } else {
                defaultMutableTreeNode3 = defaultMutableTreeNode;
                if (returnIndex != null) {
                    returnIndex.setIndex(0);
                }
            }
        }
        return defaultMutableTreeNode3;
    }

    private DefaultMutableTreeNode getPreviousParentAfterMove(ISpssDataSrc.ReturnIndex returnIndex) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.mTreeItem;
        int n = 0;
        for (defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeItem.getParent(); defaultMutableTreeNode != null && defaultMutableTreeNode.getParent() != null && (n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode3)) <= 0 && defaultMutableTreeNode3 == this.mTreeItem; defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) {
            defaultMutableTreeNode3 = defaultMutableTreeNode;
        }
        if (defaultMutableTreeNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode3.getPreviousSibling();
            if (defaultMutableTreeNode4 != null) {
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode4.getUserObject();
                if (defaultMutableTreeNode4.isLeaf()) {
                    if (menuTreeItem.isUDFMenu()) {
                        defaultMutableTreeNode2 = defaultMutableTreeNode4;
                        if (returnIndex != null) {
                            returnIndex.setIndex(0);
                        }
                    } else {
                        defaultMutableTreeNode2 = defaultMutableTreeNode;
                        if (returnIndex != null) {
                            returnIndex.setIndex(n);
                        }
                    }
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode5 = defaultMutableTreeNode4.getLastLeaf();
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode5.getParent();
                    if (defaultMutableTreeNode2 != null && returnIndex != null) {
                        returnIndex.setIndex(defaultMutableTreeNode2.getChildCount());
                    }
                }
            } else if (defaultMutableTreeNode.getParent() != null) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
                if (returnIndex != null) {
                    returnIndex.setIndex(0);
                }
            }
        }
        return defaultMutableTreeNode2;
    }

    private void dataToControls() {
        boolean bl;
        Object object;
        if (this.mCommandLocation.getCommandTitle() != null && this.mCommandLocation.getCommandTitle().length() > 0) {
            if (ComponentState.isDirOrFilePath((String)this.mCommandLocation.getCommandTitle())) {
                if (ComponentState.isPathBidiProcessingNeeded((String)this.mCommandLocation.getCommandTitle())) {
                    this.mTitleField.setText(ComponentState.preparePathForBidiDisplay((String)this.mCommandLocation.getCommandTitle()));
                } else {
                    this.mTitleField.setText(this.mCommandLocation.getCommandTitle());
                }
            } else if (ComponentState.isBtdRtlOrLtr()) {
                this.mTitleField.setText(ComponentState.prepareStringForBidiRendering((String)this.mCommandLocation.getCommandTitle()));
            } else {
                this.mTitleField.setText(this.mCommandLocation.getCommandTitle());
            }
        } else {
            this.mTitleField.setText(this.mCommandLocation.getCommandTitle());
        }
        CommandLocation.CommandSeparator commandSeparator = this.mCommandLocation.getSeparator();
        this.mDividerCheck.setSelected(commandSeparator != CommandLocation.CommandSeparator.none);
        this.mDividerCombo.setEnabled(this.mDividerCheck.isSelected());
        if (this.mDividerCheck.isSelected()) {
            int bl2 = commandSeparator == CommandLocation.CommandSeparator.below ? 1 : (commandSeparator == CommandLocation.CommandSeparator.both ? 2 : 0);
            this.mDividerCombo.setSelectedIndex(bl2);
        }
        boolean bl3 = false;
        String string = this.mCommandLocation.getCommandPath();
        if (string != null && string.length() > 0 && (object = this.commandPathToParentNode(string)) != null) {
            MenuTreeItem menuTreeItem = new MenuTreeItem(this.mCommandLocation.getCommandActionId(), this.mCommandLocation.getCommandTitle(), true);
            this.mTreeItem = new DefaultMutableTreeNode(menuTreeItem);
            this.mTreeModel.insertNodeInto(this.mTreeItem, (MutableTreeNode)object, this.mCommandLocation.getMenuItemOffset());
            TreePath treePath = new TreePath(this.mTreeModel.getPathToRoot(this.mTreeItem));
            this.mTree.scrollPathToVisible(treePath);
            int n = this.mTree.getRowForPath(treePath);
            if (n < 20) {
                n = Math.max(n - 3, 0);
                this.mTree.scrollRowToVisible(n);
            }
            bl = true;
        }
        this.enableOK(bl);
        object = this.mCommandLocation.getIconName();
        if (object != null && ((String)object).length() > 0) {
            if (ComponentState.isPathBidiProcessingNeeded((String)object)) {
                this.mIconPathEdit.setText(ComponentState.preparePathForBidiDisplay((String)object));
            } else {
                this.mIconPathEdit.setText((String)object);
            }
            if (!((String)object).contains(File.separator)) {
                object = CommandExecutor.getUIExtensionsFolderPath() + File.separator + this.mCommandLocation.getCommandActionId() + File.separator + (String)object;
            }
            this.mIconImage.setIcon(new ImageIcon((String)object));
        }
    }

    private boolean controlsToData() {
        Object object;
        Object object2;
        boolean bl = false;
        if (this.mTitleField.getText() != null && this.mTitleField.getText().length() > 0) {
            if (ComponentState.isDirOrFilePath((String)this.mTitleField.getText())) {
                if (this.mTitleField.getText().indexOf(8206) != -1) {
                    bl = !ComponentState.removeLRM((String)this.mTitleField.getText()).equals(this.mCommandLocation.getCommandTitle());
                    this.mCommandLocation.setCommandTitle(ComponentState.removeLRM((String)this.mTitleField.getText()));
                } else {
                    bl = !this.mTitleField.getText().equals(this.mCommandLocation.getCommandTitle());
                    this.mCommandLocation.setCommandTitle(this.mTitleField.getText());
                }
            } else if (ComponentState.isBtdRtlOrLtr()) {
                bl = !ComponentState.removeBidiDirectionMarks((String)this.mTitleField.getText()).equals(this.mCommandLocation.getCommandTitle());
                this.mCommandLocation.setCommandTitle(ComponentState.removeBidiDirectionMarks((String)this.mTitleField.getText()));
            } else {
                bl = !this.mTitleField.getText().equals(this.mCommandLocation.getCommandTitle());
                this.mCommandLocation.setCommandTitle(this.mTitleField.getText());
            }
        } else {
            bl = !this.mTitleField.getText().equals(this.mCommandLocation.getCommandTitle());
            this.mCommandLocation.setCommandTitle(this.mTitleField.getText());
        }
        int n = this.mDividerCombo.getSelectedIndex();
        CommandLocation.CommandSeparator commandSeparator = CommandLocation.CommandSeparator.none;
        if (this.mDividerCheck.isSelected()) {
            switch (n) {
                default: {
                    commandSeparator = CommandLocation.CommandSeparator.none;
                    break;
                }
                case 0: {
                    commandSeparator = CommandLocation.CommandSeparator.above;
                    break;
                }
                case 1: {
                    commandSeparator = CommandLocation.CommandSeparator.below;
                    break;
                }
                case 2: {
                    commandSeparator = CommandLocation.CommandSeparator.both;
                }
            }
        }
        bl |= commandSeparator != this.mCommandLocation.getSeparator();
        this.mCommandLocation.setSeparator(commandSeparator);
        int n2 = -1;
        int n3 = this.mCommandLocation.getMenuItemOffset();
        String string = "";
        String string2 = this.mCommandLocation.getCommandPath();
        if (this.mTreeItem != null) {
            TreeNode[] treeNodeArray = this.mTreeItem.getPath();
            for (int i = 1; i < treeNodeArray.length - 1; ++i) {
                object2 = (DefaultMutableTreeNode)treeNodeArray[i];
                object = (MenuTreeItem)((DefaultMutableTreeNode)object2).getUserObject();
                if (string.length() > 0) {
                    string = string + ".";
                }
                string = string + ((MenuTreeItem)object).getId();
            }
            this.mCommandLocation.setCommandPath(string);
            n2 = this.mTreeItem.getParent().getIndex(this.mTreeItem);
            if (n2 == 0) {
                this.mCommandLocation.setPreviousItemActionId("");
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeItem.getParent().getChildAt(n2 - 1);
                MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode.getUserObject();
                String string3 = menuTreeItem.getId();
                if (string3.equals("separator")) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.mTreeItem.getParent().getChildAt(n2 - 2);
                    MenuTreeItem menuTreeItem2 = (MenuTreeItem)defaultMutableTreeNode2.getUserObject();
                    string3 = menuTreeItem2.getId() + ".separator";
                }
                this.mCommandLocation.setPreviousItemActionId(string3);
            }
            this.mCommandLocation.setMenuItemOffset(n2);
        } else {
            this.mCommandLocation.setCommandPath("");
            this.mCommandLocation.setMenuItemOffset(-1);
        }
        bl |= !string.equals(string2);
        bl |= n2 != n3;
        object2 = this.mCommandLocation.getIconName();
        object = null;
        object = this.mIconPathEdit.getText() != null && this.mIconPathEdit.getText().length() > 0 ? (ComponentState.isDirOrFilePath((String)this.mIconPathEdit.getText()) && this.mIconPathEdit.getText().indexOf(8206) != -1 ? ComponentState.removeLRM((String)this.mIconPathEdit.getText()) : (ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)this.mIconPathEdit.getText()) : this.mIconPathEdit.getText())) : this.mIconPathEdit.getText();
        this.mCommandLocation.setIconName((String)object);
        if (object2 != null) {
            bl |= !((String)object2).equals(object);
        }
        return bl;
    }

    private DefaultMutableTreeNode commandPathToParentNode(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        return this.findNodeById((DefaultMutableTreeNode)this.mTreeModel.getRoot(), string2);
    }

    private DefaultMutableTreeNode findNodeById(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode.getUserObject();
        if (menuTreeItem.getId().equals(string)) {
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        } else {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.findNodeById((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), string);
                if (defaultMutableTreeNode3 == null) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                break;
            }
        }
        return defaultMutableTreeNode2;
    }

    private boolean validateMenuPath() {
        boolean bl = true;
        if (this.mCommandLocation.getCommandTitle().indexOf(">") > 0) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String defaultExtensionDlgPath() {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            URL uRL = ResUtil.getImageResource(DEFAULT_CDB_ICON);
            if (uRL != null) {
                File file = new File(PrefsMgr.getPrefsMgr().getTempPath());
                if (!file.isDirectory()) {
                    file.mkdir();
                }
                File file2 = new File(file, DEFAULT_CDB_ICON);
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while (inputStream.read(byArray) != -1) {
                    fileOutputStream.write(byArray);
                }
                String string = file2.getAbsolutePath();
                return string;
            }
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private boolean validateImageFile() {
        String string = null;
        string = this.mIconPathEdit.getText() != null && this.mIconPathEdit.getText().length() > 0 ? (ComponentState.isDirOrFilePath((String)this.mIconPathEdit.getText()) && this.mIconPathEdit.getText().indexOf(8206) != -1 ? ComponentState.removeLRM((String)this.mIconPathEdit.getText()) : (ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)this.mIconPathEdit.getText()) : this.mIconPathEdit.getText())) : this.mIconPathEdit.getText();
        if (string != null && string.length() > 0) {
            File file;
            if (!string.contains(File.separator)) {
                string = SpecificationWriter.getDeploymentFolder() + File.separator + this.mCommandLocation.getCommandActionId() + File.separator + string;
            }
            if (!(file = new File(string)).exists()) {
                String string2 = BuilderResUtil.getString("IDS_MISSING_IMAGE_FILE");
                if (string2 == null) {
                    string2 = "Missing image file: %s";
                }
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), String.format(string2, string), VersionInfo.getAppVersionString());
                return false;
            }
            File file2 = BuilderFrame.getCanonicalFileIfNotCanonical(file);
            if (file2 != null) {
                if (file2.getPath() != null && file2.getPath().length() > 0 && ComponentState.isPathBidiProcessingNeeded((String)file2.getPath())) {
                    this.mIconPathEdit.setText(ComponentState.preparePathForBidiDisplay((String)file2.getPath()));
                } else {
                    this.mIconPathEdit.setText(file2.getPath());
                }
            }
        }
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.stateChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTreeItemText();
        this.stateChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTreeItemText();
        this.stateChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTreeItemText();
        this.stateChanged();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        Object object = this.mTree.getCellEditor().getCellEditorValue();
        this.mInTextUpdateOperation = true;
        if (object.toString() != null && object.toString().length() > 0) {
            if (ComponentState.isDirOrFilePath((String)object.toString())) {
                if (object.toString().indexOf(8206) == -1 && ComponentState.isPathBidiProcessingNeeded((String)object.toString())) {
                    this.mTitleField.setText(ComponentState.preparePathForBidiDisplay((String)object.toString()));
                } else {
                    this.mTitleField.setText(object.toString());
                }
            } else if (ComponentState.isBtdRtlOrLtr()) {
                this.mTitleField.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else {
                this.mTitleField.setText(object.toString());
            }
        } else {
            this.mTitleField.setText(object.toString());
        }
        this.mInTextUpdateOperation = false;
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    class ImageFilesFilter
    extends FileFilter {
        ImageFilesFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".gif");
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_IMAGE_FILE_DESC");
        }
    }

    class MenuTree
    extends JTree {
        MenuTree(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public boolean isPathEditable(TreePath treePath) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            MenuTreeItem menuTreeItem = (MenuTreeItem)defaultMutableTreeNode.getUserObject();
            return menuTreeItem.isCustomItem();
        }
    }

    class MenuTreeItem {
        private String mId;
        private String mName;
        private boolean mIsCustom;
        private boolean mIsUDFMenu;

        MenuTreeItem(String string) {
            int n;
            this.mId = string;
            this.mIsUDFMenu = false;
            this.mIsCustom = false;
            this.mName = string.equals("separator") ? " ---" : (string.equals("root") ? string : ResUtil.getString(string));
            if (this.mName == null || this.mName.length() == 0) {
                this.mName = string;
            }
            if (this.mName.endsWith("...")) {
                this.mName = this.mName.substring(0, this.mName.length() - 3);
            }
            if ((n = this.mName.indexOf(";")) > -1) {
                int n2;
                this.mIsUDFMenu = this.mName.lastIndexOf(";") != n;
                this.mName = this.mName.substring(0, n);
                if (!this.mIsUDFMenu && (n2 = this.mName.lastIndexOf("-")) > -1) {
                    this.mName = this.mName.substring(0, n2);
                }
            }
        }

        MenuTreeItem(String string, String string2, boolean bl) {
            this.mId = string;
            this.mName = string2;
            this.mIsUDFMenu = false;
            this.mIsCustom = bl;
        }

        public String toString() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public String getId() {
            return this.mId;
        }

        public boolean isCustomItem() {
            return this.mIsCustom;
        }

        public void setIsCustomItem(boolean bl) {
            this.mIsCustom = bl;
        }

        public boolean isUDFMenu() {
            return this.mIsUDFMenu;
        }

        public void setIsUDFMenu(boolean bl) {
            this.mIsUDFMenu = bl;
        }
    }

    class MenuTreeCellRenderer
    extends DefaultTreeCellRenderer {
        MenuTreeCellRenderer() {
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTreeCellRendererComponent(jTree, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, bl3, n, bl4);
            } else {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                boolean bl5 = ((MenuTreeItem)defaultMutableTreeNode.getUserObject()).isCustomItem();
                this.setOpaque(bl5);
                if (bl5) {
                    this.setBackground(bl ? Color.orange : Color.yellow);
                }
            }
            return this;
        }
    }

    class MoveDownAction
    extends AbstractAction {
        MoveDownAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_MOVE_DOWN"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MOVE_DOWN"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MenuLocationDialog.this.mTreeItem == null) {
                return;
            }
            ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
            DefaultMutableTreeNode defaultMutableTreeNode = MenuLocationDialog.this.getParentAfterMove(false, returnIndex);
            if (defaultMutableTreeNode != null) {
                MenuLocationDialog.this.mInMoveOperation = true;
                MenuLocationDialog.this.mTreeModel.removeNodeFromParent(MenuLocationDialog.this.mTreeItem);
                MenuLocationDialog.this.mTreeModel.insertNodeInto(MenuLocationDialog.this.mTreeItem, defaultMutableTreeNode, returnIndex.getIndex());
                MenuLocationDialog.this.mInMoveOperation = false;
                TreePath treePath = new TreePath(MenuLocationDialog.this.mTreeModel.getPathToRoot(MenuLocationDialog.this.mTreeItem));
                MenuLocationDialog.this.mTree.setSelectionPath(treePath);
                MenuLocationDialog.this.mTree.scrollPathToVisible(treePath);
            }
        }
    }

    class MoveUpAction
    extends AbstractAction {
        MoveUpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_MOVE_UP"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MOVE_UP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MenuLocationDialog.this.mTreeItem == null) {
                return;
            }
            ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
            DefaultMutableTreeNode defaultMutableTreeNode = MenuLocationDialog.this.getParentAfterMove(true, returnIndex);
            if (defaultMutableTreeNode != null) {
                MenuLocationDialog.this.mInMoveOperation = true;
                MenuLocationDialog.this.mTreeModel.removeNodeFromParent(MenuLocationDialog.this.mTreeItem);
                MenuLocationDialog.this.mTreeModel.insertNodeInto(MenuLocationDialog.this.mTreeItem, defaultMutableTreeNode, returnIndex.getIndex());
                MenuLocationDialog.this.mInMoveOperation = false;
                TreePath treePath = new TreePath(MenuLocationDialog.this.mTreeModel.getPathToRoot(MenuLocationDialog.this.mTreeItem));
                MenuLocationDialog.this.mTree.setSelectionPath(treePath);
                MenuLocationDialog.this.mTree.scrollPathToVisible(treePath);
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_DELETE"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_DELETE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = MenuLocationDialog.this.mTreeItem;
            MenuLocationDialog.this.mTreeItem = null;
            MenuLocationDialog.this.mTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            MenuLocationDialog.this.stateChanged();
            MenuLocationDialog.this.enableOK(false);
        }
    }

    class AddAction
    extends AbstractAction {
        AddAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_ADD"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_ADD"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = MenuLocationDialog.this.mTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            String string = null;
            string = MenuLocationDialog.this.mTitleField.getText() != null && MenuLocationDialog.this.mTitleField.getText().length() > 0 ? (ComponentState.isDirOrFilePath((String)MenuLocationDialog.this.mTitleField.getText()) ? (MenuLocationDialog.this.mTitleField.getText().indexOf(8206) != -1 ? ComponentState.removeLRM((String)MenuLocationDialog.this.mTitleField.getText()) : MenuLocationDialog.this.mTitleField.getText()) : (ComponentState.isBtdRtlOrLtr() ? ComponentState.removeBidiDirectionMarks((String)MenuLocationDialog.this.mTitleField.getText()) : MenuLocationDialog.this.mTitleField.getText())) : MenuLocationDialog.this.mTitleField.getText();
            String string2 = MenuLocationDialog.this.mCommandLocation.getCommandActionId();
            MenuTreeItem menuTreeItem = new MenuTreeItem(string2, string, true);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(menuTreeItem);
            MenuTreeItem menuTreeItem2 = (MenuTreeItem)defaultMutableTreeNode2.getUserObject();
            boolean bl = menuTreeItem2.getId().equals("Custom");
            if (!bl && !menuTreeItem2.isUDFMenu() && defaultMutableTreeNode2.isLeaf()) {
                int n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
                MenuLocationDialog.this.mTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, n);
            } else {
                MenuLocationDialog.this.mTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, 0);
            }
            MenuLocationDialog.this.mTree.setSelectionPath(new TreePath(defaultMutableTreeNode3.getPath()));
            MenuLocationDialog.this.mTreeItem = defaultMutableTreeNode3;
            MenuLocationDialog.this.stateChanged();
            MenuLocationDialog.this.enableOK(true);
        }
    }

    class DividerCheckAction
    extends AbstractAction {
        DividerCheckAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_DISPLAY_DIVIDER"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialog.this.mDividerCombo.setEnabled(MenuLocationDialog.this.mDividerCheck.isSelected());
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialog.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuLocationDialog.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MenuLocationDialog.this.validateImageFile()) {
                return;
            }
            sWasModified = MenuLocationDialog.this.controlsToData();
            if (!MenuLocationDialog.this.validateMenuPath()) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)MenuLocationDialog.this), BuilderResUtil.getString("IDS_BAD_MENU_PATH"), VersionInfo.getAppVersionString());
                MenuLocationDialog.this.mTitleField.requestFocusInWindow();
                return;
            }
            MenuLocationDialog.this.mTargetLocation.copyFrom(MenuLocationDialog.this.mCommandLocation);
            MenuLocationDialog.this.dispose();
        }
    }
}

