/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.command.CustomCommandAction;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.dialogs.base.custom_gui.DialogExecutor;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.MenuLocationDialog;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.OpenDeployedDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.RemoveDeployedQueryDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.SyntaxDiagramDlg;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.props_ui.PropertiesPanel;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools.ToolItem;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools.ToolPalette;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.tools.ToolType;
import com.spss.java_client.ui.dialogs.base.utilities.MissingAddOnsDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.MinimizeWindowsAction;
import com.spss.java_client.ui.doc_types.actions.WindowMenuAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.doc_util.ThinMenuBarBorder;
import com.spss.java_client.ui.doc_types.syntax.SyntaxPrefManager;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.SrcListDefinition;
import com.spss.uitools.ui_builder.definition.StaticCtrlDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.util.StreamCopier;
import com.spss.uitools.util.TraceSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class BuilderFrame
extends JFrame
implements MenuListener {
    private static final String UIPKG_EXTENSION = "spd";
    private static final String UIPKG_FILE_EXT = ".spd";
    private static final String XML_FILE_EXT = ".xml";
    private static int sMainSplitPosition = 350;
    private static int sSubSplitPosition = 300;
    private static Rectangle sLastBounds = null;
    private String mOpenSpecName = "";
    private File mSPDPath = null;
    private DragPane mDragPane;
    private ToolPalette mToolPalette;
    private JToolBar mToolbar;
    private JPanel mTBPanelNorth;
    private BuilderCanvas mCanvas;
    private PropertiesPanel mPropsPanel;
    private SaveAction mSaveAction;
    private JMenuItem mMenuSaveItem;
    private boolean mIsModified = false;
    private JCheckBoxMenuItem mViewToolboxMenuItem;
    private JCheckBoxMenuItem mViewToolbarMenuItem;
    private JSplitPane mSplitPane;
    private Vector<MRUSpec> mMRUSpecs = new Vector();

    public BuilderFrame() throws HeadlessException {
        this((DialogDefinition)null);
    }

    public BuilderFrame(DialogDefinition dialogDefinition) throws HeadlessException {
        this.updateTitle(dialogDefinition);
        this.setIconImage(new ImageIcon(BuilderResUtil.getImageResource("uibuilder16.png")).getImage());
        this.setup(dialogDefinition);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.updateToolbarButtons();
        if (dialogDefinition == null) {
            this.setLocationRelativeTo(null);
            if (sLastBounds != null) {
                this.setBounds(sLastBounds);
            }
            this.mToolPalette.reposition(this);
        }
        if (dialogDefinition != null && dialogDefinition.isSubDialog()) {
            this.mToolPalette.enableButton(ToolType.SOURCE_VAR_LIST, false);
            this.mToolPalette.enableButton(ToolType.TARGET_VAR_LIST, false);
            this.mToolPalette.enableButton(ToolType.SUB_DIALOG_BUTTON, false);
        }
        if (dialogDefinition == null) {
            this.setVisible(true);
            this.mToolPalette.setVisible(true);
            this.focusToolPalette();
        }
        this.addWindowListener();
    }

    public void showEditor(Component component) {
        this.setLocationRelativeTo(component);
        this.mToolPalette.reposition(this);
        this.setVisible(true);
        this.mToolPalette.setVisible(true);
        this.focusToolPalette();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BuilderFrame();
            }
        });
    }

    public static String getBuilderPkgExtension() {
        return UIPKG_EXTENSION;
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public void setModified(boolean bl) {
        this.mIsModified = bl;
        this.updateToolbarButtons();
        this.updateTitle(this.mCanvas.getDialogDefinition());
    }

    public boolean saveModified() {
        if (this.isModified()) {
            String string;
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            String string2 = this.mCanvas.getDialogDefinition().getDialogId();
            String string3 = String.format(BuilderResUtil.getString("UI_BUILDER_SAVE_QUERY"), string2);
            int n = SpssAlertOptionPane.showConfirmDialog(this, string3, string = VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION);
            if (n == 3 || n == -1) {
                return false;
            }
            if (n == 1) {
                try {
                    if (this.mSPDPath != null) {
                        new SaveAction(false).actionPerformed(null);
                    } else {
                        new SaveAsAction(false).actionPerformed(null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    public void openSPDFile(File file) throws Exception {
        this.readPackageFile(file);
        this.addMRUItem(file.getName(), file.getPath(), false);
        this.setModified(false);
    }

    public void editDialogDefinition(DialogDefinition dialogDefinition) {
        this.mPropsPanel.setDlgDef(dialogDefinition);
        this.mCanvas.setDialogDefinition(dialogDefinition);
        new LayoutAction(true).actionPerformed(null);
        this.updateTitle(dialogDefinition);
    }

    public void runMenuLocationDialog(DialogDefinition dialogDefinition) {
        if (MenuLocationDialog.runMenuLocationDialog(this, dialogDefinition.getCommandLocation())) {
            this.mCanvas.fireSelectionChange(this.mPropsPanel.getSelectedObject());
            this.setModified(true);
        }
    }

    public void editSyntaxTemplate() {
        new SyntaxDiagramAction(false).actionPerformed(null);
    }

    public DragPane getDragPane() {
        return this.mDragPane;
    }

    public BuilderCanvas getCanvas() {
        return this.mCanvas;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mToolPalette.setVisible(bl);
    }

    public void focusPropertiesPanel() {
        this.mPropsPanel.focusTable();
    }

    public void focusToolPalette() {
        ToolItem toolItem = this.mToolPalette.getSelectedTool();
        if (toolItem != null) {
            toolItem.requestFocus();
        } else {
            this.mToolPalette.selectTool(this.mToolPalette.getToolItem(ToolType.SOURCE_VAR_LIST));
        }
    }

    public void launchControlEditor(PanelElementDefinition panelElementDefinition) {
        this.mPropsPanel.launchControlEditor(panelElementDefinition);
    }

    public static void updateFrames(DialogDefinition dialogDefinition, String string) {
        Object object;
        Object object2;
        CommandLocation commandLocation = dialogDefinition.getCommandLocation();
        String string2 = dialogDefinition.getDialogId();
        File file = new File(string);
        CustomCommandAction customCommandAction = new CustomCommandAction(string2, file);
        customCommandAction.setName(commandLocation.getCommandTitle());
        String string3 = commandLocation.getIconName();
        if (string3 != null && string3.length() > 0) {
            try {
                object2 = new File(string3);
                object = ((File)object2).getName();
                String object3 = file.getParent() + File.separator + (String)object;
                ImageIcon imageIcon = new ImageIcon(object3);
                customCommandAction.setIcon(imageIcon);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        CommandExecutor.get().replaceCommand(customCommandAction, commandLocation);
        object2 = BuilderFrame.getMenuItemContainer(string2);
        if (object2 == null) {
            object2 = new CommandExecutor.MenuItemContainer(customCommandAction, commandLocation);
        }
        BuilderFrame.removeFromFrames(string2, string);
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            object = spssFrame.getJMenuBar();
            CommandExecutor.get().addMenuItem((JMenuBar)object, (CommandExecutor.MenuItemContainer)object2, spssFrame);
        }
        ActionCatalog.getActionCatalog().registerAction(customCommandAction);
    }

    private static CommandExecutor.MenuItemContainer getMenuItemContainer(String string) {
        CommandExecutor.MenuItemContainer menuItemContainer = null;
        Vector<CommandExecutor.MenuItemContainer> vector = CommandExecutor.get().getCustomMenuItems();
        for (CommandExecutor.MenuItemContainer menuItemContainer2 : vector) {
            if (!menuItemContainer2.getAction().getActionId().equals(string)) continue;
            menuItemContainer = menuItemContainer2;
            break;
        }
        return menuItemContainer;
    }

    private static void removeFromFrames(String string, String string2) {
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            JMenuBar jMenuBar = spssFrame.getJMenuBar();
            for (int i = 0; i < jMenuBar.getMenuCount() && !BuilderFrame.removeCommand(jMenuBar.getMenu(i), string, string2); ++i) {
            }
        }
    }

    private static boolean removeCommand(JMenu jMenu, String string, String string2) {
        for (Component component : jMenu.getMenuComponents()) {
            CustomCommandAction customCommandAction;
            JMenuItem jMenuItem;
            if (component instanceof JMenu) {
                if (!BuilderFrame.removeCommand((JMenu)component, string, string2)) continue;
                return true;
            }
            if (!(component instanceof JMenuItem) || !((jMenuItem = (JMenuItem)component).getAction() instanceof CustomCommandAction) || !(customCommandAction = (CustomCommandAction)jMenuItem.getAction()).getActionId().equals(string) && !customCommandAction.getClefFileName().equalsIgnoreCase(string2)) continue;
            jMenu.remove(jMenuItem);
            return true;
        }
        return false;
    }

    private void setup(DialogDefinition dialogDefinition) {
        this.createMainPanel();
        this.mDragPane = new DragPane();
        this.setGlassPane((Component)this.mDragPane);
        boolean bl = dialogDefinition != null && dialogDefinition.isSubDialog();
        this.mCanvas = new BuilderCanvas(this, dialogDefinition);
        if (dialogDefinition == null) {
            dialogDefinition = this.mCanvas.getDialogDefinition();
        }
        this.mCanvas.setFont(new Font("SansSerif", 0, 12));
        this.mPropsPanel = new PropertiesPanel(dialogDefinition);
        this.mCanvas.addSelectionListener(this.mPropsPanel);
        if (!bl) {
            this.loadMRUMenuItems();
        }
        this.createMenubar(dialogDefinition);
        this.createToolbar(dialogDefinition);
        this.mSplitPane = new JSplitPane(0, new JScrollPane(this.mCanvas), this.mPropsPanel);
        this.mSplitPane.setOneTouchExpandable(true);
        this.mSplitPane.setResizeWeight(0.667);
        this.mSplitPane.setDividerLocation(!bl ? sMainSplitPosition : sSubSplitPosition);
        if (!bl) {
            this.mSplitPane.setPreferredSize(new Dimension(600, 500));
        } else {
            this.mSplitPane.setPreferredSize(new Dimension(500, 400));
        }
        this.getContentPane().add(this.mSplitPane);
        this.mToolPalette = new ToolPalette(this);
    }

    private void createMenubar(DialogDefinition dialogDefinition) {
        Cloneable cloneable;
        boolean bl = dialogDefinition != null && dialogDefinition.isSubDialog();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ResUtil.getString("File"));
        jMenu.setMnemonic(ResUtil.getAccessKey("File"));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(ResUtil.getString("Edit"));
        jMenu2.setMnemonic(ResUtil.getAccessKey("Edit"));
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(ResUtil.getString("View"));
        jMenu3.setMnemonic(ResUtil.getAccessKey("View"));
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = null;
        JMenu jMenu5 = null;
        if (!bl) {
            jMenu4 = new JMenu(ResUtil.getString("Window"));
            jMenu4.setMnemonic(ResUtil.getAccessKey("Window"));
            jMenuBar.add(jMenu4);
            jMenu5 = new JMenu(BuilderResUtil.getString("IDS_RECENTLY_USED"));
            jMenu5.setMnemonic(BuilderResUtil.getAccessKey("IDK_RECENTLY_USED"));
        }
        JMenu jMenu6 = new JMenu(ResUtil.getString("Help"));
        jMenu6.setMnemonic(ResUtil.getAccessKey("Help"));
        jMenuBar.add(jMenu6);
        if (!bl) {
            jMenu.add(new OpenAction(false));
            this.mMenuSaveItem = new JMenuItem(new SaveAction(false));
            jMenu.add(this.mMenuSaveItem);
            cloneable = new SaveAsAction(false);
            jMenu.add((Action)((Object)cloneable));
            jMenu.addSeparator();
            jMenu.add(new ReadDeployedAction(false));
            jMenu.add(new DeployAction(false));
            jMenu.addSeparator();
            jMenu.add(new UndeployAction(false));
            jMenu.addSeparator();
            jMenu.add(new TestDlgAction(false));
            jMenu.addSeparator();
            jMenu.add(jMenu5);
            jMenu.addSeparator();
        }
        jMenu.add(new CloseAction(false));
        jMenu2.add(new SyntaxDiagramAction(false));
        if (!bl) {
            jMenu2.add(new MenuLocationAction(false));
        }
        jMenu2.addSeparator();
        jMenu2.add(new ResetAction(false));
        this.mViewToolboxMenuItem = new JCheckBoxMenuItem(new ViewToolboxAction(false));
        jMenu3.add(this.mViewToolboxMenuItem);
        this.mViewToolbarMenuItem = new JCheckBoxMenuItem(new ViewToolbarAction(false));
        jMenu3.add(this.mViewToolbarMenuItem);
        if (!bl) {
            jMenu4.add(new MinimizeWindowsAction());
            jMenu4.addSeparator();
            SpssFrameMgr.getSpssFrameMgr().addDocumentMenuItems(jMenu4);
        }
        this.buildHelpMenu(jMenu6);
        this.setJMenuBar(jMenuBar);
        cloneable = UIManager.getLookAndFeelDefaults();
        ThinMenuBarBorder thinMenuBarBorder = new ThinMenuBarBorder(((UIDefaults)cloneable).getColor("MenuBar.shadow"));
        jMenuBar.setBorder(thinMenuBarBorder);
        jMenu.addMenuListener(this);
        jMenu2.addMenuListener(this);
        jMenu3.addMenuListener(this);
        if (!bl) {
            jMenu5.addMenuListener(this);
            jMenu4.addMenuListener(this);
        }
    }

    private void buildHelpMenu(JMenu jMenu) {
        jMenu.add(new JMenuItem(new HelpAction(false)));
    }

    private void loadMRUMenuItems() {
        this.mMRUSpecs.clear();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types").node("ui_builder").node("mru");
        for (int i = 0; i < this.getMaxMRUItems(); ++i) {
            boolean bl;
            String string = preferences2.get("mru_" + (i + 1), "");
            if (string.length() <= 1) continue;
            int n = string.lastIndexOf("+");
            if (n > -1) {
                bl = true;
                string = string.substring(0, n);
            } else {
                n = string.lastIndexOf("-");
                if (n <= -1) continue;
                bl = false;
                string = string.substring(0, n);
            }
            n = string.lastIndexOf(File.separator);
            String string2 = n > -1 ? string.substring(n + 1) : string;
            this.mMRUSpecs.add(new MRUSpec(string2, string, bl));
        }
    }

    private void updateMRUMenuItems(JMenu jMenu) {
        jMenu.removeAll();
        int n = 0;
        for (MRUSpec mRUSpec : this.mMRUSpecs) {
            jMenu.add(new BuilderMRUAction(mRUSpec.getName(), ++n, mRUSpec.isDeployed(), mRUSpec.getFullPath()));
        }
    }

    private void addMRUItem(String string, String string2, boolean bl) {
        this.removeMRUSpec(string);
        this.mMRUSpecs.add(0, new MRUSpec(string, string2, bl));
    }

    private void removeMRUSpec(String string) {
        int n = 0;
        for (MRUSpec mRUSpec : this.mMRUSpecs) {
            if (mRUSpec.getName().equals(string)) {
                this.mMRUSpecs.remove(n);
                break;
            }
            ++n;
        }
    }

    private void saveMRU() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types").node("ui_builder").node("mru");
        try {
            preferences2.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        int n = 0;
        for (MRUSpec mRUSpec : this.mMRUSpecs) {
            String string;
            String string2 = "mru_" + (n + 1);
            if (mRUSpec.isDeployed()) {
                String string3 = mRUSpec.getFullPath();
                if (string3 == null || string3.length() == 0) {
                    string3 = CommandExecutor.getUIExtensionsFolderPath() + File.separator + mRUSpec.getName();
                }
                string = string3 + "+";
            } else {
                string = mRUSpec.getFullPath() + "-";
            }
            preferences2.put(string2, string);
            ++n;
        }
    }

    private void createToolbar(DialogDefinition dialogDefinition) {
        JButton jButton;
        JButton jButton2;
        boolean bl;
        this.mToolbar = new JToolBar();
        boolean bl2 = bl = dialogDefinition != null && dialogDefinition.isSubDialog();
        if (!bl) {
            jButton2 = new JButton(new OpenAction(true));
            this.mToolbar.add(jButton2);
            this.mSaveAction = new SaveAction(true);
            jButton = new JButton(this.mSaveAction);
            this.mToolbar.add(jButton);
            this.mToolbar.addSeparator();
            JButton jButton3 = new JButton(new ReadDeployedAction(true));
            this.mToolbar.add(jButton3);
            JButton jButton4 = new JButton(new DeployAction(true));
            this.mToolbar.add(jButton4);
            this.mToolbar.addSeparator();
        }
        if (!bl) {
            jButton2 = new JButton(new TestDlgAction(true));
            this.mToolbar.add(jButton2);
            this.mToolbar.addSeparator();
        }
        jButton2 = new JButton(new SyntaxDiagramAction(true));
        this.mToolbar.add(jButton2);
        if (!bl) {
            jButton = new JButton(new MenuLocationAction(true));
            this.mToolbar.add(jButton);
        }
        this.mToolbar.addSeparator();
        jButton = new JButton(new ResetAction(true));
        this.mToolbar.add(jButton);
        this.mTBPanelNorth.add(this.mToolbar);
    }

    private void addWindowListener() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (BuilderFrame.this.doClose()) {
                    BuilderFrame.this.saveState();
                    BuilderFrame.this.dispose();
                }
            }
        };
        this.addWindowListener(windowAdapter);
    }

    private void saveState() {
        boolean bl;
        DialogDefinition dialogDefinition = this.mCanvas.getDialogDefinition();
        boolean bl2 = bl = dialogDefinition != null && dialogDefinition.isSubDialog();
        if (!bl) {
            sMainSplitPosition = this.mSplitPane.getDividerLocation();
            this.saveMRU();
        } else {
            sSubSplitPosition = this.mSplitPane.getDividerLocation();
        }
        sLastBounds = this.getBounds();
    }

    private boolean doClose() {
        if (!this.mCanvas.getDialogDefinition().isSubDialog()) {
            if (!this.checkModified(true)) {
                return false;
            }
            SpssFrameMgr.getSpssFrameMgr().removeNonDocumentFrame(this);
        }
        return true;
    }

    private void updateToolbarButtons() {
        if (this.mSaveAction != null) {
            this.mSaveAction.setEnabled(this.mIsModified);
        }
    }

    private void createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.mTBPanelNorth = new JPanel();
        this.mTBPanelNorth.setLayout(new FlowLayout(0, 2, 2));
        jPanel.add((Component)this.mTBPanelNorth, "North");
        this.setContentPane(jPanel);
    }

    private void updateTitle(DialogDefinition dialogDefinition) {
        String string;
        String string2 = BuilderResUtil.getString("IDS_UIBUILDER_TITLE");
        String string3 = string = dialogDefinition != null ? dialogDefinition.getDialogId() : null;
        if (string == null || string.length() == 0) {
            string = BuilderResUtil.getString("IDS_UNTITLED");
        }
        if (string != null && string.length() > 0) {
            string2 = string2 + " - " + string;
        }
        if (this.isModified()) {
            string2 = "*" + string2;
        }
        this.setTitle(string2);
    }

    private boolean checkModified(boolean bl) {
        int n;
        return !this.isModified() || (n = SpssAlertOptionPane.showConfirmDialog(this, BuilderResUtil.getString(bl ? "IDS_CLOSE_CHANGES_QUERY" : "IDS_DISCARD_CHANGES_QUERY"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 0;
    }

    private void testExecute() {
        DialogExecutor dialogExecutor = new DialogExecutor();
        DialogDefinition dialogDefinition = this.mCanvas.getDialogDefinition();
        if (!dialogExecutor.testDialog(this, dialogDefinition)) {
            SpssAlertOptionPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_EXECUTING_DLG"), VersionInfo.getAppVersionString());
        }
    }

    private void openDeployedSpecification() {
        try {
            String string = OpenDeployedDlg.doOpenDeployedDlg(this);
            if (string == null || string.length() == 0) {
                return;
            }
            File file = new File(string);
            if (!file.isDirectory()) {
                return;
            }
            String[] stringArray = file.list(new XmlFilter());
            if (stringArray.length == 0) {
                String string2 = BuilderResUtil.getString("IDS_ERROR_OPENING_DLG") + string;
                SpssAlertOptionPane.showErrorMessageDialog(this, string2, VersionInfo.getAppVersionString());
                return;
            }
            File file2 = new File(string + File.separator + stringArray[0]);
            this.setCurrentDefinition(file2);
            this.mOpenSpecName = file.getName();
            String string3 = string.startsWith(SpecificationBuilder.getUIExtensionsFolderPath()) ? "" : string;
            this.addMRUItem(this.mOpenSpecName, string3, true);
            this.mSPDPath = null;
            this.setModified(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SpssAlertOptionPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_BAD_CLEF_FILE_MSG"), VersionInfo.getAppVersionString());
        }
    }

    private boolean deploySpecification(boolean bl) {
        this.mPropsPanel.commitEdits();
        DialogDefinition dialogDefinition = this.mCanvas.getDialogDefinition();
        if (bl && !this.checkForSyntaxTemplate(dialogDefinition)) {
            return false;
        }
        if (bl && !this.checkForMenuLocation(dialogDefinition)) {
            return false;
        }
        if (bl && !MissingAddOnsDlg.checkForMissingAddOns(this, dialogDefinition)) {
            return false;
        }
        try {
            String string;
            SpecificationWriter specificationWriter;
            int n;
            String string2 = SpecificationWriter.getDeploymentFolder();
            if (string2 == null) {
                Object[] objectArray = new String[]{ResUtil.getCommonDlgString("IDS_OK"), ResUtil.getCommonDlgString("IDS_HELP")};
                int n2 = SpssAlertOptionPane.showOptionDialog(this, BuilderResUtil.getString("IDS_INSTALL_SPEC_ERROR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eError, objectArray, (Object)objectArray[0]);
                if (n2 == 1) {
                    StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER");
                }
                return false;
            }
            String string3 = string2 + File.separator + dialogDefinition.getDialogId();
            File file = new File(string3);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    throw new Exception("Error creating deployment directory");
                }
            } else if (!this.mOpenSpecName.equals(dialogDefinition.getDialogId()) && (n = SpssAlertOptionPane.showConfirmDialog(this, BuilderResUtil.getString("IDS_OVERWRITE_SPEC_QUERY"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) != 1) {
                return false;
            }
            String string4 = dialogDefinition.getCommandLocation().getCommandActionId();
            String string5 = dialogDefinition.getCommandLocation().getCommandPath();
            String string6 = dialogDefinition.getCommandLocation().getCommandTitle();
            String string7 = CommandExecutor.get().hasMenuItem(string4, string5, string6);
            if (string7 != null) {
                int n3 = SpssAlertOptionPane.showConfirmDialog(this, BuilderResUtil.getString("IDS_SAME_MENU_ITEM_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                if (n3 != 1) {
                    return false;
                }
                if (!this.removeDeployed(string2 + File.separator + string7)) {
                    return false;
                }
            }
            if (!(specificationWriter = new SpecificationWriter(dialogDefinition)).writeClefStream(string = string3 + File.separator + dialogDefinition.getDialogId() + XML_FILE_EXT)) {
                throw new Exception(this.makeErrorText(specificationWriter));
            }
            BuilderFrame.updateFrames(dialogDefinition, string);
            this.mOpenSpecName = dialogDefinition.getDialogId();
            String string8 = string3.startsWith(SpecificationBuilder.getUIExtensionsFolderPath()) ? "" : string3;
            this.addMRUItem(this.mOpenSpecName, string8, true);
            if (string8.equals("")) {
                string8 = SpecificationBuilder.getUIExtensionsFolderPath() + File.separator + this.mOpenSpecName;
            }
            String string9 = String.format(BuilderResUtil.getString("IDS_DIALOG_INSTALLED"), string8);
            SpssAlertOptionPane.showInformationMessageDialog(this, string9, VersionInfo.getAppVersionString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SpssAlertOptionPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + exception.getMessage(), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    private String makeErrorText(SpecificationWriter specificationWriter) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Vector vector = specificationWriter.getErrors();
        for (String string : vector) {
            stringBuffer.append(n++).append(". ").append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private boolean checkForMenuLocation(DialogDefinition dialogDefinition) {
        if (dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)this.mPropsPanel).length() == 0) {
            Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_EDIT_LOCATION"), ResUtil.getCommonDlgString("IDS_CANCEL")};
            int n = SpssAlertOptionPane.showOptionDialog(this, BuilderResUtil.getString("IDS_NO_MENU_WARNING"), BuilderResUtil.getString("IDS_INSTALL_DIALOG"), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            if (n == 1) {
                return false;
            }
            this.runMenuLocationDialog(dialogDefinition);
            return false;
        }
        return true;
    }

    private boolean checkForSyntaxTemplate(DialogDefinition dialogDefinition) {
        if (dialogDefinition.getDialogSyntax().length() == 0) {
            Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_EDIT_SYNTAX_TEMPLATE"), ResUtil.getCommonDlgString("IDS_CANCEL")};
            int n = SpssAlertOptionPane.showOptionDialog(this, BuilderResUtil.getString("IDS_NO_TEMPLATE_WARNING"), BuilderResUtil.getString("IDS_INSTALL_DIALOG"), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            if (n == 1) {
                return false;
            }
            this.editSyntaxTemplate();
            return false;
        }
        return true;
    }

    private boolean removeDeployed(String string) throws Exception {
        File file = new File(string);
        RemoveDeployedQueryDlg removeDeployedQueryDlg = new RemoveDeployedQueryDlg(this, file.getName());
        removeDeployedQueryDlg.setVisible(true);
        if (removeDeployedQueryDlg.getDoSave() && this.checkModified(false)) {
            this.setCurrentDefinition(new File(string + File.separator + file.getName() + XML_FILE_EXT), true);
            this.setModified(false);
            new SaveAsAction(false).actionPerformed(null);
        }
        if (removeDeployedQueryDlg.isContinue()) {
            File[] fileArray;
            int n = string.lastIndexOf(File.separator);
            String string2 = n > -1 ? string.substring(n + 1) : string;
            CommandExecutor.MenuItemContainer menuItemContainer = BuilderFrame.getMenuItemContainer(string2);
            if (menuItemContainer != null) {
                CommandExecutor.get().removeCustomAction(menuItemContainer.getAction());
            }
            BuilderFrame.removeFromFrames(string2, string + File.separator + string2 + XML_FILE_EXT);
            File file2 = new File(string);
            if (!file2.exists()) {
                return true;
            }
            for (File file3 : fileArray = file2.listFiles()) {
                file3.delete();
            }
            boolean bl = file2.delete();
            if (!bl) {
                throw new Exception("Folder not deleted!");
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean writeToSPDFile(String string) {
        Object object;
        File file = new File(string);
        PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
        if (pesFile != null) {
            this.mSPDPath = file;
            File file2 = file;
            object = new File(PrefsMgr.getPrefsMgr().getTempPath());
            try {
                file = PASWFileUtil.createTempFile((String)"pes", (String)"", (File)object);
            }
            catch (IOException iOException) {
                file = file2;
                pesFile = null;
            }
        }
        if (this.writePackageFile(file.getAbsolutePath()) && pesFile == null) {
            this.mSPDPath = new File(file.getAbsolutePath());
            this.setModified(false);
        }
        if (pesFile != null) {
            int n = PES_Repository.MapFilterToMimeType((String)"(*.spd)");
            object = ComponentState.getCurrentCharset().displayName();
            PES_Repository.StoreToPES((File)file, (PesFile)pesFile, (int)n, (String)object);
            file.delete();
            PES_Repository.removeFromPesCache((File)file);
            this.setModified(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePackageFile(String string) {
        boolean bl = true;
        DeflaterOutputStream deflaterOutputStream = null;
        File file = null;
        try {
            File[] fileArray = PrefsMgr.getPrefsMgr().getTempPath();
            file = PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)new File((String)fileArray));
            file.delete();
            if (!file.mkdir()) {
                boolean bl2 = false;
                return bl2;
            }
            file.deleteOnExit();
            DialogDefinition dialogDefinition = this.mCanvas.getDialogDefinition();
            String string2 = file.getPath() + File.separator + dialogDefinition.getDialogId() + XML_FILE_EXT;
            new File(string2).deleteOnExit();
            File file2 = new SpecificationWriter(dialogDefinition);
            if (!file2.writeClefStream(string2, true, true)) {
                boolean bl3 = false;
                return bl3;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string, false);
            deflaterOutputStream = new JarOutputStream(fileOutputStream);
            ((ZipOutputStream)deflaterOutputStream).setMethod(8);
            this.saveToJar((JarOutputStream)deflaterOutputStream, file);
            this.readPackageFile(new File(string));
            this.addMRUItem(new File(string).getName(), string, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        finally {
            if (file != null && file.exists()) {
                for (File file2 : file.listFiles()) {
                    file2.delete();
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.flush();
                    ((ZipOutputStream)deflaterOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    private void saveToJar(JarOutputStream jarOutputStream, File file) throws Exception {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            FileInputStream fileInputStream = new FileInputStream(file2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier.copyStream((InputStream)fileInputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = byArray.length;
            if (n == 0) {
                throw new Exception("Can't read input bytes");
            }
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            JarEntry jarEntry = new JarEntry(file2.getName());
            jarEntry.setCompressedSize(n);
            jarEntry.setCrc(cRC32.getValue());
            jarOutputStream.putNextEntry(jarEntry);
            jarOutputStream.write(byArray);
            jarOutputStream.closeEntry();
        }
    }

    private void readPackageFile(File file) throws Exception {
        File file2 = null;
        try {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            file2 = PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)new File(string));
            file2.delete();
            if (!file2.mkdir()) {
                throw new Exception("Cannot create temp folder");
            }
            file2.deleteOnExit();
            File file3 = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            file3 = this.readFromJar(file2, file3, jarInputStream);
            jarInputStream.close();
            if (file3 == null || !file3.exists()) {
                throw new Exception("CLEF file does not exist");
            }
            this.setCurrentDefinition(file3, true);
            this.mOpenSpecName = file.getName();
            this.mSPDPath = file;
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)("Error reading package file: " + exception.getMessage()), (int)15);
            throw exception;
        }
        finally {
            if (file2 != null && file2.exists()) {
                file2.deleteOnExit();
            }
        }
    }

    private File readFromJar(File file, File file2, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            ByteBuffer byteBuffer = this.readEntry(jarInputStream);
            File file3 = new File(file.getPath() + File.separator + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byteBuffer.array());
            fileOutputStream.close();
            jarInputStream.closeEntry();
            if (XML_FILE_EXT.regionMatches(true, 0, string, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                file2 = file3;
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private void setCurrentDefinition(File file) throws Exception {
        this.setCurrentDefinition(file, false);
    }

    private void setCurrentDefinition(File file, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = CommandExecutor.get().readClefFileSpec(file);
        if (dialogDefinition == null) {
            throw new Exception("Cannot read file specification");
        }
        if (bl) {
            String string;
            String string2;
            String string3;
            File file2 = file.getParentFile();
            String string4 = dialogDefinition.getHelpFileName();
            if (string4 != null && string4.length() > 0) {
                string3 = new File(string4).getName();
                string2 = file2.getCanonicalPath() + File.separator + string3;
                dialogDefinition.setHelpFileName(string2);
            }
            if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
                string2 = new File(string3).getName();
                string = file2.getCanonicalPath() + File.separator + string2;
                dialogDefinition.setCustomPropertiesFile(string);
            }
            LinkedList linkedList = dialogDefinition.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    string = panelDefinition.getPanelElement(i);
                    if (!(string instanceof SubDlgButtonDefinition) || (string4 = (string2 = ((SubDlgButtonDefinition)string).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                    String string5 = new File(string4).getName();
                    String string6 = file2.getCanonicalPath() + File.separator + string5;
                    string2.setHelpFileName(string6);
                }
            }
        }
        this.editDialogDefinition(dialogDefinition);
    }

    private ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        try {
            int n = jarInputStream.read(byArray, 0, 4096);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 4096);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    protected void updateWindowMenuDocuments(JMenu jMenu) {
        JMenuItem jMenuItem;
        int n = jMenu.getItemCount();
        for (int i = n - 1; i >= 0 && (jMenuItem = jMenu.getItem(i)) != null; --i) {
            jMenu.remove(jMenuItem);
        }
        SpssFrameMgr.getSpssFrameMgr().addDocumentMenuItems(jMenu);
        this.refreshMenuCheckStatus(jMenu);
    }

    private void refreshMenuCheckStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (!(jMenuItem instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenuItem;
            Action action = jMenuItem.getAction();
            if (!(action instanceof WindowMenuAction)) continue;
            jCheckBoxMenuItem.setSelected(((WindowMenuAction)action).getMenuItemCheckStatus());
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object = menuEvent.getSource();
        if (object instanceof JMenu) {
            DialogDefinition dialogDefinition = this.mCanvas.getDialogDefinition();
            boolean bl = dialogDefinition != null && dialogDefinition.isSubDialog();
            JMenu jMenu = (JMenu)object;
            String string = jMenu.getText();
            if (!bl && string.equals(ResUtil.getString("File"))) {
                this.mMenuSaveItem.setEnabled(this.isModified());
            } else if (!bl && string.equals(BuilderResUtil.getString("IDS_RECENTLY_USED"))) {
                this.updateMRUMenuItems(jMenu);
            } else if (string.equals(ResUtil.getString("View"))) {
                this.mViewToolboxMenuItem.setState(this.mToolPalette.isVisible());
                this.mViewToolbarMenuItem.setState(this.mToolbar.isVisible());
            } else if (!bl && string.equals(ResUtil.getString("Window"))) {
                this.updateWindowMenuDocuments(jMenu);
            }
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public int getMaxMRUItems() {
        return 10;
    }

    public static File getCanonicalFileIfNotCanonical(File file) {
        File file2 = null;
        if (file != null) {
            try {
                File file3 = new File(file.getCanonicalPath());
                if (!file3.getPath().equals(file.getPath())) {
                    file2 = new File(file3.getPath());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public boolean canSaveTo(String string) {
        DocUtil.eFileStat eFileStat2 = DocUtil.getRemoteFileStat(string);
        if (eFileStat2.equals((Object)DocUtil.eFileStat.File_Read_Only)) {
            String string2 = ResUtil.getString("ERR_READ_ONLY_NO_ACCESS");
            SpssAlertOptionPane.showInformationMessageDialog(this, string2, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    class MRUSpec {
        private String mName;
        private String mFullPath;
        private boolean mIsDeployed;

        MRUSpec(String string, String string2, boolean bl) {
            this.mIsDeployed = bl;
            this.mName = string;
            this.mFullPath = string2;
        }

        public boolean isDeployed() {
            return this.mIsDeployed;
        }

        public String getName() {
            return this.mName;
        }

        public String getFullPath() {
            return this.mFullPath;
        }
    }

    class BuilderMRUAction
    extends AbstractAction {
        private String mSpecName;
        private String mSpecPath;
        private boolean mDeployed;

        BuilderMRUAction(String string, int n, boolean bl, String string2) {
            super(n + " " + string + (bl ? " [" + BuilderResUtil.getString("IDS_DEPLOYED") + "]" : ""));
            if (n == 10) {
                this.putValue("MnemonicKey", 48);
            } else {
                this.putValue("MnemonicKey", 48 + n);
            }
            this.mSpecName = string;
            this.mSpecPath = string2;
            this.mDeployed = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            try {
                if (!BuilderFrame.this.checkModified(false)) {
                    return;
                }
                if (this.mDeployed) {
                    File file;
                    String string = this.mSpecPath;
                    if (string == null || string.length() == 0) {
                        string = CommandExecutor.getUIExtensionsFolderPath() + File.separator + this.mSpecName;
                    }
                    if ((file = new File(string + File.separator + this.mSpecName + BuilderFrame.XML_FILE_EXT)).exists()) {
                        BuilderFrame.this.setCurrentDefinition(file);
                    } else {
                        bl = false;
                    }
                } else {
                    File file = new File(this.mSpecPath);
                    if (file.exists()) {
                        BuilderFrame.this.readPackageFile(file);
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    BuilderFrame.this.addMRUItem(this.mSpecName, this.mSpecPath, this.mDeployed);
                    BuilderFrame.this.mOpenSpecName = this.mSpecName;
                    BuilderFrame.this.setModified(false);
                    BuilderFrame.this.getCanvas().repaint(100L);
                }
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
            }
            if (!bl) {
                BuilderFrame.this.removeMRUSpec(this.mSpecName);
                SpssAlertOptionPane.showErrorMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_BAD_CLEF_FILE_MSG"), VersionInfo.getAppVersionString());
            }
        }
    }

    class XmlFilter
    implements FilenameFilter {
        XmlFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return BuilderFrame.XML_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.XML_FILE_EXT.length(), BuilderFrame.XML_FILE_EXT.length());
        }
    }

    class UiPkgFilter
    extends FileFilter {
        UiPkgFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return BuilderFrame.UIPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.UIPKG_FILE_EXT.length(), BuilderFrame.UIPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_PKG_FILE_DESC");
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction(boolean bl) {
            Serializable serializable;
            if (bl) {
                this.putValue("ShortDescription", ResUtil.getString("help_topics_TOOLTIP"));
            } else {
                this.putValue("Name", ResUtil.getString("help_topics"));
                this.putValue("MnemonicKey", ResUtil.getAccessKey("help_topics"));
                serializable = ResUtil.getShortcut("help_topics");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            serializable = ResUtil.getImageURL("help_topics");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER");
        }
    }

    class ViewToolbarAction
    extends AbstractAction {
        public ViewToolbarAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_VIEW_TOOLBAR_DESC"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_VIEW_TOOLBAR"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_VIEW_TOOLBAR"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("IDS_VIEW_TOOLBAR");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.mToolbar.setVisible(!BuilderFrame.this.mToolbar.isVisible());
        }
    }

    class ViewToolboxAction
    extends AbstractAction {
        public ViewToolboxAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_VIEW_TOOLBOX_DESC"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_VIEW_TOOLBOX"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_VIEW_TOOLBOX"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("IDS_VIEW_TOOLBOX");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.mToolPalette.setVisible(!BuilderFrame.this.mToolPalette.isVisible());
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction(boolean bl) {
            Serializable serializable;
            if (!bl) {
                this.putValue("Name", ResUtil.getString("file_close"));
                this.putValue("MnemonicKey", ResUtil.getAccessKey("file_close"));
                serializable = ResUtil.getShortcut("file_close");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            if ((serializable = ResUtil.getImageURL("file_close")) != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BuilderFrame.this.doClose()) {
                BuilderFrame.this.saveState();
                BuilderFrame.this.dispose();
            }
        }
    }

    class UndeployAction
    extends AbstractAction {
        public UndeployAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_UNDEPLOY_SPEC_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_UNDEPLOY_SPEC"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_UNDEPLOY_SPEC"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = OpenDeployedDlg.doRemoveDeployedDlg(BuilderFrame.this);
                if (string == null || string.length() == 0) {
                    return;
                }
                BuilderFrame.this.removeDeployed(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class DeployAction
    extends AbstractAction {
        public DeployAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SAVE_DEPLOYED_SPEC_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_SAVE_DEPLOYED_SPEC"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_SAVE_DEPLOYED_SPEC"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("export_spec.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.deploySpecification(true);
        }
    }

    class ReadDeployedAction
    extends AbstractAction {
        public ReadDeployedAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_OPEN_DEPLOYED_SPEC_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_OPEN_DEPLOYED_SPEC"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_OPEN_DEPLOYED_SPEC"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("import_spec.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.checkModified(false)) {
                return;
            }
            BuilderFrame.this.openDeployedSpecification();
        }
    }

    class TestDlgAction
    extends AbstractAction {
        public TestDlgAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_TEST_DLG_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_TEST_DLG"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_TEST_DLG"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("test_dlg.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.mPropsPanel.commitEdits();
            BuilderFrame.this.testExecute();
        }
    }

    class ResetAction
    extends AbstractAction {
        public ResetAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_RESET_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_RESET"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_RESET"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("reset.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.checkModified(false)) {
                return;
            }
            DialogDefinition dialogDefinition = BuilderFrame.this.mCanvas.getDialogDefinition();
            DialogDefinition dialogDefinition2 = new DialogDefinition(dialogDefinition.getParentDefinition(), AppType.STATS);
            if (dialogDefinition.isSubDialog()) {
                PanelDefinition panelDefinition = (PanelDefinition)dialogDefinition.getParentDefinition().getPanels().get(0);
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    SubDlgButtonDefinition subDlgButtonDefinition;
                    PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
                    if (!(panelElementDefinition instanceof SubDlgButtonDefinition) || (subDlgButtonDefinition = (SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition() != dialogDefinition) continue;
                    subDlgButtonDefinition.setDialogDefinition(dialogDefinition2);
                    break;
                }
            }
            BuilderFrame.this.mCanvas.setDialogDefinition(dialogDefinition2);
            BuilderFrame.this.mCanvas.invalidate();
            BuilderFrame.this.validate();
            BuilderFrame.this.mCanvas.repaint();
            if (!dialogDefinition.isSubDialog()) {
                BuilderFrame.this.mOpenSpecName = "";
                BuilderFrame.this.mSPDPath = null;
                BuilderFrame.this.setModified(false);
            }
        }
    }

    class MenuLocationAction
    extends AbstractAction {
        public MenuLocationAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_MENU_LOCATION_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_MENU_LOCATION"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MENU_LOCATION"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("properties.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DialogDefinition dialogDefinition = BuilderFrame.this.mCanvas.getDialogDefinition();
            if (MenuLocationDialog.runMenuLocationDialog(BuilderFrame.this, dialogDefinition.getCommandLocation())) {
                BuilderFrame.this.mCanvas.fireSelectionChange(BuilderFrame.this.mPropsPanel.getSelectedObject());
                BuilderFrame.this.setModified(true);
            }
        }
    }

    public static class DialogDefinitionHelper {
        ArrayList<String> mControlIds = new ArrayList();

        public ArrayList<String> getControlIds(DialogDefinition dialogDefinition) {
            this.mControlIds = new ArrayList();
            this.loadControlIds(dialogDefinition);
            return this.mControlIds;
        }

        private void loadControlIds(DialogDefinition dialogDefinition) {
            this.mControlIds = new ArrayList();
            this.loadMainPanelIds(dialogDefinition);
        }

        private void loadMainPanelIds(DialogDefinition dialogDefinition) {
            for (PanelDefinition panelDefinition : dialogDefinition.getPanels()) {
                this.loadSubPanelIds((PanelElementDefinition)panelDefinition);
            }
        }

        private void loadSubPanelIds(PanelElementDefinition panelElementDefinition) {
            int n;
            if (panelElementDefinition instanceof PanelDefinition) {
                n = ((PanelDefinition)panelElementDefinition).getElementCount();
            } else if (panelElementDefinition instanceof RadioItemDefinition) {
                n = ((RadioItemDefinition)panelElementDefinition).getElementCount();
            } else {
                return;
            }
            for (int i = 0; i < n; ++i) {
                DialogDefinition dialogDefinition;
                PanelElementDefinition panelElementDefinition2 = panelElementDefinition instanceof PanelDefinition ? ((PanelDefinition)panelElementDefinition).getPanelElement(i) : ((RadioItemDefinition)panelElementDefinition).getPanelElement(i);
                if (panelElementDefinition2 instanceof SrcListDefinition || panelElementDefinition2 instanceof StaticCtrlDefinition) continue;
                if (panelElementDefinition2 instanceof SubDlgButtonDefinition) {
                    dialogDefinition = ((SubDlgButtonDefinition)panelElementDefinition2).getDialogDefinition();
                    this.mControlIds.add(dialogDefinition.getDialogId());
                    this.loadMainPanelIds(dialogDefinition);
                    continue;
                }
                this.mControlIds.add(panelElementDefinition2.getControlId());
                if (panelElementDefinition2 instanceof PanelDefinition) {
                    this.loadSubPanelIds(panelElementDefinition2);
                    continue;
                }
                if (!(panelElementDefinition2 instanceof RadioGroupDefinition)) continue;
                dialogDefinition = (RadioGroupDefinition)panelElementDefinition2;
                for (int j = 0; j < dialogDefinition.radioItemCount(); ++j) {
                    this.loadSubPanelIds((PanelElementDefinition)dialogDefinition.getRadioItem(j));
                }
            }
        }
    }

    class SyntaxDiagramAction
    extends AbstractAction {
        SyntaxDiagramDlg mSyntaxDiagramDlg;

        public SyntaxDiagramAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_SYNTAX_DIAGRAM"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("syntax_diagram.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getDialogSyntax();
            DialogDefinitionHelper dialogDefinitionHelper = new DialogDefinitionHelper();
            this.mSyntaxDiagramDlg = new SyntaxDiagramDlg(BuilderFrame.this, string, dialogDefinitionHelper.getControlIds(this.getMainDialogDefinition()), SyntaxMgr.getStaticSyntaxCommands(), SyntaxPrefManager.getSyntaxEditorPreferences(), new SyntaxDiagramDlgCallback());
            this.mSyntaxDiagramDlg.setVisible(true);
            if (this.mSyntaxDiagramDlg.getModalResult()) {
                BuilderFrame.this.mCanvas.fireSelectionChange(BuilderFrame.this.mCanvas.getSelectedObject());
                BuilderFrame.this.setModified(true);
            }
        }

        private String getDialogSyntax() {
            DialogDefinition dialogDefinition = this.getMainDialogDefinition();
            return dialogDefinition.getDialogSyntax();
        }

        private DialogDefinition getMainDialogDefinition() {
            DialogDefinition dialogDefinition = BuilderFrame.this.mCanvas.getDialogDefinition();
            if (dialogDefinition.isSubDialog()) {
                dialogDefinition = dialogDefinition.getParentDefinition();
            }
            return dialogDefinition;
        }

        private class SyntaxDiagramDlgCallback
        implements SyntaxDiagramDlg.SyntaxDiagramDlgCallback {
            private SyntaxDiagramDlgCallback() {
            }

            @Override
            public void syntaxModifiedNotification() {
                SyntaxDiagramAction.this.getMainDialogDefinition().setDialogSyntax(SyntaxDiagramAction.this.mSyntaxDiagramDlg.getSyntax());
                BuilderFrame.this.setModified(true);
            }

            @Override
            public void showHelp() {
                StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER_SYNTEMPLATE");
            }

            @Override
            public boolean showInvalidSyntaxWarning() {
                int n = SpssAlertOptionPane.showConfirmDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                return n == 2;
            }
        }
    }

    class LayoutAction
    extends AbstractAction {
        public LayoutAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_DO_LAYOUT_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_DO_LAYOUT"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_DO_LAYOUT"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("do_layout.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = BuilderFrame.this.mCanvas.isLayoutOn();
            BuilderFrame.this.mCanvas.setLayoutOn(true);
            BuilderFrame.this.mCanvas.invalidate();
            BuilderFrame.this.validate();
            BuilderFrame.this.mCanvas.setLayoutOn(bl);
            if (!bl) {
                BuilderFrame.this.setModified(true);
            }
        }
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(boolean bl) {
            Serializable serializable;
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("file_save_as_TOOLTIP"));
            } else {
                this.putValue("Name", ResUtil.getString("file_save_as"));
                this.putValue("MnemonicKey", ResUtil.getAccessKey("file_save_as"));
                serializable = ResUtil.getShortcut("file_save_as");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            serializable = ResUtil.getImageURL("file_save_as");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false, false, true);
            UiPkgFilter uiPkgFilter = new UiPkgFilter();
            remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_SAVE_CLEF_DLG_TITLE"));
            remoteFileChooser.addChoosableFileFilter(uiPkgFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            remoteFileChooser.setFileFilter(uiPkgFilter);
            DialogDefinition dialogDefinition = BuilderFrame.this.mCanvas.getDialogDefinition();
            String string = BuilderFrame.this.mSPDPath != null ? BuilderFrame.this.mSPDPath.getName() : dialogDefinition.getDialogId() + "." + BuilderFrame.getBuilderPkgExtension();
            ((BasicFileChooserUI)remoteFileChooser.getUI()).setFileName(string);
            int n = remoteFileChooser.showSaveDialog(BuilderFrame.this);
            if (n == 0) {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                String string2 = remoteFileChooser.getSelectedFilePath();
                if (!BuilderFrame.UIPKG_FILE_EXT.regionMatches(true, 0, string2, string2.length() - BuilderFrame.UIPKG_FILE_EXT.length(), BuilderFrame.UIPKG_FILE_EXT.length())) {
                    string2 = string2 + BuilderFrame.UIPKG_FILE_EXT;
                }
                if (!BuilderFrame.this.canSaveTo(string2)) {
                    return;
                }
                BuilderFrame.this.writeToSPDFile(string2);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(boolean bl) {
            Serializable serializable;
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SAVE_SPEC"));
            } else {
                this.putValue("Name", ResUtil.getString("file_save"));
                this.putValue("MnemonicKey", ResUtil.getAccessKey("file_save"));
                serializable = ResUtil.getShortcut("file_save");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            serializable = ResUtil.getImageURL("file_save");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public boolean isEnabled() {
            return BuilderFrame.this.isModified();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (BuilderFrame.this.mSPDPath == null) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false, false, true);
                UiPkgFilter uiPkgFilter = new UiPkgFilter();
                remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_SAVE_CLEF_DLG_TITLE"));
                remoteFileChooser.addChoosableFileFilter(uiPkgFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setFileFilter(uiPkgFilter);
                DialogDefinition dialogDefinition = BuilderFrame.this.mCanvas.getDialogDefinition();
                ((BasicFileChooserUI)remoteFileChooser.getUI()).setFileName(dialogDefinition.getDialogId() + "." + BuilderFrame.getBuilderPkgExtension());
                int n = remoteFileChooser.showSaveDialog(BuilderFrame.this);
                if (n == 0) {
                    FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    string = remoteFileChooser.getSelectedFilePath();
                    if (!BuilderFrame.UIPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.UIPKG_FILE_EXT.length(), BuilderFrame.UIPKG_FILE_EXT.length())) {
                        string = string + BuilderFrame.UIPKG_FILE_EXT;
                    }
                }
            } else {
                string = BuilderFrame.this.mSPDPath.getAbsolutePath();
            }
            if (string != null) {
                BuilderFrame.this.mSPDPath = null;
                if (!BuilderFrame.this.canSaveTo(string)) {
                    return;
                }
                BuilderFrame.this.writeToSPDFile(string);
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction(boolean bl) {
            Serializable serializable;
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_OPEN_SPEC"));
            } else {
                this.putValue("Name", ResUtil.getString("file_open") + "...");
                this.putValue("MnemonicKey", ResUtil.getAccessKey("file_open"));
                serializable = ResUtil.getShortcut("file_open");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            serializable = ResUtil.getImageURL("script");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.checkModified(false)) {
                return;
            }
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
            UiPkgFilter uiPkgFilter = new UiPkgFilter();
            remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_OPEN_CLEF_DLG_TITLE"));
            remoteFileChooser.addChoosableFileFilter(uiPkgFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            remoteFileChooser.setFileFilter(uiPkgFilter);
            int n = remoteFileChooser.showOpenDialog(BuilderFrame.this);
            if (n == 0) {
                try {
                    Object object;
                    FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    File file = remoteFileChooser.getSelectedFile();
                    PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
                    if (pesFile != null) {
                        object = PES_Repository.RetrieveFromPES((PesFile)pesFile);
                        file = pesFile.getCacheFile();
                        if (file == null) {
                            SpssAlertOptionPane.showWarningMessageDialog(BuilderFrame.this, (String)object, VersionInfo.getAppVersionString());
                            return;
                        }
                    }
                    BuilderFrame.this.openSPDFile(file);
                    if (pesFile != null) {
                        object = remoteFileChooser.getSelectedFile();
                        BuilderFrame.this.addMRUItem(((File)object).getName(), ((File)object).getPath(), false);
                        BuilderFrame.this.setModified(false);
                        BuilderFrame.this.mSPDPath = (File)object;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SpssAlertOptionPane.showErrorMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_BAD_CLEF_FILE_MSG"), VersionInfo.getAppVersionString());
                }
            }
        }
    }
}

