/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.custom_gui.DialogExecutor;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.StatsCDBAppInfo;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.BaseDialogExecutor;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.uitools.help.StatsHelp;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class EnhancedCDBlAlertDlg
extends SpssAlertDialog {
    static final String DONT_SHOW_DIALOG_CHECK = "IDS_DONOT_SHOW_ENHANCED";
    private JButton mEnhancedButton;
    private JButton mCompatiButton;
    private JButton mHelpButton;
    protected JCheckBox mDontShowCheck;

    public EnhancedCDBlAlertDlg(JFrame jFrame, String string, String string2) {
        super(jFrame, ResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), string, string2, SpssAlertOptionPane.IconType.eInformation);
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    protected void setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mEnhancedButton);
        vector.add(this.mCompatiButton);
        vector.add(this.mHelpButton);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    @Override
    protected void initVars() {
        super.initVars();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DONT_SHOW_DIALOG_CHECK);
        this.mDontShowCheck = new JCheckBox(toggleButtonAction);
        this.mDontShowCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = EnhancedCDBlAlertDlg.this.mDontShowCheck.isSelected();
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                Preferences preferences2 = preferences.node("dialog_settings/enhanced_custom_dlg_builder");
                preferences2.putBoolean("dont_show_enhanced_CDB_warning", bl);
            }
        });
    }

    @Override
    protected void addComponents(boolean bl) {
        super.addComponents(bl);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mViewPanel, this.mDontShowCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    @Override
    protected JPanel setupCmdButtons() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mEnhancedButton = new JButton(new EhancedAction());
        this.mHelpButton = new JButton((Action)this.createHelpAction());
        this.mCompatiButton = new JButton(new CompatibleAction());
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap() * 3, 0, 0, 0));
            int n = 6 * (insets.left + insets.right);
            FlowLayout flowLayout = null;
            flowLayout = OSCheck.getOSType() == OSInfo.OSType.MAC ? new FlowLayout(2, n, 0) : new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mEnhancedButton);
            jPanel.add(this.mCompatiButton);
            jPanel.add(this.mHelpButton);
            this.getRootPane().setDefaultButton(this.mEnhancedButton);
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(this.mEnhancedButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCompatiButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            this.getRootPane().setDefaultButton(this.mEnhancedButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_uibuilder");
    }

    class CompatibleAction
    extends AbstractAction {
        public CompatibleAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_COMPATIBLE_BUTTON"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", EnhancedCDBlAlertDlg.this.getDlgAccessKey("IDK_COMPATIBLE_BUTTON_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EnhancedCDBlAlertDlg.this.dispose();
            StatsCDBAppInfo statsCDBAppInfo = new StatsCDBAppInfo(true);
            statsCDBAppInfo.setTabbed(false);
            try {
                BuilderFrame builderFrame = new BuilderFrame((CDBAppInfo)statsCDBAppInfo);
                DialogExecutor dialogExecutor = new DialogExecutor();
                builderFrame.setDlgExecutor((BaseDialogExecutor)dialogExecutor);
                builderFrame.setVisible(true);
                SpssFrameMgr.getSpssFrameMgr().addNonDocumentFrame((JFrame)builderFrame);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class EhancedAction
    extends AbstractAction {
        public EhancedAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_ENHANCED_BUTTON"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", EnhancedCDBlAlertDlg.this.getDlgAccessKey("IDK_ENHANCED_BUTTON_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EnhancedCDBlAlertDlg.this.dispose();
            StatsCDBAppInfo statsCDBAppInfo = new StatsCDBAppInfo(false);
            statsCDBAppInfo.setTabbed(false);
            try {
                BuilderFrame builderFrame = new BuilderFrame((CDBAppInfo)statsCDBAppInfo);
                DialogExecutor dialogExecutor = new DialogExecutor();
                builderFrame.setDlgExecutor((BaseDialogExecutor)dialogExecutor);
                builderFrame.setVisible(true);
                SpssFrameMgr.getSpssFrameMgr().addNonDocumentFrame((JFrame)builderFrame);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

