/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui;

import com.pasw.core.extension.feature.FeatureImpl;
import com.pasw.core.property.DefaultProperties;
import com.pasw.framework.common.core.CFEnum;
import com.pasw.framework.common.extension.Feature;
import com.pasw.ui.common.FeatureUI;
import com.pasw.ui.common.control.Control;
import com.pasw.ui.swing.common.SwingFeatureUI;
import com.pasw.ui.swing.control.DatasetSelectorControl;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.cf_integration.dialog.CFProcedureDialog;
import com.spss.java_client.ui.dialogs.base.custom_gui.CustomProcedureDialog;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.MenuLocationDialog;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.MenuLocationDialogEx;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.InstallExtensionBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.custom_gui.ui_builder.BaseDialogExecutor;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class DialogExecutor
implements BaseDialogExecutor {
    private static final String UIPKG_FILE_EXT = ".spd";
    private static final String SPDXPKG_FILE_EXT = ".spdx";
    private static final String CFE_FILE_EXT = ".cfe";
    private static final String SPEPKG_FILE_EXT = ".spe";

    public boolean runDialog(JFrame jFrame, DialogDefinition dialogDefinition) {
        try {
            CustomProcedureDialog.runCustomProcedureDialog(jFrame, dialogDefinition, dialogDefinition.isModal());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean testDialog(JFrame jFrame, DialogDefinition dialogDefinition) {
        try {
            CustomProcedureDialog.testCustomProcedureDialog(jFrame, dialogDefinition);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void testDialog(JFrame jFrame, String string, Feature feature, FeatureUI featureUI, boolean bl) {
        this.handleDataselectorControl((FeatureImpl)feature, featureUI);
        new CFProcedureDialog(jFrame, string, feature, featureUI, bl);
    }

    public void showDialogMenuLocation(JFrame jFrame, CommandLocation commandLocation, BuilderCanvas builderCanvas, CanvasObject canvasObject) {
        String string = "";
        if (commandLocation.getCommandPath() != null) {
            string = commandLocation.getCommandPath();
        }
        String string2 = "";
        if (commandLocation.getCommandTitle() != null) {
            string2 = commandLocation.getCommandTitle();
        }
        if (commandLocation.getVersionNumber() == null || commandLocation.getVersionNumber() < 2) {
            if (MenuLocationDialog.runMenuLocationDialog(jFrame, commandLocation)) {
                builderCanvas.fireSelectionChange(canvasObject);
                ((BuilderFrame)jFrame).setModified(true);
            }
        } else if (MenuLocationDialogEx.runMenuLocationDialog(jFrame, commandLocation)) {
            if (((BuilderFrame)jFrame).isDlgMenuExist(commandLocation.getCommandActionId(), commandLocation, true)) {
                commandLocation.setCommandPath(string);
                commandLocation.setCommandTitle(string2);
                BuilderAlertPane.showWarningMessageDialog((Window)jFrame, (String)BuilderResUtil.getString((String)"IDS_DUPLICATE_DLG_MENU_LOCATION_WARNING"), (String)BuilderUtil.getInstance().getAppVersionString());
                return;
            }
            builderCanvas.fireSelectionChange(canvasObject);
            ((BuilderFrame)jFrame).setModified(true);
        }
    }

    public void removeBuilderFrame(JFrame jFrame) {
        SpssFrameMgr.getSpssFrameMgr().removeNonDocumentFrame(jFrame);
    }

    public void openDeployedSpecification() {
    }

    public String getMenuName(String string) {
        return ResUtil.getString(string);
    }

    public void setConvertDontShowSetting(boolean bl) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings/dont_show_enhanced_CDB_convert_warning");
        preferences2.putBoolean("dont_show_enhanced_CDB_convert_warning", bl);
    }

    public boolean showConvertAlert() {
        boolean bl = false;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings/dont_show_enhanced_CDB_convert_warning");
        boolean bl2 = preferences2.getBoolean("dont_show_enhanced_CDB_convert_warning", false);
        if (bl2 || CommandLine.isClementineCaller()) {
            bl = true;
        }
        return !bl;
    }

    public void setExtPropDontShow(boolean bl) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings/dont_show_extension_property_dialog_warning");
        preferences2.putBoolean("dont_show_extension_property_dialog_warning", bl);
    }

    public boolean showExtPropAlert() {
        boolean bl = false;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings/dont_show_extension_property_dialog_warning");
        boolean bl2 = preferences2.getBoolean("dont_show_extension_property_dialog_warning", false);
        if (bl2 || CommandLine.isClementineCaller()) {
            bl = true;
        }
        return !bl;
    }

    public String getSaveFilePath(boolean bl, File file, DialogDefinition dialogDefinition, JFrame jFrame) {
        String string;
        FileFilter fileFilter;
        String string2;
        String string3 = "";
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false, false, true);
        String string4 = "";
        if (bl) {
            string2 = BuilderResUtil.getString((String)"IDS_SAVE_CLEF_DLG_TITLE");
            fileFilter = new UiPkgFilter();
            string4 = BuilderFrame.getBuilderSPDExpension();
        } else {
            string2 = BuilderResUtil.getString((String)"IDS_SAVE_SPE_DLG_TITLE");
            fileFilter = new SPEFilter();
            string4 = BuilderFrame.getSPEExpension();
        }
        remoteFileChooser.setDialogTitle(string2);
        remoteFileChooser.addChoosableFileFilter(fileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter(fileFilter);
        if (file != null) {
            string = file.getName();
            if (string.endsWith(UIPKG_FILE_EXT) && !bl) {
                string = string.substring(0, string.length() - UIPKG_FILE_EXT.length()) + SPDXPKG_FILE_EXT;
            }
        } else if (bl) {
            string = dialogDefinition.getDialogId() + string4;
        } else {
            String string5 = ((BuilderFrame)jFrame).getDefaultExtName();
            if (string5 == null || string5.length() == 0) {
                string5 = dialogDefinition.getDialogId();
            }
            string = string5 + string4;
        }
        if (string.endsWith(CFE_FILE_EXT)) {
            string = string.substring(0, string.lastIndexOf(CFE_FILE_EXT)) + "." + BuilderFrame.getBuilderPkgExtension();
        }
        ((BasicFileChooserUI)remoteFileChooser.getUI()).setFileName(string);
        int n = remoteFileChooser.showSaveDialog(jFrame);
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            string3 = remoteFileChooser.getSelectedFilePath();
            if (bl) {
                if (!string3.endsWith(UIPKG_FILE_EXT)) {
                    string3 = string3.endsWith(".") ? string3 + "spd" : string3 + UIPKG_FILE_EXT;
                }
            } else if (!string3.endsWith(SPEPKG_FILE_EXT)) {
                string3 = string3.endsWith(".") ? string3 + "spe" : string3 + SPEPKG_FILE_EXT;
            }
        }
        return string3;
    }

    public File getOpenFilePath(boolean bl, JFrame jFrame) {
        FileFilter fileFilter;
        String string;
        File file = null;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        if (bl) {
            string = BuilderResUtil.getString((String)"IDS_OPEN_CLEF_DLG_TITLE");
            fileFilter = new UiPkgFilter();
        } else {
            fileFilter = new SPEFilter();
            string = BuilderResUtil.getString((String)"IDS_OPEN_SPE_DLG_TITLE");
        }
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.addChoosableFileFilter(fileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter(fileFilter);
        int n = remoteFileChooser.showOpenDialog(jFrame);
        if (n == 0) {
            try {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                file = remoteFileChooser.getSelectedFile();
                PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
                if (pesFile != null) {
                    String string2 = PES_Repository.RetrieveFromPES((PesFile)pesFile);
                    file = pesFile.getCacheFile();
                    if (file == null) {
                        SpssAlertOptionPane.showWarningMessageDialog(jFrame, string2, VersionInfo.getAppVersionString());
                        return null;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SpssAlertOptionPane.showErrorMessageDialog(jFrame, BuilderResUtil.getString((String)"IDS_BAD_CLEF_FILE_MSG"), VersionInfo.getAppVersionString());
            }
        }
        return file;
    }

    public File getFilePath(int n, BaseDialog baseDialog, String string, String string2, String string3, String string4) {
        RemoteFileChooser remoteFileChooser;
        boolean bl = false;
        boolean bl2 = false;
        if (n == RemoteFileChooser.ChooserType.SaveFile.ordinal()) {
            remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
            bl = true;
        } else if (n == RemoteFileChooser.ChooserType.OpenFile.ordinal()) {
            remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, string4, false, false, true);
            bl2 = true;
        } else if (n == RemoteFileChooser.ChooserType.OpenFolder.ordinal()) {
            remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.Generic, string4, true);
        } else {
            return null;
        }
        remoteFileChooser.setDialogTitle(string);
        if (bl || bl2) {
            remoteFileChooser.setFileSelectionMode(0);
            RefFileFilter refFileFilter = new RefFileFilter(string3, string2);
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
            if (bl) {
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                if (string4.trim().length() != 0) {
                    remoteFileChooser.setCurrentDirectory(new File(string4));
                }
            } else {
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
            }
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        } else {
            remoteFileChooser.setSelectedFile(remoteFileChooser.getCurrentDirectory());
        }
        int n2 = bl ? remoteFileChooser.showSaveDialog((Component)baseDialog) : remoteFileChooser.showOpenDialog((Component)baseDialog);
        if (n2 == 0) {
            return remoteFileChooser.getSelectedFile();
        }
        return null;
    }

    private String getFileNameExt(String string) {
        String string2 = "";
        if (string.lastIndexOf(".") >= 0 && string.lastIndexOf(".") < string.length() - 1) {
            string2 = string.substring(string.lastIndexOf(".") + 1);
        }
        return string2;
    }

    public String isDatasetNameValid(String string) {
        VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
        if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
            return "Bad dataset name";
        }
        if (DataMgr.getDataMgr().getDataSource(string) != null) {
            return "Duplicate dataset name";
        }
        return "";
    }

    public String getPESPath(File file) {
        String string = "";
        if (file != null) {
            PesFile pesFile;
            string = file.getAbsolutePath();
            if ((string = string.trim()) != null && string.length() > 0 && (pesFile = PES_Repository.getPesFile((String)string)) != null) {
                string = pesFile.getUri();
            }
        }
        return string;
    }

    public File getPESCacheFile(BaseDialog baseDialog, File file) {
        File file2 = file;
        PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
        if (pesFile != null) {
            String string = PES_Repository.RetrieveFromPES((PesFile)pesFile);
            file2 = pesFile.getCacheFile();
            if (file2 == null && string != null && string.length() > 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, string, VersionInfo.getAppVersionString());
            }
        }
        return file2;
    }

    private void handleDataselectorControl(FeatureImpl featureImpl, FeatureUI featureUI) {
        DefaultProperties defaultProperties = (DefaultProperties)featureImpl.getProperties();
        Set set = defaultProperties.propertyNames();
        Vector<DatasetSelectorControl> vector = new Vector<DatasetSelectorControl>();
        for (Object object : set) {
            Control control = ((SwingFeatureUI)featureUI).getControlManager().getControl((String)object);
            if (!(control instanceof DatasetSelectorControl)) continue;
            vector.add((DatasetSelectorControl)control);
        }
        if (vector.size() > 0) {
            Object object;
            Vector vector2 = new Vector();
            vector2.add("data1.sav[Dataset1]");
            object = new Vector();
            ((Vector)object).add("data2.sav[Dataset2]");
            for (DatasetSelectorControl datasetSelectorControl : vector) {
                LinkedList<CFEnum> linkedList = new LinkedList<CFEnum>();
                if (datasetSelectorControl.includeActiveDataset() && vector2.size() == 1) {
                    linkedList.add(new CFEnum(0, (String)vector2.get(0) + "*"));
                }
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    linkedList.add(new CFEnum(0, string));
                }
                datasetSelectorControl.setListItems(linkedList);
            }
        }
    }

    public void installExtensionBundle(File file, JFrame jFrame) {
        InstallExtensionBundle installExtensionBundle = new InstallExtensionBundle(jFrame);
        installExtensionBundle.doInstall(file);
    }

    class SPEFilter
    extends FileFilter {
        SPEFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return DialogExecutor.SPEPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - DialogExecutor.SPEPKG_FILE_EXT.length(), DialogExecutor.SPEPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString((String)"IDS_SPE_FILE_DESC_STATS");
        }
    }

    class SPDXFilter
    extends FileFilter {
        SPDXFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return DialogExecutor.SPDXPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - DialogExecutor.SPDXPKG_FILE_EXT.length(), DialogExecutor.SPDXPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString((String)"IDS_SPDX_FILE_DESC");
        }
    }

    class UiPkgFilter
    extends FileFilter {
        UiPkgFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return DialogExecutor.UIPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - DialogExecutor.UIPKG_FILE_EXT.length(), DialogExecutor.UIPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString((String)"IDS_PKG_FILE_DESC");
        }
    }
}

