/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.custom_gui.ListBoxItem;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SpssTextArea;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.DefinitionUtil;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.ControlDefinition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.EditCtrlDefinition;
import com.spss.uitools.ui_builder.definition.FileSystemBrowserDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.SrcListDefinition;
import com.spss.uitools.ui_builder.definition.StaticCtrlDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import com.spss.uitools.ui_builder.definition.VarListDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;

public class DialogBuilder {
    private static final int COLUMN_COUNT = 2;
    private boolean mUseColumnPanels = true;
    private Vector<FocusContainer> mFocusItems = new Vector();
    private ControllerCheckListener mControllerCheckListener = null;
    private LinkedList<Object> mFocusList;
    private DialogDefinition mDlgDef = null;
    private HashMap<String, String> mListAssociations;

    public static JComponent findComponent(JComponent jComponent, Class<?> clazz) {
        JComponent jComponent2 = null;
        for (Component component : jComponent.getComponents()) {
            if (component.getClass().equals(clazz)) {
                jComponent2 = (JComponent)component;
                break;
            }
            if ((component.getClass().equals(JPanel.class) || component.getClass().equals(JScrollPane.class) || component.getClass().equals(JViewport.class)) && (jComponent2 = DialogBuilder.findComponent((JComponent)component, clazz)) != null) break;
        }
        return jComponent2;
    }

    public static JComponent findComponentByName(JComponent jComponent, String string) {
        JComponent jComponent2 = null;
        for (Component component : jComponent.getComponents()) {
            String string2 = component.getName();
            if (string2 != null && string2.equals(string)) {
                jComponent2 = (JComponent)component;
                break;
            }
            if ((component instanceof JPanel || component.getClass().equals(JScrollPane.class) || component.getClass().equals(JViewport.class)) && (jComponent2 = DialogBuilder.findComponentByName((JComponent)component, string)) != null) break;
        }
        return jComponent2;
    }

    public Vector<Object> buildMainPanel(JPanel jPanel, DialogDefinition dialogDefinition) {
        Cloneable cloneable;
        this.mListAssociations = new HashMap();
        PanelDefinition panelDefinition = dialogDefinition.getCurrentPanel();
        this.mFocusList = new LinkedList();
        this.mDlgDef = dialogDefinition;
        if (this.mUseColumnPanels) {
            cloneable = new GridBagConstraints();
            cloneable.gridx = 0;
            cloneable.gridy = 0;
            cloneable.weightx = 0.0;
            cloneable.weighty = 1.0;
            cloneable.fill = 1;
            cloneable.anchor = 23;
            for (int i = 0; i < 2; ++i) {
                cloneable.gridx = i;
                cloneable.weightx = 1.0;
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                jPanel.add((Component)jPanel2, cloneable);
                this.mFocusItems.clear();
                int n = i < 1 || !dialogDefinition.hasTargetList() ? i : i + 1;
                LinkedList<PanelElementDefinition> linkedList = this.getColumnItems(panelDefinition, n);
                for (PanelElementDefinition panelElementDefinition : linkedList) {
                    this.buildPanelElement(jPanel2, (PanelElementDefinition)panelDefinition, panelElementDefinition);
                }
                this.sortFocusList(this.mFocusItems, this.mFocusList);
            }
        } else {
            for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
                this.buildPanelElement(jPanel, (PanelElementDefinition)panelDefinition, panelElementDefinition);
            }
        }
        cloneable = new Vector<Object>(this.mFocusList);
        this.mFocusList = null;
        this.addListListeners(jPanel);
        return cloneable;
    }

    private void sortFocusList(Vector<FocusContainer> vector, LinkedList<Object> linkedList) {
        int n = 0;
        int n2 = 0;
        if (vector.size() == 2) {
            FocusContainer focusContainer = vector.get(0);
            FocusContainer focusContainer2 = vector.get(1);
            if (focusContainer.getFocusTarget() instanceof JTextField && focusContainer2.getFocusTarget() instanceof JButton) {
                linkedList.add(focusContainer.getFocusTarget());
                linkedList.add(focusContainer2.getFocusTarget());
                return;
            }
        }
        while (n < vector.size() && n2 < 100) {
            for (FocusContainer focusContainer2 : vector) {
                GridBagConstraints gridBagConstraints = focusContainer2.getGbc();
                if (gridBagConstraints.gridy != n2) continue;
                Object object = focusContainer2.getFocusTarget();
                if (object == null) {
                    this.sortFocusList(focusContainer2.getSubItems(), linkedList);
                } else {
                    linkedList.add(object);
                }
                ++n;
            }
            ++n2;
        }
    }

    private LinkedList<PanelElementDefinition> getColumnItems(PanelDefinition panelDefinition, int n) {
        LinkedList<PanelElementDefinition> linkedList = new LinkedList<PanelElementDefinition>();
        for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
            if (panelElementDefinition.getConstraints().gridx != n) continue;
            linkedList.add(panelElementDefinition);
        }
        return linkedList;
    }

    private JComponent buildPanelElement(JPanel jPanel, PanelElementDefinition panelElementDefinition, PanelElementDefinition panelElementDefinition2) {
        JComponent jComponent = null;
        try {
            boolean bl = panelElementDefinition instanceof CheckBoxGroupDefinition && this.mControllerCheckListener != null;
            GridBagConstraints gridBagConstraints = (GridBagConstraints)panelElementDefinition2.getConstraints().clone();
            if (panelElementDefinition2 instanceof CheckBoxGroupDefinition) {
                jComponent = this.buildCheckboxGroupPanel((CheckBoxGroupDefinition)panelElementDefinition2);
            } else if (panelElementDefinition2 instanceof PanelDefinition) {
                jComponent = this.buildSubPanel((PanelDefinition)panelElementDefinition2);
            } else if (panelElementDefinition2 instanceof CheckBoxDefinition) {
                jComponent = this.processCheckbox(jPanel, panelElementDefinition2, bl);
            } else if (panelElementDefinition2 instanceof ComboBoxDefinition) {
                jComponent = this.processComboBox((ComboBoxDefinition)panelElementDefinition2);
            } else if (panelElementDefinition2 instanceof ListBoxDefinition) {
                jComponent = this.processListBox((ListBoxDefinition)panelElementDefinition2);
            } else if (panelElementDefinition2 instanceof EditCtrlDefinition) {
                jComponent = this.processEditCtrl((EditCtrlDefinition)panelElementDefinition2);
            } else {
                if (panelElementDefinition2 instanceof RadioGroupDefinition) {
                    return this.processRadioGroup(jPanel, (RadioGroupDefinition)panelElementDefinition2, bl, gridBagConstraints);
                }
                if (panelElementDefinition2 instanceof SrcListDefinition) {
                    jComponent = this.makeVariableList(jPanel, panelElementDefinition2);
                } else if (panelElementDefinition2 instanceof StaticCtrlDefinition) {
                    jComponent = this.makeStaticText((StaticCtrlDefinition)panelElementDefinition2, bl);
                } else if (panelElementDefinition2 instanceof TargetListDefinition) {
                    jComponent = this.makeVariableList(jPanel, panelElementDefinition2);
                } else {
                    if (panelElementDefinition2 instanceof SubDlgButtonDefinition) {
                        return null;
                    }
                    if (panelElementDefinition2 instanceof FileSystemBrowserDefinition) {
                        jComponent = this.makeFileSystemBrowser((FileSystemBrowserDefinition)panelElementDefinition2);
                    } else {
                        assert (false);
                        return null;
                    }
                }
            }
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        return jComponent;
    }

    private JComponent processCheckbox(JPanel jPanel, PanelElementDefinition panelElementDefinition, boolean bl) {
        String string = panelElementDefinition.getTitle();
        JCheckBox jCheckBox = string.indexOf("\\n") > -1 ? new SpssMultiLineCheckBox(new CustomToggleButtonAction((ControlDefinition)((CheckBoxDefinition)panelElementDefinition)), -1) : new JCheckBox(new CustomToggleButtonAction((ControlDefinition)((CheckBoxDefinition)panelElementDefinition)));
        jCheckBox.setSelected(((CheckBoxDefinition)panelElementDefinition).getDefaultState());
        jCheckBox.setName(panelElementDefinition.getControlId());
        this.mFocusItems.add(new FocusContainer(panelElementDefinition.getConstraints(), jCheckBox));
        if (bl) {
            if (jPanel.getComponentCount() == 0) {
                jCheckBox.addItemListener(this.mControllerCheckListener);
            } else {
                this.mControllerCheckListener.addSubordinateItem(jCheckBox);
            }
        }
        return jCheckBox;
    }

    private JComponent buildCheckboxGroupPanel(CheckBoxGroupDefinition checkBoxGroupDefinition) {
        this.mControllerCheckListener = new ControllerCheckListener();
        JPanel jPanel = this.buildSubPanel((PanelDefinition)checkBoxGroupDefinition);
        Component component = jPanel.getComponent(0);
        if (component instanceof JCheckBox) {
            this.mControllerCheckListener.updateState(((JCheckBox)component).isSelected());
        }
        this.mControllerCheckListener = null;
        return jPanel;
    }

    private JComponent processComboBox(ComboBoxDefinition comboBoxDefinition) {
        Object object;
        Object object22;
        Serializable serializable;
        JComboBox jComboBox;
        GridBagConstraints gridBagConstraints = comboBoxDefinition.getConstraints();
        if (comboBoxDefinition.isDynamicSourceType()) {
            jComboBox = new JComboBox();
            this.mListAssociations.put(comboBoxDefinition.getControlId(), comboBoxDefinition.getTargetListId());
        } else {
            serializable = new Vector();
            for (Object object22 : comboBoxDefinition.getListItems()) {
                ((Vector)serializable).add(new ListBoxItem(object22.getTitle(), object22.getSyntax()));
            }
            object = new DefaultComboBoxModel(serializable);
            jComboBox = new JComboBox(object);
            jComboBox.setSelectedIndex(comboBoxDefinition.getDefaultSelectionIndex());
        }
        serializable = jComboBox;
        jComboBox.setName(comboBoxDefinition.getControlId());
        jComboBox.setAction(new ComboboxAction(null, comboBoxDefinition.getControlId()));
        this.mFocusItems.add(new FocusContainer(gridBagConstraints, jComboBox));
        object = comboBoxDefinition.getTip();
        if (object != null && ((String)object).length() > 0) {
            jComboBox.setToolTipText((String)object);
        }
        if ((object22 = comboBoxDefinition.getTitle()) != null && ((String)object22).length() > 0) {
            serializable = this.buildLabeledComponentPanel((PanelElementDefinition)comboBoxDefinition, (String)object22, jComboBox);
        } else if (this.mControllerCheckListener != null) {
            this.mControllerCheckListener.addSubordinateItem((JComponent)serializable);
        }
        if (object != null && ((String)object).length() > 0) {
            ((JComponent)serializable).setToolTipText((String)object);
        }
        return serializable;
    }

    private JComponent processListBox(ListBoxDefinition listBoxDefinition) {
        String string;
        GridBagConstraints gridBagConstraints = listBoxDefinition.getConstraints();
        DefaultListModel<ListBoxItem> defaultListModel = new DefaultListModel<ListBoxItem>();
        PlainList plainList = new PlainList(defaultListModel, listBoxDefinition.getControlId(), PlainList.DragType.eNoAutoDrag);
        if (listBoxDefinition.isDynamicSourceType()) {
            this.mListAssociations.put(listBoxDefinition.getControlId(), listBoxDefinition.getTargetListId());
        } else {
            for (ListDefinition.ListItem listItem : listBoxDefinition.getListItems()) {
                defaultListModel.addElement(new ListBoxItem(listItem.getTitle(), listItem.getSyntax()));
            }
            plainList.setSelectedIndex(listBoxDefinition.getDefaultSelectionIndex());
            this.updateSelectionState(plainList);
        }
        if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.single_select) {
            plainList.setSelectionMode(0);
        } else {
            plainList.setSelectionMode(2);
        }
        if (listBoxDefinition.getSelectionType() == ListBoxDefinition.SelectionType.checkbox_select) {
            plainList.setCellRenderer(new CheckboxCellRenderer());
        } else {
            plainList.setCellRenderer(new ListBoxCellRenderer());
        }
        plainList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isConsumed() || mouseEvent.getClickCount() > 1) {
                    return;
                }
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                boolean bl = jList.getCellRenderer() instanceof JCheckBox;
                if (bl) {
                    DialogBuilder.this.handleCheckBoxClick(jList, n, mouseEvent.getPoint().x);
                } else {
                    DialogBuilder.this.updateSelectionState(jList);
                }
                mouseEvent.consume();
            }
        });
        plainList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    JList jList = (JList)keyEvent.getSource();
                    int n = jList.getLeadSelectionIndex();
                    boolean bl = jList.getCellRenderer() instanceof JCheckBox;
                    if (bl) {
                        DialogBuilder.this.handleCheckBoxSelect(jList, n);
                    } else {
                        DialogBuilder.this.updateSelectionState(jList);
                    }
                }
            }
        });
        plainList.setPrototypeCellValue(new ListBoxItem("123-45-6789"));
        int n = plainList.getFixedCellHeight();
        n = n < 18 ? 18 : n;
        plainList.setFixedCellHeight(n);
        JScrollPane jScrollPane = new JScrollPane(plainList);
        jScrollPane.setAlignmentX(0.0f);
        plainList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), plainList.getFixedCellHeight() * 4 + 2));
        jScrollPane.setPreferredSize(plainList.getMinimumSize());
        JComponent jComponent = jScrollPane;
        plainList.setName(listBoxDefinition.getControlId());
        this.mFocusItems.add(new FocusContainer(gridBagConstraints, plainList));
        String string2 = listBoxDefinition.getTip();
        if (string2 != null && string2.length() > 0) {
            plainList.setToolTipText(string2);
        }
        if ((string = listBoxDefinition.getTitle()) != null && string.length() > 0) {
            jComponent = this.buildLabeledComponentPanel((PanelElementDefinition)listBoxDefinition, string, jComponent);
        } else if (this.mControllerCheckListener != null) {
            this.mControllerCheckListener.addSubordinateItem(jComponent);
        }
        if (string2 != null && string2.length() > 0) {
            jComponent.setToolTipText(string2);
        }
        return jComponent;
    }

    private void handleCheckBoxClick(JList jList, int n, int n2) {
        ListBoxItem listBoxItem;
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (n2 < rectangle.x || n2 > rectangle.x + 20) {
            return;
        }
        listBoxItem.setSelected(!(listBoxItem = (ListBoxItem)jList.getModel().getElementAt(n)).isSelected());
        jList.repaint(rectangle);
    }

    private void handleCheckBoxSelect(JList jList, int n) {
        ListBoxItem listBoxItem;
        listBoxItem.setSelected(!(listBoxItem = (ListBoxItem)jList.getModel().getElementAt(n)).isSelected());
        jList.repaint(jList.getCellBounds(n, n));
    }

    private void updateSelectionState(JList jList) {
        int[] nArray = jList.getSelectedIndices();
        for (int i = 0; i < jList.getModel().getSize(); ++i) {
            boolean bl = false;
            ListBoxItem listBoxItem = (ListBoxItem)jList.getModel().getElementAt(i);
            for (int n : nArray) {
                if (n != i) continue;
                bl = true;
                break;
            }
            listBoxItem.setSelected(bl);
        }
    }

    private void addListListeners(JComponent jComponent) {
        for (Map.Entry<String, String> entry : this.mListAssociations.entrySet()) {
            JComponent jComponent2 = DialogBuilder.findComponentByName(jComponent, entry.getKey());
            JComponent jComponent3 = DialogBuilder.findComponentByName(jComponent, entry.getValue());
            if (jComponent2 == null || !(jComponent3 instanceof TargetVariableList)) continue;
            TargetVariableList targetVariableList = (TargetVariableList)jComponent3;
            targetVariableList.getModel().addListDataListener(new ListListener(targetVariableList, jComponent2));
        }
    }

    private void updateListbox(TargetVariableList targetVariableList, JComponent jComponent) {
        PanelElementDefinition panelElementDefinition = DefinitionUtil.findPanelItem((DialogDefinition)this.mDlgDef, (String)jComponent.getName());
        if (jComponent instanceof JComboBox && panelElementDefinition instanceof ComboBoxDefinition) {
            JComboBox jComboBox = (JComboBox)jComponent;
            ComboBoxDefinition comboBoxDefinition = (ComboBoxDefinition)panelElementDefinition;
            if (comboBoxDefinition.getSourceType() == ListDefinition.ValueSourceType.variable_names) {
                this.loadVariableNames(targetVariableList, jComboBox);
            } else if (comboBoxDefinition.getSourceType() == ListDefinition.ValueSourceType.value_labels) {
                this.loadValueLabels(targetVariableList, jComboBox);
            } else if (comboBoxDefinition.getSourceType() == ListDefinition.ValueSourceType.custom_attribute) {
                this.loadCustomAttrValues(targetVariableList, jComboBox, comboBoxDefinition);
            }
            if (jComboBox.getModel().getSize() > 0) {
                jComboBox.setSelectedIndex(0);
            }
        } else if (jComponent instanceof JList && panelElementDefinition instanceof ListBoxDefinition) {
            JList jList = (JList)jComponent;
            ListBoxDefinition listBoxDefinition = (ListBoxDefinition)panelElementDefinition;
            if (listBoxDefinition.getSourceType() == ListDefinition.ValueSourceType.variable_names) {
                this.loadVariableNames(targetVariableList, jList);
            } else if (listBoxDefinition.getSourceType() == ListDefinition.ValueSourceType.value_labels) {
                this.loadValueLabels(targetVariableList, jList);
            } else if (listBoxDefinition.getSourceType() == ListDefinition.ValueSourceType.custom_attribute) {
                this.loadCustomAttrValues(targetVariableList, jList, listBoxDefinition);
            }
            if (jList.getModel().getSize() > 0) {
                boolean bl = jList.getCellRenderer() instanceof JCheckBox;
                if (!bl) {
                    this.updateSelectionState(jList);
                } else {
                    jList.setSelectedIndex(0);
                }
            }
        }
    }

    private void loadVariableNames(TargetVariableList targetVariableList, JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        String string = object != null ? object.toString() : null;
        jComboBox.removeAllItems();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            jComboBox.addItem(iSpssVariable.getName());
        }
        jComboBox.setSelectedItem(string);
    }

    private void loadValueLabels(TargetVariableList targetVariableList, JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        String string = object != null ? object.toString() : null;
        jComboBox.removeAllItems();
        TreeSet treeSet = new TreeSet();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            Set set = iSpssVariable.getValueLabels().getValueLabelEntries();
            for (Map.Entry entry : set) {
                treeSet.add(entry.getValue());
            }
        }
        for (Object object2 : treeSet) {
            jComboBox.addItem(object2);
        }
        jComboBox.setSelectedItem(string);
    }

    private void loadCustomAttrValues(TargetVariableList targetVariableList, JComboBox jComboBox, ComboBoxDefinition comboBoxDefinition) {
        Object object = jComboBox.getSelectedItem();
        String string = object != null ? object.toString() : null;
        jComboBox.removeAllItems();
        TreeSet treeSet = new TreeSet();
        String string2 = comboBoxDefinition.getCustomAttrName();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            Vector vector = iSpssVariable.getAttributeValues(string2);
            if (vector == null) continue;
            treeSet.addAll(vector);
        }
        for (String string3 : treeSet) {
            jComboBox.addItem(string3);
        }
        jComboBox.setSelectedItem(string);
    }

    private void loadVariableNames(TargetVariableList targetVariableList, JList jList) {
        Object[] objectArray = jList.getSelectedValues();
        int n = jList.getModel().getSize();
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = jList.getModel().getElementAt(i);
        }
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.removeAllElements();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            defaultListModel.addElement(new ListBoxItem(iSpssVariable.getName()));
        }
        this.reselectListItems(jList, objectArray, defaultListModel, objectArray2);
    }

    private void loadValueLabels(TargetVariableList targetVariableList, JList jList) {
        Object[] objectArray = jList.getSelectedValues();
        int n = jList.getModel().getSize();
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = jList.getModel().getElementAt(i);
        }
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.removeAllElements();
        TreeSet treeSet = new TreeSet();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            Set set = iSpssVariable.getValueLabels().getValueLabelEntries();
            for (Map.Entry entry : set) {
                treeSet.add(entry.getValue());
            }
        }
        for (Object object : treeSet) {
            defaultListModel.addElement(new ListBoxItem((String)object));
        }
        this.reselectListItems(jList, objectArray, defaultListModel, objectArray2);
    }

    private void loadCustomAttrValues(TargetVariableList targetVariableList, JList jList, ListBoxDefinition listBoxDefinition) {
        Object[] objectArray = jList.getSelectedValues();
        int n = jList.getModel().getSize();
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = jList.getModel().getElementAt(i);
        }
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.removeAllElements();
        TreeSet treeSet = new TreeSet();
        String string = listBoxDefinition.getCustomAttrName();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            Vector vector = iSpssVariable.getAttributeValues(string);
            if (vector == null) continue;
            treeSet.addAll(vector);
        }
        for (String string2 : treeSet) {
            defaultListModel.addElement(new ListBoxItem(string2));
        }
        this.reselectListItems(jList, objectArray, defaultListModel, objectArray2);
    }

    private void reselectListItems(JList jList, Object[] objectArray, DefaultListModel defaultListModel, Object[] objectArray2) {
        int n;
        for (Object object : objectArray2) {
            if (!(object instanceof ListBoxItem)) continue;
            ListBoxItem listBoxItem = (ListBoxItem)object;
            n = defaultListModel.indexOf(object);
            if (n <= -1) continue;
            ((ListBoxItem)defaultListModel.get(n)).setSelected(listBoxItem.isSelected());
        }
        for (Object object : objectArray) {
            if (!(object instanceof ListBoxItem) || (n = defaultListModel.indexOf(object)) <= -1) continue;
            jList.addSelectionInterval(n, n);
        }
        if (jList.getSelectedValue() == null && defaultListModel.size() > 0) {
            jList.setSelectedIndex(0);
        }
    }

    private JComponent processEditCtrl(EditCtrlDefinition editCtrlDefinition) {
        String string;
        String string2;
        Object object;
        Object object2;
        if (editCtrlDefinition.isMultiLine()) {
            object2 = new SpssTextArea(ComponentState.getCurrentCharset());
        } else {
            object = editCtrlDefinition.getParseType();
            if (object == EditCtrlDefinition.ParseType.integer) {
                double d = editCtrlDefinition.getMinValue();
                d = Double.isNaN(d) ? -2.147483648E9 : d;
                double d2 = editCtrlDefinition.getMaxValue();
                d2 = Double.isNaN(d2) ? 2.147483647E9 : d2;
                object2 = new IntTextField((int)d, (int)d2);
            } else if (object == EditCtrlDefinition.ParseType.number) {
                object2 = new FloatTextField(editCtrlDefinition.getMinValue(), editCtrlDefinition.getMaxValue(), 6);
                if (Double.isNaN(editCtrlDefinition.getMinValue())) {
                    ((FloatTextField)object2).setIncludeMinRange(false);
                }
                if (Double.isNaN(editCtrlDefinition.getMaxValue())) {
                    ((FloatTextField)object2).setIncludeMaxRange(false);
                }
            } else {
                object2 = new StringTextField();
            }
            if (ComponentState.isBtdRtlOrLtr() && editCtrlDefinition.getDefaultValue() != null && editCtrlDefinition.getDefaultValue() instanceof String && editCtrlDefinition.getDefaultValue().length() > 0) {
                ((JTextField)object2).setText(ComponentState.prepareStringForBidiRendering((String)editCtrlDefinition.getDefaultValue()));
            } else {
                ((JTextField)object2).setText(editCtrlDefinition.getDefaultValue());
            }
            ((JTextField)object2).setAction(new TextFieldAction(null, editCtrlDefinition.getControlId()));
            if (object == EditCtrlDefinition.ParseType.variableName) {
                ((Component)object2).addFocusListener(new VarNameFocusListener((JTextField)object2));
            }
        }
        ((Component)object2).setName(editCtrlDefinition.getControlId());
        object = editCtrlDefinition.getConstraints();
        this.mFocusItems.add(new FocusContainer((GridBagConstraints)object, object2));
        Dimension dimension = ((JComponent)object2).getPreferredSize();
        if (dimension.width < 60) {
            dimension.width = 60;
            ((JComponent)object2).setPreferredSize(dimension);
        }
        if ((string2 = editCtrlDefinition.getTip()) != null && string2.length() > 0) {
            ((JComponent)object2).setToolTipText(string2);
        }
        if ((string = editCtrlDefinition.getTitle()) != null && string.length() > 0) {
            object2 = this.buildLabeledComponentPanel((PanelElementDefinition)editCtrlDefinition, string, (JComponent)object2);
        } else if (this.mControllerCheckListener != null) {
            this.mControllerCheckListener.addSubordinateItem((JComponent)object2);
        }
        if (string2 != null && string2.length() > 0) {
            ((JComponent)object2).setToolTipText(string2);
        }
        return object2;
    }

    private JComponent buildLabeledComponentPanel(PanelElementDefinition panelElementDefinition, String string, JComponent jComponent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.createStaticControl(string, panelElementDefinition.getMnemonicKey());
        jLabel.setLabelFor(jComponent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        if (this.mControllerCheckListener != null) {
            this.mControllerCheckListener.addSubordinateItem(jLabel);
        }
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        boolean bl = jComponent instanceof JScrollPane;
        if (bl) {
            gridBagConstraints.fill = 1;
        }
        jPanel.add((Component)jComponent, gridBagConstraints);
        if (this.mControllerCheckListener != null) {
            this.mControllerCheckListener.addSubordinateItem(jComponent);
        }
        jComponent = jPanel;
        return jComponent;
    }

    private void addArrowButton(JPanel jPanel, TargetVariableList targetVariableList, TargetListDefinition targetListDefinition) {
        ArrowButton arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        JComponent jComponent = this.mUseColumnPanels ? (JComponent)jPanel.getParent() : jPanel;
        SrcVariableList srcVariableList = (SrcVariableList)DialogBuilder.findComponent(jComponent, SrcVariableList.class);
        if (srcVariableList != null) {
            arrowButton.registerVariableList(srcVariableList, SpssArrowButton.ButtonOrientation.right);
            targetVariableList.setDragType(srcVariableList.getDragType());
        }
        arrowButton.registerVariableList(targetVariableList, SpssArrowButton.ButtonOrientation.left);
        boolean bl = !targetListDefinition.isMultiItemList();
        GridBagConstraints gridBagConstraints = (GridBagConstraints)targetListDefinition.getConstraints().clone();
        --gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = targetListDefinition.getConstraints().weighty;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = bl ? 19 : 10;
        Insets insets = (Insets)DialogUtil.getArrowButtonInsets().clone();
        if (bl) {
            insets.bottom = 0;
        }
        gridBagConstraints.insets = insets;
        jPanel.add((Component)arrowButton, gridBagConstraints);
        this.mFocusList.add(arrowButton);
    }

    private JComponent makeVariableList(JPanel jPanel, PanelElementDefinition panelElementDefinition) {
        JScrollPane jScrollPane;
        VariableList variableList;
        String string;
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        String string2 = panelElementDefinition.getTitle();
        if (string2.length() == 0 && panelElementDefinition instanceof SrcListDefinition) {
            string2 = " ";
        }
        if ((string = panelElementDefinition.getTip()).length() > 0) {
            jPanel2.setToolTipText(string);
        }
        JLabel jLabel = this.createStaticControl(string2, panelElementDefinition.getMnemonicKey());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        int n = this.getFilterFlags((VarListDefinition)panelElementDefinition);
        if (panelElementDefinition instanceof SrcListDefinition) {
            SrcListDefinition.TransferOp transferOp = ((SrcListDefinition)panelElementDefinition).getTransferOp();
            VariableList.VarMoveType varMoveType = transferOp == SrcListDefinition.TransferOp.move ? VariableList.VarMoveType.eMoveOriginal : VariableList.VarMoveType.eKeepOriginal;
            variableList = new SrcVariableList(varMoveType);
            GridBagConstraints gridBagConstraints2 = panelElementDefinition.getConstraints();
            this.mFocusItems.add(new FocusContainer(gridBagConstraints2, variableList));
            jLabel.setLabelFor(variableList);
            variableList.addVarFilter(new SpssVarFilter(n, false, true));
            jScrollPane = new JScrollPane(variableList);
            jScrollPane.setPreferredSize(variableList.getMinimumSize());
            jScrollPane.setAlignmentX(0.0f);
        } else if (panelElementDefinition instanceof TargetListDefinition) {
            boolean bl = ((TargetListDefinition)panelElementDefinition).isMultiItemList();
            TargetVariableList.TargetListType targetListType = bl ? TargetVariableList.TargetListType.normal : TargetVariableList.TargetListType.single_item;
            variableList = new TargetVariableList(targetListType, VariableList.VarMoveType.eMoveOriginal);
            GridBagConstraints gridBagConstraints3 = panelElementDefinition.getConstraints();
            this.mFocusItems.add(new FocusContainer(gridBagConstraints3, variableList));
            jLabel.setLabelFor(variableList);
            variableList.addVarFilter(new SpssVarFilter(n, false, true));
            if (!bl) {
                gridBagConstraints.fill = 2;
            }
            this.addArrowButton(jPanel, (TargetVariableList)variableList, (TargetListDefinition)panelElementDefinition);
            jScrollPane = new JScrollPane(variableList);
            jScrollPane.setAlignmentX(0.0f);
            if (targetListType == TargetVariableList.TargetListType.single_item) {
                jScrollPane.setHorizontalScrollBarPolicy(31);
                jScrollPane.setVerticalScrollBarPolicy(21);
            } else {
                variableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), variableList.getFixedCellHeight() * 6 + 2));
            }
            jScrollPane.setPreferredSize(variableList.getMinimumSize());
        } else {
            assert (false);
            return null;
        }
        variableList.setName(panelElementDefinition.getControlId());
        variableList.setIdentifier(panelElementDefinition.getControlId());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        return jPanel2;
    }

    private int getFilterFlags(VarListDefinition varListDefinition) {
        int n = 0;
        boolean bl = varListDefinition.isIncluded(VarListDefinition.NUMERIC_BIT);
        boolean bl2 = varListDefinition.isIncluded(VarListDefinition.DATETIME_BIT);
        boolean bl3 = varListDefinition.isIncluded(VarListDefinition.STRING_BIT);
        if (bl) {
            if (varListDefinition.isIncluded(VarListDefinition.NOMINAL_BIT)) {
                n |= 0x1000;
            }
            if (varListDefinition.isIncluded(VarListDefinition.ORDINAL_BIT)) {
                n |= 0x100;
            }
            if (varListDefinition.isIncluded(VarListDefinition.SCALE_BIT)) {
                n |= 0x10000;
            }
        }
        if (bl2) {
            if (varListDefinition.isIncluded(VarListDefinition.NOMINAL_BIT)) {
                n |= 0x6000;
            }
            if (varListDefinition.isIncluded(VarListDefinition.ORDINAL_BIT)) {
                n |= 0x600;
            }
            if (varListDefinition.isIncluded(VarListDefinition.SCALE_BIT)) {
                n |= 0x60000;
            }
        }
        if (bl3) {
            if (varListDefinition.isIncluded(VarListDefinition.NOMINAL_BIT)) {
                n |= 0x800;
            }
            if (varListDefinition.isIncluded(VarListDefinition.ORDINAL_BIT)) {
                n |= 0x80;
            }
            if (varListDefinition.isIncluded(VarListDefinition.SCALE_BIT)) {
                n |= 0x8000;
            }
        }
        return n |= varListDefinition.isIncluded(VarListDefinition.MRVARS_BIT) ? 524288 : 0;
    }

    static boolean isIncluded(VarListDefinition varListDefinition, ISpssVariable iSpssVariable) {
        if (iSpssVariable instanceof SpssMRVariable) {
            return varListDefinition.isIncluded(VarListDefinition.MRVARS_BIT);
        }
        MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
        if (measurementLevel == MeasurementLevel.nominal && !varListDefinition.isIncluded(VarListDefinition.NOMINAL_BIT)) {
            return false;
        }
        if (measurementLevel == MeasurementLevel.ordinal && !varListDefinition.isIncluded(VarListDefinition.ORDINAL_BIT)) {
            return false;
        }
        if (measurementLevel == MeasurementLevel.scale && !varListDefinition.isIncluded(VarListDefinition.SCALE_BIT)) {
            return false;
        }
        short s = iSpssVariable.getType();
        if (s != 0 && !varListDefinition.isIncluded(VarListDefinition.STRING_BIT)) {
            return false;
        }
        if (s == 0) {
            FormatType formatType = iSpssVariable.getFormat().getFormatType();
            if (formatType.isDateOrTimeFormat() && !varListDefinition.isIncluded(VarListDefinition.DATETIME_BIT)) {
                return false;
            }
            if (!formatType.isDateOrTimeFormat() && !varListDefinition.isIncluded(VarListDefinition.NUMERIC_BIT)) {
                return false;
            }
        }
        return true;
    }

    private JPanel buildSubPanel(PanelDefinition panelDefinition) {
        JPanel2 jPanel2 = new JPanel2(new GridBagLayout(), true);
        jPanel2.setName(panelDefinition.getControlId());
        if (panelDefinition.getTitle().length() > 0) {
            jPanel2.setBorder(BorderFactory.createTitledBorder(panelDefinition.getTitle()));
        } else {
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        FocusContainer focusContainer = new FocusContainer(panelDefinition.getConstraints(), null);
        this.mFocusItems.add(focusContainer);
        Vector<FocusContainer> vector = this.mFocusItems;
        this.mFocusItems = focusContainer.getSubItems();
        JPanel2 jPanel22 = jPanel2;
        for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
            this.buildPanelElement(jPanel2, (PanelElementDefinition)panelDefinition, panelElementDefinition);
        }
        this.mFocusItems = vector;
        return jPanel22;
    }

    private JLabel makeStaticControl(StaticCtrlDefinition staticCtrlDefinition, boolean bl) {
        JLabel jLabel = this.createStaticControl(staticCtrlDefinition.getTitle(), null);
        String string = staticCtrlDefinition.getTip();
        if (string != null && string.length() > 0) {
            jLabel.setToolTipText(string);
        }
        if (bl) {
            this.mControllerCheckListener.addSubordinateItem(jLabel);
        }
        return jLabel;
    }

    private JLabel createStaticControl(String string, Integer n) {
        JLabel jLabel;
        if (string.indexOf("\\n") == -1) {
            jLabel = new JLabel(string);
            if (n != null) {
                jLabel.setDisplayedMnemonic(n);
            }
        } else {
            jLabel = new SpssMultiLineLabel(string.replace("\\n", "\n"), n, -1);
        }
        return jLabel;
    }

    private FocusableTextArea makeStaticText(StaticCtrlDefinition staticCtrlDefinition, boolean bl) {
        FocusableTextArea focusableTextArea = this.createStaticText(staticCtrlDefinition.getTitle());
        String string = staticCtrlDefinition.getTip();
        if (string != null && string.length() > 0) {
            focusableTextArea.setToolTipText(string);
        }
        if (bl) {
            this.mControllerCheckListener.addSubordinateItem(focusableTextArea);
        }
        GridBagConstraints gridBagConstraints = staticCtrlDefinition.getConstraints();
        this.mFocusItems.add(new FocusContainer(gridBagConstraints, focusableTextArea));
        return focusableTextArea;
    }

    private FocusableTextArea createStaticText(String string) {
        String string2 = new String(string);
        if (string.indexOf("\\n") != -1) {
            string2 = string.replace("\\n", "\n");
        }
        FocusableTextArea focusableTextArea = new FocusableTextArea(string2, null);
        focusableTextArea.setLineWrap(false);
        return focusableTextArea;
    }

    private JComponent makeFileSystemBrowser(final FileSystemBrowserDefinition fileSystemBrowserDefinition) {
        String string;
        JPanel jPanel;
        String string2;
        boolean bl;
        GridBagConstraints gridBagConstraints = fileSystemBrowserDefinition.getConstraints();
        gridBagConstraints = (GridBagConstraints)gridBagConstraints.clone();
        Insets insets = PanelElementDefinition.getStandardInsets();
        int n = gridBagConstraints.insets.left - insets.left;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        FocusContainer focusContainer = new FocusContainer(fileSystemBrowserDefinition.getConstraints(), null);
        this.mFocusItems.add(focusContainer);
        Vector<FocusContainer> vector = this.mFocusItems;
        this.mFocusItems = focusContainer.getSubItems();
        final JTextField jTextField = new JTextField();
        jTextField.setAction(new TextFieldAction(null, fileSystemBrowserDefinition.getControlId()));
        jTextField.setName(fileSystemBrowserDefinition.getControlId());
        if (ComponentState.isBtdRtlOrLtr() && fileSystemBrowserDefinition.getDefaultValue() != null && fileSystemBrowserDefinition.getDefaultValue() instanceof String && fileSystemBrowserDefinition.getDefaultValue().length() > 0) {
            jTextField.setText(ComponentState.prepareStringForBidiRendering((String)fileSystemBrowserDefinition.getDefaultValue()));
        } else {
            jTextField.setText(fileSystemBrowserDefinition.getDefaultValue());
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DialogBuilder.this.updateFSBEditTooltip(fileSystemBrowserDefinition, jTextField);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DialogBuilder.this.updateFSBEditTooltip(fileSystemBrowserDefinition, jTextField);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DialogBuilder.this.updateFSBEditTooltip(fileSystemBrowserDefinition, jTextField);
            }
        });
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        GridBagConstraints gridBagConstraints2 = fileSystemBrowserDefinition.getConstraints();
        this.mFocusItems.add(new FocusContainer(gridBagConstraints2, jTextField));
        Dimension dimension = jTextField.getPreferredSize();
        if (dimension.width < 60) {
            dimension.width = 60;
            jTextField.setPreferredSize(dimension);
        }
        boolean bl2 = bl = (string2 = fileSystemBrowserDefinition.getTitle()) != null && string2.length() > 0;
        if (bl) {
            jPanel = (JPanel)this.buildLabeledComponentPanel((PanelElementDefinition)fileSystemBrowserDefinition, string2, jTextField);
        } else {
            jPanel = new JPanel(new GridBagLayout(), true);
            jPanel.setBorder(null);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jTextField, gridBagConstraints);
            if (this.mControllerCheckListener != null) {
                this.mControllerCheckListener.addSubordinateItem(jTextField);
            }
        }
        JButton jButton = new JButton(new BrowseButtonAction(fileSystemBrowserDefinition, jTextField));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = bl ? 2 : 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.mFocusItems.add(new FocusContainer(gridBagConstraints, jButton));
        if (this.mControllerCheckListener != null) {
            this.mControllerCheckListener.addSubordinateItem(jButton);
        }
        if ((string = fileSystemBrowserDefinition.getTip()) != null && string.length() > 0) {
            if (ComponentState.isBtdRtlOrLtr()) {
                jTextField.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                jTextField.setToolTipText(string);
            }
            jPanel.setToolTipText(string);
            jButton.setToolTipText(string);
        }
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (ComponentState.isBtdRtlOrLtr() && jTextField.getText() != null && jTextField.getText() instanceof String && jTextField.getText().length() > 0) {
                    jTextField.setToolTipText(ComponentState.prepareStringForBidiRendering((String)jTextField.getText()));
                } else {
                    jTextField.setToolTipText(jTextField.getText());
                }
            }
        });
        this.mFocusItems = vector;
        return jPanel;
    }

    private void updateFSBEditTooltip(FileSystemBrowserDefinition fileSystemBrowserDefinition, JTextField jTextField) {
        String string;
        String string2;
        String string3 = fileSystemBrowserDefinition.getTip() != null && fileSystemBrowserDefinition.getTip().trim().length() > 0 ? fileSystemBrowserDefinition.getTip() : null;
        String string4 = string2 = jTextField.getText() != null && jTextField.getText().trim().length() > 0 ? jTextField.getText() : null;
        if (ComponentState.isBtdRtlOrLtr() && string2 != null && string2.length() > 0) {
            string2 = ComponentState.removeBidiDirectionMarks((String)string2);
        }
        String string5 = string = string2 != null ? string2 : string3;
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            jTextField.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            jTextField.setToolTipText(string);
        }
    }

    private JComponent processRadioGroup(JPanel jPanel, RadioGroupDefinition radioGroupDefinition, boolean bl, GridBagConstraints gridBagConstraints) {
        GridBagConstraints gridBagConstraints2;
        JRadioButton jRadioButton;
        JPanel jPanel2 = this.setupRadioPanel(jPanel, radioGroupDefinition);
        if (bl && jPanel2 != jPanel) {
            this.mControllerCheckListener.addSubordinateItem(jPanel2);
        }
        boolean bl2 = false;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        for (int i = 0; i < radioGroupDefinition.radioItemCount(); ++i) {
            RadioItemDefinition radioItemDefinition = radioGroupDefinition.getRadioItem(i);
            String string = radioItemDefinition.getTitle();
            jRadioButton = string.indexOf("\\n") > -1 ? new SpssMultiLineRadioButton(new CustomToggleButtonAction((ControlDefinition)radioItemDefinition), -1) : new JRadioButton(new CustomToggleButtonAction((ControlDefinition)radioItemDefinition));
            jRadioButton.setName(radioItemDefinition.getControlId());
            gridBagConstraints2 = radioItemDefinition.getConstraints();
            jPanel2.add((Component)jRadioButton, gridBagConstraints2);
            spssButtonGroup.add(jRadioButton);
            if (radioItemDefinition.getIsDefault()) {
                jRadioButton.setSelected(true);
                bl2 = true;
            }
            if (radioItemDefinition.getHasSubGroup() && radioItemDefinition.getElementCount() > 0) {
                this.addRadioChildControls(jPanel2, jRadioButton, radioItemDefinition, i == radioGroupDefinition.radioItemCount() - 1, gridBagConstraints);
            }
            if (!bl) continue;
            this.mControllerCheckListener.addSubordinateItem(jRadioButton);
        }
        if (!bl2 && radioGroupDefinition.radioItemCount() > 0) {
            radioGroupDefinition.getRadioItem(0).setIsDefault(true);
            jRadioButton = (JRadioButton)jPanel2.getComponent(0);
            jRadioButton.setSelected(true);
        }
        gridBagConstraints2 = radioGroupDefinition.getConstraints();
        this.mFocusItems.add(new FocusContainer(gridBagConstraints2, spssButtonGroup));
        return jPanel2;
    }

    private void addRadioChildControls(JPanel jPanel, JToggleButton jToggleButton, RadioItemDefinition radioItemDefinition, boolean bl, GridBagConstraints gridBagConstraints) {
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)radioItemDefinition.getConstraints().clone();
        ++gridBagConstraints2.gridy;
        if (bl) {
            gridBagConstraints2.weighty = 1.0;
        }
        gridBagConstraints2.fill = 2;
        JPanel2 jPanel2 = new JPanel2(new GridBagLayout(), true);
        jPanel2.setBorder(null);
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        ++gridBagConstraints3.gridy;
        FocusContainer focusContainer = new FocusContainer(gridBagConstraints3, null);
        this.mFocusItems.add(focusContainer);
        Vector<FocusContainer> vector = this.mFocusItems;
        this.mFocusItems = focusContainer.getSubItems();
        for (int i = 0; i < radioItemDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = radioItemDefinition.getPanelElement(i);
            JComponent jComponent = this.buildPanelElement(jPanel2, (PanelElementDefinition)radioItemDefinition, panelElementDefinition);
            jToggleButton.addItemListener(new ControllerToggleButtonListener(jComponent, radioItemDefinition.getIsDefault()));
        }
        this.mFocusItems = vector;
    }

    private JPanel setupRadioPanel(JPanel jPanel, RadioGroupDefinition radioGroupDefinition) {
        String string = radioGroupDefinition.getTitle();
        boolean bl = string == null || string.length() == 0;
        JPanel2 jPanel2 = new JPanel2(new GridBagLayout(), true);
        if (bl) {
            jPanel2.setBorder(null);
        } else {
            jPanel2.setBorder(BorderFactory.createTitledBorder(string));
        }
        String string2 = radioGroupDefinition.getTip();
        if (string2 != null && string2.length() > 0) {
            jPanel2.setToolTipText(string2);
        }
        GridBagConstraints gridBagConstraints = radioGroupDefinition.getConstraints();
        if (bl) {
            gridBagConstraints = (GridBagConstraints)gridBagConstraints.clone();
            Insets insets = PanelElementDefinition.getStandardInsets();
            int n = gridBagConstraints.insets.left - insets.left;
            gridBagConstraints.insets = new Insets(0, n, 0, 0);
        }
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel2;
    }

    class ListListener
    implements ListDataListener {
        private TargetVariableList mTvl;
        private JComponent mListbox;

        ListListener(TargetVariableList targetVariableList, JComponent jComponent) {
            this.mTvl = targetVariableList;
            this.mListbox = jComponent;
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            DialogBuilder.this.updateListbox(this.mTvl, this.mListbox);
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.setSelectedItem();
            DialogBuilder.this.updateListbox(this.mTvl, this.mListbox);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            DialogBuilder.this.updateListbox(this.mTvl, this.mListbox);
        }

        private void setSelectedItem() {
            boolean bl;
            if (this.mListbox instanceof SerializableList && !(bl = ((SerializableList)this.mListbox).getCellRenderer() instanceof JCheckBox)) {
                DefaultListModel defaultListModel = (DefaultListModel)((SerializableList)this.mListbox).getModel();
                int n = -1;
                for (int i = 0; i < defaultListModel.size(); ++i) {
                    Object e = defaultListModel.getElementAt(i);
                    if (!(e instanceof ListBoxItem) || !((ListBoxItem)e).isSelected()) continue;
                    n = i;
                }
                if (n >= 0) {
                    ((SerializableList)this.mListbox).setSelectedIndex(n);
                }
            }
        }
    }

    class CheckboxCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CheckboxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled());
            this.setSelected(((ListBoxItem)object).isSelected());
            this.setFont(jList.getFont());
            if (bl) {
                this.setForeground(jList.getSelectionForeground());
                if (bl2) {
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setBackground(Color.lightGray);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(object.toString());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    class ListBoxCellRenderer
    extends DefaultListCellRenderer {
        ListBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                object = ComponentState.removeBidiDirectionMarks((String)((String)object));
            }
            if (bl && !bl2) {
                this.setBackground(Color.lightGray);
            }
            return this;
        }
    }

    class JPanel2
    extends JPanel {
        JPanel2(LayoutManager layoutManager, boolean bl) {
            super(layoutManager, bl);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Border border = this.getBorder();
            if (border instanceof TitledBorder) {
                Dimension dimension2 = ((TitledBorder)border).getMinimumSize(this);
                dimension.width = Math.max(dimension.width, dimension2.width + 6);
            }
            return dimension;
        }
    }

    class ControllerToggleButtonListener
    implements ItemListener {
        private JComponent mComponent;

        ControllerToggleButtonListener(JComponent jComponent, boolean bl) {
            this.mComponent = jComponent;
            this.enableComponents(jComponent, bl);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.enableComponents(this.mComponent, bl);
        }

        private void enableComponents(JComponent jComponent, boolean bl) {
            jComponent.setEnabled(bl);
            for (Component component : jComponent.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                this.enableComponents((JComponent)component, bl);
            }
        }
    }

    class VarNameFocusListener
    extends FocusAdapter {
        private JTextField mTextField;

        VarNameFocusListener(JTextField jTextField) {
            this.mTextField = jTextField;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            String string;
            if (this.mTextField instanceof ContextEnabledTextField && ((ContextEnabledTextField)this.mTextField).isPopupisVisible()) {
                return;
            }
            if (focusEvent.getOppositeComponent() == null) {
                return;
            }
            if (focusEvent.getOppositeComponent() instanceof JButton && ((string = ((JButton)focusEvent.getOppositeComponent()).getText()).equals(UIToolResUtil.getString((String)"IDS_CANCEL")) || string.equals(UIToolResUtil.getString((String)"IDS_RESET")))) {
                return;
            }
            string = this.mTextField.getText();
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                string = ComponentState.removeBidiDirectionMarks((String)string);
            }
            if (string.length() > 0 && !DialogUtil.checkNewVarName((Window)this.mTextField.getTopLevelAncestor(), null, string)) {
                this.mTextField.putClientProperty("BAD_STATE", true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VarNameFocusListener.this.mTextField.requestFocus();
                        VarNameFocusListener.this.mTextField.selectAll();
                    }
                });
            } else {
                this.mTextField.putClientProperty("BAD_STATE", null);
            }
        }
    }

    class FocusContainer {
        private GridBagConstraints mGbc;
        private Object mFocusTarget;
        private Vector<FocusContainer> mSubItems = new Vector();

        FocusContainer(GridBagConstraints gridBagConstraints, Object object) {
            this.mGbc = gridBagConstraints;
            this.mFocusTarget = object;
        }

        public Object getFocusTarget() {
            return this.mFocusTarget;
        }

        public GridBagConstraints getGbc() {
            return this.mGbc;
        }

        public Vector<FocusContainer> getSubItems() {
            return this.mSubItems;
        }
    }

    class DBFileFilter
    extends RefFileFilter {
        private String mDesc;
        private Vector<String> mExtensions;

        public DBFileFilter(String string, String string2) {
            super(string, string2, ";");
            this.mExtensions = new Vector();
            this.mDesc = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                this.mExtensions.add(string3);
            }
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            String string2 = "*.";
            int n = string.lastIndexOf(".");
            if (n > -1) {
                string2 = "*." + string.substring(n + 1);
            }
            for (String string3 : this.mExtensions) {
                if (string3.equals("*")) {
                    return true;
                }
                if (string3.toLowerCase().equals(string2.toLowerCase())) {
                    return true;
                }
                if (!string3.startsWith("*.") || !string3.endsWith("*")) continue;
                String string4 = string3.substring(0, string3.length() - 1);
                if (!string2.toLowerCase().contains(string4)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.mDesc;
        }

        public String getExtension() {
            String string = super.getExtension();
            int n = string.lastIndexOf(".");
            if (n > -1) {
                string = string.substring(n + 1);
            }
            return string;
        }
    }

    class ControllerCheckListener
    implements ItemListener {
        private Vector<JComponent> mSubordinates = new Vector();

        ControllerCheckListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.updateState(bl);
        }

        public void updateState(boolean bl) {
            for (JComponent jComponent : this.mSubordinates) {
                jComponent.setEnabled(bl);
                if (!(jComponent instanceof JPanel)) continue;
                this.adjustPanelTitleColor((JPanel)jComponent, bl);
            }
        }

        public void addSubordinateItem(JComponent jComponent) {
            this.mSubordinates.add(jComponent);
        }

        private void adjustPanelTitleColor(JPanel jPanel, boolean bl) {
            Border border = jPanel.getBorder();
            if (border instanceof TitledBorder) {
                TitledBorder titledBorder = (TitledBorder)border;
                String string = bl ? "TitledBorder.titleColor" : "textInactiveText";
                Color color = UIManager.getColor(string);
                titledBorder.setTitleColor(color);
            }
        }
    }

    class BrowseButtonAction
    extends AbstractAction {
        private FileSystemBrowserDefinition mFsbDef;
        private JTextField mEditField;

        BrowseButtonAction(FileSystemBrowserDefinition fileSystemBrowserDefinition, JTextField jTextField) {
            this.mFsbDef = fileSystemBrowserDefinition;
            this.mEditField = jTextField;
            this.putValue("Name", BuilderResUtil.getString("IDS_BROWSE_BUTTON_TEXT"));
            Integer n = BuilderResUtil.getAccessKey("IDK_BROWSE_BUTTON_TEXT");
            if (n != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Container container = ((JButton)actionEvent.getSource()).getTopLevelAncestor();
            boolean bl = this.mFsbDef.isDirectoryBrowser();
            boolean bl2 = this.mFsbDef.isOpenDialog();
            boolean bl3 = this.mFsbDef.isServerFileSystemBrowser();
            boolean bl4 = false;
            String string2 = string = bl3 ? FileLocationsUtil.getDataFilesDirectoryPath() : FileLocationsUtil.getOtherFilesDirectoryPath();
            RemoteFileChooser.ChooserType chooserType = bl ? RemoteFileChooser.ChooserType.OpenFolder : (bl2 ? RemoteFileChooser.ChooserType.OpenFile : RemoteFileChooser.ChooserType.SaveFile);
            RemoteFileChooser.ChooserOption chooserOption = RemoteFileChooser.ChooserOption.Generic;
            LinkedList linkedList = this.mFsbDef.getFilterList();
            if (!bl && linkedList.size() == 1 && ((FileSystemBrowserDefinition.FilterItem)linkedList.get(0)).getFilterType() == FileSystemBrowserDefinition.FilterType.DataFiles) {
                chooserOption = RemoteFileChooser.ChooserOption.Data;
            }
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(chooserType, chooserOption, string, bl3, bl4);
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            for (FileSystemBrowserDefinition.FilterItem filterItem : linkedList) {
                if (filterItem.getFilterType() == FileSystemBrowserDefinition.FilterType.AllFiles) {
                    remoteFileChooser.setAcceptAllFileFilterUsed(true);
                    continue;
                }
                remoteFileChooser.addChoosableFileFilter((FileFilter)((Object)new DBFileFilter(filterItem.getUserText(), filterItem.getFilterString())));
            }
            int n = bl2 ? remoteFileChooser.showOpenDialog(container) : remoteFileChooser.showSaveDialog(container);
            if (n == 0) {
                if (ComponentState.isPathBidiProcessingNeeded((String)remoteFileChooser.getSelectedFilePath())) {
                    this.mEditField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    this.mEditField.setText(ComponentState.preparePathForBidiDisplay((String)remoteFileChooser.getSelectedFilePath()));
                    this.mEditField.setToolTipText(ComponentState.preparePathForBidiDisplay((String)remoteFileChooser.getSelectedFilePath()));
                } else {
                    this.mEditField.setText(remoteFileChooser.getSelectedFilePath());
                    this.mEditField.setToolTipText(remoteFileChooser.getSelectedFilePath());
                }
            }
        }
    }

    class CustomToggleButtonAction
    extends ToggleButtonAction {
        public CustomToggleButtonAction(ControlDefinition controlDefinition) {
            Integer n;
            super(controlDefinition.getControlId(), false);
            this.putValue("Name", controlDefinition.getTitle().replace("\\n", "\n"));
            String string = controlDefinition.getTip();
            if (string != null && string.length() > 0) {
                this.putValue("ShortDescription", string);
            }
            if ((n = controlDefinition.getMnemonicKey()) != null) {
                this.putValue("MnemonicKey", n);
            }
        }
    }
}

