/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.SpssVLMapId;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.custom_gui.CDDialogData;
import com.spss.java_client.ui.dialogs.base.custom_gui.CustomSubDialog;
import com.spss.java_client.ui.dialogs.base.custom_gui.DialogBuilder;
import com.spss.java_client.ui.dialogs.base.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.StateCheck;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.BrowserLaunch;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.CDSyntaxGenerator;
import com.spss.uitools.ui_builder.DefinitionUtil;
import com.spss.uitools.ui_builder.DialogData;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.EditCtrlDefinition;
import com.spss.uitools.ui_builder.definition.FileSystemBrowserDefinition;
import com.spss.uitools.ui_builder.definition.ItemGroupDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.ui_builder.definition.VarListDefinition;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;

public class CustomProcedureDialog
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private static DialogDefinition sTransientDef;
    protected DialogDefinition mDlgDef;
    protected boolean mIsTestMode;
    private Vector<Object> mFocusTargets;
    private EditFieldDocumentListener mTextFieldListener;

    public static void runCustomProcedureDialog(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        sTransientDef = dialogDefinition;
        CustomProcedureDialog customProcedureDialog = new CustomProcedureDialog(jFrame, dialogDefinition, bl, false);
        if (!bl) {
            ProcedureDlgMgr.getMgr().addProcedureDialog(customProcedureDialog.getIActionKey(), customProcedureDialog);
        }
        sTransientDef = null;
    }

    public static void testCustomProcedureDialog(JFrame jFrame, DialogDefinition dialogDefinition) {
        sTransientDef = dialogDefinition;
        new CustomProcedureDialog(jFrame, dialogDefinition, true, true);
        sTransientDef = null;
    }

    private CustomProcedureDialog(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl, boolean bl2) throws HeadlessException {
        super(jFrame, dialogDefinition.getDialogTitle(), bl, "", "");
        this.mDlgDef = dialogDefinition;
        this.mIsTestMode = bl2;
        this.setDefaultState();
        String string = this.mDlgDef.getHelpFileName();
        if (string == null || string.length() == 0) {
            if (this.mIsTestMode) {
                this.mHelpAction.setEnabled(false);
            } else {
                this.mCmdButtonPanel.remove(this.mHelpButton);
            }
        }
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public String generateSyntax() {
        CDDialogData cDDialogData = new CDDialogData(this.getDialogDataModel());
        CDSyntaxGenerator cDSyntaxGenerator = new CDSyntaxGenerator(this.mDlgDef, (DialogData)cDDialogData);
        return cDSyntaxGenerator.generateSyntax();
    }

    @Override
    public String getIActionKey() {
        return this.mDlgDef.getDialogId();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaultState();
    }

    @Override
    public String getDialogHelpID() {
        return "";
    }

    @Override
    public void doHelp() {
        String string = this.mDlgDef.getHelpFileName();
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = string.contains(File.separator) ? string : this.getSpecFolderPath() + File.separator + string;
        if (CustomProcedureDialog.validateFile(this, string2 = this.getLocalizedURLPath(string2))) {
            BrowserLaunch.getBrowserLaunch().openURL(string2);
        }
    }

    public String getSpecFolderPath() {
        return SpecificationWriter.getDeploymentFolder() + File.separator + this.mDlgDef.getDialogId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean okPastePressed() {
        try {
            StateCheck stateCheck = new StateCheck();
            StateCheck.start((Container)((Object)this), stateCheck);
            if (stateCheck.isBadState()) {
                boolean bl = false;
                return bl;
            }
            if (this.mIsTestMode) {
                this.saveDialogState();
                if (this.getPressedButton() == this.mPasteButton) {
                    this.getDialogDataModel().setInTestMode(true);
                    String string = this.generateSyntax();
                    TraceSettings.trace1((String)("** Custom Syntax: **\n" + string), (int)15);
                    LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
                    ProcedureDlgMgr.getMgr().removePersistenceData(locallyUniqueId, this.getIActionKey());
                    SyntaxFrame syntaxFrame = (SyntaxFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.SYNTAX_DOC);
                    if (syntaxFrame != null) {
                        ISyntaxDocument iSyntaxDocument = (ISyntaxDocument)syntaxFrame.getCoreDocument();
                        iSyntaxDocument.pasteSyntax("\n" + string);
                    }
                }
                this.dispose();
                boolean bl = false;
                return bl;
            }
            boolean bl = super.okPastePressed();
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.getDialogDataModel().setInTestMode(false);
        }
        return false;
    }

    @Override
    protected boolean canBeRecalled() {
        return !this.mIsTestMode;
    }

    public String getTitle() {
        String string = super.getTitle();
        if (string == null || string.length() == 0) {
            string = this.mDlgDef.getDialogId();
        }
        return string;
    }

    @Override
    protected void loadDialogState() {
        boolean bl = this.isModal();
        if (bl) {
            this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(this.mDlgDef, this.getViewPanel()));
        }
        if (!this.mIsTestMode) {
            super.loadDialogState();
        } else {
            this.setVisible(true);
        }
        if (!bl) {
            this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(this.mDlgDef, this.getViewPanel()));
        }
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(this.mDlgDef, this.getViewPanel()));
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(this.mDlgDef, this.getViewPanel()));
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(this.mDlgDef, this.getViewPanel()));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CustomProcedureDialog.this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(CustomProcedureDialog.this.mDlgDef, CustomProcedureDialog.this.getViewPanel()));
            }
        });
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        if (this.mDlgDef == null) {
            this.mDlgDef = sTransientDef;
        }
        if (this.mFocusTargets == null) {
            this.mFocusTargets = new Vector();
        }
        LinkedList<SubDlgButtonDefinition> linkedList = this.getOptionsButtons();
        for (SubDlgButtonDefinition subDlgButtonDefinition : linkedList) {
            OptionsButtonAction optionsButtonAction = new OptionsButtonAction(subDlgButtonDefinition);
            JButton jButton = new JButton(optionsButtonAction);
            this.mFocusTargets.add(jButton);
            this.addOptionsPanelButton(jPanel, jButton);
        }
        return jPanel;
    }

    @Override
    protected void init() {
        int n;
        super.init();
        JPanel jPanel = this.getViewPanel();
        DialogBuilder dialogBuilder = new DialogBuilder();
        Vector<Object> vector = dialogBuilder.buildMainPanel(jPanel, this.mDlgDef);
        for (n = vector.size() - 1; n >= 0; --n) {
            this.mFocusTargets.insertElementAt(vector.get(n), 0);
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            this.mFocusTargets.add(this.mCmdButtonPanel.getComponent(n));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.mFocusTargets, false));
        this.mTextFieldListener = new EditFieldDocumentListener();
        this.addControlListeners(jPanel);
    }

    private void setDefaultState() {
        SrcVariableList srcVariableList = (SrcVariableList)DialogBuilder.findComponent(this.getViewPanel(), SrcVariableList.class);
        if (srcVariableList != null) {
            if (!this.mIsTestMode) {
                boolean bl = false;
                String string = srcVariableList.getName();
                PanelElementDefinition panelElementDefinition = DefinitionUtil.findPanelItem((DialogDefinition)this.mDlgDef, (String)string);
                if (panelElementDefinition instanceof VarListDefinition) {
                    VarListDefinition varListDefinition = (VarListDefinition)panelElementDefinition;
                    bl = varListDefinition.isIncluded(VarListDefinition.MRVARS_BIT);
                }
                srcVariableList.loadFromActiveDataset(bl);
            } else {
                this.loadTestData(srcVariableList);
            }
            srcVariableList.setSelectedIndex(0);
            srcVariableList.requestFocus();
        }
        this.clearTargetLists(this.getViewPanel());
        this.cycleDefaults((PanelElementDefinition)this.mDlgDef.getCurrentPanel());
        this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(this.mDlgDef, this.getViewPanel()));
    }

    private void loadTestData(SrcVariableList srcVariableList) {
        SpssVariable spssVariable;
        String string = srcVariableList.getName();
        PanelElementDefinition panelElementDefinition = DefinitionUtil.findPanelItem((DialogDefinition)this.mDlgDef, (String)string);
        VarListDefinition varListDefinition = null;
        if (panelElementDefinition instanceof VarListDefinition) {
            varListDefinition = (VarListDefinition)panelElementDefinition;
        }
        VarListModel varListModel = srcVariableList.getModel();
        varListModel.reset();
        int n = 0;
        String string2 = BuilderResUtil.getString("IDS_SAMPLE_VAR");
        String string3 = BuilderResUtil.getString("IDS_SAMPLE_VALUE_LABEL");
        String string4 = BuilderResUtil.getString("IDS_SAMPLE_ATTR");
        for (int i = 0; i < 9; ++i) {
            ValueLabelMap valueLabelMap;
            OBS oBS;
            Object object;
            spssVariable = new SpssVariable();
            spssVariable.setName(string2 + (n + 1));
            spssVariable.setDatasetIndex(n);
            spssVariable.setMeasurementLevel(MeasurementLevel.fromShort((short)((short)(i % 3 + 1))));
            spssVariable.setId(new LocallyUniqueId(ORIGINATOR_ID.DATAMGR_ORIGINATOR, i + 1));
            if (i < 3) {
                spssVariable.setType((short)8);
            } else if (i < 6) {
                spssVariable.setFormat(new SPSS_Format(FormatType.F, 8, 2));
            } else {
                spssVariable.setFormat(new SPSS_Format(FormatType.DATETIME, 23, 0));
            }
            if (spssVariable.getDisplayMeasurementLevel() == MeasurementLevel.scale && spssVariable.getType() > 0) continue;
            if (DialogBuilder.isIncluded(varListDefinition, (ISpssVariable)spssVariable)) {
                varListModel.addElement((ISpssVariable)spssVariable, false);
            }
            ++n;
            if (spssVariable.getMeasurementLevel() != MeasurementLevel.scale) {
                object = new HashMap();
                oBS = spssVariable.getType() == 0 ? new OBS(1.0) : new OBS("v1");
                ((HashMap)object).put(oBS, spssVariable.getName() + ": " + string3 + " " + 1);
                oBS = spssVariable.getType() == 0 ? new OBS(2.0) : new OBS("v2");
                ((HashMap)object).put(oBS, spssVariable.getName() + ": " + string3 + " " + 2);
                oBS = spssVariable.getType() == 0 ? new OBS(3.0) : new OBS("v3");
                ((HashMap)object).put(oBS, spssVariable.getName() + ": " + string3 + " " + 3);
                valueLabelMap = new ValueLabelMap(new SpssVLMapId(), (Map)object);
                spssVariable.setValueLabels((IValueLabelMap)valueLabelMap);
                continue;
            }
            object = string4 + 1;
            oBS = new DatasourceAttributes();
            valueLabelMap = new Vector();
            valueLabelMap.add(spssVariable.getName() + ": " + (String)object + " " + "(A)");
            valueLabelMap.add(spssVariable.getName() + ": " + (String)object + " " + "(B)");
            valueLabelMap.add(spssVariable.getName() + ": " + (String)object + " " + "(C)");
            oBS.put("attr1", valueLabelMap);
            valueLabelMap = new Vector();
            object = string4 + 2;
            valueLabelMap.add(spssVariable.getName() + ": " + (String)object + " " + "(A)");
            valueLabelMap.add(spssVariable.getName() + ": " + (String)object + " " + "(B)");
            valueLabelMap.add(spssVariable.getName() + ": " + (String)object + " " + "(C)");
            oBS.put("attr2", (Vector)valueLabelMap);
            spssVariable.setAttributes((IDatasourceAttributes)oBS);
        }
        if (varListDefinition != null && varListDefinition.isIncluded(VarListDefinition.MRVARS_BIT)) {
            spssVariable = new SpssMRVariable(null);
            spssVariable.setName("$" + string2 + 10);
            spssVariable.setMeasurementLevel(MeasurementLevel.nominal);
            spssVariable.setDatasetIndex(9);
            spssVariable.setId(new LocallyUniqueId(ORIGINATOR_ID.DATAMGR_ORIGINATOR, 10));
            varListModel.addElement((ISpssVariable)spssVariable, false);
        }
    }

    private String getLocalizedURLPath(String string) {
        String string2;
        String string3;
        File file = new File(string);
        Locale locale = Locale.getDefault();
        String string4 = file.getName();
        int n = string4.lastIndexOf(".");
        if (locale.getCountry().length() > 0) {
            string3 = string4.substring(0, n) + "_" + locale.getLanguage() + "_" + locale.getCountry() + string4.substring(n);
            string2 = file.getParent() + File.separator + string3;
            if (new File(string2).exists()) {
                return string2;
            }
        }
        if (locale.getLanguage().length() > 0) {
            string3 = string4.substring(0, n) + "_" + locale.getLanguage() + string4.substring(n);
            string2 = file.getParent() + File.separator + string3;
            if (new File(string2).exists()) {
                return string2;
            }
        }
        return string;
    }

    private void cycleDefaults(PanelElementDefinition panelElementDefinition) {
        int n;
        if (panelElementDefinition instanceof PanelDefinition) {
            n = ((PanelDefinition)panelElementDefinition).getElementCount();
        } else if (panelElementDefinition instanceof RadioItemDefinition) {
            n = ((RadioItemDefinition)panelElementDefinition).getElementCount();
        } else {
            assert (false);
            return;
        }
        for (int i = 0; i < n; ++i) {
            JRadioButton jRadioButton;
            Object object;
            Object object2;
            String string;
            PanelElementDefinition panelElementDefinition2 = panelElementDefinition instanceof PanelDefinition ? ((PanelDefinition)panelElementDefinition).getPanelElement(i) : ((RadioItemDefinition)panelElementDefinition).getPanelElement(i);
            if (panelElementDefinition2 instanceof CheckBoxDefinition) {
                string = panelElementDefinition2.getControlId();
                object2 = (JCheckBox)DialogBuilder.findComponentByName(this.getViewPanel(), string);
                if (object2 == null) continue;
                ((AbstractButton)object2).setSelected(((CheckBoxDefinition)panelElementDefinition2).getDefaultState());
                continue;
            }
            if (panelElementDefinition2 instanceof ComboBoxDefinition) {
                object2 = (ComboBoxDefinition)panelElementDefinition2;
                string = object2.getControlId();
                object = (JComboBox)DialogBuilder.findComponentByName(this.getViewPanel(), string);
                if (object == null) continue;
                if (object2.isDynamicSourceType()) {
                    ((JComboBox)object).setSelectedItem(null);
                    continue;
                }
                ((JComboBox)object).setSelectedIndex(object2.getDefaultSelectionIndex());
                continue;
            }
            if (panelElementDefinition2 instanceof ListBoxDefinition) {
                object2 = (ListBoxDefinition)panelElementDefinition2;
                string = object2.getControlId();
                object = (JList)DialogBuilder.findComponentByName(this.getViewPanel(), string);
                if (object == null) continue;
                if (object2.isDynamicSourceType()) {
                    ((JList)object).clearSelection();
                    continue;
                }
                ((JList)object).setSelectedIndex(object2.getDefaultSelectionIndex());
                continue;
            }
            if (panelElementDefinition2 instanceof EditCtrlDefinition) {
                string = panelElementDefinition2.getControlId();
                object2 = (JTextComponent)DialogBuilder.findComponentByName(this.getViewPanel(), string);
                if (object2 == null) continue;
                ((JTextComponent)object2).setText(((EditCtrlDefinition)panelElementDefinition2).getDefaultValue());
                continue;
            }
            if (panelElementDefinition2 instanceof FileSystemBrowserDefinition) {
                string = panelElementDefinition2.getControlId();
                object2 = (JTextComponent)DialogBuilder.findComponentByName(this.getViewPanel(), string);
                if (object2 == null) continue;
                object = ((FileSystemBrowserDefinition)panelElementDefinition2).getDefaultValue();
                if (object != null) {
                    ((JTextComponent)object2).setText((String)object);
                }
                String string2 = panelElementDefinition2.getTip() != null && panelElementDefinition2.getTip().trim().length() > 0 ? panelElementDefinition2.getTip() : null;
                jRadioButton = object != null && ((String)object).trim().length() > 0 ? object : null;
                Object object3 = jRadioButton != null ? jRadioButton : string2;
                ((JComponent)object2).setToolTipText((String)object3);
                continue;
            }
            if (panelElementDefinition2 instanceof RadioGroupDefinition) {
                object = (RadioGroupDefinition)panelElementDefinition2;
                for (int j = 0; j < object.radioItemCount(); ++j) {
                    object2 = object.getRadioItem(j);
                    if (object2.getIsDefault()) {
                        string = object2.getControlId();
                        jRadioButton = (JRadioButton)DialogBuilder.findComponentByName(this.getViewPanel(), string);
                        if (jRadioButton != null) {
                            jRadioButton.setSelected(true);
                        }
                    }
                    if (!object2.getHasSubGroup() || object2.getElementCount() <= 0) continue;
                    this.cycleDefaults((PanelElementDefinition)object2);
                }
                continue;
            }
            if (!(panelElementDefinition2 instanceof PanelDefinition)) continue;
            this.cycleDefaults(panelElementDefinition2);
        }
    }

    private void addControlListeners(JComponent jComponent) {
        for (Component component : jComponent.getComponents()) {
            if (component instanceof TargetVariableList) {
                ((TargetVariableList)component).getModel().addListDataListener(this);
                continue;
            }
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).addItemListener(this);
                continue;
            }
            if (component instanceof JRadioButton) {
                ((JRadioButton)component).addItemListener(this);
                continue;
            }
            if (component instanceof JTextField) {
                ((JTextField)component).getDocument().addDocumentListener(this.mTextFieldListener);
                continue;
            }
            if (!(component instanceof JPanel) && !(component instanceof JScrollPane) && !(component instanceof JViewport)) continue;
            this.addControlListeners((JComponent)component);
        }
    }

    static boolean requiredControlsHaveValues(DialogDefinition dialogDefinition, JComponent jComponent) {
        for (Component component : jComponent.getComponents()) {
            if (component.isEnabled()) {
                PanelElementDefinition panelElementDefinition;
                String string = component.getName();
                PanelElementDefinition panelElementDefinition2 = panelElementDefinition = string != null ? DefinitionUtil.findPanelItem((DialogDefinition)dialogDefinition, (String)string) : null;
                if (panelElementDefinition != null && panelElementDefinition.isRequired()) {
                    if (component instanceof TargetVariableList && ((TargetVariableList)component).getModel().getSize() == 0) {
                        return false;
                    }
                    if (component instanceof JPanel && panelElementDefinition instanceof ItemGroupDefinition && !CustomProcedureDialog.itemGroupHasSelections((JPanel)component, panelElementDefinition instanceof CheckBoxGroupDefinition)) {
                        return false;
                    }
                    if (component instanceof JTextField && (panelElementDefinition instanceof FileSystemBrowserDefinition || panelElementDefinition instanceof EditCtrlDefinition) && ((JTextField)component).getText().length() == 0) {
                        return false;
                    }
                } else if (panelElementDefinition != null && panelElementDefinition instanceof CheckBoxGroupDefinition) {
                    return CustomProcedureDialog.itemGroupHasSelections((JPanel)component, true);
                }
            }
            if (!(component instanceof JPanel) && !(component instanceof JScrollPane) && !(component instanceof JViewport) || CustomProcedureDialog.requiredControlsHaveValues(dialogDefinition, (JComponent)component)) continue;
            return false;
        }
        return true;
    }

    private static boolean itemGroupHasSelections(JComponent jComponent, boolean bl) {
        if (jComponent.getName() != null && !CustomProcedureDialog.hasRequiredControls(jComponent, bl)) {
            return true;
        }
        int n = 0;
        for (Component component : jComponent.getComponents()) {
            if (component instanceof TargetVariableList && ((TargetVariableList)component).getModel().getSize() > 0) {
                return true;
            }
            if (component instanceof JCheckBox && (n == 0 && bl && !((JCheckBox)component).isSelected() || (!bl || n > 0) && ((JCheckBox)component).isSelected())) {
                return true;
            }
            if (component instanceof JTextField) {
                return ((JTextField)component).getText().length() > 0;
            }
            if (component instanceof JPanel || component instanceof JScrollPane || component instanceof JViewport) {
                if (CustomProcedureDialog.itemGroupHasSelections((JComponent)component, bl)) {
                    return true;
                }
                if (CustomProcedureDialog.hasRequiredControls((JComponent)component, false)) {
                    return false;
                }
            }
            ++n;
        }
        return false;
    }

    private static boolean hasRequiredControls(JComponent jComponent, boolean bl) {
        int n = 0;
        for (Component component : jComponent.getComponents()) {
            if (component instanceof TargetVariableList) {
                return true;
            }
            if (component instanceof JCheckBox && (n == 0 && bl && !((JCheckBox)component).isSelected() || !bl || n > 0)) {
                return true;
            }
            if (component instanceof JTextField) {
                return true;
            }
            if ((component instanceof JPanel || component instanceof JScrollPane || component instanceof JViewport) && CustomProcedureDialog.hasRequiredControls((JComponent)component, bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private LinkedList<SubDlgButtonDefinition> getOptionsButtons() {
        LinkedList<SubDlgButtonDefinition> linkedList = new LinkedList<SubDlgButtonDefinition>();
        PanelDefinition panelDefinition = this.mDlgDef.getCurrentPanel();
        this.getButtons(panelDefinition, linkedList);
        this.sortButtons(linkedList);
        return linkedList;
    }

    private void sortButtons(LinkedList<SubDlgButtonDefinition> linkedList) {
        SubDlgButtonDefinition[] subDlgButtonDefinitionArray = new SubDlgButtonDefinition[linkedList.size()];
        linkedList.toArray(subDlgButtonDefinitionArray);
        Arrays.sort(subDlgButtonDefinitionArray, new ButtonComparator());
        linkedList.clear();
        linkedList.addAll(Arrays.asList(subDlgButtonDefinitionArray));
    }

    private void getButtons(PanelDefinition panelDefinition, LinkedList<SubDlgButtonDefinition> linkedList) {
        for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
            if (panelElementDefinition instanceof SubDlgButtonDefinition) {
                linkedList.add((SubDlgButtonDefinition)panelElementDefinition);
                continue;
            }
            if (!(panelElementDefinition instanceof PanelDefinition)) continue;
            this.getButtons((PanelDefinition)panelElementDefinition, linkedList);
        }
    }

    private void clearTargetLists(JComponent jComponent) {
        for (Component component : jComponent.getComponents()) {
            if (component instanceof TargetVariableList) {
                ((TargetVariableList)component).getModel().removeAll();
                continue;
            }
            if (!(component instanceof JPanel) && !(component instanceof JScrollPane) && !(component instanceof JViewport)) continue;
            this.clearTargetLists((JComponent)component);
        }
    }

    static boolean validateFile(BaseDialog baseDialog, String string) {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = UIToolResUtil.getString((String)"ERR_HELP_NO_FILE_MSG");
            String string3 = String.format(string2, string);
            SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, string3, UIToolResUtil.getString((String)"IDS_ERROR_HELP_TITLE"));
            return false;
        }
        return true;
    }

    class EditFieldDocumentListener
    implements DocumentListener {
        EditFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            CustomProcedureDialog.this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(CustomProcedureDialog.this.mDlgDef, CustomProcedureDialog.this.getViewPanel()));
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CustomProcedureDialog.this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(CustomProcedureDialog.this.mDlgDef, CustomProcedureDialog.this.getViewPanel()));
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CustomProcedureDialog.this.enableOkPaste(CustomProcedureDialog.requiredControlsHaveValues(CustomProcedureDialog.this.mDlgDef, CustomProcedureDialog.this.getViewPanel()));
        }
    }

    class OptionsButtonAction
    extends AbstractAction {
        private SubDlgButtonDefinition mSubDlgButtonDef;

        public OptionsButtonAction(SubDlgButtonDefinition subDlgButtonDefinition) {
            Integer n;
            this.mSubDlgButtonDef = subDlgButtonDefinition;
            this.putValue("Name", subDlgButtonDefinition.getTitle());
            String string = subDlgButtonDefinition.getTip();
            if (string.length() > 0) {
                this.putValue("ShortDescription", string);
            }
            if ((n = subDlgButtonDefinition.getMnemonicKey()) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new CustomSubDialog(CustomProcedureDialog.this, this.mSubDlgButtonDef.getDialogDefinition());
        }
    }

    class ButtonComparator
    implements Comparator<SubDlgButtonDefinition> {
        ButtonComparator() {
        }

        @Override
        public int compare(SubDlgButtonDefinition subDlgButtonDefinition, SubDlgButtonDefinition subDlgButtonDefinition2) {
            GridBagConstraints gridBagConstraints = subDlgButtonDefinition.getConstraints();
            GridBagConstraints gridBagConstraints2 = subDlgButtonDefinition2.getConstraints();
            return gridBagConstraints.gridy < gridBagConstraints2.gridy ? -1 : (gridBagConstraints.gridy == gridBagConstraints2.gridy ? 0 : 1);
        }
    }
}

