/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.custom_gui;

import com.spss.java_client.ui.dialogs.base.custom_gui.ListBoxItem;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.ui_builder.DialogData;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.ControlDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.ObjectDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import com.spss.uitools.util.CharacterUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class CDDialogData
implements DialogData {
    private DialogDataModel mDialogData;

    public CDDialogData(DialogDataModel dialogDataModel) {
        this.mDialogData = dialogDataModel;
    }

    public Boolean getBoolean(ObjectDefinition objectDefinition) {
        Boolean bl = null;
        if (objectDefinition instanceof CheckBoxGroupDefinition) {
            CheckBoxGroupDefinition checkBoxGroupDefinition = (CheckBoxGroupDefinition)objectDefinition;
            Boolean bl2 = this.mDialogData.getBoolean(checkBoxGroupDefinition.getControllerCheckBox().getControlId());
            bl = bl2 != null ? bl2.booleanValue() : checkBoxGroupDefinition.getControllerCheckBox().getDefaultState();
        } else if (objectDefinition instanceof RadioItemDefinition) {
            RadioItemDefinition radioItemDefinition = (RadioItemDefinition)objectDefinition;
            Boolean bl3 = this.mDialogData.getBoolean(radioItemDefinition.getControlId());
            bl = bl3 != null ? bl3.booleanValue() : radioItemDefinition.getIsDefault();
        } else if (objectDefinition instanceof CheckBoxDefinition) {
            CheckBoxDefinition checkBoxDefinition = (CheckBoxDefinition)objectDefinition;
            Boolean bl4 = this.mDialogData.getBoolean(checkBoxDefinition.getControlId());
            bl = bl4 != null ? bl4.booleanValue() : checkBoxDefinition.getDefaultState();
        }
        return bl;
    }

    public String getString(ObjectDefinition objectDefinition) {
        String string = "";
        if (objectDefinition instanceof ComboBoxDefinition) {
            ComboBoxDefinition comboBoxDefinition = (ComboBoxDefinition)objectDefinition;
            if (comboBoxDefinition.isDynamicSourceType()) {
                String string2 = this.mDialogData.getString(comboBoxDefinition.getControlId());
                String string3 = this.getSyntaxListItem((ListDefinition)comboBoxDefinition, string2);
                string = string2 != null ? this.smartQuoteAsNeeded((ListDefinition)comboBoxDefinition, string3, string2) : "";
            } else {
                Integer n = this.mDialogData.getInteger(comboBoxDefinition.getControlId());
                if (n == null) {
                    n = comboBoxDefinition.getDefaultSelectionIndex();
                }
                ListDefinition.ListItem listItem = (ListDefinition.ListItem)comboBoxDefinition.getListItems().get(n);
                string = listItem.getSyntax();
            }
        } else if (objectDefinition instanceof ControlDefinition) {
            ControlDefinition controlDefinition = (ControlDefinition)objectDefinition;
            string = this.mDialogData.getString(controlDefinition.getControlId());
        }
        return string;
    }

    public String[] getStringArray(ObjectDefinition objectDefinition) {
        TargetListDefinition targetListDefinition;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (objectDefinition instanceof ListBoxDefinition) {
            SerializableObject[] serializableObjectArray;
            ListBoxDefinition listBoxDefinition = (ListBoxDefinition)objectDefinition;
            for (SerializableObject serializableObject : serializableObjectArray = this.mDialogData.getSerializableArray(listBoxDefinition.getControlId())) {
                ListBoxItem listBoxItem = (ListBoxItem)serializableObject;
                if (!listBoxItem.isSelected()) continue;
                if (listBoxDefinition.isDynamicSourceType()) {
                    String string = this.getSyntaxListItem((ListDefinition)listBoxDefinition, listBoxItem);
                    arrayList.add(this.smartQuoteAsNeeded((ListDefinition)listBoxDefinition, string, listBoxItem.toString()));
                    continue;
                }
                arrayList.add(listBoxItem.getSyntax());
            }
        } else if (objectDefinition instanceof TargetListDefinition && (stringArray = this.mDialogData.getVarNameArray((targetListDefinition = (TargetListDefinition)objectDefinition).getControlId())) != null) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String smartQuoteAsNeeded(ListDefinition listDefinition, String string, String string2) {
        Object object;
        if (!listDefinition.isDynamicSourceType() || listDefinition.getSourceType() == ListDefinition.ValueSourceType.variable_names) {
            return string;
        }
        if (listDefinition.getSourceType() == ListDefinition.ValueSourceType.value_labels && listDefinition.getUseValues() && (object = this.mDialogData.getValueForValueLabel(string2, listDefinition.getTargetListId())) instanceof Double) {
            return string;
        }
        return CharacterUtil.smartQuote((String)string);
    }

    private String getSyntaxListItem(ListDefinition listDefinition, Object object) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        if (listDefinition.getSourceType() != ListDefinition.ValueSourceType.value_labels || !listDefinition.getUseValues()) {
            return string;
        }
        Object object2 = this.mDialogData.getValueForValueLabel(string, listDefinition.getTargetListId());
        if (object2 != null) {
            if (object2 instanceof Double) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setGroupingUsed(false);
                String string2 = numberFormat.format(object2);
                return string2.replace(',', '.');
            }
            return object2.toString();
        }
        return string;
    }

    private String trimZeros(String string) {
        int n;
        for (n = string.length(); n > 0 && string.charAt(n - 1) == '0'; --n) {
        }
        if (n > 0 && string.charAt(n - 1) == '.') {
            --n;
        }
        return string.substring(0, n);
    }
}

