/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.spectral_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trends.res.TrendsResBundle;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class SpectralDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    static final String SPAN_TEXT = "IDS_TIME_SPECTRAL_SPAN";
    static final String CENTER_VARIABLE_KEY = "IDS_TIME_SPECTRAL_CENTER_VARIABLE_CHECK_BOX";
    static final String BIVARIATE_KEY = "IDS_TIME_SPECTRAL_BIVARIATE_ANALYSIS_CHECK_BOX";
    static final String PERIODOGRAM_KEY = "IDS_TIME_SPECTRAL_PERIODOGRAM_CHECK_BOX";
    static final String SPECTRAL_DENSITY_KEY = "IDS_TIME_SPECTRAL_SPECTRAL_DENSITY_CHECK_BOX";
    static final String SQUARED_COHERENCY_KEY = "IDS_TIME_SPECTRAL_SQUARED_COHERENCY_CHECK_BOX";
    static final String COSPECTRAL_DENSITY_KEY = "IDS_TIME_SPECTRAL_COSPECTRAL_DENSITY_CHECK_BOX";
    static final String QUADRATURE_SPECTRUM_KEY = "IDS_TIME_SPECTRAL_QUADRATURE_SPECTRUM_CHECK_BOX";
    static final String PHASE_SPECTRUM_KEY = "IDS_TIME_SPECTRAL_PHASE_SPECTRUM_CHECK_BOX";
    static final String CROSS_AMPLITUDE_KEY = "IDS_TIME_SPECTRAL_CROSS_AMPLITUDE_CHECK_BOX";
    static final String GAIN_KEY = "IDS_TIME_SPECTRAL_GAIN_CHECK_BOX";
    static final String BY_FREQUENCY_KEY = "IDS_TIME_SPECTRAL_BY_FREQUENCY_RADIO";
    static final String BY_PERIOD_KEY = "IDS_TIME_SPECTRAL_BY_PERIOD_RADIO";
    static final String SPECTRAL_WIN_COMBO_KEY = "IDS_TIME_SPECTRAL_WIN_COMBO";
    private static final int SPAN_MINVALUE = 0;
    private static final int SPAN_MAXVALUE = 99;
    private static final String TIME_SERIES_SPECTRAL_SRCLIST_KEY = "TIME_SERIES_SPECTRAL_SRCLIST_KEY";
    private static final String TIME_SERIES_SPECTRAL_TARLIST_KEY = "TIME_SERIES_SPECTRAL_TARLIST_KEY";
    private static final String SPAN_VALUE = "5";
    private static final String SPAN_SIZE = "2";
    private JComboBox mSpectralWinCB;
    private IntTextField mSpan;
    private JLabel mSpanLabel;
    private JCheckBox mCenterVariable;
    private JCheckBox mBivariate;
    private JCheckBox mPeriodogram;
    private JCheckBox mSpectralDensity;
    private JCheckBox mSquaredCoherency;
    private JCheckBox mCospectralDensity;
    private JCheckBox mQuadratureSpectrum;
    private JCheckBox mPhaseSpectrum;
    private JCheckBox mCrossAmplitude;
    private JCheckBox mGain;
    private JRadioButton mByFrequency;
    private JRadioButton mByPeriod;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVariableList;
    private ArrowButton mArrowButton;
    private SpssButtonGroup mRadioGroup;

    public SpectralDlg(JFrame jFrame) {
        super(jFrame, false, TrendsResBundle.getDefaultResourceBundleName(), TrendsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TIME_SERIES_SPECTRAL_TITLE"));
    }

    @Override
    public final String getIActionKey() {
        return "analyze_time_series_spectral";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableButtons();
        this.enableBivariate();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableButtons();
        this.enableBivariate();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableButtons();
        this.enableBivariate();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mSpectralWinCB.getSelectedIndex() != 5;
        this.mSpan.setEnabled(bl);
        this.mSpan.setOpaque(bl);
        this.mSpanLabel.setEnabled(bl);
        this.enableButtons();
        this.enableCheckBoxes();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer = stringBuffer.append("* " + this.getResString("IDS_TIME_SERIES_SPECTRAL_SYNTAX_TITLE") + ".");
        stringBuffer = stringBuffer.append("\n");
        stringBuffer = stringBuffer.append(SyntaxUtil.getMainCommand("TSET "));
        stringBuffer = stringBuffer.append(SyntaxUtil.getMainCommandParamters("PRINT=DEFAULT"));
        stringBuffer = stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer = stringBuffer.append(SyntaxUtil.getMainCommand("SPECTRA"));
        stringBuffer = stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMultiValueSubCommand("VARIABLES", Arrays.asList(this.mTargetVariableList.getVariablesStringList()), true));
        int n = this.mSpectralWinCB.getSelectedIndex();
        switch (n) {
            case 0: {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("WINDOW", "HAMMING", this.mSpan.getText(), true));
                break;
            }
            case 1: {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("WINDOW", "TUKEY", this.mSpan.getText(), true));
                break;
            }
            case 2: {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("WINDOW", "PARZEN", this.mSpan.getText(), true));
                break;
            }
            case 3: {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("WINDOW", "BARTLETT", this.mSpan.getText(), true));
                break;
            }
            case 4: {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("WINDOW", "DANIELL", this.mSpan.getText(), true));
                break;
            }
            case 5: {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("WINDOW", "NONE", true));
            }
        }
        if (this.mCenterVariable.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/CENTER"));
            stringBuffer.append("\n");
        }
        String string = "";
        if (this.mPeriodogram.isSelected()) {
            string = string + "P ";
        }
        if (this.mSpectralDensity.isSelected()) {
            string = string + "S ";
        }
        if (this.mBivariate.isEnabled() && this.mBivariate.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/CROSS"));
            if (this.mSquaredCoherency.isSelected()) {
                string = string + "K ";
            }
            if (this.mCospectralDensity.isSelected()) {
                string = string + "CS ";
            }
            if (this.mQuadratureSpectrum.isSelected()) {
                string = string + "QS ";
            }
            if (this.mPhaseSpectrum.isSelected()) {
                string = string + "PH ";
            }
            if (this.mCrossAmplitude.isSelected()) {
                string = string + "A ";
            }
            if (this.mGain.isSelected()) {
                string = string + "G ";
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getMultiValueSubCommand("PLOT", Arrays.asList(string), false));
        if (this.mByFrequency.isSelected()) {
            stringBuffer.append(" BY FREQUENCY");
        } else {
            stringBuffer.append(" BY PERIOD");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVariableList.removeAll();
        this.mSpectralDensity.setSelected(false);
        this.mBivariate.setSelected(false);
        this.mSquaredCoherency.setSelected(false);
        this.mCospectralDensity.setSelected(false);
        this.mQuadratureSpectrum.setSelected(false);
        this.mPhaseSpectrum.setSelected(false);
        this.mCrossAmplitude.setSelected(false);
        this.mGain.setSelected(false);
        this.mSpectralWinCB.setSelectedIndex(0);
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_spec";
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (this.mSpan.isEnabled() && Integer.parseInt(this.mSpan.getText()) % 2 != 1) {
            bl = false;
            if (Integer.parseInt(this.mSpan.getText()) == 0) {
                this.mSpan.requestFocus();
                this.mSpan.selectAll();
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_TIME_SPECTRAL_SPAN_TEXT_ALERT_FOR_ZERO"), VersionInfo.getAppVersionString());
            } else {
                this.mSpan.requestFocus();
                this.mSpan.selectAll();
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_TIME_SPECTRAL_SPAN_TEXT_ALERT_FOR_ODD"), VersionInfo.getAppVersionString());
            }
        }
        return bl;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setTabTraversalOrder();
        JPanel jPanel2 = this.setupAllPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mCenterVariable.setSelected(true);
        this.mPeriodogram.setSelected(true);
        this.mSpan.setText(SPAN_VALUE);
        this.mBivariate.setEnabled(false);
        this.mSquaredCoherency.setEnabled(false);
        this.mCospectralDensity.setEnabled(false);
        this.mQuadratureSpectrum.setEnabled(false);
        this.mPhaseSpectrum.setEnabled(false);
        this.mCrossAmplitude.setEnabled(false);
        this.mGain.setEnabled(false);
        this.mByFrequency.setSelected(true);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVariableList);
        vector.add(this.mSpectralWinCB);
        vector.add(this.mSpan);
        vector.add(this.mCenterVariable);
        vector.add(this.mBivariate);
        vector.add(this.mPeriodogram);
        vector.add(this.mSpectralDensity);
        vector.add(this.mSquaredCoherency);
        vector.add(this.mCospectralDensity);
        vector.add(this.mQuadratureSpectrum);
        vector.add(this.mPhaseSpectrum);
        vector.add(this.mCrossAmplitude);
        vector.add(this.mGain);
        vector.add(this.mRadioGroup);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(2048, false));
        this.mSrcVarList.setIdentifier(TIME_SERIES_SPECTRAL_SRCLIST_KEY);
        this.mSrcVarList.loadFromActiveDataset();
        this.mTargetVariableList = new TargetVariableList();
        this.mTargetVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVariableList.addVarFilter(new SpssVarFilter(2048, false));
        this.mTargetVariableList.getModel().addListDataListener(this);
        this.mTargetVariableList.setIdentifier(TIME_SERIES_SPECTRAL_TARLIST_KEY);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVariableList, SpssArrowButton.ButtonOrientation.left);
        ControlAction controlAction = new ComboboxAction(this, SPECTRAL_WIN_COMBO_KEY);
        this.mSpectralWinCB = new JComboBox<String>(this.getResStringArray("IDS_TIME_SPECTRAL_WIN_COMBO_ITEM"));
        this.mSpectralWinCB.setAction(controlAction);
        this.mSpectralWinCB.addItemListener(this);
        controlAction = new TextFieldAction(this, SPAN_TEXT);
        this.mSpan = new IntTextField(0, 99, true);
        this.mSpan.setColumns(Integer.parseInt(SPAN_SIZE));
        this.mSpan.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        this.mSpan.setAction((Action)controlAction);
        this.mSpan.getDocument().addDocumentListener(this);
        this.mSpanLabel = DialogUtil.createLabel(this, "IDS_TIME_SPECTRAL_SPAN_TEXT_LABEL");
        this.mSpanLabel.setLabelFor((Component)this.mSpan);
        controlAction = new ToggleButtonAction(this, CENTER_VARIABLE_KEY);
        this.mCenterVariable = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, BIVARIATE_KEY);
        this.mBivariate = new JCheckBox(controlAction);
        this.mBivariate.addItemListener(this);
        controlAction = new ToggleButtonAction(this, PERIODOGRAM_KEY);
        this.mPeriodogram = new JCheckBox(controlAction);
        this.mPeriodogram.addItemListener(this);
        controlAction = new ToggleButtonAction(this, SPECTRAL_DENSITY_KEY);
        this.mSpectralDensity = new JCheckBox(controlAction);
        this.mSpectralDensity.addItemListener(this);
        controlAction = new ToggleButtonAction(this, SQUARED_COHERENCY_KEY);
        this.mSquaredCoherency = new JCheckBox(controlAction);
        this.mSquaredCoherency.addItemListener(this);
        controlAction = new ToggleButtonAction(this, COSPECTRAL_DENSITY_KEY);
        this.mCospectralDensity = new JCheckBox(controlAction);
        this.mCospectralDensity.addItemListener(this);
        controlAction = new ToggleButtonAction(this, QUADRATURE_SPECTRUM_KEY);
        this.mQuadratureSpectrum = new JCheckBox(controlAction);
        this.mQuadratureSpectrum.addItemListener(this);
        controlAction = new ToggleButtonAction(this, PHASE_SPECTRUM_KEY);
        this.mPhaseSpectrum = new JCheckBox(controlAction);
        this.mPhaseSpectrum.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CROSS_AMPLITUDE_KEY);
        this.mCrossAmplitude = new JCheckBox(controlAction);
        this.mCrossAmplitude.addItemListener(this);
        controlAction = new ToggleButtonAction(this, GAIN_KEY);
        this.mGain = new JCheckBox(controlAction);
        this.mGain.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPeriodogram);
        spssButtonGroup.add(this.mSpectralDensity);
        spssButtonGroup.add(this.mSquaredCoherency);
        spssButtonGroup.add(this.mCospectralDensity);
        spssButtonGroup.add(this.mQuadratureSpectrum);
        spssButtonGroup.add(this.mPhaseSpectrum);
        spssButtonGroup.add(this.mCrossAmplitude);
        spssButtonGroup.add(this.mGain);
        controlAction = new ToggleButtonAction(this, BY_FREQUENCY_KEY);
        this.mByFrequency = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, BY_PERIOD_KEY);
        this.mByPeriod = new JRadioButton(controlAction);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mByFrequency);
        this.mRadioGroup.add(this.mByPeriod);
    }

    private void enableCheckBoxes() {
        boolean bl = this.mBivariate.isEnabled() && this.mBivariate.isSelected();
        this.mSquaredCoherency.setEnabled(bl);
        this.mCospectralDensity.setEnabled(bl);
        this.mQuadratureSpectrum.setEnabled(bl);
        this.mPhaseSpectrum.setEnabled(bl);
        this.mCrossAmplitude.setEnabled(bl);
        this.mGain.setEnabled(bl);
    }

    private void enableBivariate() {
        this.mBivariate.setEnabled(this.mTargetVariableList.getModel().getSize() >= 2);
        this.enableCheckBoxes();
    }

    private void enableButtons() {
        if (this.mTargetVariableList.getModel().getSize() >= 1) {
            if (this.mPeriodogram.isSelected() || this.mSpectralDensity.isSelected()) {
                if (!this.mSpan.isEnabled() || this.mSpan.getText().length() != 0) {
                    this.enableOkPaste(true);
                } else {
                    this.enableOkPaste(false);
                }
            } else if (this.mBivariate.isEnabled() && this.mBivariate.isSelected()) {
                if (this.mSquaredCoherency.isSelected() || this.mCospectralDensity.isSelected() || this.mQuadratureSpectrum.isSelected() || this.mPhaseSpectrum.isSelected() || this.mCrossAmplitude.isSelected() || this.mGain.isSelected()) {
                    if (!this.mSpan.isEnabled() || this.mSpan.getText().length() != 0) {
                        this.enableOkPaste(true);
                    } else {
                        this.enableOkPaste(false);
                    }
                } else {
                    this.enableOkPaste(false);
                }
            } else {
                this.enableOkPaste(false);
            }
        } else {
            this.enableOkPaste(false);
        }
    }

    private JPanel setupAllPanel() {
        JPanel jPanel = this.setupListPanel();
        JPanel jPanel2 = this.setupSpectralWinPanel();
        JPanel jPanel3 = this.setupPlotPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2 - 5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        insets = new Insets(0, n2 - 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 5, 2, 1, n, insets);
        insets = new Insets(0, n2 - 9, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCenterVariable, gridBagConstraints, 2, 3, 1, 1, n, insets);
        insets.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mBivariate, gridBagConstraints, 1, 4, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPlotPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JComponent[] jComponentArray = new JComponent[]{this.mPeriodogram, this.mSquaredCoherency, this.mQuadratureSpectrum, this.mCrossAmplitude, this.mSpectralDensity, this.mCospectralDensity, this.mPhaseSpectrum, this.mGain};
        jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_TIME_SPECTRAL_PLOT_GROUP_LABEL"), 4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2 - 4, n2 - 2);
        Insets insets2 = new Insets(n2 - 2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 4, 3, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mByFrequency, gridBagConstraints, 0, 5, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mByPeriod, gridBagConstraints, 1, 5, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TIME_SERIES_SPECTRAL_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TIME_SERIES_VARIABLES_LIST_LABEL");
        jLabel2.setLabelFor(this.mTargetVariableList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVariableList);
        jScrollPane.setPreferredSize(this.mTargetVariableList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupSpectralWinPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSpectralWinCB, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TIME_SPECTRAL_SPECTRAL_WIN_GROUP_LABEL");
        jLabel.setLabelFor(this.mSpectralWinCB);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSpanLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSpan, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.setupMnemonickey(jPanel, jLabel);
        return jPanel2;
    }
}

