/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.sequence_charts;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.DateFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.sequence_charts.SequenceDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SequenceTimeLines
extends BaseSubDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    static final String NO_REF_LINES_KEY = "IDS_NO_REF_LINES_RADIO";
    static final String LINE_AT_CHANGE_KEY = "IDS_LINE_AT_CHANGE_RADIO";
    static final String LINE_AT_DATE_KEY = "IDS_LINE_AT_DATE_RADIO";
    static final String SEQTIMELINES_DATENAMES_KEY = "SEQTIMELINES_DATENAMES_KEY";
    static final String SEQTIMELINES_DATEVALUES_KEY = "SEQTIMELINES_DATEVALUES_KEY";
    static final String SEQTIMELINES_REF_VARLIST_KEY = "SEQTIMELINES_REF_VARLIST_KEY";
    static final String SEQTIMELINES_SRCLIST_KEY = "SEQTIMELINES_SRCLIST_KEY";
    private DateFactory.DatePanel mDatePanel;
    private JRadioButton mNoRefLinesRadio;
    private JRadioButton mLineAtChangeRadio;
    private JRadioButton mLineAtDateRadio;
    private SrcVariableList mSeqTimeLinesSrcVarList;
    private ArrowButton mSeqTimeLinesArrowButton;
    private List<Integer> mPeriodicity;
    private SequenceDlg mSequenceDlg;
    private TargetVariableList mRefVarList;
    private SpssButtonGroup mGroup;

    public SequenceTimeLines(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_SEQUENCE_TIME_LINES_TITLE"), true);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableContinue(this.mRefVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableContinue(this.mRefVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableContinue(this.mRefVarList.getModel().getSize() > 0);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDatePanel.getFields()[0].getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDatePanel.getFields()[0].getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDatePanel.getFields()[0].getText().length() > 0);
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (this.mLineAtDateRadio.isSelected()) {
            int n = this.mDatePanel.getFields().length;
            for (int i = 1; bl && i < n; ++i) {
                if (this.mDatePanel.getFields()[i - 1].getText().length() != 0 || this.mDatePanel.getFields()[i].getText().length() <= 0) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_HIGHERDATE_EMPTY_WARNING"), VersionInfo.getAppVersionString());
                this.mDatePanel.getFields()[i - 1].requestFocus();
                bl = false;
            }
            for (int i = 0; bl && i < n; ++i) {
                String string = this.mDatePanel.getFields()[i].getText();
                int n2 = this.mPeriodicity.get(i);
                if (string.length() <= 0 || n2 <= 0 || Integer.parseInt(string) < n2) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXCEED_PERIODICITY_WARNING"), VersionInfo.getAppVersionString());
                this.mDatePanel.getFields()[i].requestFocus();
                this.mDatePanel.getFields()[i].selectAll();
                bl = false;
            }
        }
        if (bl) {
            bl = super.continuePressed();
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableComponents();
        this.enableButtons();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        JPanel jPanel2 = this.setupListPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNoRefLinesRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLineAtChangeRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n2 = 23;
        Insets insets2 = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLineAtDateRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        insets2 = new Insets(0, n * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDatePanel, gridBagConstraints, 0, 4, 1, 1, n2, insets2);
        this.pack();
        this.setTabTraversalOrder();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gseq_mark";
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        SrcVariableList srcVariableList = new SrcVariableList();
        srcVariableList.loadFromActiveDataset();
        this.mDatePanel.saveState(this.mSequenceDlg.getDialogDataModel(), SEQTIMELINES_DATEVALUES_KEY, SEQTIMELINES_DATENAMES_KEY, srcVariableList);
        if (this.mLineAtChangeRadio.isSelected()) {
            this.mSequenceDlg.getDialogDataModel().putString(SEQTIMELINES_REF_VARLIST_KEY, this.mRefVarList.getVariablesStringList());
        }
        boolean bl = super.saveState(dialogDataModel);
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        SrcVariableList srcVariableList = new SrcVariableList();
        srcVariableList.loadFromActiveDataset();
        if (DateFactory.hasDateFormatChanged(this.mSequenceDlg.getDialogDataModel(), SEQTIMELINES_DATENAMES_KEY, srcVariableList)) {
            this.mNoRefLinesRadio.setSelected(true);
        } else {
            this.mDatePanel.loadState(this.mSequenceDlg.getDialogDataModel(), SEQTIMELINES_DATEVALUES_KEY);
        }
        this.enableComponents();
        this.enableButtons();
    }

    void enableComponents() {
        boolean bl = this.mLineAtChangeRadio.isSelected();
        this.mSeqTimeLinesSrcVarList.setEnabled(bl);
        this.mRefVarList.setEnabled(bl);
        int n = this.mDatePanel.getFields().length;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = this.mLineAtDateRadio.isSelected();
            this.mDatePanel.getFields()[i].setEnabled(bl2);
            this.mDatePanel.getFields()[i].setOpaque(bl2);
            this.mDatePanel.getLabels()[i].setEnabled(bl2);
        }
    }

    void enableButtons() {
        if (this.mNoRefLinesRadio.isSelected()) {
            this.enableContinue(true);
        } else if (this.mLineAtChangeRadio.isSelected()) {
            this.enableContinue(this.mRefVarList.getModel().getSize() > 0);
        } else if (this.mLineAtDateRadio.isSelected()) {
            this.enableContinue(this.mDatePanel.getFields()[0].getText().length() > 0);
        }
    }

    private void initVars() {
        this.mSequenceDlg = (SequenceDlg)this.mParentDlg;
        this.mSeqTimeLinesSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        VarListModel varListModel = this.mSequenceDlg.getSourceList().getModel();
        VarListModel varListModel2 = this.mSeqTimeLinesSrcVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            varListModel2.addElement(varListModel.getElementAt(i));
        }
        this.mRefVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mRefVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRefVarList.getModel().addListDataListener(this);
        this.mRefVarList.setIdentifier(SEQTIMELINES_REF_VARLIST_KEY);
        this.mSeqTimeLinesSrcVarList.setIdentifier(SEQTIMELINES_SRCLIST_KEY);
        this.mSeqTimeLinesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSeqTimeLinesArrowButton.registerVariableList(this.mSeqTimeLinesSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSeqTimeLinesArrowButton.registerVariableList(this.mRefVarList, SpssArrowButton.ButtonOrientation.left);
        SrcVariableList srcVariableList = new SrcVariableList();
        srcVariableList.loadFromActiveDataset();
        this.mDatePanel = DateFactory.getPanel(srcVariableList);
        this.mPeriodicity = DateFactory.getPeriodicity(srcVariableList);
        this.mDatePanel.getFields()[0].getDocument().addDocumentListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, LINE_AT_CHANGE_KEY);
        this.mLineAtChangeRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, LINE_AT_DATE_KEY);
        this.mLineAtDateRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, NO_REF_LINES_KEY);
        this.mNoRefLinesRadio = new JRadioButton(toggleButtonAction);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mNoRefLinesRadio);
        this.mGroup.add(this.mLineAtChangeRadio);
        this.mGroup.add(this.mLineAtDateRadio);
        this.mNoRefLinesRadio.addItemListener(this);
        this.mLineAtChangeRadio.addItemListener(this);
        this.mLineAtDateRadio.addItemListener(this);
    }

    private void setDefaults() {
        this.mSeqTimeLinesSrcVarList.setSelectedIndex(0);
        this.mSeqTimeLinesSrcVarList.setEnabled(false);
        this.mSeqTimeLinesSrcVarList.setOpaque(false);
        this.mNoRefLinesRadio.setSelected(true);
        this.enableComponents();
    }

    private void setTabTraversalOrder() {
        IntTextField[] intTextFieldArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mSeqTimeLinesSrcVarList);
        vector.add(this.mSeqTimeLinesArrowButton);
        vector.add(this.mRefVarList);
        Object[] objectArray = intTextFieldArray = this.mDatePanel.getFields();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            IntTextField intTextField = objectArray[i];
            vector.add(intTextField);
        }
        for (IntTextField intTextField : objectArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(intTextField);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mSeqTimeLinesSrcVarList);
        jScrollPane.setPreferredSize(this.mSeqTimeLinesSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 3, n, insets);
        JPanel jPanel2 = this.setupReferencePanel();
        Insets insets3 = new Insets(insets2.top * 3 - 2, 0, 0, 0);
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupReferencePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_REF_VAR_COLON_LABEL");
        jLabel.setLabelFor(this.mRefVarList);
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mRefVarList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mRefVarList.getMinimumSize());
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 20, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mSeqTimeLinesArrowButton, gridBagConstraints, 0, 0, 1, 2, 20, insets3);
        return jPanel;
    }
}

