/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.sequence_charts;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SequenceFormat
extends BaseSubDialog {
    static final String TIME_HOR_AXIS_KEY = "IDS_TIME_HOR_AXIS_CHECK";
    static final String LINE_CHART_KEY = "IDS_LINE_CHART_RADIO";
    static final String AREA_CHART_KEY = "IDS_AREA_CHART_RADIO";
    static final String REF_LINE_MEAN_KEY = "IDS_REF_LINE_MEAN_CHECK";
    static final String CONNECT_CASES_KEY = "IDS_CONNECT_CASES_CHECK";
    private JCheckBox mTimeHorAxisCheck;
    private JRadioButton mLineChartRadio;
    private JRadioButton mAreaChartRadio;
    private JCheckBox mRefLineMeanCheck;
    private JCheckBox mConnectCasesCheck;
    private SpssButtonGroup mRadioButtonGroup;

    public SequenceFormat(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_SEQUENCE_FORMAT_TITLE"), true);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTimeHorAxisCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupSingleVarCharts();
        insets.top = n;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        jPanel2 = this.setupMultipleVarCharts();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gseq_format";
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TIME_HOR_AXIS_KEY);
        this.mTimeHorAxisCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LINE_CHART_KEY);
        this.mLineChartRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, AREA_CHART_KEY);
        this.mAreaChartRadio = new JRadioButton(toggleButtonAction);
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mRadioButtonGroup.add(this.mLineChartRadio);
        this.mRadioButtonGroup.add(this.mAreaChartRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, REF_LINE_MEAN_KEY);
        this.mRefLineMeanCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CONNECT_CASES_KEY);
        this.mConnectCasesCheck = new JCheckBox(toggleButtonAction);
    }

    private void setDefaults() {
        this.mTimeHorAxisCheck.setSelected(true);
        this.mLineChartRadio.setSelected(true);
        this.mRefLineMeanCheck.setSelected(false);
        this.mConnectCasesCheck.setSelected(false);
    }

    private JPanel setupSingleVarCharts() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_SINGLE_VAR_CHART")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, n, insets.bottom, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mLineChartRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAreaChartRadio, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.bottom = n;
        DialogUtil.addUsingGBL(jPanel, this.mRefLineMeanCheck, gridBagConstraints, 0, 1, 2, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupMultipleVarCharts() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MULTIPLE_VAR_CHART")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mConnectCasesCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTimeHorAxisCheck);
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mRefLineMeanCheck);
        vector.add(this.mConnectCasesCheck);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

