/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.sequence_charts;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.DateFactory;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.sequence_charts.SequenceFormat;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.sequence_charts.SequenceTimeLines;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class SequenceDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener {
    static final String NATURAL_LOG_TRANS_KEY = "IDS_NATURAL_LOG_TRANS_CHECK";
    static final String DIFFERENCE_KEY = "IDS_DIFFERENCE_COLON_CHECK";
    static final String SEASONNALY_DIFF_KEY = "IDS_SEASONALLY_DIFF_CHECK";
    static final String ONE_CHART_PER_VAR_KEY = "IDS_ONE_CHART_PER_VAR_CHECK";
    static final String SEQCHART_SRCLIST_KEY = "SEQCHART_SRCLIST_KEY";
    static final String SEQCHART_VARLIST_KEY = "SEQCHART_VARLIST_KEY";
    static final String SEQCHART_TIMEAXISLIST_KEY = "SEQCHART_TIMEAXISLIST_KEY";
    static final String SEQCHART_DIFFERNECE_KEY = "SEQCHART_DIFFERNECE_KEY";
    static final String SEQCHART_SEA_DIFFERNECE_KEY = "SEQCHART_SEA_DIFFERNECE_KEY";
    private static final String SEASONALLY_DIFF_DEFAULT_VALUE = "1";
    private static final String DIFFERENCE_DEFAULT_VALUE = "1";
    JCheckBox mDifferenceCheck;
    IntTextField mDifferenceValEdit;
    JCheckBox mSeasonallyDiffCheck;
    IntTextField mSeasonallyDiffValEdit;
    private SrcVariableList mSeqChartSourceVarList;
    private TargetVariableList mSeqChartVariableList;
    private TargetVariableList mSeqChartTimeAxisList;
    private JCheckBox mNaturalLogTransCheck;
    private ArrowButton mSeqChartVarArrowButton;
    private ArrowButton mSeqChartTimeAxisArrowButton;
    private JCheckBox mOneChartPerVar;
    private JButton mTimeLinesButton;
    private JButton mFormatButton;
    private JLabel mCurrPeriodicityVal;
    private BaseSubDialog mTimeLinesDlg;
    private StringBuffer mBuffer;
    private int mDateVarCount;

    public SequenceDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_SEQUENCE_TITLE"));
    }

    @Override
    public String generateSyntax() {
        this.mBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.mBuffer.append("* ").append(this.getResString("IDS_SEQUENCE_SYNTAX_TITLE")).append(".");
        if (dialogDataModel.getBoolean(ONE_CHART_PER_VAR_KEY).booleanValue()) {
            String[] stringArray;
            for (String string : stringArray = this.mSeqChartVariableList.getVariablesStringList().split(" ")) {
                this.genSyntaxPerVar(string);
            }
        } else {
            this.genSyntaxPerVar(this.mSeqChartVariableList.getVariablesStringList());
        }
        this.mBuffer.append("\n");
        return this.mBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gseq";
    }

    @Override
    public void reset() {
        super.reset();
        this.mSeqChartSourceVarList.loadFromActiveDataset();
        this.mSeqChartSourceVarList.setSelectedIndex(0);
        this.mSeqChartSourceVarList.requestFocus();
        this.mSeqChartVariableList.removeAll();
        this.mSeqChartTimeAxisList.removeAll();
        this.mNaturalLogTransCheck.setSelected(false);
        this.mDifferenceCheck.setSelected(false);
        this.mSeasonallyDiffCheck.setSelected(false);
        this.mSeqChartVarArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSeqChartTimeAxisArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mOneChartPerVar.setSelected(false);
        this.setDefaults();
    }

    @Override
    public boolean okPastePressed() {
        String string;
        DialogDataModel dialogDataModel;
        Boolean bl;
        boolean bl2 = true;
        if (this.mTimeLinesDlg != null && (bl = (dialogDataModel = this.getDialogDataModel()).getBoolean("IDS_LINE_AT_CHANGE_RADIO")) != null && bl.booleanValue() && (string = dialogDataModel.getString("SEQTIMELINES_REF_VARLIST_KEY")) != null) {
            String[] stringArray;
            for (String string2 : stringArray = this.mSeqChartVariableList.getVariablesStringList().split(" ")) {
                if (!string.equalsIgnoreCase(string2)) continue;
                bl2 = false;
            }
            if (string.equalsIgnoreCase(this.mSeqChartTimeAxisList.getVariablesStringList())) {
                bl2 = false;
            }
        }
        if (bl2) {
            super.okPastePressed();
        } else {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REF_VAR_WARNING"), VersionInfo.getAppVersionString());
        }
        return bl2;
    }

    public SrcVariableList getSourceList() {
        return this.mSeqChartSourceVarList;
    }

    @Override
    public final String getIActionKey() {
        return "analyze_time_series_sequence";
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableButtons();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.updateDateControls();
        this.enableSeasonalDiffControls();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        JScrollPane jScrollPane = new JScrollPane(this.mSeqChartSourceVarList);
        jScrollPane.setPreferredSize(this.mSeqChartSourceVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SEQUENCE_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSeqChartSourceVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSeqChartVarArrowButton, gridBagConstraints, 1, 1, 1, 1, 10, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SEQCHART_VARIABLES");
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        jScrollPane = new JScrollPane(this.mSeqChartVariableList);
        this.mSeqChartVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSeqChartVariableList.getFixedCellHeight() * 4 + 2));
        jScrollPane.setPreferredSize(this.mSeqChartVariableList.getMinimumSize());
        jLabel2.setLabelFor(this.mSeqChartVariableList);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_TIME_AXIS_LABEL_VARIABLE_COLON");
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        jScrollPane = new JScrollPane(this.mSeqChartTimeAxisList);
        jScrollPane.setPreferredSize(this.mSeqChartTimeAxisList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        jLabel3.setLabelFor(this.mSeqChartTimeAxisList);
        gridBagConstraints.weightx = 0.0;
        n = 20;
        gridBagConstraints.fill = 0;
        insets = new Insets(n2, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSeqChartTimeAxisArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        JPanel jPanel2 = this.setupTransformPanel();
        gridBagConstraints.fill = 2;
        insets2.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 4, 2, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mOneChartPerVar, gridBagConstraints, 0, 5, 3, 1, n, insets2);
        this.mSeqChartVarArrowButton.registerVariableList(this.mSeqChartSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSeqChartVarArrowButton.registerVariableList(this.mSeqChartVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mSeqChartTimeAxisArrowButton.registerVariableList(this.mSeqChartSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSeqChartTimeAxisArrowButton.registerVariableList(this.mSeqChartTimeAxisList, SpssArrowButton.ButtonOrientation.left);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_TIME_LINES_3DOT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SequenceDlg.this.runTimeLinesSubDialog();
            }
        };
        this.mTimeLinesButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mTimeLinesButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_FORMAT_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SequenceDlg.this.runFormatSubDialog();
            }
        };
        this.mFormatButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mFormatButton);
        return jPanel;
    }

    void runTimeLinesSubDialog() {
        this.mTimeLinesDlg = new SequenceTimeLines(this);
        this.runSubDialog(this.mTimeLinesDlg);
    }

    void runFormatSubDialog() {
        this.runSubDialog(new SequenceFormat(this));
    }

    void enableButtons() {
        boolean bl = true;
        if (this.mDifferenceCheck.isSelected() || this.mSeasonallyDiffCheck.isSelected()) {
            if (this.mDifferenceCheck.isSelected() && this.mDifferenceValEdit != null && this.mDifferenceValEdit.getText().length() == 0) {
                bl = false;
            }
            if (this.mSeasonallyDiffCheck.isSelected() && this.mSeasonallyDiffValEdit != null && this.mSeasonallyDiffValEdit.getText().length() == 0) {
                bl = false;
            }
        }
        this.enableOkPaste(bl && this.mSeqChartVariableList.getModel().getSize() > 0);
    }

    private void initVars() {
        this.mSeqChartSourceVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSeqChartSourceVarList.loadFromActiveDataset();
        this.mSeqChartSourceVarList.setIdentifier(SEQCHART_SRCLIST_KEY);
        this.mSeqChartVariableList = new TargetVariableList();
        this.mSeqChartVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSeqChartVariableList.addVarFilter(new SpssVarFilter(8, false));
        this.mSeqChartVariableList.setIdentifier(SEQCHART_VARLIST_KEY);
        this.mSeqChartVariableList.setMaxLimitOfList(100);
        this.mSeqChartTimeAxisList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSeqChartTimeAxisList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSeqChartTimeAxisList.setIdentifier(SEQCHART_TIMEAXISLIST_KEY);
        this.mSeqChartVariableList.getModel().addListDataListener(this);
        this.mSeqChartSourceVarList.getModel().addListDataListener(this);
        this.mSeqChartVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSeqChartTimeAxisArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        ControlAction controlAction = new ToggleButtonAction(this, DIFFERENCE_KEY);
        this.mDifferenceCheck = new JCheckBox(controlAction);
        this.mDifferenceCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = SequenceDlg.this.mDifferenceCheck.isSelected();
                SequenceDlg.this.mDifferenceValEdit.setEnabled(bl);
                SequenceDlg.this.mDifferenceValEdit.setOpaque(bl);
                SequenceDlg.this.enableButtons();
            }
        });
        controlAction = new ToggleButtonAction(this, NATURAL_LOG_TRANS_KEY);
        this.mNaturalLogTransCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, SEASONNALY_DIFF_KEY);
        this.mSeasonallyDiffCheck = new JCheckBox(controlAction);
        this.mSeasonallyDiffCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SequenceDlg.this.enableSeasonalDiffControls();
            }
        });
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNaturalLogTransCheck);
        spssButtonGroup.add(this.mDifferenceCheck);
        spssButtonGroup.add(this.mSeasonallyDiffCheck);
        controlAction = new ToggleButtonAction(this, ONE_CHART_PER_VAR_KEY);
        this.mOneChartPerVar = new JCheckBox(controlAction);
        this.mDifferenceValEdit = new IntTextField(1, 99, true);
        this.mDifferenceValEdit.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        controlAction = new TextFieldAction(this, SEQCHART_DIFFERNECE_KEY);
        this.mDifferenceValEdit.setAction((Action)controlAction);
        this.mSeasonallyDiffValEdit = new IntTextField(1, 99, true);
        this.mSeasonallyDiffValEdit.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        controlAction = new TextFieldAction(this, SEQCHART_SEA_DIFFERNECE_KEY);
        this.mSeasonallyDiffValEdit.setAction((Action)controlAction);
        this.mCurrPeriodicityVal = new JLabel();
        this.mBuffer = new StringBuffer();
    }

    private void setDefaults() {
        this.mDifferenceValEdit.setText("1");
        this.mSeasonallyDiffValEdit.setText("1");
        this.mSeqChartSourceVarList.setSelectedIndex(0);
        this.mDifferenceValEdit.setColumns(2);
        this.mSeasonallyDiffValEdit.setColumns(2);
        boolean bl = this.mDifferenceCheck.isSelected();
        this.mDifferenceValEdit.setEnabled(bl);
        this.mDifferenceValEdit.setOpaque(bl);
        this.updateDateControls();
    }

    private JPanel setupTransformPanel() {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_TRANSFORM")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n2, n2, insets.bottom, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNaturalLogTransCheck, gridBagConstraints, 0, 0, 3, 1, n3, insets2);
        insets2.right = insets.right;
        DialogUtil.addUsingGBL(jPanel, this.mDifferenceCheck, gridBagConstraints, 0, 1, 2, 1, n3, insets2);
        insets2.right = n2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDifferenceValEdit, gridBagConstraints, 2, 1, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.right = insets.right;
        DialogUtil.addUsingGBL(jPanel, this.mSeasonallyDiffCheck, gridBagConstraints, 0, 2, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.right = n2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSeasonallyDiffValEdit, gridBagConstraints, 2, 2, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_CURR_PERIODICITY_LABEL"), 10);
        insets2.top = n = DialogUtil.getComponentGroupGap();
        insets2.bottom = n2;
        insets2.right = insets.right;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n3, insets2);
        insets2.right = n2;
        DialogUtil.addUsingGBL(jPanel, this.mCurrPeriodicityVal, gridBagConstraints, 1, 3, 1, 1, n3, insets2);
        this.mDifferenceValEdit.getDocument().addDocumentListener(this);
        this.mSeasonallyDiffValEdit.getDocument().addDocumentListener(this);
        return jPanel;
    }

    private void genSyntaxPerVar(String string) {
        Boolean bl;
        Object[] objectArray;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        SrcVariableList srcVariableList = new SrcVariableList();
        srcVariableList.loadFromActiveDataset();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_LINE_AT_DATE_RADIO");
        boolean bl3 = true;
        if (bl2 != null && bl2.booleanValue() && DateFactory.hasDateFormatChanged(dialogDataModel, "SEQTIMELINES_DATENAMES_KEY", srcVariableList)) {
            bl2 = false;
        }
        if (bl2 != null && bl2.booleanValue() && DateFactory.getDateVariableNames(srcVariableList).size() == 0) {
            objectArray = dialogDataModel.getArray("SEQTIMELINES_DATEVALUES_KEY");
            this.mBuffer.append("\n");
            this.mBuffer.append(SyntaxUtil.getMainCommand("TEMPORARY"));
            this.mBuffer.append(SyntaxUtil.terminateSyntax());
            this.mBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
            this.mBuffer.append(SyntaxUtil.getMainCommandParamters("#OBSN=#OBSN+1"));
            this.mBuffer.append(SyntaxUtil.terminateSyntax());
            this.mBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
            this.mBuffer.append(SyntaxUtil.getMainCommandParamters("MK_V_#=(#OBSN<" + objectArray[0] + ")"));
            this.mBuffer.append(SyntaxUtil.terminateSyntax());
            bl3 = false;
        }
        objectArray = dialogDataModel.getBoolean("IDS_TIME_HOR_AXIS_CHECK");
        if (bl3) {
            this.mBuffer.append("\n");
        }
        if (objectArray == null || objectArray.booleanValue()) {
            this.mBuffer.append(SyntaxUtil.getMainCommand("TSPLOT"));
            this.mBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        } else {
            this.mBuffer.append(SyntaxUtil.getMainCommand("CASEPLOT"));
            this.mBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        }
        this.mBuffer.append(string);
        String string2 = this.mSeqChartTimeAxisList.getVariablesStringList();
        if (string2.length() > 0) {
            this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/ID=")).append(string2);
        }
        if (this.mNaturalLogTransCheck.isSelected()) {
            this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/LN"));
        } else {
            this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/NOLOG"));
        }
        if (this.mDifferenceCheck.isSelected()) {
            this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/DIFF=")).append(this.mDifferenceValEdit.getText());
        }
        if (this.mSeasonallyDiffCheck.isEnabled() && this.mSeasonallyDiffCheck.isSelected()) {
            this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SDIFF=")).append(this.mSeasonallyDiffValEdit.getText());
        }
        if (string.split(" ").length == 1) {
            this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FORMAT "));
            bl = dialogDataModel.getBoolean("IDS_AREA_CHART_RADIO");
            if (bl != null && bl.booleanValue()) {
                if (objectArray.booleanValue()) {
                    this.mBuffer.append("BOTTOM ");
                } else {
                    this.mBuffer.append("LEFT ");
                }
            } else {
                this.mBuffer.append("NOFILL ");
            }
            bl = dialogDataModel.getBoolean("IDS_REF_LINE_MEAN_CHECK");
            if (bl == null || !bl.booleanValue()) {
                this.mBuffer.append("NOREFERENCE");
            } else {
                this.mBuffer.append("REFERENCE");
            }
        } else {
            bl = dialogDataModel.getBoolean("IDS_CONNECT_CASES_CHECK");
            if (bl != null && bl.booleanValue()) {
                this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FORMAT JOIN"));
            }
        }
        bl = dialogDataModel.getBoolean("IDS_LINE_AT_CHANGE_RADIO");
        if (bl != null && bl.booleanValue()) {
            this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MARK ")).append(dialogDataModel.getString("SEQTIMELINES_REF_VARLIST_KEY"));
        } else if (bl2 != null && bl2.booleanValue()) {
            if (!bl3) {
                this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MARK MK_V_#"));
            } else {
                Object[] objectArray2 = dialogDataModel.getArray("SEQTIMELINES_DATEVALUES_KEY");
                Object[] objectArray3 = dialogDataModel.getArray("SEQTIMELINES_DATENAMES_KEY");
                this.mBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MARK"));
                for (int i = 0; i < objectArray3.length; ++i) {
                    if (objectArray2[i].toString().length() <= 0) continue;
                    this.mBuffer.append(" ").append(objectArray3[i].toString().replace("_", ""));
                    this.mBuffer.append(" ").append(objectArray2[i].toString());
                }
            }
        }
        this.mBuffer.append(".");
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSeqChartSourceVarList);
        vector.add(this.mSeqChartVarArrowButton);
        vector.add(this.mSeqChartTimeAxisArrowButton);
        vector.add(this.mSeqChartVariableList);
        vector.add(this.mSeqChartTimeAxisList);
        vector.add(this.mNaturalLogTransCheck);
        vector.add(this.mDifferenceCheck);
        vector.add(this.mDifferenceValEdit);
        vector.add(this.mSeasonallyDiffCheck);
        vector.add(this.mSeasonallyDiffValEdit);
        vector.add(this.mOneChartPerVar);
        vector.add(this.mTimeLinesButton);
        vector.add(this.mFormatButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private void updateDateControls() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        ITrendsInfo iTrendsInfo = iSpssDataSrc.getTrendsInfo();
        this.mDateVarCount = iTrendsInfo.getNDateVars();
        if (this.mDateVarCount > 1) {
            this.mSeasonallyDiffCheck.setEnabled(true);
            boolean bl = this.mSeasonallyDiffCheck.isSelected();
            this.mSeasonallyDiffValEdit.setEnabled(bl);
            this.mSeasonallyDiffValEdit.setEditable(bl);
            this.mSeasonallyDiffValEdit.setOpaque(bl);
            this.mCurrPeriodicityVal.setText(Integer.toString(iTrendsInfo.getPeriod()));
        } else {
            this.mSeasonallyDiffCheck.setEnabled(false);
            this.mSeasonallyDiffValEdit.setEnabled(false);
            this.mSeasonallyDiffValEdit.setEditable(false);
            this.mSeasonallyDiffValEdit.setOpaque(false);
            this.mCurrPeriodicityVal.setText(this.getResString("IDS_PERODICITY_NONE"));
        }
        this.enableButtons();
        this.mSeqChartSourceVarList.setSelectedIndex(0);
    }

    private void enableSeasonalDiffControls() {
        boolean bl = this.mSeasonallyDiffCheck.isSelected() && this.mSeasonallyDiffCheck.isEnabled();
        this.mSeasonallyDiffValEdit.setEnabled(bl);
        this.mSeasonallyDiffValEdit.setEditable(bl);
        this.mSeasonallyDiffValEdit.setOpaque(bl);
        this.enableButtons();
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new DataObserver();
    }

    private class DataObserver
    extends BaseProcedureDialog.DataViewObserverAdapter {
        private DataObserver() {
            super(SequenceDlg.this);
        }

        @Override
        public void notifyTrendsInfo() {
            SequenceDlg.this.updateDateControls();
        }
    }
}

