/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.seasonal_decomp;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.seasonal_decomp.SeasonalDecompSaveSubDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trends.res.TrendsResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SeasonalDecompDlg
extends BaseProcedureDialog
implements ListDataListener,
KeyListener,
ItemListener,
FocusListener {
    public static final String SOURCE_LIST_IDENTIFIER_KEY = "sourcevars";
    public static final String TARGET_LIST_IDENTIFIER_KEY = "targetvars";
    static final int NEW_VARS_FACTOR = 4;
    static final String DISPLAYCASEWISE_CHECK_KEY = "IDS_TIME_SERIES_SEASONAL_DECOMP_DISPLAY_CASEWISE";
    static final String PARTIAL_AUTOCORRELATIONS_CHECK_KEY = "IDS_AUTOCORR_PARTIAL_AUTOCORRELATIONS";
    static final String IDS_OPTIONS_KEY = "IDS_TIME_SERIES_SEASONAL_DECOMP_SAVE_BUTTON_LABEL";
    static final String MULTIPLICATIVE_RADIO = "IDS_TIME_SERIES_SEASONAL_DECOMP_MULTIPLICATIVE";
    static final String ADDITIVE_RADIO = "IDS_TIME_SERIES_SEASONAL_DECOMP_ADDITIVE";
    static final String ALL_RADIO = "IDS_TIME_SERIES_SEASONAL_DECOMP_ALL_POINTS_EQUAL";
    static final String END_POINTS_RADIO = "IDS_TIME_SERIES_SEASONAL_DECOMP_ENDPOINTS_WEIGHTED";
    static final String DEFAULT_DIFFERENCE_TXTFLD_VALUE = "1";
    static final String DEFAULT_SEASONALLY_DIFFERENCE_TXTFLD_VALUE = "1";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private JButton mSaveButton;
    private JCheckBox mDisplayCasewiseCheck;
    private SpssButtonGroup mModelGroup;
    private JRadioButton mModelMultiplicativeRadio;
    private JRadioButton mModelAdditiveRadio;
    private SpssButtonGroup mAveGroup;
    private JRadioButton mAveAllEqualRadio;
    private JRadioButton mAveEndWeightedRadio;
    private JLabel mPeriodicityLabel;
    private ITrendsInfo mTrendsInfo;
    private JPanel mAvePanel;
    private SaveSelection mSaveSelection;
    private boolean mResetSubDialog = true;

    public SeasonalDecompDlg(JFrame jFrame) {
        super(jFrame, false, TrendsResBundle.getDefaultResourceBundleName(), TrendsResBundle.getImageFolder());
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.updateUI();
        this.enableOkPaste(false);
    }

    @Override
    public String getIActionKey() {
        return "analyze_time_series_seasonal_decomp";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("* Seasonal Decomposition."));
        stringBuffer.append("\n");
        Integer n = this.mTargetVarList.getModel().getSize() * 4;
        String string = "";
        string = string + "TSET PRINT=";
        string = this.mDisplayCasewiseCheck.isSelected() ? string + "DEFAULT " : string + "BRIEF ";
        string = string + "NEWVAR=";
        if (this.mSaveSelection == SaveSelection.DONOTCREATE) {
            string = string + "NONE";
        } else {
            if (this.mSaveSelection == SaveSelection.ADDTOFILE) {
                string = string + "ALL ";
            } else if (this.mSaveSelection == SaveSelection.REPLACEEXISTING) {
                string = string + "CURRENT ";
            }
            string = string + "MXNEWVAR=%d";
        }
        stringBuffer.append(String.format(string, n));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append("SEASON");
        stringBuffer.append("\n  /VARIABLES=");
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(i);
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(iSpssVariable.getName());
        }
        stringBuffer.append("\n");
        stringBuffer.append("  /MODEL=");
        if (this.mModelMultiplicativeRadio.isSelected()) {
            stringBuffer.append("MULTIPLICATIVE");
        } else {
            stringBuffer.append("ADDITIVE");
        }
        if (this.mAveAllEqualRadio.isEnabled()) {
            stringBuffer.append("\n");
            stringBuffer.append("  /MA=");
            if (this.mAveAllEqualRadio.isSelected()) {
                stringBuffer.append("EQUAL");
            } else {
                stringBuffer.append("CENTERED");
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (this.mSaveSelection != SaveSelection.DONOTCREATE) {
            int n = this.mTargetVarList.getModel().getSize() * 4;
            String string = String.format(this.getResString("ERR_TIME_SERIES_SEASONAL_DECOMP_CREATE_VARS_MSG"), n, n);
            return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0;
        }
        return super.okPastePressed();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_seas";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mDisplayCasewiseCheck)) {
            this.enableDisableOkPaste();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void init() {
        this.setVisible(false);
        super.init();
        this.setTitle(this.getResString("IDS_TIME_SERIES_SEASONAL_DECOMP_DIALOG_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        this.mTrendsInfo = iSpssDataSrc.getTrendsInfo();
        if (this.mTrendsInfo.getPeriod() < 2) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("ERR_TIME_SERIES_SEASONAL_DECOMP_NOT_PERIODIC_MSG"), VersionInfo.getAppVersionString());
            this.dispose();
        } else {
            this.updateUI();
            this.setVisible(true);
        }
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.mSaveSelection = dialogDataModel.getBoolean("IDS_TIME_SERIES_SEASONAL_DECOMP_ADD_TO_FILE_RADIO") == null || dialogDataModel.getBoolean("IDS_TIME_SERIES_SEASONAL_DECOMP_ADD_TO_FILE_RADIO") != false ? SaveSelection.ADDTOFILE : (dialogDataModel.getBoolean("IDS_TIME_SERIES_SEASONAL_DECOMP_DO_NOT_CREATE_RADIO") != false ? SaveSelection.DONOTCREATE : SaveSelection.REPLACEEXISTING);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_OPTIONS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeasonalDecompDlg.this.runSaveSubDialog();
            }
        };
        this.mSaveButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier(SOURCE_LIST_IDENTIFIER_KEY);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DISPLAYCASEWISE_CHECK_KEY);
        this.mDisplayCasewiseCheck = new JCheckBox(toggleButtonAction);
        this.mDisplayCasewiseCheck.addItemListener(this);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setIdentifier(TARGET_LIST_IDENTIFIER_KEY);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMaxLimitOfList(100);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mModelGroup = new SpssButtonGroup();
        this.mModelGroup.setToggleBehaveAsRadioGroup(true);
        toggleButtonAction = new ToggleButtonAction(this, MULTIPLICATIVE_RADIO);
        this.mModelMultiplicativeRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ADDITIVE_RADIO);
        this.mModelAdditiveRadio = new JRadioButton(toggleButtonAction);
        this.mModelGroup.add(this.mModelMultiplicativeRadio);
        this.mModelGroup.add(this.mModelAdditiveRadio);
        this.mAveGroup = new SpssButtonGroup();
        this.mAveGroup.setToggleBehaveAsRadioGroup(true);
        toggleButtonAction = new ToggleButtonAction(this, ALL_RADIO);
        this.mAveAllEqualRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, END_POINTS_RADIO);
        this.mAveEndWeightedRadio = new JRadioButton(toggleButtonAction);
        this.mAveGroup.add(this.mAveAllEqualRadio);
        this.mAveGroup.add(this.mAveEndWeightedRadio);
        String string = this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_PREFIX");
        this.mPeriodicityLabel = new JLabel(string);
    }

    private ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mModelGroup);
        vector.add(this.mAveGroup);
        vector.add(this.mDisplayCasewiseCheck);
        vector.add(this.mSaveButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableDisableOkPaste() {
        if (this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
            return;
        }
        this.enableOkPaste(false);
    }

    private void setDefaults() {
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mTargetVarList.getModel().removeAll();
        this.mModelMultiplicativeRadio.setSelected(true);
        this.mModelAdditiveRadio.setSelected(false);
        this.mAveAllEqualRadio.setSelected(true);
        this.mAveEndWeightedRadio.setSelected(false);
        this.mDisplayCasewiseCheck.setSelected(false);
        this.mResetSubDialog = true;
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new SeasonalDecompSaveSubDlg(this, this.mResetSubDialog));
        this.mResetSubDialog = false;
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 0, 1, 5, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCasewiseCheck, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TIME_SERIES_SEASONAL_DECOMP_VARIABLES");
        jLabel.setLabelFor(this.mTargetVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_MODEL")));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mModelMultiplicativeRadio, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mModelAdditiveRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.mAvePanel = new JPanel();
        this.mAvePanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_SEASONAL_DECOMP_MOVING_AVE_WEIGHT")));
        this.mAvePanel.setLayout(new GridBagLayout());
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mAvePanel, this.mAveAllEqualRadio, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mAvePanel, this.mAveEndWeightedRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        Insets insets3 = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mAvePanel, gridBagConstraints, 1, 3, 2, 1, n, insets3);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPeriodicityLabel, gridBagConstraints, 1, 4, 2, 1, n, insets3);
        gridBagConstraints.fill = 0;
        n = 10;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private void updateUI() {
        this.mTrendsInfo = this.getDataSource().getTrendsInfo();
        String string = this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_PREFIX");
        string = string + Integer.toString(this.mTrendsInfo.getPeriod());
        this.mPeriodicityLabel.setText(string);
        int n = this.mTrendsInfo.getPeriod() % 2;
        if (n != 0) {
            this.enableDisablePanel(false);
        } else {
            this.enableDisablePanel(true);
        }
    }

    private void enableDisablePanel(boolean bl) {
        this.mAveAllEqualRadio.setEnabled(bl);
        this.mAveEndWeightedRadio.setEnabled(bl);
        DialogUtil.enableTitledBorder(this.mAvePanel, bl);
        this.repaint();
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new DataObserver();
    }

    protected void SetSaveSelection(SaveSelection saveSelection) {
        this.mSaveSelection = saveSelection;
    }

    protected static enum SaveSelection {
        ADDTOFILE,
        REPLACEEXISTING,
        DONOTCREATE;

    }

    public class DataObserver
    extends BaseProcedureDialog.DataViewObserverAdapter {
        public DataObserver() {
            super(SeasonalDecompDlg.this);
        }

        @Override
        public void notifyTrendsInfo() {
            SeasonalDecompDlg.this.updateUI();
            SeasonalDecompDlg.this.mSrcVarList.requestFocus();
            SeasonalDecompDlg.this.mSrcVarList.setSelectedIndex(0);
        }
    }
}

