/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.cross_correlation;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CrossCorrelationOptions
extends BaseSubDialog
implements DocumentListener {
    static final String DISLAY_CORREL_LAG_CHECK_KEY = "IDS_CROSS_CORREL_PERIOD_LAG_CHECK";
    static final String MAX_LAGS_KEY = "MAX_LAG_VAL";
    private JCheckBox mDisplayCorrelLagCheck;
    private int mCurPeriod;
    private ContextEnabledTextField mMaxLagsText;
    private Vector<Object> mTabOrder;

    public CrossCorrelationOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_CROSS_CORREL_OPTIONS_TITLE"), true);
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        int n = Integer.parseInt(this.mMaxLagsText.getText());
        if (this.mDisplayCorrelLagCheck.isSelected()) {
            if (n <= this.mCurPeriod) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CROSS_CORREL_PERIOD_LAG_MSG"), VersionInfo.getAppVersionString());
                bl = false;
            }
        } else if (n == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CROSS_CORREL_OUT_OF_RANGE_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        if (!bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CrossCorrelationOptions.this.mMaxLagsText.requestFocus();
                    CrossCorrelationOptions.this.mMaxLagsText.selectAll();
                }
            });
        }
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableDisableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableDisableContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableDisableContinue();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ccfu_opts";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        ControlAction controlAction = new TextFieldAction(this.mParentDlg, MAX_LAGS_KEY);
        this.mMaxLagsText = new ContextEnabledTextField();
        this.mMaxLagsText.setAction((Action)controlAction);
        this.mMaxLagsText.setDocument((Document)new FixedLengthNumericDocument(3, true, false));
        this.mMaxLagsText.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CrossCorrelationOptions.this.mMaxLagsText.selectAll();
            }
        });
        this.mMaxLagsText.getDocument().addDocumentListener(this);
        controlAction = new ToggleButtonAction(this, DISLAY_CORREL_LAG_CHECK_KEY);
        this.mDisplayCorrelLagCheck = new JCheckBox();
        this.mDisplayCorrelLagCheck.setAction(controlAction);
        this.mTabOrder = new Vector();
    }

    private void setDefaults() {
        this.mMaxLagsText.setText("7");
        this.mMaxLagsText.setColumns(3);
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        String string = dialogDataModel.getString("PERIODICITY_LABEL");
        if (string.equals(this.getResString("IDS_CROSS_CORREL_PERODICITY_NONE"))) {
            this.mDisplayCorrelLagCheck.setEnabled(false);
        } else {
            this.mCurPeriod = Integer.parseInt(string);
        }
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CROSS_CORREL_MAX_LAG_LABEL");
        jLabel.setLabelFor((Component)this.mMaxLagsText);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxLagsText, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCorrelLagCheck, gridBagConstraints, 0, 1, 3, 1, n, insets);
        return jPanel;
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mMaxLagsText);
        this.mTabOrder.add(this.mDisplayCorrelLagCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableDisableContinue() {
        if (this.mMaxLagsText.getText().length() == 0 || this.mMaxLagsText.getText() == null) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }
}

