/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.cross_correlation;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.cross_correlation.CrossCorrelationOptions;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class CrossCorrelationDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    private static final String NATURAL_LOG_TRANS_KEY = "IDS_CROSS_CORREL_NATURAL_LOG_TRANS_CHECK";
    private static final String DIFFERENCE_KEY = "IDS_CROSS_CORREL_DIFFERENCE_COLON_CHECK";
    private static final String SEASONNALY_DIFF_KEY = "IDS_CROSS_CORREL_SEASONALLY_DIFF_CHECK";
    private static final String CROSS_CORREL_SRCLIST_KEY = "CROSS_CORREL_SRCLIST_KEY";
    private static final String CROSS_CORREL_VARLIST_KEY = "CROSS_CORREL_VARLIST_KEY";
    private static final String CROSS_CORREL_DIFFERNECE_KEY = "CROSS_CORREL_DIFFERNECE_KEY";
    private static final String CROSS_CORREL_SEA_DIFFERNECE_KEY = "CROSS_CORREL_SEA_DIFFERNECE_KEY";
    static final String PERIODICITY_KEY = "PERIODICITY_LABEL";
    private static final int MAX_VAR_LIMIT = 100;
    static final String LAG_DEFAULT = "7";
    private SrcVariableList mSrcVarList;
    private ArrowButton mArrowButton;
    private TargetVariableList mTargetVarList;
    private JCheckBox mNaturalLogTransCheck;
    private JCheckBox mDifferenceCheck;
    private JCheckBox mSeasonallyDiffCheck;
    private ContextEnabledTextField mDifferenceValEdit;
    private ContextEnabledTextField mSeasonallyDiffValEdit;
    private JButton mOptionsButton;
    private JLabel mCurrPeriodicityVal;
    private int mDateVarCount;
    private Vector<Object> mTabOrder;

    public CrossCorrelationDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_CROSS_CORREL_TITLE"));
    }

    @Override
    public boolean okPastePressed() {
        int n;
        boolean bl = true;
        if (this.mDifferenceCheck.isSelected() && (n = Integer.parseInt(this.mDifferenceValEdit.getText())) == 0) {
            bl = false;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CROSS_CORREL_OUT_OF_RANGE_MSG"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CrossCorrelationDlg.this.mDifferenceValEdit.requestFocus();
                    CrossCorrelationDlg.this.mDifferenceValEdit.selectAll();
                }
            });
        }
        if (bl && this.mSeasonallyDiffCheck.isSelected() && (n = Integer.parseInt(this.mSeasonallyDiffValEdit.getText())) == 0) {
            bl = false;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CROSS_CORREL_OUT_OF_RANGE_MSG"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CrossCorrelationDlg.this.mSeasonallyDiffValEdit.requestFocus();
                    CrossCorrelationDlg.this.mSeasonallyDiffValEdit.selectAll();
                }
            });
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getCommand("CCF", true));
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("VARIABLES", this.mTargetVarList.getVariablesStringList(), true));
        Boolean bl = dialogDataModel.getBoolean(NATURAL_LOG_TRANS_KEY);
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/LN"));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/NOLOG"));
        }
        bl = dialogDataModel.getBoolean(DIFFERENCE_KEY);
        if (bl != null && bl.booleanValue()) {
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append("\n");
            }
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("DIFF", this.mDifferenceValEdit.getText()));
        }
        if ((bl = dialogDataModel.getBoolean(SEASONNALY_DIFF_KEY)) != null && bl.booleanValue()) {
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append("\n");
            }
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("SDIFF", this.mSeasonallyDiffValEdit.getText()));
        }
        String string2 = (string = dialogDataModel.getString("MAX_LAG_VAL")) != null ? string : LAG_DEFAULT;
        stringBuffer.append(SyntaxUtil.getSingleParameterSubCommand("MXCROSS", string2, false));
        bl = dialogDataModel.getBoolean("IDS_CROSS_CORREL_PERIOD_LAG_CHECK");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SEASONAL"));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mNaturalLogTransCheck.setSelected(false);
        this.mDifferenceCheck.setSelected(false);
        this.mSeasonallyDiffCheck.setSelected(false);
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.setDefaults();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    @Override
    public final String getIActionKey() {
        return "analyze_time_series_cross_correlations";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ccfu";
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableButtons();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mDifferenceCheck.isSelected();
        boolean bl2 = this.mSeasonallyDiffCheck.isSelected();
        this.mDifferenceValEdit.setEnabled(bl);
        this.mDifferenceValEdit.setOpaque(bl);
        this.mSeasonallyDiffValEdit.setEnabled(bl2);
        this.mSeasonallyDiffValEdit.setOpaque(bl2);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.updateDateControls();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrossCorrelationDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString(PERIODICITY_KEY, this.mCurrPeriodicityVal.getText());
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CROSS_CORREL_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 4, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_CROSS_CORREL_VARIABLES");
        Insets insets3 = new Insets(insets.top, 0, 0, 0);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        jScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets3.set(insets.top, 0, 0, 2 * insets2.right);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 2, n, insets3);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets3.set(insets.top, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupTransformPanel(), gridBagConstraints, 2, 3, 2, 1, n, insets3);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new CrossCorrelationOptions(this));
    }

    private void enableButtons() {
        boolean bl = true;
        if (this.mDifferenceCheck.isSelected() && this.mDifferenceValEdit.getText().length() == 0) {
            bl = false;
        }
        if (this.mSeasonallyDiffCheck.isSelected() && this.mSeasonallyDiffValEdit.getText().length() == 0) {
            bl = false;
        }
        this.enableOkPaste(bl && this.mTargetVarList.getModel().getSize() > 1);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setIdentifier(CROSS_CORREL_SRCLIST_KEY);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setIdentifier(CROSS_CORREL_VARLIST_KEY);
        this.mTargetVarList.setMaxLimitOfList(100);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        ControlAction controlAction = new ToggleButtonAction(this, NATURAL_LOG_TRANS_KEY);
        this.mNaturalLogTransCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, DIFFERENCE_KEY);
        this.mDifferenceCheck = new JCheckBox(controlAction);
        this.mDifferenceCheck.addItemListener(this);
        controlAction = new ToggleButtonAction(this, SEASONNALY_DIFF_KEY);
        this.mSeasonallyDiffCheck = new JCheckBox(controlAction);
        this.mSeasonallyDiffCheck.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNaturalLogTransCheck);
        spssButtonGroup.add(this.mDifferenceCheck);
        spssButtonGroup.add(this.mSeasonallyDiffCheck);
        this.mDifferenceValEdit = new ContextEnabledTextField();
        this.mDifferenceValEdit.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        controlAction = new TextFieldAction(this, CROSS_CORREL_DIFFERNECE_KEY);
        this.mDifferenceValEdit.setAction((Action)controlAction);
        this.mSeasonallyDiffValEdit = new ContextEnabledTextField();
        this.mSeasonallyDiffValEdit.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        controlAction = new TextFieldAction(this, CROSS_CORREL_SEA_DIFFERNECE_KEY);
        this.mSeasonallyDiffValEdit.setAction((Action)controlAction);
        this.mCurrPeriodicityVal = new JLabel(this.getCurrPerodicityValue());
        this.mTabOrder = new Vector();
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mDifferenceValEdit.setText("1");
        this.mDifferenceValEdit.setColumns(2);
        this.mDifferenceValEdit.setEnabled(this.mDifferenceCheck.isSelected());
        this.mDifferenceValEdit.setOpaque(false);
        this.mSeasonallyDiffCheck.setEnabled(this.isSeasonalDiffEnabled());
        this.mSeasonallyDiffValEdit.setOpaque(false);
        this.mSeasonallyDiffValEdit.setText("1");
        this.mSeasonallyDiffValEdit.setColumns(2);
        this.mSeasonallyDiffValEdit.setEnabled(this.mSeasonallyDiffCheck.isSelected());
        this.mSeasonallyDiffValEdit.setOpaque(this.mSeasonallyDiffCheck.isSelected());
    }

    private JPanel setupTransformPanel() {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_CROSS_CORREL_TRANSFORM")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n2, n2, insets.bottom, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNaturalLogTransCheck, gridBagConstraints, 0, 0, 3, 1, n3, insets2);
        insets2.right = insets.right;
        DialogUtil.addUsingGBL(jPanel, this.mDifferenceCheck, gridBagConstraints, 0, 1, 2, 1, n3, insets2);
        insets2.right = n2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDifferenceValEdit, gridBagConstraints, 2, 1, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.right = insets.right;
        DialogUtil.addUsingGBL(jPanel, this.mSeasonallyDiffCheck, gridBagConstraints, 0, 2, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.right = n2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSeasonallyDiffValEdit, gridBagConstraints, 2, 2, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_CROSS_CORREL_CURR_PERIODICITY_LABEL"), 10);
        insets2.top = n = DialogUtil.getComponentGroupGap();
        insets2.bottom = n2;
        insets2.right = insets.right;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n3, insets2);
        insets2.right = n2;
        DialogUtil.addUsingGBL(jPanel, this.mCurrPeriodicityVal, gridBagConstraints, 1, 3, 1, 1, n3, insets2);
        this.mDifferenceValEdit.getDocument().addDocumentListener(this);
        this.mSeasonallyDiffValEdit.getDocument().addDocumentListener(this);
        return jPanel;
    }

    private String getCurrPerodicityValue() {
        int n = this.getTrendsInfo().getPeriod();
        String string = n == 1 ? this.getResString("IDS_CROSS_CORREL_PERODICITY_NONE") : String.valueOf(n);
        return string;
    }

    private boolean isSeasonalDiffEnabled() {
        return this.getTrendsInfo().getNDateVars() > 0;
    }

    private ITrendsInfo getTrendsInfo() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        return iSpssDataSrc.getTrendsInfo();
    }

    private ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(this.mTargetVarList);
        this.mTabOrder.add(this.mNaturalLogTransCheck);
        this.mTabOrder.add(this.mDifferenceCheck);
        this.mTabOrder.add(this.mDifferenceValEdit);
        this.mTabOrder.add(this.mSeasonallyDiffCheck);
        this.mTabOrder.add(this.mSeasonallyDiffValEdit);
        this.mTabOrder.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateDateControls() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        ITrendsInfo iTrendsInfo = iSpssDataSrc.getTrendsInfo();
        this.mDateVarCount = iTrendsInfo.getNDateVars();
        if (this.mDateVarCount > 1) {
            this.mSeasonallyDiffCheck.setEnabled(true);
            boolean bl = this.mSeasonallyDiffCheck.isSelected();
            this.mSeasonallyDiffValEdit.setEnabled(bl);
            this.mSeasonallyDiffValEdit.setOpaque(bl);
            this.mCurrPeriodicityVal.setText(Integer.toString(iTrendsInfo.getPeriod()));
        } else {
            this.mSeasonallyDiffCheck.setEnabled(false);
            this.mSeasonallyDiffValEdit.setEnabled(false);
            this.mSeasonallyDiffValEdit.setOpaque(false);
            this.mCurrPeriodicityVal.setText(this.getResString("IDS_PERODICITY_NONE"));
        }
        this.enableButtons();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new DataObserver();
    }

    public class DataObserver
    extends BaseProcedureDialog.DataViewObserverAdapter {
        public DataObserver() {
            super(CrossCorrelationDlg.this);
        }

        @Override
        public void notifyTrendsInfo() {
            CrossCorrelationDlg.this.updateDateControls();
        }
    }
}

