/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.DateFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CreateModelsMainDlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMADlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMATransferTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertDlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertModelTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertModelTabWrapper;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExponentialDlg;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VariablesTab
extends BaseProcedureTab
implements ListDataListener,
ItemListener,
IVarMoveHandler {
    public static final String SOURCE_LIST_IDENTIFIER_KEY = "sourcevars";
    public static final String DEPENDENT_LIST_IDENTIFIER_KEY = "dependentvars";
    public static final String INDEPENDENT_LIST_IDENTIFIER_KEY = "independentvars";
    static final String COMBO_VALUE = "IDS_COMBO_VALUE";
    static final String SOURCE_LIST_INDEX = "SRC_LIST_INDEX";
    private ArrowButton mArrowDependentButton;
    private ArrowButton mArrowIndependentButton;
    private JLabel mSrcListLabel;
    private SrcVariableList mSrcVarList;
    private JLabel mIndependentListLabel;
    private TargetVariableList mIndependentList;
    private JLabel mDependentListLabel;
    private TargetVariableList mDependentList;
    private JLabel mMethodLabel;
    private JComboBox mMethodCombo;
    private ComboBoxModel mMethodComboFullModel;
    private ComboBoxModel mMethodComboSmallModel;
    private JButton mCriteriaButton;
    private JLabel mModelLabel;
    private JLabel mModelSettingLabel;
    private JLabel mEstimationStartLabel;
    private JLabel mEstimationEndLabel;
    private JLabel mForecastStartLabel;
    private JLabel mForecastEndLabel;
    CriteriaExpertDlg mDlgExpert = null;
    CriteriaExponentialDlg mDlgExponential = null;
    CriteriaARIMADlg mDlgARIMA = null;
    List<Pair<ITrendsInfo.DateVarTypes, String>> mPeriodLabels;
    Hashtable<ITrendsInfo.DateVarTypes, String> mSyntaxLabels;

    public VariablesTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, bl);
        this.mSrcVarList.getInputMap().put(ResUtil.getShortcut("edit_copy"), "copyAction");
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_vars";
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.loadFromActiveDataset();
        this.loadVariablesList();
        this.mDependentList.removeAll();
        this.mIndependentList.removeAll();
        this.mMethodCombo.setSelectedItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0"));
        this.mMethodCombo.repaint();
        this.updateOKPasteButtons();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        if (this.mDlgExpert != null && this.mDlgExpert.getModelTab() != null) {
            this.mDlgExpert.getModelTab().setWrapperVector(new Vector<CriteriaExpertModelTabWrapper>());
        }
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        SerializableObject[] serializableObjectArray;
        if (variableList.equals(this.mIndependentList) && this.mMethodCombo.getSelectedItem().toString().equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1"))) {
            if (SpssAlertOptionPane.showConfirmDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_VARS_EXPONENTIAL_TO_ARIMA_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0) {
                this.setCorrectComboModel();
                this.mMethodCombo.setSelectedItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2"));
                if (this.mDlgARIMA != null) {
                    this.mModelSettingLabel.setText(this.mDlgARIMA.getModelString());
                }
                return true;
            }
            return false;
        }
        if (variableList.equals(this.mIndependentList)) {
            serializableObjectArray = ((CreateModelsMainDlg)this.mParent).getDialogDataModel().getSerializableArray("IDS_WRAPPER_VECTOR");
            if (this.mDlgExpert != null) {
                this.updateModelTabTable(this.mIndependentList, false, iSpssVariableArray);
            } else if (serializableObjectArray != null) {
                this.updateWrapperVectorInDataModel(iSpssVariableArray, variableList, false);
            }
            if (this.mDlgARIMA != null) {
                this.updateTransferTab(this.mIndependentList, false, iSpssVariableArray);
            }
        }
        if (variableList.equals(this.mSrcVarList)) {
            serializableObjectArray = ((CreateModelsMainDlg)this.mParent).getDialogDataModel().getSerializableArray("IDS_WRAPPER_VECTOR");
            if (this.mDlgExpert != null) {
                this.updateModelTabTable(this.mSrcVarList, true, iSpssVariableArray);
            } else if (serializableObjectArray != null) {
                this.updateWrapperVectorInDataModel(iSpssVariableArray, variableList, true);
            }
            if (this.mDlgExpert != null) {
                this.updateModelTabTable(this.mSrcVarList, true, iSpssVariableArray);
            }
            if (this.mDlgARIMA != null) {
                this.updateTransferTab(this.mSrcVarList, true, iSpssVariableArray);
            }
        }
        return true;
    }

    private void updateWrapperVectorInDataModel(ISpssVariable[] iSpssVariableArray, VariableList variableList, boolean bl) {
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            Vector<CriteriaExpertModelTabWrapper> vector = new Vector<CriteriaExpertModelTabWrapper>();
            TargetVariableList targetVariableList = this.getIndependentVars();
            int n = targetVariableList.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
                Icon icon = targetVariableList.getIcon(iSpssVariable);
                Object object = new CriteriaExpertModelTabWrapper(iSpssVariable, icon, false, variableList.getShowVarLabels());
                vector.add((CriteriaExpertModelTabWrapper)object);
            }
            if (bl) {
                this.removeIfExists(vector, iSpssVariableArray);
            } else {
                for (Object object : iSpssVariableArray) {
                    Icon icon = targetVariableList.getIcon((ISpssVariable)object);
                    CriteriaExpertModelTabWrapper criteriaExpertModelTabWrapper = new CriteriaExpertModelTabWrapper((ISpssVariable)object, icon, false, variableList.getShowVarLabels());
                    vector.add(criteriaExpertModelTabWrapper);
                }
            }
            SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
            ((CreateModelsMainDlg)this.mParent).getDialogDataModel().putSerializableArray("IDS_WRAPPER_VECTOR", vector.toArray(serializableObjectArray));
        }
    }

    private void removeIfExists(Vector<CriteriaExpertModelTabWrapper> vector, ISpssVariable[] iSpssVariableArray) {
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            String string = iSpssVariable.getName();
            for (int i = 0; i < vector.size(); ++i) {
                CriteriaExpertModelTabWrapper criteriaExpertModelTabWrapper = vector.get(i);
                if (!criteriaExpertModelTabWrapper.getSpssVar().getName().equals(string)) continue;
                vector.remove(i--);
            }
        }
    }

    private void updateTransferTab(VariableList variableList, boolean bl, ISpssVariable[] iSpssVariableArray) {
        CriteriaARIMATransferTab criteriaARIMATransferTab = this.mDlgARIMA.getTransferTab();
        if (criteriaARIMATransferTab != null) {
            HashMap<Object, CriteriaARIMATransferTab.TransferDataModel> hashMap = criteriaARIMATransferTab.getTransferTabHashMap();
            if (hashMap != null && !hashMap.isEmpty()) {
                if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
                    this.removeFirst(hashMap, iSpssVariableArray, variableList);
                    if (!bl) {
                        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                            CriteriaARIMATransferTab.TransferDataModel transferDataModel = criteriaARIMATransferTab.makeTransferDataModel();
                            hashMap.put(iSpssVariable, transferDataModel);
                        }
                    }
                }
            } else {
                hashMap = new HashMap();
            }
            ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[hashMap.size()];
            ((CreateModelsMainDlg)this.mParent).getDialogDataModel().putVarArray("IDS_TRANSFER_TAB_VAR_ARRAY", hashMap.keySet().toArray(iSpssVariableArray2));
            SerializableObject[] serializableObjectArray = new SerializableObject[hashMap.size()];
            ((CreateModelsMainDlg)this.mParent).getDialogDataModel().putSerializableArray("IDS_TRANSFER_TAB_ITEM_ARRAY", hashMap.values().toArray(serializableObjectArray));
        }
    }

    private void removeFirst(HashMap<ISpssVariable, CriteriaARIMATransferTab.TransferDataModel> hashMap, ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        int n;
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (variableList.getModel().getSize() > 0) {
            ISpssVariable[] iSpssVariableArray2 = iSpssVariableArray;
            n = iSpssVariableArray2.length;
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssVariableArray2[i];
                String string = iSpssVariable.getName();
                Set<ISpssVariable> set = hashMap.keySet();
                for (ISpssVariable iSpssVariable2 : set) {
                    if (!iSpssVariable2.getName().equals(string)) continue;
                    vector.add(iSpssVariable2);
                    if (variableList.getModel().getSize() != 0) continue;
                    return;
                }
            }
        } else {
            hashMap = null;
            ((CreateModelsMainDlg)this.mParent).getDialogDataModel().putVarArray("IDS_TRANSFER_TAB_VAR_ARRAY", null);
            ((CreateModelsMainDlg)this.mParent).getDialogDataModel().putSerializableArray("IDS_TRANSFER_TAB_ITEM_ARRAY", null);
        }
        int n2 = vector.size();
        if (hashMap != null && n2 > 0) {
            for (n = 0; n < n2; ++n) {
                hashMap.remove(vector.get(n));
            }
        }
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        if (this.mSrcVarList.getSelectedIndices().length != 0) {
            dialogDataModel.putInteger(SOURCE_LIST_INDEX, this.mSrcVarList.getSelectedIndex());
        } else {
            dialogDataModel.putInteger(SOURCE_LIST_INDEX, 0);
        }
        Object object = this.mMethodCombo.getSelectedItem();
        dialogDataModel.putObject(COMBO_VALUE, this.mMethodCombo.getSelectedItem());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mIndependentList.getModel())) {
            if (this.mMethodCombo.getSelectedItem().toString().equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0")) && this.mModelSettingLabel.getText().equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON"))) {
                if (SpssAlertOptionPane.showConfirmDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_VARS_ARIMA_ONLY_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0) {
                    if (this.mDlgExpert != null) {
                        this.mDlgExpert.setModelToARIMA();
                    }
                    this.setModelString(this.getExpertModelerModelSettingLabelText());
                } else {
                    this.mIndependentList.removeAll();
                }
            }
            this.setCorrectComboModel();
        }
        this.updateOKPasteButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mIndependentList.getModel())) {
            this.setCorrectComboModel();
        }
        this.updateOKPasteButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    protected void generateModelSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        String string;
        String string2;
        StringBuffer stringBuffer2 = new StringBuffer("\n   /MODEL DEPENDENT=");
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(DEPENDENT_LIST_IDENTIFIER_KEY);
        for (int i = 0; i < iSpssVariableArray.length; ++i) {
            if (i > 0) {
                stringBuffer2.append(" ");
            }
            stringBuffer2.append(iSpssVariableArray[i].getName());
        }
        ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray(INDEPENDENT_LIST_IDENTIFIER_KEY);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_WRAPPER_VECTOR");
        if (iSpssVariableArray2.length > 0) {
            stringBuffer2.append(" INDEPENDENT=");
            for (int i = 0; i < iSpssVariableArray2.length; ++i) {
                if (i > 0) {
                    stringBuffer2.append(" ");
                }
                stringBuffer2.append(iSpssVariableArray2[i].getName());
                if (!dialogDataModel.getObject(COMBO_VALUE).equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0")) || !this.isIndependentVariableEvent(iSpssVariableArray2[i].getName(), serializableObjectArray)) continue;
                stringBuffer2.append(" [E] ");
            }
        }
        if ((string2 = dialogDataModel.getSafeString("EXPORT_XML_FILE_PATH").trim()).length() > 0) {
            stringBuffer2.append("\n      OUTFILE=").append(CharacterUtil.smartQuote((String)string2));
        }
        if ((string2 = dialogDataModel.getSafeString("EXPORT_PMMML_FILE_PATH").trim()).length() > 0) {
            stringBuffer2.append("\n      OUTPMML=").append(CharacterUtil.smartQuote((String)string2));
        }
        if ((string = dialogDataModel.getString("IDS_TS_CREATE_MODEL_OPTIONS_PREFIX_OUTPUT_EDIT").trim()).length() > 0) {
            stringBuffer2.append("\n      PREFIX=").append(CharacterUtil.smartQuote((String)string));
        }
        stringBuffer.append(stringBuffer2);
        this.generateModelTypeSyntax(stringBuffer, dialogDataModel);
    }

    private boolean isIndependentVariableEvent(String string, SerializableObject[] serializableObjectArray) {
        if (serializableObjectArray == null) {
            return false;
        }
        for (SerializableObject serializableObject : serializableObjectArray) {
            CriteriaExpertModelTabWrapper criteriaExpertModelTabWrapper = (CriteriaExpertModelTabWrapper)serializableObject;
            if (!criteriaExpertModelTabWrapper.getSpssVar().getName().equals(string) || !criteriaExpertModelTabWrapper.isChecked()) continue;
            return true;
        }
        return false;
    }

    protected void generateModelTypeSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (dialogDataModel.getObject(COMBO_VALUE).equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0"))) {
            Object object;
            String string = this.getModelType(dialogDataModel);
            stringBuffer2.append("\n   /EXPERTMODELER TYPE=[").append(string).append("]");
            if (((CreateModelsMainDlg)this.mParent).getPeriodNum() > 1) {
                object = dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_CONSIDER_SEASONAL_CHECK_BOX");
                if (object == null || ((Boolean)object).booleanValue()) {
                    stringBuffer2.append(" TRYSEASONAL=YES");
                } else {
                    stringBuffer2.append(" TRYSEASONAL=NO");
                }
            }
            object = this.generateOutlierSyntax(dialogDataModel);
            stringBuffer2.append((String)object);
        } else if (dialogDataModel.getObject(COMBO_VALUE).equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1"))) {
            String string;
            String string2 = this.generateSmoothModelTypeSyntax(dialogDataModel);
            if (string2.length() != 0) {
                stringBuffer2.append("\n   /EXSMOOTH TYPE=").append(string2);
            }
            if ((string = this.generateTransformSyntax(dialogDataModel)).length() != 0) {
                stringBuffer2.append("  TRANSFORM=").append(string);
            }
        } else if (dialogDataModel.getObject(COMBO_VALUE).equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2"))) {
            ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(INDEPENDENT_LIST_IDENTIFIER_KEY);
            StringBuffer stringBuffer3 = new StringBuffer();
            if (dialogDataModel.getObject("IDS_STRUCTURE_TABLE_MODEL") != null) {
                this.generateArimaSyntax(stringBuffer3, dialogDataModel);
                if (iSpssVariableArray.length > 0) {
                    this.generateTransferFunctionSyntax(stringBuffer3, dialogDataModel);
                }
                this.generateARIMAOutlierSyntax(stringBuffer3, dialogDataModel);
                stringBuffer2.append(stringBuffer3.toString());
            } else {
                stringBuffer3.append("\n   /ARIMA AR=[0] DIFF=0 MA=[0]");
                stringBuffer3.append("\n      ARSEASONAL=[0]  DIFFSEASONAL=0  MASEASONAL=[0]");
                stringBuffer3.append("\n      TRANSFORM=NONE CONSTANT=YES");
                for (int i = 0; i < iSpssVariableArray.length; ++i) {
                    stringBuffer3.append("\n   /TRANSFERFUNCTION VARIABLES=").append(iSpssVariableArray[i].getName()).append(" NUM=[0] DENOM=[0] DIFF=0 DELAY=0");
                    stringBuffer3.append("\n   TRANSFORM=NONE");
                }
                stringBuffer3.append("\n   /AUTOOUTLIER DETECT=OFF");
                stringBuffer2.append(stringBuffer3.toString());
            }
        }
        stringBuffer.append(stringBuffer2);
    }

    private String getModelType(DialogDataModel dialogDataModel) {
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON");
        if (bl == null || bl.booleanValue()) {
            return "ARIMA EXSMOOTH";
        }
        if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON").booleanValue()) {
            return "EXSMOOTH";
        }
        if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON").booleanValue()) {
            return "ARIMA";
        }
        return "ARIMA EXSMOOTH";
    }

    private void setExpertModelerModelType(String string) {
        DialogDataModel dialogDataModel = ((CreateModelsMainDlg)this.mParent).getDialogDataModel();
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON", false);
        if (string.equalsIgnoreCase("ARIMA EXSMOOTH")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("EXSMOOTH")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("ARIMA")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON", true);
        } else {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON", true);
        }
    }

    private void setExpoSmoothingModelType(String string) {
        DialogDataModel dialogDataModel = ((CreateModelsMainDlg)this.mParent).getDialogDataModel();
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_HOLTS_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_DAMPED_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON", false);
        dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON", false);
        if (string.equalsIgnoreCase("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_HOLTS_RADIO_BUTTON")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_DAMPED_RADIO_BUTTON")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON", true);
        } else if (string.equalsIgnoreCase("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON")) {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON", true);
        } else {
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON", true);
            dialogDataModel.putBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_NONE_RADIO_BUTTON", true);
        }
    }

    protected String generateOutlierSyntax(DialogDataModel dialogDataModel) {
        String string = "\n   /AUTOOUTLIER  DETECT=";
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_DETECT_OUTLIERS_CHECK_BOX");
        if (bl != null && bl.booleanValue()) {
            string = string + "ON TYPE=[";
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_ADDITIVE_CHECK_BOX").booleanValue()) {
                string = string + " ADDITIVE";
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_LEVEL_SHIFT").booleanValue()) {
                string = string + " LEVELSHIFT";
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_INNOVATIONAL_CHECK_BOX").booleanValue()) {
                string = string + " INNOVATIONAL";
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_TRANSIENT_CHECK_BOX").booleanValue()) {
                string = string + " TRANSIENT";
            }
            if (((CreateModelsMainDlg)this.mParent).getPeriodNum() > 1 && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_SEASONAL_ADDITIVE_CHECK_BOX").booleanValue()) {
                string = string + " SEASONALADDITIVE";
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_LOCAL_TREND_CHECK_BOX").booleanValue()) {
                string = string + " LOCALTREND";
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_ADDITIVE_PATH_CHECK_BOX").booleanValue()) {
                string = string + " ADDITIVEPATCH";
            }
            string = string + "]";
        } else {
            string = string + "OFF";
        }
        return string;
    }

    protected String generateSmoothModelTypeSyntax(DialogDataModel dialogDataModel) {
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON");
        if (bl == null) {
            return "SIMPLE";
        }
        if (bl.booleanValue()) {
            string = "SIMPLE";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_HOLTS_RADIO_BUTTON").booleanValue()) {
            string = "HOLT";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON").booleanValue()) {
            string = "BROWN";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_DAMPED_RADIO_BUTTON").booleanValue()) {
            string = "DAMPEDTREND";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON").booleanValue()) {
            string = "SIMPLESEASONAL";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON").booleanValue()) {
            string = "WINTERSADDITIVE";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON").booleanValue()) {
            string = "WINTERSMULTIPLICATIVE";
        }
        return string;
    }

    protected String generateTransformSyntax(DialogDataModel dialogDataModel) {
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_NONE_RADIO_BUTTON");
        if (bl == null) {
            return "NONE";
        }
        if (bl.booleanValue()) {
            string = "NONE";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_SQUARE_ROOT_RADIO_BUTTON").booleanValue()) {
            string = "SQRT";
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_NATURAL_LOG_RADIO_BUTTON").booleanValue()) {
            string = "LN";
        }
        return string;
    }

    protected void generateArimaSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        Object[][] objectArray = (Object[][])dialogDataModel.getObject("IDS_STRUCTURE_TABLE_MODEL");
        StringBuffer stringBuffer2 = new StringBuffer("\n   /ARIMA ");
        stringBuffer2.append("AR=" + ((CreateModelsMainDlg)this.mParent).buildBracketedNumList((Integer)objectArray[0][1]));
        stringBuffer2.append("  DIFF=" + objectArray[1][1]);
        stringBuffer2.append("  MA=" + ((CreateModelsMainDlg)this.mParent).buildBracketedNumList((Integer)objectArray[2][1]));
        if (((CreateModelsMainDlg)this.mParent).getPeriodNum() > 1) {
            stringBuffer2.append("  ARSEASONAL=" + ((CreateModelsMainDlg)this.mParent).buildBracketedNumList((Integer)objectArray[0][2]));
            stringBuffer2.append("  DIFFSEASONAL=" + objectArray[1][2]);
            stringBuffer2.append("  MASEASONAL=" + ((CreateModelsMainDlg)this.mParent).buildBracketedNumList((Integer)objectArray[2][2]));
        }
        stringBuffer2.append("\n      TRANSFORM=");
        if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_DEPENDENT_NONE_RADIO_BUTTON").booleanValue()) {
            stringBuffer2.append("NONE");
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_DEPENDENT_SQUARE_ROOT_RADIO_BUTTON").booleanValue()) {
            stringBuffer2.append("SQRT");
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_DEPENDENT_NATURAL_LOG_RADIO_BUTTON").booleanValue()) {
            stringBuffer2.append("LN");
        }
        stringBuffer2.append("  CONSTANT=");
        if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_INCLUDE_CONSTANT_CHECK_BOX").booleanValue()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer.append(stringBuffer2);
    }

    private void generateTransferFunctionSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        String string = "\n   /TRANSFERFUNCTION VARIABLES=";
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TRANSFER_TAB_VAR_ARRAY");
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_TRANSFER_TAB_ITEM_ARRAY");
        CreateModelsMainDlg createModelsMainDlg = (CreateModelsMainDlg)this.mParent;
        int n = 0;
        if (iSpssVariableArray != null && iSpssVariableArray.length != 0) {
            block5: for (int i = 0; i < iSpssVariableArray.length; ++i) {
                ISpssVariable iSpssVariable = iSpssVariableArray[i];
                CriteriaARIMATransferTab.TransferDataModel transferDataModel = (CriteriaARIMATransferTab.TransferDataModel)serializableObjectArray[i];
                if (transferDataModel == null) continue;
                ++n;
                stringBuffer2.append(string);
                stringBuffer2.append(iSpssVariable.getName()).append("  ");
                stringBuffer2.append("NUM=").append(createModelsMainDlg.buildBracketedNumList((Integer)transferDataModel.getTableData()[0][1]));
                stringBuffer2.append(" DENOM=").append(createModelsMainDlg.buildBracketedNumList((Integer)transferDataModel.getTableData()[1][1]));
                stringBuffer2.append(" DIFF=").append(transferDataModel.getTableData()[2][1].toString()).append(" ");
                if (createModelsMainDlg.getPeriodNum() > 1) {
                    stringBuffer2.append("NUMSEASONAL=").append(createModelsMainDlg.buildBracketedNumList((Integer)transferDataModel.getTableData()[0][2]));
                    stringBuffer2.append(" DENOMSEASONAL=").append(createModelsMainDlg.buildBracketedNumList((Integer)transferDataModel.getTableData()[1][2]));
                    stringBuffer2.append(" DIFFSEASONAL=").append(transferDataModel.getTableData()[2][2].toString());
                }
                stringBuffer2.append(" DELAY=").append(transferDataModel.getDelay()).append("  ");
                stringBuffer2.append(" TRANSFORM=");
                switch (transferDataModel.getTransformation()) {
                    case None: {
                        stringBuffer2.append("NONE");
                        continue block5;
                    }
                    case SquareRoot: {
                        stringBuffer2.append("SQRT");
                        continue block5;
                    }
                    case NaturalLog: {
                        stringBuffer2.append("LN");
                    }
                }
            }
        }
        if (n == 0) {
            return;
        }
        stringBuffer.append(stringBuffer2);
    }

    private boolean containsInfo(CriteriaARIMATransferTab.TransferDataModel transferDataModel) {
        Object[][] objectArray = transferDataModel.getTableData();
        for (int i = 1; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                if ((Integer)objectArray[j][i] == 0) continue;
                return true;
            }
        }
        return false;
    }

    private void generateARIMAOutlierSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        CreateModelsMainDlg createModelsMainDlg = (CreateModelsMainDlg)this.mParent;
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_NO_OUTLIERS_RADIO_BUTTON");
        if (bl == null || bl.booleanValue()) {
            stringBuffer2.append("\n   /AUTOOUTLIER DETECT=OFF");
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_DETECT_OUTLIERS_RADIO_BUTTON").booleanValue()) {
            stringBuffer2.append("\n   /AUTOOUTLIER DETECT=ON  TYPE=[");
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_ADDITIVE_CHECK_BOX").booleanValue()) {
                stringBuffer2.append("ADDITIVE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_LEVEL_SHIFT_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" LEVELSHIFT");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_INNOVATIONAL_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" INNOVATIONAL");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_TRANSIENT_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" TRANSIENT");
            }
            if (createModelsMainDlg.getPeriodNum() > 1 && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_SEASONAL_ADDITIVE_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" SEASONALADDITIVE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_OUTLIERS_LOCAL_TREND_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" LOCALTREND");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_ADDITIVE_PATCH_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" ADDITIVEPATCH");
            }
            stringBuffer2.append("]");
        } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_MODEL_SPECIFIC_RADIO_BUTTON").booleanValue()) {
            Vector vector = (Vector)dialogDataModel.getObject("IDS_DEFINITION_TABLE_VECTOR");
            for (int i = 0; i < vector.size(); ++i) {
                int n;
                String string;
                boolean bl2 = true;
                int n2 = createModelsMainDlg.getTrendsInfo().getNDateVars();
                if (n2 == 0) {
                    Object e = ((Vector)vector.get(i)).get(0);
                    if (e == null || (string = e.toString().trim()).length() <= 0) continue;
                    stringBuffer2.append("\n   /OUTLIER LOCATION=[");
                    stringBuffer2.append(string);
                    stringBuffer2.append("] TYPE=");
                    stringBuffer2.append(this.getOutlierTypeFromLocalized((String)((Vector)vector.get(i)).get(1)));
                    continue;
                }
                if (!this.hasUserValues((Vector)vector.get(i), n2)) continue;
                stringBuffer2.append("\n   /OUTLIER LOCATION=[");
                for (n = 0; n < n2; ++n) {
                    string = ((Vector)vector.get(i)).get(n).toString().trim();
                    if (string.length() <= 0) continue;
                    if (n > 0) {
                        stringBuffer2.append(" ");
                    }
                    ITrendsInfo iTrendsInfo = createModelsMainDlg.getTrendsInfo();
                    stringBuffer2.append(iTrendsInfo.getDateVarString(n));
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string);
                }
                stringBuffer2.append("]");
                stringBuffer2.append(" TYPE=");
                stringBuffer2.append(this.getOutlierTypeFromLocalized((String)((Vector)vector.get(i)).get(n)));
            }
        }
        stringBuffer.append(stringBuffer2.toString());
    }

    private boolean hasUserValues(Vector<Object> vector, int n) {
        for (int i = 0; i < n; ++i) {
            Object object = vector.get(i);
            if (object != null) continue;
            return false;
        }
        return true;
    }

    private String getOutlierTypeFromLocalized(String string) {
        if (string.equals(this.getResString("IDS_TIME_SERIES_ADDITIVE"))) {
            return "ADDITIVE";
        }
        if (string.equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_LEVEL_SHIFT_CHECK_BOX"))) {
            return "LEVELSHIFT";
        }
        if (string.equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_INNOVATIONAL_CHECK_BOX"))) {
            return "INNOVATIONAL";
        }
        if (string.equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_TRANSIENT_CHECK_BOX"))) {
            return "TRANSIENT";
        }
        if (string.equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_SEASONAL_ADDITIVE_CHECK_BOX"))) {
            return "SEASONALADDITIVE";
        }
        if (string.equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_LOCAL_TREND_CHECK_BOX"))) {
            return "LOCALTREND";
        }
        if (string.equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_OUTLIERS_ADDITIVE_PATCH_CHECK_BOX"))) {
            return "ADDITIVEPATCH";
        }
        return "";
    }

    private void loadVariablesList() {
        if (((CreateModelsMainDlg)this.mParent).getIsSplitFileOn()) {
            Vector<ISpssVariable> vector = ((CreateModelsMainDlg)this.mParent).getSplitFileVars();
            for (int i = this.mSrcVarList.getModel().getSize() - 1; i >= 0; --i) {
                String string = this.mSrcVarList.getModel().getElementAt(i).getName();
                for (ISpssVariable iSpssVariable : vector) {
                    if (!iSpssVariable.getName().equals(string)) continue;
                    this.mSrcVarList.getModel().removeElementAt(i);
                }
            }
        }
        this.updatePeriodLabels();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.loadVariablesList();
        this.mForecastStartLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_FORECAST_START_DEFAULT_LABEL"));
        this.mForecastEndLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_FORECAST_END_DEFAULT_LABEL"));
        ITrendsInfo iTrendsInfo = ((CreateModelsMainDlg)this.mParent).getTrendsInfo();
        if (iTrendsInfo.getUseLo() || iTrendsInfo.getUseHi()) {
            this.setEstimationRange(iTrendsInfo);
        } else {
            this.mEstimationStartLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_START_DEFAULT_LABEL"));
            this.mEstimationEndLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_END_DEFAULT_LABEL"));
        }
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void setEstimationRange(ITrendsInfo iTrendsInfo) {
        String string;
        if (!iTrendsInfo.getUseLo()) {
            this.mEstimationStartLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_START_DEFAULT_LABEL"));
        } else if (iTrendsInfo.getUseLoDate()) {
            this.mEstimationStartLabel.setText(this.buildDateString(iTrendsInfo, true));
        } else {
            string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_OBSERVATION");
            this.mEstimationStartLabel.setText(String.format(string, iTrendsInfo.getUseLoCase()));
        }
        if (!iTrendsInfo.getUseHi()) {
            this.mEstimationEndLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_END_DEFAULT_LABEL"));
        } else if (iTrendsInfo.getUseHiDate()) {
            this.mEstimationEndLabel.setText(this.buildDateString(iTrendsInfo, false));
        } else {
            string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_OBSERVATION");
            this.mEstimationEndLabel.setText(String.format(string, iTrendsInfo.getUseHiCase()));
        }
    }

    public List<Pair<ITrendsInfo.DateVarTypes, String>> getDateComponentList() {
        return this.mPeriodLabels;
    }

    public Hashtable<ITrendsInfo.DateVarTypes, String> getDateSyntaxList() {
        return this.mSyntaxLabels;
    }

    private String buildDateString(ITrendsInfo iTrendsInfo, boolean bl) {
        String string = "";
        int n = iTrendsInfo.getNDateVars();
        if (n > 0) {
            List<Pair<ITrendsInfo.DateVarTypes, String>> list = this.getDateComponentList();
            for (int i = 0; i < n; ++i) {
                OBS oBS = bl ? iTrendsInfo.getUseVarLo(i) : iTrendsInfo.getUseVarHi(i);
                if (oBS.isEmpty()) continue;
                if (i > 0) {
                    string = string + ", ";
                }
                String string2 = (String)list.get(i).getSecond() + " %.0f";
                string = string + String.format(string2, oBS.getNum());
            }
        }
        return string;
    }

    private void setupPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getArrowButtonInsets().clone();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets3 = new Insets(n, n, n, n);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSrcVarList.getFixedCellHeight() * 7 + 2));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n2, insets);
        this.mArrowDependentButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowDependentButton, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        n2 = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDependentListLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        this.mDependentList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mDependentList);
        this.mDependentList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDependentList.getFixedCellHeight() * 7 + 2));
        jScrollPane.setPreferredSize(this.mDependentList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        this.mDependentList.getModel().addListDataListener(this);
        this.mArrowDependentButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowDependentButton.registerVariableList(this.mDependentList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowIndependentButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowIndependentButton, gridBagConstraints, 1, 3, 1, 1, n2, insets2);
        n2 = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentListLabel, gridBagConstraints, 2, 2, 1, 1, n2, insets);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mIndependentList);
        this.mIndependentList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mIndependentList.getFixedCellHeight() * 7 + 2));
        jScrollPane.setPreferredSize(this.mIndependentList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n2, insets);
        this.mArrowIndependentButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowIndependentButton.registerVariableList(this.mIndependentList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowIndependentButton.setVarMoveHandler(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n2 = 23;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 2, 1, n2, insets3);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            DialogUtil.addUsingGBL(jPanel3, this.mMethodLabel, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets.top + 6, insets.left, insets.bottom, 5));
            DialogUtil.addUsingGBL(jPanel3, this.mMethodCombo, gridBagConstraints, 1, 0, 1, 1, n2, new Insets(3, insets.left, 0, 5));
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel3, this.mCriteriaButton, gridBagConstraints, 2, 0, 1, 1, n2, new Insets(0, insets.left, 2, 5));
        } else {
            DialogUtil.addUsingGBL(jPanel3, this.mMethodLabel, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets.top + 3, insets.left, insets.bottom, 5));
            DialogUtil.addUsingGBL(jPanel3, this.mMethodCombo, gridBagConstraints, 1, 0, 1, 1, n2, new Insets(insets.top, insets.left, insets.bottom, 5));
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel3, this.mCriteriaButton, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        }
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        n2 = 23;
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            DialogUtil.addUsingGBL(jPanel4, this.mModelLabel, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets.top, insets.left + 60, insets.bottom, insets.right));
        } else {
            DialogUtil.addUsingGBL(jPanel4, this.mModelLabel, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets.top, insets.left + 47, insets.bottom, insets.right));
        }
        DialogUtil.addUsingGBL(jPanel4, this.mModelSettingLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets.top, insets.left + 2, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel2, jPanel4, gridBagConstraints, 0, 1, 1, 1, n2, new Insets(insets.top, insets.left + 2, insets.bottom, insets.right));
        gridBagConstraints.fill = 0;
        n2 = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 2, 1, n2, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel5 = new JPanel(new GridBagLayout(), true);
        jPanel5.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_ESTIMATION_GROUP_BOX")));
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_TIME_SERIES_START_LABEL"));
        JLabel jLabel2 = new JLabel("          ");
        JLabel jLabel3 = new JLabel(this.getResString("IDS_TIME_SERIES_END_LABEL"));
        JLabel jLabel4 = new JLabel("          ");
        n2 = 23;
        Insets insets4 = new Insets(0, 2, 0, 2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel5, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets4);
        DialogUtil.addUsingGBL(jPanel5, jLabel2, gridBagConstraints, 0, 1, 1, 1, n2, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        insets4.set(0, 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel5, jLabel3, gridBagConstraints, 0, 2, 1, 1, n2, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets4.set(0, 2, 0, 2);
        DialogUtil.addUsingGBL(jPanel5, this.mEstimationStartLabel, gridBagConstraints, 1, 0, 1, 2, n2, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        insets4.set(0, 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel5, this.mEstimationEndLabel, gridBagConstraints, 1, 2, 1, 1, n2, insets4);
        JPanel jPanel6 = new JPanel(new GridBagLayout(), true);
        jPanel6.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_FORECAST_GROUP_BOX")));
        JLabel jLabel5 = new JLabel(this.getResString("IDS_TIME_SERIES_START_LABEL"));
        JLabel jLabel6 = new JLabel(this.getResString("IDS_TIME_SERIES_END_LABEL"));
        JLabel jLabel7 = new JLabel("          ");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets4.set(0, 2, 0, 2);
        DialogUtil.addUsingGBL(jPanel6, jLabel5, gridBagConstraints, 0, 0, 1, 1, n2, insets4);
        DialogUtil.addUsingGBL(jPanel6, jLabel7, gridBagConstraints, 0, 1, 1, 1, n2, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        insets4.set(0, 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel6, jLabel6, gridBagConstraints, 0, 2, 1, 1, n2, insets4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets4.set(0, 2, 0, 2);
        DialogUtil.addUsingGBL(jPanel6, this.mForecastStartLabel, gridBagConstraints, 1, 0, 1, 2, n2, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets4.set(0, 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel6, this.mForecastEndLabel, gridBagConstraints, 1, 2, 1, 1, n2, insets4);
        Dimension dimension = jPanel5.getPreferredSize();
        Dimension dimension2 = jPanel6.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.max((int)dimension.getWidth(), (int)dimension2.getWidth()), Math.max((int)dimension.getHeight(), (int)dimension2.getHeight()));
        jPanel5.setPreferredSize(dimension3);
        jPanel5.setMinimumSize(dimension3);
        jPanel6.setPreferredSize(dimension3);
        jPanel6.setMinimumSize(dimension3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n2 = 11;
        gridBagConstraints.fill = 2;
        insets3.set(2, 10, 16, 10);
        DialogUtil.addUsingGBL(this, jPanel5, gridBagConstraints, 0, 2, 1, 1, n2, insets3);
        n2 = 11;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel6, gridBagConstraints, 1, 2, 1, 1, n2, insets3);
    }

    @Override
    protected void aboutToShowTab() {
        Object object;
        Component component;
        super.aboutToShowTab();
        DialogDataModel dialogDataModel = ((CreateModelsMainDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null && dialogDataModel.getInteger(SOURCE_LIST_INDEX) != null) {
            this.mSrcVarList.setSelectedIndex(((CreateModelsMainDlg)this.mParent).getDialogDataModel().getInteger(SOURCE_LIST_INDEX));
        }
        if ((component = ((CreateModelsMainDlg)((Object)this.getTopLevelAncestor())).getGlassPane()) instanceof DragPane) {
            object = (DragPane)component;
            object.getDropListeners().removeAllElements();
            object.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList, this));
            object.addDropListener((IDropListener)new VarListDropListener(this.mDependentList, this));
            object.addDropListener((IDropListener)new VarListDropListener(this.mIndependentList, this));
        }
        if (dialogDataModel != null && dialogDataModel.getObject(COMBO_VALUE) != null) {
            object = (String)dialogDataModel.getObject(COMBO_VALUE);
            String string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0");
            String string2 = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1");
            String string3 = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2");
            this.mMethodCombo.setSelectedItem(((CreateModelsMainDlg)this.mParent).getDialogDataModel().getObject(COMBO_VALUE));
        }
    }

    void updateOKPasteButtons() {
        if (this.mDependentList.getModel().getSize() > 0) {
            ((CreateModelsMainDlg)this.mParent).enableOkPaste(true);
        } else {
            ((CreateModelsMainDlg)this.mParent).enableOkPaste(false);
        }
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.removeAllElements();
        this.mComponentOrder.add(this.mSrcVarList);
        this.mComponentOrder.add(this.mArrowDependentButton);
        this.mComponentOrder.add(this.mArrowIndependentButton);
        this.mComponentOrder.add(this.mDependentList);
        this.mComponentOrder.add(this.mIndependentList);
        this.mComponentOrder.add(this.mMethodCombo);
        this.mComponentOrder.add(this.mCriteriaButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
    }

    protected void setForecastEndValue(String string) {
        if (string.length() > 0) {
            this.mForecastEndLabel.setText(string);
        } else {
            this.mForecastEndLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_FORECAST_END_DEFAULT_LABEL"));
        }
    }

    private void runCriteriaSubDialog() {
        if (this.mMethodCombo.getSelectedItem().equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0"))) {
            this.mDlgExpert = new CriteriaExpertDlg((CreateModelsMainDlg)this.mParent);
            ((CreateModelsMainDlg)this.mParent).runSubDialog(this.mDlgExpert);
        } else if (this.mMethodCombo.getSelectedItem().equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1"))) {
            this.mDlgExponential = new CriteriaExponentialDlg((CreateModelsMainDlg)this.mParent);
            ((CreateModelsMainDlg)this.mParent).runSubDialog(this.mDlgExponential);
        } else if (this.mMethodCombo.getSelectedItem().equals(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2"))) {
            this.updatePeriodLabels();
            this.mDlgARIMA = new CriteriaARIMADlg((CreateModelsMainDlg)this.mParent);
            ((CreateModelsMainDlg)this.mParent).runSubDialog(this.mDlgARIMA);
        }
    }

    protected TargetVariableList getIndependentVars() {
        return this.mIndependentList;
    }

    protected void setModelString(String string) {
        this.mModelSettingLabel.setText(string);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier(SOURCE_LIST_IDENTIFIER_KEY);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mSrcListLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_VARIABLES_LABEL");
        this.mSrcListLabel.setLabelFor(this.mSrcVarList);
        this.mDependentList = new TargetVariableList();
        this.mDependentList.getModel().addListDataListener(this);
        this.mDependentList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDependentList.setIdentifier(DEPENDENT_LIST_IDENTIFIER_KEY);
        this.mDependentListLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_DEPENDENT_VARIABLES_LABEL");
        this.mDependentListLabel.setLabelFor(this.mDependentList);
        this.mIndependentList = new TargetVariableList();
        this.mIndependentList.setIdentifier(INDEPENDENT_LIST_IDENTIFIER_KEY);
        this.mIndependentList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mIndependentList.getModel().addListDataListener(this);
        this.mIndependentList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIndependentListLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_INDEPENDENT_VARIABLES_LABEL");
        this.mIndependentListLabel.setLabelFor(this.mIndependentList);
        this.mMethodLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_LABEL");
        this.mMethodComboFullModel = new CriteriaComboModel(new String[]{this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0"), this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1"), this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2")});
        this.mMethodComboSmallModel = new CriteriaComboModel(new String[]{this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0"), this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2")});
        this.mMethodCombo = new JComboBox(this.mMethodComboFullModel);
        this.mMethodCombo.setSelectedIndex(0);
        this.mMethodCombo.addActionListener(new ComboListener());
        this.mMethodCombo.setAction(new ComboboxAction(this.mParent, COMBO_VALUE));
        this.mMethodLabel.setLabelFor(this.mMethodCombo);
        String string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0");
        if (string.length() < this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1").length()) {
            string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1");
        }
        if (string.length() < this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2").length()) {
            string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2");
        }
        this.mMethodCombo.setPrototypeDisplayValue(string);
        this.mCriteriaButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_CRITERIA_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariablesTab.this.runCriteriaSubDialog();
            }
        });
        this.mModelLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_MODEL");
        this.mModelSettingLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_EXPERT_DESCRIPTION_LABEL");
        this.mEstimationStartLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_START_DEFAULT_LABEL");
        this.mEstimationEndLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_END_DEFAULT_LABEL");
        this.mForecastStartLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_FORECAST_START_DEFAULT_LABEL");
        this.mForecastEndLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_VARS_FORECAST_END_DEFAULT_LABEL");
        this.mSrcListLabel.setLabelFor(this.mSrcVarList);
    }

    private void updateModelTabTable(VariableList variableList, boolean bl, ISpssVariable[] iSpssVariableArray) {
        Vector<CriteriaExpertModelTabWrapper> vector;
        CriteriaExpertModelTab criteriaExpertModelTab = this.mDlgExpert.getModelTab();
        if (criteriaExpertModelTab != null && (vector = criteriaExpertModelTab.getWrapperVector()) != null && iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            this.checkIfExists(vector, iSpssVariableArray, variableList);
            if (!bl) {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    Icon icon = this.mIndependentList.getIcon(iSpssVariable);
                    CriteriaExpertModelTabWrapper criteriaExpertModelTabWrapper = new CriteriaExpertModelTabWrapper(iSpssVariable, icon, false, variableList.getShowVarLabels());
                    vector.add(criteriaExpertModelTabWrapper);
                }
            }
            ISpssVariable[] iSpssVariableArray2 = new SerializableObject[vector.size()];
            ((CreateModelsMainDlg)this.mParent).getDialogDataModel().putSerializableArray("IDS_WRAPPER_VECTOR", (SerializableObject[])vector.toArray(iSpssVariableArray2));
        }
    }

    private void checkIfExists(Vector<CriteriaExpertModelTabWrapper> vector, ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if (variableList.getModel().getSize() > 0) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                String string = iSpssVariable.getName();
                for (int i = 0; i < vector.size(); ++i) {
                    CriteriaExpertModelTabWrapper criteriaExpertModelTabWrapper = vector.get(i);
                    if (!criteriaExpertModelTabWrapper.getSpssVar().getName().equals(string)) continue;
                    vector.remove(i);
                    if (variableList.getModel().getSize() != 0) continue;
                    return;
                }
            }
        }
    }

    public void updatePeriodLabels() {
        ArrayList<Pair<ITrendsInfo.DateVarTypes, String>> arrayList;
        CreateModelsMainDlg createModelsMainDlg = (CreateModelsMainDlg)this.mParent;
        int n = createModelsMainDlg.getTrendsInfo().getNDateVars();
        if (n == 0) {
            arrayList = new ArrayList<Pair<ITrendsInfo.DateVarTypes, String>>(n);
            arrayList.add((Pair<ITrendsInfo.DateVarTypes, String>)new Pair((Object)ITrendsInfo.DateVarTypes.e_NONE, (Object)this.getColumnString(ITrendsInfo.DateVarTypes.e_NONE)));
        } else {
            arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                ITrendsInfo.DateVarTypes dateVarTypes = createModelsMainDlg.getTrendsInfo().getDateVarType(i);
                if (dateVarTypes == ITrendsInfo.DateVarTypes.e_DATKEY) continue;
                String string = this.getColumnString(dateVarTypes);
                Pair pair = new Pair((Object)dateVarTypes, (Object)string);
                arrayList.add((Pair<ITrendsInfo.DateVarTypes, String>)pair);
            }
        }
        this.mPeriodLabels = arrayList;
        this.mSyntaxLabels = DateFactory.getDateVariableSyntax();
    }

    private String getColumnString(ITrendsInfo.DateVarTypes dateVarTypes) {
        String string = "";
        ResourceBundle resourceBundle = ResUtil.getBundle(DataResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_CYCKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_CYCLE_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_YRKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_YEAR_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_QTRKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_QUARTER_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_MONKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_MONTH_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_WKKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_WEEK_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_DAYKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_DAY_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_HRKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_HOUR_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_MINKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_MINUTE_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_SECKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_SECOND_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_NONE) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_OBSERVATION_LABEL");
        }
        if (string.length() > 0 && string.substring(string.length() - 1).equals(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public CriteriaARIMADlg getARIMADialog() {
        return this.mDlgARIMA;
    }

    public void setARIMADialog(CriteriaARIMADlg criteriaARIMADlg) {
        this.mDlgARIMA = criteriaARIMADlg;
    }

    private void setCorrectComboModel() {
        int n = this.mMethodCombo.getSelectedIndex();
        CriteriaComboModel criteriaComboModel = (CriteriaComboModel)this.mMethodCombo.getModel();
        if (this.mIndependentList.getModel().getSize() > 0 && criteriaComboModel.equals(this.mMethodComboFullModel)) {
            this.mMethodCombo.setModel(this.mMethodComboSmallModel);
            if (n == 2) {
                n = 1;
            }
            this.mMethodCombo.setSelectedIndex(n);
        } else if (this.mIndependentList.getModel().getSize() == 0 && criteriaComboModel.equals(this.mMethodComboSmallModel)) {
            this.mMethodCombo.setModel(this.mMethodComboFullModel);
            if (n == 1) {
                n = 2;
            }
            this.mMethodCombo.setSelectedIndex(n);
        }
    }

    private String getExpertModelerModelSettingLabelText() {
        String string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_EXPERT_DESCRIPTION_LABEL");
        DialogDataModel dialogDataModel = ((CreateModelsMainDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null) {
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON");
            }
        }
        return string;
    }

    private String getExpoSmoothingModelSettingLabelText() {
        String string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_EXPONENTIAL_DESCRIPTION_LABEL");
        DialogDataModel dialogDataModel = ((CreateModelsMainDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null) {
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_EXPONENTIAL_DESCRIPTION_LABEL");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_HOLTS_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_HOLTS_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_HOLTS_RADIO_BUTTON");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_DAMPED_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_DAMPED_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_DAMPED_RADIO_BUTTON");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON");
            } else if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON") != null && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON").booleanValue()) {
                string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON");
            }
        }
        return string;
    }

    private String getARIMAModelSettingLabelText() {
        Object[][] objectArray;
        String string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ARIMA_DESCRIPTION_LABEL");
        DialogDataModel dialogDataModel = ((CreateModelsMainDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null && (objectArray = (Object[][])dialogDataModel.getObject("IDS_STRUCTURE_TABLE_MODEL")) != null) {
            Object[][] objectArrayArray = new Object[objectArray.length][];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArrayArray[i] = new Object[objectArray[i].length];
                for (int j = 0; j < objectArray[i].length; ++j) {
                    objectArrayArray[i][j] = objectArray[i][j];
                }
            }
            string = String.format("%s(%s, %s, %s)", this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2"), objectArrayArray[0][1].toString(), objectArrayArray[1][1].toString(), objectArrayArray[2][1].toString());
            if (objectArray.length == 3) {
                string = string + String.format("(%s, %s, %s)", objectArrayArray[0][2].toString(), objectArrayArray[1][2].toString(), objectArrayArray[2][2].toString());
            }
        }
        return string;
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            if (string.equals(VariablesTab.this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_0"))) {
                if (VariablesTab.this.mDlgExpert != null) {
                    VariablesTab.this.setModelString(VariablesTab.this.mDlgExpert.getModelTypeName());
                } else {
                    DialogDataModel dialogDataModel = ((CreateModelsMainDlg)VariablesTab.this.mParent).getDialogDataModel();
                    VariablesTab.this.setModelString(VariablesTab.this.getExpertModelerModelSettingLabelText());
                }
                ((CreateModelsMainDlg)VariablesTab.this.mParent).getSaveTab().setPMMLComponentsEnableState(true);
            } else if (string.equals(VariablesTab.this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_1"))) {
                if (VariablesTab.this.mDlgExponential != null) {
                    VariablesTab.this.setModelString(VariablesTab.this.mDlgExponential.getModelString());
                } else {
                    VariablesTab.this.setModelString(VariablesTab.this.getExpoSmoothingModelSettingLabelText());
                }
                ((CreateModelsMainDlg)VariablesTab.this.mParent).getSaveTab().setPMMLComponentsEnableState(false);
            } else if (string.equals(VariablesTab.this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_METHOD_COMBO_ITEM_2"))) {
                if (VariablesTab.this.mDlgARIMA != null) {
                    VariablesTab.this.setModelString(VariablesTab.this.mDlgARIMA.getModelString());
                } else {
                    VariablesTab.this.setModelString(VariablesTab.this.getARIMAModelSettingLabelText());
                }
                ((CreateModelsMainDlg)VariablesTab.this.mParent).getSaveTab().setPMMLComponentsEnableState(true);
            }
        }
    }

    private class CriteriaComboModel
    implements ComboBoxModel {
        private Object[] mValues;
        private String mSelected;
        int mDropListIndex;

        CriteriaComboModel(Object[] objectArray) {
            this.mValues = objectArray;
        }

        @Override
        public Object getSelectedItem() {
            return this.mSelected;
        }

        @Override
        public void setSelectedItem(Object object) {
            this.mDropListIndex = this.findIndexOfValue((String)object);
            this.mSelected = (String)object;
        }

        @Override
        public int getSize() {
            return this.mValues.length;
        }

        @Override
        public Object getElementAt(int n) {
            return this.mValues[n];
        }

        public int getSelectedIndex() {
            return this.mDropListIndex;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        private int findIndexOfValue(String string) {
            for (int i = 0; i < this.mValues.length; ++i) {
                if (!this.mValues[i].equals(string)) continue;
                return i;
            }
            return -1;
        }
    }
}

