/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CreateModelsMainDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class CriteriaExponentialDlg
extends BaseSubDialog {
    private JRadioButton mNonSeasonalSimpleRadio;
    private JRadioButton mNonSeasonalHoltsRadio;
    private JRadioButton mNonSeasonalBrownsRadio;
    private JRadioButton mNonSeasonalDampedRadio;
    private JRadioButton mSeasonalSimpleRadio;
    private JRadioButton mSeasonalWintersAdditiveRadio;
    private JRadioButton mSeasonalWintersMultiplicativeRadio;
    private JRadioButton mDependentNoneRadio;
    private JRadioButton mDependentSquareRootRadio;
    private JRadioButton mDependentNaturalLogRadio;
    private SpssButtonGroup mDependentButtonGrp;
    private SpssButtonGroup mModelTypeButtonGrp;

    public CriteriaExponentialDlg(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DIALOG_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_exp_smooth_crit";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        if (((CreateModelsMainDlg)this.mParentDlg).getPeriodNum() > 1) {
            this.mSeasonalSimpleRadio.setEnabled(true);
            this.mSeasonalWintersAdditiveRadio.setEnabled(true);
            this.mSeasonalWintersMultiplicativeRadio.setEnabled(true);
        } else {
            this.mSeasonalSimpleRadio.setEnabled(false);
            this.mSeasonalWintersAdditiveRadio.setEnabled(false);
            this.mSeasonalWintersMultiplicativeRadio.setEnabled(false);
        }
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setDefaults() {
        this.mNonSeasonalSimpleRadio.setSelected(true);
        this.mNonSeasonalHoltsRadio.setSelected(false);
        this.mNonSeasonalBrownsRadio.setSelected(false);
        this.mNonSeasonalDampedRadio.setSelected(false);
        this.mDependentNoneRadio.setSelected(true);
        this.mDependentSquareRootRadio.setSelected(false);
        this.mDependentNaturalLogRadio.setSelected(false);
        if (((CreateModelsMainDlg)this.mParentDlg).getPeriodNum() <= 1 && (this.mSeasonalSimpleRadio.isSelected() || this.mSeasonalWintersAdditiveRadio.isSelected() || this.mSeasonalWintersMultiplicativeRadio.isSelected())) {
            this.mNonSeasonalSimpleRadio.setSelected(true);
        }
        this.mSeasonalSimpleRadio.setSelected(false);
        this.mSeasonalWintersAdditiveRadio.setSelected(false);
        this.mSeasonalWintersMultiplicativeRadio.setSelected(false);
    }

    private void setupPanel() {
        JLabel jLabel = new JLabel(((CreateModelsMainDlg)this.mParentDlg).getPeriodText());
        JPanel jPanel = this.getViewPanel();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_MODEL_TYPE_GROUP_BOX")));
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_TRANSFORM_GROUP_BOX"));
        jPanel3.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets3 = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets3.left = DialogUtil.getStandardDialogInsets().left;
        int n2 = 10;
        DialogUtil.addUsingGBL(jPanel2, new JLabel(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_LABEL")), gridBagConstraints, 0, 0, 2, 1, n, insets3);
        gridBagConstraints.insets.left += n2;
        DialogUtil.addUsingGBL(jPanel2, this.mNonSeasonalSimpleRadio, gridBagConstraints, 0, 1, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mNonSeasonalHoltsRadio, gridBagConstraints, 0, 2, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mNonSeasonalBrownsRadio, gridBagConstraints, 0, 3, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mNonSeasonalDampedRadio, gridBagConstraints, 0, 4, 2, 1, n, insets3);
        gridBagConstraints.insets.left -= n2;
        DialogUtil.addUsingGBL(jPanel2, new JLabel(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_LABEL")), gridBagConstraints, 0, 5, 2, 1, n, insets3);
        gridBagConstraints.insets.left += n2;
        DialogUtil.addUsingGBL(jPanel2, this.mSeasonalSimpleRadio, gridBagConstraints, 0, 6, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mSeasonalWintersAdditiveRadio, gridBagConstraints, 0, 7, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mSeasonalWintersMultiplicativeRadio, gridBagConstraints, 0, 8, 2, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 1, 9, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDependentNoneRadio, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel3, this.mDependentSquareRootRadio, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDependentNaturalLogRadio, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.fill = 1;
        insets2.top = insets.top;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.left = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        Dimension dimension = new Dimension(230, 280);
        jPanel2.setPreferredSize(dimension);
        jPanel2.setMinimumSize(dimension);
        jPanel3.setMinimumSize(dimension);
        jPanel3.setPreferredSize(dimension);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mModelTypeButtonGrp);
        vector.add(this.mDependentButtonGrp);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    protected String getModelString() {
        String string = "";
        if (this.mNonSeasonalSimpleRadio.isSelected()) {
            string = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_EXPONENTIAL_DESCRIPTION_LABEL");
        } else if (this.mNonSeasonalHoltsRadio.isSelected()) {
            string = this.mNonSeasonalHoltsRadio.getText();
        } else if (this.mNonSeasonalBrownsRadio.isSelected()) {
            string = this.mNonSeasonalBrownsRadio.getText();
        } else if (this.mNonSeasonalDampedRadio.isSelected()) {
            string = this.mNonSeasonalDampedRadio.getText();
        } else if (this.mSeasonalSimpleRadio.isSelected()) {
            string = this.mSeasonalSimpleRadio.getText();
        } else if (this.mSeasonalWintersAdditiveRadio.isSelected()) {
            string = this.mSeasonalWintersAdditiveRadio.getText();
        } else if (this.mSeasonalWintersMultiplicativeRadio.isSelected()) {
            string = this.mSeasonalWintersMultiplicativeRadio.getText();
        }
        return string;
    }

    @Override
    public boolean continuePressed() {
        boolean bl = super.continuePressed();
        if (bl) {
            ((CreateModelsMainDlg)this.mParentDlg).getVariablesTab().setModelString(this.getModelString());
        }
        return bl;
    }

    protected String generateSmoothModelTypeSyntax() {
        String string = "";
        if (this.mNonSeasonalSimpleRadio.isSelected()) {
            string = "SIMPLE";
        } else if (this.mNonSeasonalHoltsRadio.isSelected()) {
            string = "HOLT";
        } else if (this.mNonSeasonalBrownsRadio.isSelected()) {
            string = "BROWN";
        } else if (this.mNonSeasonalDampedRadio.isSelected()) {
            string = "DAMPEDTREND";
        } else if (this.mSeasonalSimpleRadio.isSelected()) {
            string = "SIMPLESEASONAL";
        } else if (this.mSeasonalWintersAdditiveRadio.isSelected()) {
            string = "WINTERSADDITIVE";
        } else if (this.mSeasonalWintersMultiplicativeRadio.isSelected()) {
            string = "WINTERSMULTIPLICATIVE";
        }
        return string;
    }

    protected String generateTransformSyntax() {
        String string = "";
        if (this.mDependentNoneRadio.isSelected()) {
            string = "NONE";
        } else if (this.mDependentSquareRootRadio.isSelected()) {
            string = "SQRT";
        } else if (this.mDependentNaturalLogRadio.isSelected()) {
            string = "LN";
        }
        return string;
    }

    private void initVars() {
        this.mNonSeasonalSimpleRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_SIMPLE_RADIO_BUTTON"));
        this.mNonSeasonalHoltsRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_HOLTS_RADIO_BUTTON"));
        this.mNonSeasonalBrownsRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_BROWNS_RADIO_BUTTON"));
        this.mNonSeasonalDampedRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_NONSEASONAL_DAMPED_RADIO_BUTTON"));
        this.mSeasonalSimpleRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_SIMPLE_RADIO_BUTTON"));
        this.mSeasonalWintersAdditiveRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_ADDITIVE_RADIO_BUTTON"));
        this.mSeasonalWintersMultiplicativeRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_SEASONAL_WINTERS_MULTIPLICATIVE_RADIO_BUTTON"));
        this.mModelTypeButtonGrp = new SpssButtonGroup();
        this.mModelTypeButtonGrp.add(this.mNonSeasonalSimpleRadio);
        this.mModelTypeButtonGrp.add(this.mNonSeasonalHoltsRadio);
        this.mModelTypeButtonGrp.add(this.mNonSeasonalBrownsRadio);
        this.mModelTypeButtonGrp.add(this.mNonSeasonalDampedRadio);
        this.mModelTypeButtonGrp.add(this.mSeasonalSimpleRadio);
        this.mModelTypeButtonGrp.add(this.mSeasonalWintersAdditiveRadio);
        this.mModelTypeButtonGrp.add(this.mSeasonalWintersMultiplicativeRadio);
        this.mDependentNoneRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_NONE_RADIO_BUTTON"));
        this.mDependentSquareRootRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_SQUARE_ROOT_RADIO_BUTTON"));
        this.mDependentNaturalLogRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPONENTIAL_DEPENDENT_NATURAL_LOG_RADIO_BUTTON"));
        this.mDependentButtonGrp = new SpssButtonGroup();
        this.mDependentButtonGrp.add(this.mDependentNoneRadio);
        this.mDependentButtonGrp.add(this.mDependentSquareRootRadio);
        this.mDependentButtonGrp.add(this.mDependentNaturalLogRadio);
    }
}

