/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CreateModelsMainDlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertDlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertModelTabWrapper;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertTableModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableColumn;

public class CriteriaExpertModelTab
extends BaseProcedureTab {
    static final String MIN_WIDTH_KEY = "IDS_MIN_WIDTH";
    private JRadioButton mAllModelsRadio;
    private JRadioButton mExponentialOnlyRadio;
    private JRadioButton mARIMAOnlyRadio;
    private JCheckBox mConsiderSeasonalCheck;
    private JLabel mIndependentVariablesLabel;
    private JTable mEventsTable;
    protected static String[] COLUMN_NAMES = new String[3];
    private JScrollPane mScrollPane;
    private SpssButtonGroup mModelTypeButtonGrp;
    private Vector<CriteriaExpertModelTabWrapper> mWrapperVector;

    public CriteriaExpertModelTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_expmod_crit_model";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        SerializableObject[] serializableObjectArray = new SerializableObject[this.mWrapperVector.size()];
        ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getDialogDataModel().putSerializableArray("IDS_WRAPPER_VECTOR", this.mWrapperVector.toArray(serializableObjectArray));
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.enableDisableExpertModelerCheckbox();
    }

    private void enableDisableExpertModelerCheckbox() {
        if (((CreateModelsMainDlg)((Object)this.mParent.getParent())).getPeriodNum() > 1) {
            this.mConsiderSeasonalCheck.setEnabled(true);
        } else {
            this.mConsiderSeasonalCheck.setEnabled(false);
        }
        this.mConsiderSeasonalCheck.setSelected(true);
    }

    private void setDefaults() {
        this.mAllModelsRadio.setSelected(true);
        this.mExponentialOnlyRadio.setSelected(false);
        this.mARIMAOnlyRadio.setSelected(false);
        if (this.mEventsTable.getSelectedColumn() < 0 || this.mEventsTable.getSelectedRow() < 0) {
            this.mEventsTable.changeSelection(0, 0, false, false);
        }
    }

    private void setupPanel() {
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        insets.left = insets2.left;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_TYPE_GROUP_BOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mAllModelsRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mExponentialOnlyRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mARIMAOnlyRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 3, 3, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mConsiderSeasonalCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        JLabel jLabel = new JLabel(((CreateModelsMainDlg)((Object)this.mParent.getParent())).getPeriodText());
        n = 10;
        gridBagConstraints = new GridBagConstraints();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EVENTS_GROUP_BOX")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mIndependentVariablesLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, DialogUtil.getGroupBoxInnerMargin()));
        gridBagConstraints = new GridBagConstraints();
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EVENT_VARS_TEXT_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jTextArea, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JTextArea jTextArea2 = new JTextArea(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_CHECK_ALL_TEXT_LABEL"));
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setBorder(null);
        jTextArea2.setOpaque(false);
        jTextArea2.setFocusable(false);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jTextArea2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        Dimension dimension = jPanel2.getSize();
        dimension.width = 400;
        dimension.height = 300;
        jPanel2.setPreferredSize(dimension);
        jPanel2.setMinimumSize(dimension);
        this.setLayout(new GridBagLayout());
        n = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets2.top, insets2.left, DialogUtil.getComponentGroupGap(), insets2.right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, insets2.left, insets2.bottom, insets2.right));
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mModelTypeButtonGrp);
        this.mComponentOrder.add(this.mConsiderSeasonalCheck);
        this.mComponentOrder.add(this.mEventsTable);
    }

    protected void loadTableData() {
        CriteriaExpertTableModel criteriaExpertTableModel;
        Serializable serializable;
        Object object;
        String[] stringArray = new String[]{this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_INDEPENDENT_VARS_COL1_HEADER"), this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_INDEPENDENT_VARS_COL2_HEADER"), this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_INDEPENDENT_VARS_COL3_HEADER")};
        TargetVariableList targetVariableList = ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getVariablesTab().getIndependentVars();
        int n = targetVariableList.getModel().getSize();
        if (n > 0) {
            this.mExponentialOnlyRadio.setEnabled(false);
            object = ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getDialogDataModel().getSerializableArray("IDS_WRAPPER_VECTOR");
            if (object == null) {
                this.mWrapperVector = this.fillData();
            } else {
                try {
                    serializable = new Vector();
                    for (SerializableObject serializableObject : object) {
                        CriteriaExpertModelTabWrapper criteriaExpertModelTabWrapper = (CriteriaExpertModelTabWrapper)serializableObject;
                        criteriaExpertModelTabWrapper.setShowLabel(targetVariableList.getShowVarLabels());
                        ((Vector)serializable).add((CriteriaExpertModelTabWrapper)criteriaExpertModelTabWrapper.clone());
                    }
                    this.mWrapperVector = serializable;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            criteriaExpertTableModel = new CriteriaExpertTableModel(this.mWrapperVector, stringArray);
            this.mEventsTable.setModel(criteriaExpertTableModel);
        } else {
            this.mWrapperVector.clear();
            this.mExponentialOnlyRadio.setEnabled(true);
            ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getDialogDataModel().putSerializableArray("IDS_WRAPPER_VECTOR", null);
        }
        criteriaExpertTableModel = new CriteriaExpertTableModel(this.mWrapperVector, stringArray);
        this.mEventsTable.setModel(criteriaExpertTableModel);
        object = this.mEventsTable.getColumnModel();
        if (object != null) {
            serializable = object.getColumn(0);
            ((TableColumn)serializable).setPreferredWidth(40);
            serializable = object.getColumn(1);
            ((TableColumn)serializable).setPreferredWidth(40);
        }
    }

    private void initVars() {
        this.mWrapperVector = new Vector();
        this.mAllModelsRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ALL_MODELS_RADIO_BUTTON"));
        this.mExponentialOnlyRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_EXPONENTIAL_ONLY_RADIO_BUTTON"));
        this.mARIMAOnlyRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_ARIMA_ONLY_RADIO_BUTTON"));
        this.mModelTypeButtonGrp = new SpssButtonGroup();
        this.mModelTypeButtonGrp.add(this.mAllModelsRadio);
        this.mModelTypeButtonGrp.add(this.mExponentialOnlyRadio);
        this.mModelTypeButtonGrp.add(this.mARIMAOnlyRadio);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_CONSIDER_SEASONAL_CHECK_BOX");
        this.mConsiderSeasonalCheck = new JCheckBox(toggleButtonAction);
        this.mEventsTable = new JTable();
        this.mEventsTable.setCellSelectionEnabled(true);
        this.mIndependentVariablesLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_EXPERT_MODEL_INDEPENDENT_VARS_LABEL");
        this.mIndependentVariablesLabel.setLabelFor(this.mEventsTable);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (CriteriaExpertModelTab.this.mEventsTable.getSelectedColumn() < 0 || CriteriaExpertModelTab.this.mEventsTable.getSelectedRow() < 0) {
                    CriteriaExpertModelTab.this.mEventsTable.changeSelection(0, 0, false, false);
                }
            }
        };
        this.mEventsTable.addFocusListener(focusAdapter);
        this.mScrollPane = new JScrollPane(this.mEventsTable, 20, 31);
        Dimension dimension = this.mScrollPane.getSize();
        dimension.width = 300;
        dimension.height = 100;
        this.mScrollPane.setPreferredSize(dimension);
        this.mScrollPane.setMinimumSize(dimension);
    }

    protected String getModelTypeName() {
        String string = "";
        if (this.mAllModelsRadio.isSelected()) {
            string = this.mAllModelsRadio.getText();
        } else if (this.mExponentialOnlyRadio.isSelected()) {
            string = this.mExponentialOnlyRadio.getText();
        } else if (this.mARIMAOnlyRadio.isSelected()) {
            string = this.mARIMAOnlyRadio.getText();
        }
        return string;
    }

    protected void setModelToARIMA() {
        this.mARIMAOnlyRadio.setSelected(true);
        ToggleButtonAction toggleButtonAction = (ToggleButtonAction)this.mAllModelsRadio.getAction();
        ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getDialogDataModel().putBoolean(toggleButtonAction.getActionKey(), this.mAllModelsRadio.isSelected());
        toggleButtonAction = (ToggleButtonAction)this.mExponentialOnlyRadio.getAction();
        ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getDialogDataModel().putBoolean(toggleButtonAction.getActionKey(), this.mExponentialOnlyRadio.isSelected());
        toggleButtonAction = (ToggleButtonAction)this.mARIMAOnlyRadio.getAction();
        ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getDialogDataModel().putBoolean(toggleButtonAction.getActionKey(), this.mARIMAOnlyRadio.isSelected());
    }

    protected boolean getConsiderSeasonal() {
        return this.mConsiderSeasonalCheck.isSelected();
    }

    private Vector<CriteriaExpertModelTabWrapper> fillData() {
        this.mWrapperVector = new Vector();
        TargetVariableList targetVariableList = ((CreateModelsMainDlg)((Object)((CriteriaExpertDlg)this.mParent).getParent())).getVariablesTab().getIndependentVars();
        boolean bl = targetVariableList.getShowVarLabels();
        int n = targetVariableList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            Icon icon = targetVariableList.getIcon(targetVariableList.getModel().getElementAt(i));
            CriteriaExpertModelTabWrapper criteriaExpertModelTabWrapper = new CriteriaExpertModelTabWrapper(iSpssVariable, icon, false, bl);
            this.mWrapperVector.add(criteriaExpertModelTabWrapper);
        }
        return this.mWrapperVector;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.loadTableData();
    }

    public Vector<CriteriaExpertModelTabWrapper> getWrapperVector() {
        return this.mWrapperVector;
    }

    public void setWrapperVector(Vector<CriteriaExpertModelTabWrapper> vector) {
        this.mWrapperVector = vector;
    }
}

