/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CreateModelsMainDlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMADlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMAStructureTableModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class CriteriaARIMATransferTab
extends BaseProcedureTab
implements ListDataListener,
ItemListener,
DocumentListener {
    static final String MIN_WIDTH_KEY = "IDS_TS_CRITERIA_ARIMA_TRANSFER_TAB_DELAY_VALUE";
    static final String DELAY_VALUE_DEFAULT = "0";
    private JLabel mIndependentVarsLabel;
    private TargetVariableList mIndependentList;
    private JLabel mStructureLabel;
    private PlainTable mStructureTable;
    private JLabel mDelayLabel;
    private IntTextField mDelayValue;
    private JRadioButton mTransformationNoneRadio;
    private JRadioButton mTransformationSquareRootRadio;
    private JRadioButton mTransformationNaturalLogRadio;
    private JScrollPane mScrollPane;
    private ButtonGroup mButtonGrp;
    private DialogDataModel mDataModel;
    private CriteriaARIMAStructureTableModel mStructureTableModel;
    private HashMap<ISpssVariable, TransferDataModel> mTransferTabHashMap;

    public CriteriaARIMATransferTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_arima_crit_xferfunc";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public TransferDataModel makeTransferDataModel() {
        Object[][] objectArray = new Object[this.mStructureTable.getModel().getRowCount()][this.mStructureTable.getColumnCount()];
        for (int i = 0; i < this.mStructureTable.getModel().getRowCount(); ++i) {
            for (int j = 1; j < this.mStructureTable.getColumnCount(); ++j) {
                objectArray[i][j] = 0;
            }
        }
        objectArray[0][0] = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_NUMERATOR_ROW_HEADER");
        objectArray[1][0] = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_DENOMINATOR_ROW_HEADER");
        objectArray[2][0] = this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_DIFFERENCE_ROW_HEADER");
        return new TransferDataModel(objectArray);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mTransformationNoneRadio) {
            this.setTextInTransferData(false, EnumTransformation.None);
        } else if (itemEvent.getSource() == this.mTransformationSquareRootRadio) {
            this.setTextInTransferData(false, EnumTransformation.SquareRoot);
        } else if (itemEvent.getSource() == this.mTransformationNaturalLogRadio) {
            this.setTextInTransferData(false, EnumTransformation.NaturalLog);
        }
    }

    protected void loadListData() {
        TargetVariableList targetVariableList = ((CreateModelsMainDlg)((Object)((CriteriaARIMADlg)this.mParent).getParent())).getVariablesTab().getIndependentVars();
        int n = targetVariableList.getModel().getSize();
        this.mIndependentList.removeAll();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            this.mIndependentList.getModel().addElement(iSpssVariable);
            this.mTransferTabHashMap.put(iSpssVariable, this.makeTransferDataModel());
        }
        this.mIndependentList.setSelectedIndex(0);
        this.mIndependentList.requestFocus();
    }

    private void setDefaults() {
        this.mTransferTabHashMap.clear();
        this.mTransformationNoneRadio.setSelected(true);
        this.mDelayValue.setText(DELAY_VALUE_DEFAULT);
        if (this.mStructureTable.getSelectedColumn() < 0 || this.mStructureTable.getSelectedRow() < 0) {
            this.mStructureTable.changeSelection(0, 1, false, false);
        }
    }

    private void setupPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets3 = new Insets(0, 0, 0, 0);
        insets3.left = insets2.left;
        insets3.right = insets.right;
        insets3.top = insets.top;
        insets3.bottom = insets.bottom;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_GROUP_BOX")));
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDelayLabel, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        insets3.left = insets.left;
        insets3.right = insets.right;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mDelayValue, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        JPanel jPanel4 = new JPanel(new GridBagLayout(), true);
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_DEPENDENT_GROUP_BOX")));
        insets3.left = insets2.left;
        insets3.right = insets2.right;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVarsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mIndependentList);
        jScrollPane.setPreferredSize(this.mIndependentList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mStructureLabel, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        JLabel jLabel = new JLabel(((CreateModelsMainDlg)((Object)this.mParent.getParent())).getPeriodText());
        gridBagConstraints.fill = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 17;
        DialogUtil.addUsingGBL(jPanel2, new JSeparator(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        n = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 18;
        DialogUtil.addUsingGBL(jPanel4, this.mTransformationNoneRadio, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel4, this.mTransformationSquareRootRadio, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mTransformationNaturalLogRadio, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        Insets insets4 = new Insets(insets2.top, insets2.left, insets2.bottom, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 2, n, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets4.set(insets2.top, 0, DialogUtil.getComponentGroupGap(), insets2.right);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets4.set(0, 0, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(this, jPanel4, gridBagConstraints, 1, 1, 1, 1, n, insets4);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mIndependentList);
        this.mComponentOrder.add(this.mStructureTable);
        this.mComponentOrder.add(this.mDelayValue);
        this.mComponentOrder.add(this.mButtonGrp);
    }

    private void initVars() {
        this.mTransferTabHashMap = new HashMap();
        this.mDataModel = ((CreateModelsMainDlg)((Object)((CriteriaARIMADlg)this.mParent).getParent())).getDialogDataModel();
        this.mIndependentList = new TargetVariableList();
        this.mIndependentList.setSelectionMode(0);
        this.mIndependentList.addListSelectionListener(new IndependentVarsListSelectionHandler());
        this.mIndependentVarsLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_INDEPENDENT_VARIABLES_LABEL");
        this.mIndependentVarsLabel.setLabelFor(this.mIndependentList);
        String[] stringArray = new String[]{" ", this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_NONSEASONAL_COLUMN_HEADER"), this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_SEASONAL_COLUMN_HEADER")};
        Object[][] objectArray = new Object[][]{{this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_NUMERATOR_ROW_HEADER"), 0, 0}, {this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_DENOMINATOR_ROW_HEADER"), 0, 0}, {this.getResString("IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_DIFFERENCE_ROW_HEADER"), 0, 0}};
        this.mStructureTableModel = new CriteriaARIMAStructureTableModel(this.mParent, stringArray, objectArray);
        this.mStructureTable = new PlainTable(this.mStructureTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                if (n2 == 0 || n2 == 2 && ((CreateModelsMainDlg)((Object)CriteriaARIMATransferTab.this.mParent.getParent())).getPeriodNum() <= 1) {
                    return false;
                }
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mStructureTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mStructureTable.setAutoResizeMode(3);
        this.mStructureTable.setDefaultRenderer(Object.class, new StructureTableRenderer());
        this.mStructureTable.setRowSelectionAllowed(false);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CriteriaARIMATransferTab.this.mStructureTable.getSelectedColumn();
                int n2 = CriteriaARIMATransferTab.this.mStructureTable.getSelectedRow();
                int n3 = n - 1;
                if (n3 <= 0) {
                    n3 = 1;
                }
                if (n3 > 0 && n3 < CriteriaARIMATransferTab.this.mStructureTable.getColumnCount()) {
                    CriteriaARIMATransferTab.this.mStructureTable.changeSelection(n2, n3, false, false);
                }
            }
        };
        this.mStructureTable.getInputMap(0).put(KeyStroke.getKeyStroke(37, 0), "leftArrow");
        this.mStructureTable.getActionMap().put("leftArrow", abstractAction);
        this.mStructureLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_STRUCTURE_LABEL");
        this.mStructureLabel.setLabelFor(this.mStructureTable);
        this.mScrollPane = new JScrollPane(this.mStructureTable, 21, 31);
        Dimension dimension = this.mScrollPane.getSize();
        dimension.width = 400;
        dimension.height = 125;
        this.mScrollPane.setPreferredSize(dimension);
        this.mScrollPane.setMinimumSize(dimension);
        this.mDelayValue = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mDelayValue.setAction((Action)new TextFieldAction(this.mParent, MIN_WIDTH_KEY));
        this.mDelayValue.setText(DELAY_VALUE_DEFAULT);
        this.mDelayValue.setAlignmentX(1.0f);
        this.mDelayLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_TRANSFER_ORDERS_DELAY_LABEL");
        this.mDelayLabel.setLabelFor((Component)this.mDelayValue);
        this.mDelayValue.getDocument().addDocumentListener(this);
        this.mTransformationNoneRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_DEPENDENT_NONE_RADIO_BUTTON"));
        this.mTransformationNoneRadio.addItemListener(this);
        this.mTransformationSquareRootRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_DEPENDENT_SQUARE_ROOT_RADIO_BUTTON"));
        this.mTransformationSquareRootRadio.addItemListener(this);
        this.mTransformationNaturalLogRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_CRITERIA_ARIMA_MODEL_DEPENDENT_NATURAL_LOG_RADIO_BUTTON"));
        this.mTransformationNaturalLogRadio.addItemListener(this);
        this.mButtonGrp = new SpssButtonGroup();
        this.mButtonGrp.add(this.mTransformationNoneRadio);
        this.mButtonGrp.add(this.mTransformationSquareRootRadio);
        this.mButtonGrp.add(this.mTransformationNaturalLogRadio);
    }

    @Override
    protected boolean validateTab() {
        if (this.mStructureTable.isEditing()) {
            this.mStructureTable.getCellEditor().stopCellEditing();
        }
        boolean bl = super.validateTab();
        if (this.mDelayValue.getText().trim().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_ENTER_POSITIVE_VALUE_WARNING"), VersionInfo.getAppVersionString());
            this.mDelayValue.requestFocus();
            return false;
        }
        TableModel tableModel = this.mStructureTable.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            for (int j = 1; j < tableModel.getColumnCount(); ++j) {
                Object object = tableModel.getValueAt(i, j);
                if (object != null && object.toString().trim().length() != 0) continue;
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_ENTER_POSITIVE_VALUE_WARNING"), VersionInfo.getAppVersionString());
                this.mStructureTable.requestFocus();
                this.mStructureTable.changeSelection(i, j, false, false);
                return false;
            }
        }
        return bl;
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        if (this.mStructureTableModel != null) {
            this.mDataModel.putObject("IDS_TRANSFER_STRUCTURE_TABLE_MODEL", this.mStructureTableModel.getTableData());
        }
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.mTransferTabHashMap.size()];
        this.mDataModel.putVarArray("IDS_TRANSFER_TAB_VAR_ARRAY", this.mTransferTabHashMap.keySet().toArray(iSpssVariableArray));
        SerializableObject[] serializableObjectArray = new SerializableObject[this.mTransferTabHashMap.size()];
        this.mDataModel.putSerializableArray("IDS_TRANSFER_TAB_ITEM_ARRAY", this.mTransferTabHashMap.values().toArray(serializableObjectArray));
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        TargetVariableList targetVariableList = ((CreateModelsMainDlg)((Object)((CriteriaARIMADlg)this.mParent).getParent())).getVariablesTab().getIndependentVars();
        int n = targetVariableList.getModel().getSize();
        if (n > 0) {
            ISpssVariable[] iSpssVariableArray = this.mDataModel.getVarArray("IDS_TRANSFER_TAB_VAR_ARRAY");
            LinkedHashSet<ISpssVariable> linkedHashSet = new LinkedHashSet<ISpssVariable>(Arrays.asList(iSpssVariableArray));
            SerializableObject[] serializableObjectArray = this.mDataModel.getSerializableArray("IDS_TRANSFER_TAB_ITEM_ARRAY");
            HashMap<ISpssVariable, TransferDataModel> hashMap = new HashMap<ISpssVariable, TransferDataModel>();
            if (iSpssVariableArray == null || serializableObjectArray == null || iSpssVariableArray.length == 0) {
                this.loadListData();
            } else {
                try {
                    this.mIndependentList.removeAll();
                    for (int i = 0; i < n; ++i) {
                        ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
                        this.mIndependentList.getModel().addElement(iSpssVariable);
                        int n2 = this.listContains(iSpssVariableArray, iSpssVariable);
                        if (n2 >= 0) {
                            TransferDataModel transferDataModel = (TransferDataModel)serializableObjectArray[n2];
                            hashMap.put(iSpssVariable, (TransferDataModel)transferDataModel.clone());
                            continue;
                        }
                        hashMap.put(iSpssVariable, this.makeTransferDataModel());
                    }
                    this.mTransferTabHashMap = hashMap;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else {
            this.mDataModel.putVarArray("IDS_TRANSFER_TAB_VAR_ARRAY", null);
            this.mDataModel.putSerializableArray("IDS_TRANSFER_TAB_ITEM_ARRAY", null);
        }
        if (this.mIndependentList.getModel().getSize() > 0) {
            this.mIndependentList.requestFocus();
            this.mIndependentList.setSelectedIndex(0);
        }
    }

    private int listContains(ISpssVariable[] iSpssVariableArray, ISpssVariable iSpssVariable) {
        for (int i = 0; i < iSpssVariableArray.length; ++i) {
            ISpssVariable iSpssVariable2 = iSpssVariableArray[i];
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setTextInTransferData(true, null);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setTextInTransferData(true, null);
    }

    private void setTextInTransferData(boolean bl, EnumTransformation enumTransformation) {
        ISpssVariable[] iSpssVariableArray = this.mIndependentList.getSelectedValues();
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            TransferDataModel transferDataModel = this.getModelFromMap(iSpssVariableArray[0]);
            if (transferDataModel == null) {
                return;
            }
            if (bl) {
                transferDataModel.setDelay(this.mDelayValue.getText());
            } else {
                transferDataModel.setTransformation(enumTransformation);
            }
        }
    }

    private TransferDataModel getModelFromMap(ISpssVariable iSpssVariable) {
        for (Map.Entry<ISpssVariable, TransferDataModel> entry : this.mTransferTabHashMap.entrySet()) {
            if (!entry.getKey().getName().equals(iSpssVariable.getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    public TargetVariableList getIndependentList() {
        return this.mIndependentList;
    }

    public void setIndependentList(TargetVariableList targetVariableList) {
        this.mIndependentList = targetVariableList;
    }

    private void displayData(TransferDataModel transferDataModel) {
        if (transferDataModel != null) {
            this.mDelayValue.setText(transferDataModel.getDelay());
            EnumTransformation enumTransformation = transferDataModel.getTransformation();
            switch (enumTransformation) {
                case None: {
                    this.mTransformationNoneRadio.setSelected(true);
                    break;
                }
                case SquareRoot: {
                    this.mTransformationSquareRootRadio.setSelected(true);
                    break;
                }
                case NaturalLog: {
                    this.mTransformationNaturalLogRadio.setSelected(true);
                }
            }
            this.mStructureTableModel.setTableData(transferDataModel.getTableData());
            this.mStructureTableModel.fireTableDataChanged();
        }
    }

    public HashMap<ISpssVariable, TransferDataModel> getTransferTabHashMap() {
        return this.mTransferTabHashMap;
    }

    public void setTransferTabHashMap(HashMap<ISpssVariable, TransferDataModel> hashMap) {
        this.mTransferTabHashMap = hashMap;
    }

    class IndependentVarsListSelectionHandler
    implements ListSelectionListener {
        private int statLastIndex = 0;
        TransferDataModel transferData = null;

        IndependentVarsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ISpssVariable[] iSpssVariableArray;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            if (!jList.isSelectionEmpty() && (iSpssVariableArray = CriteriaARIMATransferTab.this.mIndependentList.getSelectedValues()) != null) {
                ISpssVariable iSpssVariable = iSpssVariableArray[0];
                this.transferData = CriteriaARIMATransferTab.this.getModelFromMap(iSpssVariable);
                if (iSpssVariableArray.length > 1) {
                    // empty if block
                }
                CriteriaARIMATransferTab.this.displayData(this.transferData);
            }
        }
    }

    public static class TransferDataModel
    implements SerializableObject {
        private Object[][] mTableData = null;
        private String mDelay = "0";
        private EnumTransformation mTransformation = EnumTransformation.None;

        public TransferDataModel() {
            this(null);
        }

        public TransferDataModel(Object[][] objectArray) {
            this.mTableData = objectArray;
            this.mDelay = CriteriaARIMATransferTab.DELAY_VALUE_DEFAULT;
            this.mTransformation = EnumTransformation.None;
        }

        public TransferDataModel(Object[][] objectArray, String string, EnumTransformation enumTransformation) {
            this.mTableData = objectArray;
            this.mDelay = string;
            this.mTransformation = enumTransformation;
        }

        public Object[][] getTableData() {
            return this.mTableData;
        }

        public void setTableData(Object[][] objectArray) {
            this.mTableData = objectArray;
        }

        public String getDelay() {
            return this.mDelay;
        }

        public void setDelay(String string) {
            this.mDelay = string;
        }

        public EnumTransformation getTransformation() {
            return this.mTransformation;
        }

        public void setTransformation(EnumTransformation enumTransformation) {
            this.mTransformation = enumTransformation;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMATransferTab$TransferDataModel";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mTableData = (Object[][])objectInputStream.readObject();
            this.mDelay = objectInputStream.readUTF();
            this.mTransformation = EnumTransformation.fromInt(objectInputStream.readInt());
            return true;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeObject(this.mTableData);
            objectOutputStream.writeUTF(this.mDelay);
            objectOutputStream.writeInt(this.mTransformation.ordinal());
            return true;
        }

        protected Object clone() throws CloneNotSupportedException {
            Object[][] objectArray = null;
            if (this.mTableData != null) {
                objectArray = new Object[this.mTableData.length][];
                for (int i = 0; i < this.mTableData.length; ++i) {
                    objectArray[i] = new Object[this.mTableData[i].length];
                    System.arraycopy(this.mTableData[i], 0, objectArray[i], 0, this.mTableData[i].length);
                }
            }
            return new TransferDataModel(objectArray, this.mDelay, this.mTransformation);
        }
    }

    static enum EnumTransformation {
        None,
        SquareRoot,
        NaturalLog;


        static EnumTransformation fromInt(int n) {
            switch (n) {
                default: {
                    return None;
                }
                case 1: {
                    return SquareRoot;
                }
                case 2: 
            }
            return NaturalLog;
        }
    }

    class StructureTableRenderer
    extends DefaultTableCellRenderer {
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        StructureTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0) {
                component.setForeground(jTable.getTableHeader().getForeground());
                component.setBackground(jTable.getTableHeader().getBackground());
                ((JLabel)component).setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                ((JLabel)component).setHorizontalAlignment(2);
            } else if (n2 == 2 && ((CreateModelsMainDlg)((Object)CriteriaARIMATransferTab.this.mParent.getParent())).getPeriodNum() <= 1) {
                component.setForeground(Color.gray);
                component.setBackground(jTable.getBackground());
                ((JLabel)component).setBorder(this.mEmptyBorder);
                ((JLabel)component).setHorizontalAlignment(4);
            } else if (component instanceof JLabel) {
                component.setForeground(Color.black);
                if (component.hasFocus()) {
                    ((JLabel)component).setBorder(this.mHighLightBorder);
                }
                if (bl && component.hasFocus()) {
                    component.setBackground(jTable.getSelectionBackground());
                } else {
                    component.setBackground(jTable.getBackground());
                }
                ((JLabel)component).setHorizontalAlignment(4);
            }
            return component;
        }
    }

    class CriteriaARIMAEventsTableItem {
        boolean mSave = false;
        boolean mEnable = true;
        String mItemToSave = "";
        String mDefVariableName = "";
        String mVariableName = "";

        public CriteriaARIMAEventsTableItem(boolean bl, String string, String string2) {
            this.mSave = bl;
            this.mItemToSave = string;
            this.mVariableName = string2;
            this.mDefVariableName = string2;
        }

        public boolean getSave() {
            return this.mSave;
        }

        public void setSave(boolean bl) {
            this.mSave = bl;
        }

        public boolean isEnabled() {
            return this.mEnable;
        }

        public void setEnabled(boolean bl) {
            this.mEnable = bl;
        }

        public String getItemToSave() {
            return this.mItemToSave;
        }

        public String getVariableName() {
            return this.mVariableName;
        }

        public String getDefaultVariableName() {
            return this.mDefVariableName;
        }

        public void setVariableName(String string) {
            this.mVariableName = string;
        }
    }
}

