/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.GlobalParameterErrorChecking;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesDefineDatesAlertDlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesOutputFilterTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesPlotsTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesSaveTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesStatisticsTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMADlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMAOutliersTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.OptionsTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.VariablesTab;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.trends.res.TrendsResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.canvas.tables.BaseTableCanvas;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CreateModelsMainDlg
extends BaseTabbedDialog {
    private VariablesTab mVariablesTab;
    private TimeSeriesStatisticsTab mStatisticsTab;
    private TimeSeriesPlotsTab mPlotsTab;
    private TimeSeriesOutputFilterTab mOutputFilterTab;
    private TimeSeriesSaveTab mSaveTab;
    private OptionsTab mOptionsTab;
    private boolean mIsSplitFileOn = false;
    private Vector<ISpssVariable> mSplitVars;

    public CreateModelsMainDlg(JFrame jFrame) {
        super(jFrame, false, TrendsResBundle.getDefaultResourceBundleName(), TrendsResBundle.getImageFolder());
        this.secondInit(jFrame);
    }

    private void secondInit(JFrame jFrame) {
        this.setTitle(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_WINDOW_TITLE"));
        this.pack();
        this.setLocationRelativeTo(jFrame);
        boolean bl = PrefsMgr.getPrefsMgr().getDialogBooleanPref("create_models", "dont_show_create_models_warning");
        if (!bl && !this.AreDateVarsDefined()) {
            this.launchAlert();
        }
    }

    private void launchAlert() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TimeSeriesDefineDatesAlertDlg(CreateModelsMainDlg.this, CreateModelsMainDlg.this.getResString("IDS_TIME_SERIES_DEFINE_DATES_SUBDLG_LINE_1") + CreateModelsMainDlg.this.getResString("IDS_TIME_SERIES_DEFINE_DATES_SUBDLG_LINE_2") + CreateModelsMainDlg.this.getResString("IDS_TIME_SERIES_DEFINE_DATES_SUBDLG_LINE_3"), CreateModelsMainDlg.this.getResString("IDS_TIME_SERIES_CREATE_MODELS_WINDOW_TITLE"), "create_models", "dont_show_create_models_warning");
            }
        });
    }

    private boolean AreDateVarsDefined() {
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        return iTrendsInfo.getNDateVars() > 0;
    }

    @Override
    public String getIActionKey() {
        return "analyze_time_series_create_models";
    }

    @Override
    public String getDialogHelpID() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        return baseProcedureTab.getDialogHelpID();
    }

    public VariablesTab getAssignVarsTab() {
        return this.mVariablesTab;
    }

    @Override
    public void dispose() {
        super.dispose();
        BaseTableCanvas.setClipboard(null);
    }

    @Override
    public void reset() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel != null) {
            dialogDataModel.putSerializableArray("IDS_WRAPPER_VECTOR", null);
        }
        super.reset();
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected void init() {
        super.init();
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mIsSplitFileOn = GlobalParameterErrorChecking.isSplitFileON((LocallyUniqueId)locallyUniqueId);
        if (this.mIsSplitFileOn) {
            int n = iSpssDataSrc.getNSplitVars();
            this.mSplitVars = null;
            this.mSplitVars = new Vector();
            for (int i = 0; i < n; ++i) {
                int n2 = iSpssDataSrc.getSplitVarIndex(i);
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
                this.mSplitVars.add(iSpssVariable);
            }
        }
        this.mVariablesTab = new VariablesTab(this, true);
        this.mStatisticsTab = new TimeSeriesStatisticsTab(this, true, false);
        this.mPlotsTab = new TimeSeriesPlotsTab(this, true, false);
        this.mOutputFilterTab = new TimeSeriesOutputFilterTab(this, true);
        this.mSaveTab = new TimeSeriesSaveTab(this, true, false);
        this.mOptionsTab = new OptionsTab(this, true);
        this.addTab(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_TAB_TITLE"), this.mVariablesTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_STATISTICS_TAB_TITLE"), this.mStatisticsTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_PLOTS_TAB_TITLE"), this.mPlotsTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_OUTPUT_FILTER_TAB_TITLE"), this.mOutputFilterTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_SAVE_TAB_TITLE"), this.mSaveTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_OPTIONS_TAB_TITLE"), this.mOptionsTab);
        this.mTabbedPane.addChangeListener(this);
    }

    public VariablesTab getVariablesTab() {
        return this.mVariablesTab;
    }

    public TimeSeriesSaveTab getSaveTab() {
        return this.mSaveTab;
    }

    public OptionsTab getOptionsTab() {
        return this.mOptionsTab;
    }

    public ITrendsInfo getTrendsInfo() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        return iSpssDataSrc.getTrendsInfo();
    }

    public int getPeriodNum() {
        return this.getTrendsInfo().getPeriod();
    }

    public String getPeriodText() {
        String string = this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_PREFIX");
        string = this.getPeriodNum() > 1 ? string + Integer.toString(this.getPeriodNum()) : string + this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_NONE_VALUE");
        return string;
    }

    public int getPeriodMinVal(ITrendsInfo.DateVarTypes dateVarTypes) {
        int n = 0;
        switch (dateVarTypes) {
            case e_CYCKEY: 
            case e_DATKEY: 
            case e_DAYKEY: 
            case e_MONKEY: 
            case e_NONE: 
            case e_OBSKEY: 
            case e_QTRKEY: 
            case e_WKKEY: 
            case e_YRKEY: {
                n = 1;
                break;
            }
            case e_HRKEY: 
            case e_MINKEY: 
            case e_SECKEY: {
                n = 0;
            }
        }
        return n;
    }

    public boolean getIsSplitFileOn() {
        return this.mIsSplitFileOn;
    }

    public Vector<ISpssVariable> getSplitFileVars() {
        return this.mSplitVars;
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("PREDICT THRU ");
        stringBuffer.append(this.mOptionsTab.getForecastEndSyntax(this.getDialogDataModel())).append(SyntaxUtil.terminateSyntax());
        stringBuffer.append("* ").append(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_SYNTAX_TITLE")).append(".\n");
        stringBuffer.append("TSMODEL");
        this.mStatisticsTab.generateModelSyntax(stringBuffer, this.getDialogDataModel());
        this.mPlotsTab.generateModelPlotSyntax(stringBuffer, this.getDialogDataModel());
        this.mStatisticsTab.generateModelStatsSyntax(stringBuffer, this.getDialogDataModel());
        StringBuffer stringBuffer2 = new StringBuffer();
        this.mStatisticsTab.generateModelDetailsSyntax(stringBuffer2, this.getDialogDataModel());
        this.mPlotsTab.generateModelDetailsSyntax(stringBuffer2, this.getDialogDataModel());
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n   /MODELDETAILS").append(stringBuffer2);
        }
        this.mPlotsTab.generateSeriesPlotSyntax(stringBuffer, this.getDialogDataModel());
        this.mOutputFilterTab.generateSyntax(stringBuffer, this.getDialogDataModel());
        this.mSaveTab.generateSyntax(stringBuffer, this.getDialogDataModel());
        this.mOptionsTab.generateAuxiliarySyntax(stringBuffer, this.getDialogDataModel());
        this.mOptionsTab.generateMissingSyntax(stringBuffer, this.getDialogDataModel());
        this.mVariablesTab.generateModelSyntax(stringBuffer, this.getDialogDataModel());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile((String)this.getDialogDataModel().getString("EXPORT_XML_FILE_PATH"));
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    protected String buildBracketedNumList(Integer n) {
        if (n == null) {
            return "[]";
        }
        String string = "[";
        if (n >= 1) {
            for (int i = n.intValue(); i >= 1; --i) {
                String string2 = i == n ? String.format("%d", i) : String.format(",%d", i);
                string = string + string2;
            }
        } else {
            String string3 = "0";
            string = string + string3;
        }
        string = string + "]";
        return string;
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new DataObserver();
    }

    public class DataObserver
    extends BaseProcedureDialog.DataViewObserverAdapter {
        public DataObserver() {
            super(CreateModelsMainDlg.this);
        }

        @Override
        public void notifyTrendsInfo() {
            if (CreateModelsMainDlg.this.mVariablesTab != null) {
                CriteriaARIMAOutliersTab criteriaARIMAOutliersTab;
                CreateModelsMainDlg.this.mVariablesTab.updatePeriodLabels();
                CriteriaARIMADlg criteriaARIMADlg = CreateModelsMainDlg.this.mVariablesTab.getARIMADialog();
                if (criteriaARIMADlg != null && (criteriaARIMAOutliersTab = criteriaARIMADlg.getOutliersTab()) != null) {
                    criteriaARIMAOutliersTab.setTableDataVector(null);
                    CreateModelsMainDlg.this.getDialogDataModel().putObject("IDS_DEFINITION_TABLE_VECTOR", null);
                }
                if (CreateModelsMainDlg.this.mOptionsTab != null) {
                    CreateModelsMainDlg.this.getDialogDataModel().putObject("IDS_TS_CREATE_MODEL_OPTION_TAB_TABLE_MODEL", null);
                    CreateModelsMainDlg.this.mOptionsTab.updateTableData();
                }
            }
        }
    }
}

