/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.auto_correlation;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.auto_correlation.AutoCorrelationDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class AutoCorrelationOptions
extends BaseSubDialog
implements KeyListener,
FocusListener {
    public static IntTextField mMaxIntTxtFld;
    public static JCheckBox mDisplayCheck;
    static final String INDEPENDENCE_MODEL_RADIO_KEY = "IDS_INDEPENDENCE_MODEL";
    static final String BARTLETTS_APPROXIMATION_RADIO_KEY = "IDS_BARTLETTS_APPROXIMATION";
    static final String DISPLAY_AUTOCORR_PERIODIC_LAGS_KEY = "IDS_DISPLAY_AUTOCORRELATIONS_AT_PERIODIC_LAGS";
    static String MAX_NUMBER_OF_LAGS_DEFAULT_VALUE;
    private JLabel mMaxNumLagsLabel;
    private JPanel mStdErrMethodPanel;
    private JPanel mDummyPanel;
    private JRadioButton mIndeMdlRadio;
    private JRadioButton mBartApproxRadio;
    private ButtonGroup mButtonGroup;
    private JComponent[] jComponentArr;
    private SpssButtonGroup mStdErrPanelGroup;
    private int mDateVarCount;
    private ITrendsInfo trendsInfo;

    public AutoCorrelationOptions(AutoCorrelationDlg autoCorrelationDlg) {
        super(autoCorrelationDlg, autoCorrelationDlg.getResString("IDS_AUTOCORRELATIONS_COLON_OPTIONS"), true);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(mMaxIntTxtFld)) {
            if (mMaxIntTxtFld.getText().equals("")) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
        }
    }

    @Override
    public boolean continuePressed() {
        if (mDisplayCheck.isSelected() && mDisplayCheck.isEnabled()) {
            if (Double.parseDouble(mMaxIntTxtFld.getText()) <= (double)this.trendsInfo.getPeriod()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_AUTOCORR_OPTIONS_WARNING_MESSAGE"), VersionInfo.getAppVersionString());
                mMaxIntTxtFld.requestFocus();
                return false;
            }
            return true;
        }
        if (Double.parseDouble(mMaxIntTxtFld.getText()) <= 0.0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), AutoCorrelationDlg.getValueOutOfRangeMessage(1, 999), VersionInfo.getAppVersionString());
            mMaxIntTxtFld.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_acfu_opts";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == mMaxIntTxtFld) {
            mMaxIntTxtFld.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupStdErrMthdPanel();
        this.mStdErrPanelGroup = DialogUtil.createButtonGroup(this.mStdErrMethodPanel);
        this.stdErrPanelEnableDisable();
        this.setupOptionsPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.seasonCheckEnableDisable();
        this.pack();
    }

    private void seasonCheckEnableDisable() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        this.trendsInfo = iSpssDataSrc.getTrendsInfo();
        this.mDateVarCount = this.trendsInfo.getNDateVars();
        if (this.mDateVarCount > 1) {
            mDisplayCheck.setEnabled(true);
        } else {
            mDisplayCheck.setEnabled(false);
        }
    }

    private void initVars() {
        this.mMaxNumLagsLabel = DialogUtil.createLabel(this, "IDS_MAXIMUM_NUMBER_OF_FLAGS_COLON");
        ControlAction controlAction = new TextFieldAction(this, "IDS_MAX");
        mMaxIntTxtFld = new IntTextField();
        this.mMaxNumLagsLabel.setLabelFor((Component)mMaxIntTxtFld);
        mMaxIntTxtFld.setAction((Action)controlAction);
        mMaxIntTxtFld.setDocument((Document)new FixedLengthNumericDocument(3, true, false));
        mMaxIntTxtFld.setText(MAX_NUMBER_OF_LAGS_DEFAULT_VALUE);
        mMaxIntTxtFld.addKeyListener((KeyListener)this);
        mMaxIntTxtFld.addFocusListener((FocusListener)this);
        this.mStdErrMethodPanel = new JPanel();
        this.mButtonGroup = new ButtonGroup();
        controlAction = new ToggleButtonAction(this, INDEPENDENCE_MODEL_RADIO_KEY);
        this.mIndeMdlRadio = new JRadioButton(controlAction);
        this.mIndeMdlRadio.setSelected(true);
        this.mButtonGroup.add(this.mIndeMdlRadio);
        controlAction = new ToggleButtonAction(this, BARTLETTS_APPROXIMATION_RADIO_KEY);
        this.mBartApproxRadio = new JRadioButton(controlAction);
        this.mButtonGroup.add(this.mBartApproxRadio);
        controlAction = new ToggleButtonAction(this, DISPLAY_AUTOCORR_PERIODIC_LAGS_KEY);
        mDisplayCheck = new JCheckBox(controlAction);
        mDisplayCheck.setSelected(false);
        mDisplayCheck.setEnabled(false);
        this.jComponentArr = new JComponent[2];
        this.jComponentArr[0] = this.mIndeMdlRadio;
        this.jComponentArr[1] = this.mBartApproxRadio;
        this.mStdErrPanelGroup = new SpssButtonGroup();
        this.mDummyPanel = new JPanel();
    }

    private JPanel setupOptionsPanel(JPanel jPanel) {
        this.mDummyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(this.mDummyPanel, this.mMaxNumLagsLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(this.mDummyPanel, (JComponent)mMaxIntTxtFld, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mDummyPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStdErrMethodPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, mDisplayCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return this.mDummyPanel;
    }

    private ISpssDataSrc getDataSource() {
        LocallyUniqueId locallyUniqueId = null;
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mDummyPanel.getComponent(1));
        vector.add(this.mStdErrPanelGroup);
        vector.add(mDisplayCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void stdErrPanelEnableDisable() {
        if (!AutoCorrelationDlg.mAutoCorrCheck.isSelected()) {
            this.setComponentEnableState(this.mStdErrMethodPanel, false);
        } else {
            this.setComponentEnableState(this.mStdErrMethodPanel, true);
        }
    }

    private void setupStdErrMthdPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mStdErrMethodPanel.setBorder(new TitledBorder(this.getResString("IDS_STANDARD_ERROR_METHOD")));
        this.mStdErrMethodPanel.setLayout(new GridBagLayout());
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mStdErrMethodPanel, this.mIndeMdlRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mStdErrMethodPanel, this.mBartApproxRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
    }

    static {
        MAX_NUMBER_OF_LAGS_DEFAULT_VALUE = "16";
    }
}

