/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.auto_correlation;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.auto_correlation.AutoCorrelationOptions;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class AutoCorrelationDlg
extends BaseProcedureDialog
implements ListDataListener,
KeyListener,
ItemListener,
FocusListener {
    public static JCheckBox mAutoCorrCheck;
    public static JCheckBox mParAutoCorrCheck;
    static final String NATURAL_LOG_TRANSFORM_KEY = "IDS_AUTOCORR_NATURAL_LOG_TRANSFORM";
    static final String DIFFERENCE_COLON_KEY = "IDS_AUTOCORR_DIFFERENCE_COLON";
    static final String SEASONALLY_DIFFERENCE_COLON_KEY = "IDS_AUTOCORR_SEASONALLY_DIFFERENCE_COLON";
    static final String AUTOCORRELATIONS_CHECK_KEY = "IDS_AUTOCORR_AUTOCORRELATIONS";
    static final String PARTIAL_AUTOCORRELATIONS_CHECK_KEY = "IDS_AUTOCORR_PARTIAL_AUTOCORRELATIONS";
    static final String IDS_OPTIONS_KEY = "IDS_AUTOCORR_OPTIONS_3DOT";
    static final String DEFAULT_DIFFERENCE_TXTFLD_VALUE = "1";
    static final String DEFAULT_SEASONALLY_DIFFERENCE_TXTFLD_VALUE = "1";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private JLabel mVarLabel;
    private JButton mOptionsButton;
    private JPanel mTransformPanel;
    private JPanel mDisplayPanel;
    private JCheckBox mNatLogTransCheck;
    private JCheckBox mDifferenceCheck;
    private JCheckBox mSeasonDiffCheck;
    private IntTextField mDiffIntTxtFld;
    private IntTextField mSeasonIntTxtFld;
    private JComponent[] mDisplayComponentArr;
    private int mDateVarCount;
    private JLabel mTransformCurLabel;
    private Vector<SPSSTextField> mtxtFldVector;
    private ITrendsInfo mTrendsInfo;

    public AutoCorrelationDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString(AUTOCORRELATIONS_CHECK_KEY));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.setDefaults();
        this.enableOkPaste(false);
    }

    @Override
    public String getIActionKey() {
        return "analyze_time_series_autocorrelatios";
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (mAutoCorrCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("ACF"));
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommand("PACF"));
        }
        String string2 = this.mTargetVarList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        stringBuffer.append(string2);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(NATURAL_LOG_TRANSFORM_KEY);
        stringBuffer.append("\n");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/LN"));
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/NOLOG"));
            stringBuffer.append("\n");
        }
        bl = dialogDataModel.getBoolean(DIFFERENCE_COLON_KEY);
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DIFF=")).append(this.mDiffIntTxtFld.getText());
            stringBuffer.append("\n");
        }
        if ((bl = dialogDataModel.getBoolean(SEASONALLY_DIFFERENCE_COLON_KEY)) != null && bl.booleanValue() && this.mSeasonDiffCheck.isEnabled()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/SDIFF=")).append(this.mSeasonIntTxtFld.getText());
            stringBuffer.append("\n");
        }
        if ((string = dialogDataModel.getString("IDS_MAX")) != null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/MXAUTO ")).append(string);
        }
        if (string == null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/MXAUTO ")).append(AutoCorrelationOptions.MAX_NUMBER_OF_LAGS_DEFAULT_VALUE);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_INDEPENDENCE_MODEL")) != null && bl.booleanValue() && mAutoCorrCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SERROR=IND"));
        }
        if (bl == null && mAutoCorrCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SERROR=IND"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_BARTLETTS_APPROXIMATION")) != null && bl.booleanValue() && mAutoCorrCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SERROR=MA"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_DISPLAY_AUTOCORRELATIONS_AT_PERIODIC_LAGS")) != null && bl.booleanValue() && this.mSeasonDiffCheck.isEnabled()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SEASONAL"));
        }
        if ((bl = dialogDataModel.getBoolean(PARTIAL_AUTOCORRELATIONS_CHECK_KEY)) != null && bl.booleanValue() && mAutoCorrCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PACF"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (bl != null && !bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (!mAutoCorrCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (this.mtxtFldVector.size() > 0) {
            if (this.mtxtFldVector.size() == 1) {
                IntTextField intTextField = (IntTextField)this.mtxtFldVector.get(0);
                if (Integer.parseInt(intTextField.getText()) > 0) {
                    return super.okPastePressed();
                }
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), AutoCorrelationDlg.getValueOutOfRangeMessage(1, 99), VersionInfo.getAppVersionString());
                intTextField.requestFocus();
                return false;
            }
            if (this.mtxtFldVector.size() == 2) {
                IntTextField intTextField = (IntTextField)this.mtxtFldVector.get(0);
                IntTextField intTextField2 = (IntTextField)this.mtxtFldVector.get(1);
                if (Integer.parseInt(intTextField.getText()) > 0 && Integer.parseInt(intTextField2.getText()) > 0) {
                    return super.okPastePressed();
                }
                if (Integer.parseInt(intTextField.getText()) <= 0) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), AutoCorrelationDlg.getValueOutOfRangeMessage(1, 99), VersionInfo.getAppVersionString());
                    intTextField.requestFocus();
                    return false;
                }
                if (Integer.parseInt(intTextField2.getText()) <= 0) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), AutoCorrelationDlg.getValueOutOfRangeMessage(1, 99), VersionInfo.getAppVersionString());
                    intTextField2.requestFocus();
                    return false;
                }
            }
        }
        return super.okPastePressed();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_acfu";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mDifferenceCheck)) {
            if (this.mDifferenceCheck.isSelected()) {
                this.mDiffIntTxtFld.setEnabled(true);
                this.mDiffIntTxtFld.setEditable(true);
            } else {
                this.mDiffIntTxtFld.setEnabled(false);
                this.mDiffIntTxtFld.setEditable(false);
            }
            this.enableDisableOkPaste();
        }
        if (itemEvent.getItem().equals(this.mSeasonDiffCheck)) {
            if (this.mSeasonDiffCheck.isSelected() && this.mSeasonDiffCheck.isEnabled()) {
                this.mSeasonIntTxtFld.setEnabled(true);
                this.mSeasonIntTxtFld.setEditable(true);
            } else {
                this.mSeasonIntTxtFld.setEnabled(false);
                this.mSeasonIntTxtFld.setEditable(false);
            }
            this.enableDisableOkPaste();
        }
        if (itemEvent.getSource().equals(mAutoCorrCheck) || itemEvent.getSource().equals(mParAutoCorrCheck)) {
            this.enableDisableOkPaste();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mDiffIntTxtFld) {
            this.mDiffIntTxtFld.selectAll();
        }
        if (focusEvent.getSource() == this.mSeasonIntTxtFld) {
            this.mSeasonIntTxtFld.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.createTransformPanel();
        this.mDisplayPanel = PanelFactory.getBasicPanel(this.mDisplayComponentArr, PanelFactory.PanelType.yaxis, this.getResString("IDS_AUTOCORR_DISPLAY"));
        this.setupSrcTargetLists(jPanel);
        this.setFocusTraversalPolicy();
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        this.mTrendsInfo = iSpssDataSrc.getTrendsInfo();
        this.seasonCheckEnableDisable();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_OPTIONS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoCorrelationDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMaxLimitOfList(100);
        Dimension dimension = this.mTargetScrollPane.getMinimumSize();
        dimension.height += 70;
        this.mTargetScrollPane.setPreferredSize(dimension);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mVarLabel = DialogUtil.createLabel(this, "IDS_AUTOCORR_VARIABLES_COLON");
        this.mVarLabel.setLabelFor(this.mTargetVarList);
        this.mTransformPanel = new JPanel();
        this.mDisplayPanel = new JPanel();
        ControlAction controlAction = new ToggleButtonAction(this, AUTOCORRELATIONS_CHECK_KEY);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        mAutoCorrCheck = new JCheckBox(controlAction);
        mAutoCorrCheck.addItemListener(this);
        spssButtonGroup.add(mAutoCorrCheck);
        controlAction = new ToggleButtonAction(this, PARTIAL_AUTOCORRELATIONS_CHECK_KEY);
        mParAutoCorrCheck = new JCheckBox(controlAction);
        mParAutoCorrCheck.addItemListener(this);
        spssButtonGroup.add(mParAutoCorrCheck);
        this.mDisplayComponentArr = new JComponent[2];
        this.mDisplayComponentArr[0] = mAutoCorrCheck;
        this.mDisplayComponentArr[1] = mParAutoCorrCheck;
        controlAction = new ToggleButtonAction(this, NATURAL_LOG_TRANSFORM_KEY);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        this.mNatLogTransCheck = new JCheckBox(controlAction);
        spssButtonGroup2.add(this.mNatLogTransCheck);
        controlAction = new ToggleButtonAction(this, DIFFERENCE_COLON_KEY);
        this.mDifferenceCheck = new JCheckBox(controlAction);
        this.mDifferenceCheck.addItemListener(this);
        spssButtonGroup2.add(this.mDifferenceCheck);
        controlAction = new ToggleButtonAction(this, SEASONALLY_DIFFERENCE_COLON_KEY);
        this.mSeasonDiffCheck = new JCheckBox(controlAction);
        spssButtonGroup2.add(this.mSeasonDiffCheck);
        this.mSeasonDiffCheck.addItemListener(this);
        controlAction = new TextFieldAction(this, "IDS_DIFFERENCE_TXT_FLD");
        this.mDiffIntTxtFld = new IntTextField();
        this.mDiffIntTxtFld.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        this.mDiffIntTxtFld.setAction((Action)controlAction);
        this.mDiffIntTxtFld.addKeyListener((KeyListener)this);
        this.mDiffIntTxtFld.addFocusListener((FocusListener)this);
        controlAction = new TextFieldAction(this, "IDS_SEASONALLY_DIFFERENCE_TXT_FLD");
        this.mSeasonIntTxtFld = new IntTextField();
        this.mSeasonIntTxtFld.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        this.mSeasonIntTxtFld.setAction((Action)controlAction);
        this.mSeasonIntTxtFld.addKeyListener((KeyListener)this);
        this.mSeasonIntTxtFld.addFocusListener((FocusListener)this);
        this.mTransformCurLabel = new JLabel(this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_COLON_NONE"));
        this.mtxtFldVector = new Vector();
    }

    private ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private void seasonCheckEnableDisable() {
        this.mDateVarCount = this.mTrendsInfo.getNDateVars();
        if (this.mDateVarCount > 1) {
            this.mSeasonDiffCheck.setEnabled(true);
            if (this.mSeasonDiffCheck.isSelected() && this.mSeasonDiffCheck.isEnabled()) {
                this.mSeasonIntTxtFld.setEnabled(true);
                this.mSeasonIntTxtFld.setEditable(true);
                this.enableDisableOkPaste();
            } else {
                this.mSeasonIntTxtFld.setEditable(false);
                this.mSeasonIntTxtFld.setEnabled(false);
                this.enableDisableOkPaste();
            }
            this.mTransformCurLabel.setText(this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_COLON") + this.mTrendsInfo.getPeriod());
        } else {
            this.mSeasonDiffCheck.setEnabled(false);
            this.mSeasonIntTxtFld.setEditable(false);
            this.mSeasonIntTxtFld.setEnabled(false);
            this.mTransformCurLabel.setText(this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_COLON_NONE"));
            this.enableDisableOkPaste();
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(mAutoCorrCheck);
        vector.add(mParAutoCorrCheck);
        vector.add(this.mNatLogTransCheck);
        vector.add(this.mDifferenceCheck);
        vector.add(this.mDiffIntTxtFld);
        vector.add(this.mSeasonDiffCheck);
        vector.add(this.mSeasonIntTxtFld);
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableDisableOkPaste() {
        if ((mAutoCorrCheck.isSelected() || mParAutoCorrCheck.isSelected()) && this.mTargetVarList.getModel().getSize() > 0) {
            if (this.mtxtFldVector.size() > 0) {
                this.mtxtFldVector.removeAllElements();
            }
            if (this.mDifferenceCheck.isSelected()) {
                this.mtxtFldVector.add((SPSSTextField)this.mDiffIntTxtFld);
            }
            if (this.mSeasonDiffCheck.isSelected() && this.mSeasonDiffCheck.isEnabled()) {
                this.mtxtFldVector.add((SPSSTextField)this.mSeasonIntTxtFld);
            }
            if (this.mtxtFldVector.size() > 0) {
                for (SPSSTextField sPSSTextField : this.mtxtFldVector) {
                    if (sPSSTextField.getText().trim().length() > 0) continue;
                    this.enableOkPaste(false);
                    return;
                }
                this.enableOkPaste(true);
                return;
            }
            this.enableOkPaste(true);
            return;
        }
        this.enableOkPaste(false);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        mAutoCorrCheck.setSelected(true);
        mParAutoCorrCheck.setSelected(true);
        this.mNatLogTransCheck.setSelected(false);
        this.mDifferenceCheck.setSelected(false);
        this.mDiffIntTxtFld.setEditable(false);
        this.mDiffIntTxtFld.setEnabled(false);
        this.mDiffIntTxtFld.setText("1");
        this.mSeasonIntTxtFld.setEditable(false);
        this.mSeasonIntTxtFld.setEnabled(false);
        this.mSeasonIntTxtFld.setText("1");
        this.mSrcVarList.requestFocus();
        this.enableOkPaste(false);
        if (this.mDateVarCount > 1) {
            this.mSeasonDiffCheck.setSelected(false);
            this.mSeasonDiffCheck.setEnabled(true);
        } else {
            this.mSeasonDiffCheck.setSelected(false);
            this.mSeasonDiffCheck.setEnabled(false);
        }
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new AutoCorrelationOptions(this));
    }

    private void createTransformPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mTransformPanel.setLayout(new GridBagLayout());
        this.mTransformPanel.setBorder(new TitledBorder(this.getResString("IDS_TIME_SERIES_TRANSFORM")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = 23;
        Insets insets = new Insets(0, n, n, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.mTransformPanel, this.mNatLogTransCheck, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(this.mTransformPanel, this.mDifferenceCheck, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(this.mTransformPanel, this.mSeasonDiffCheck, gridBagConstraints, 0, 2, 1, 1, n3, insets);
        insets.set(0, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mTransformPanel, (JComponent)this.mDiffIntTxtFld, gridBagConstraints, 1, 1, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(this.mTransformPanel, (JComponent)this.mSeasonIntTxtFld, gridBagConstraints, 1, 2, 1, 1, n3, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n, n2, 0);
        DialogUtil.addUsingGBL(this.mTransformPanel, this.mTransformCurLabel, gridBagConstraints, 0, 3, 1, 1, n3, insets);
    }

    private void setupSrcTargetLists(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, 0, 0, insets.right * 2);
        DialogUtil.addUsingGBL(jPanel2, this.mTargetScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        Insets insets3 = new Insets(n, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mTransformPanel, gridBagConstraints, 0, 2, 2, 1, n2, insets3);
        gridBagConstraints.fill = 1;
        insets3.set(0, 0, n, 0);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_AUTOCORR_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel3, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 0, 1, 2, n2, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 10;
        insets3.set(insets.top, insets.left, insets.bottom * 5 - DialogUtil.getGroupBoxInnerMargin() * 2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n2, insets3);
        n2 = 21;
        gridBagConstraints.fill = 2;
        insets3.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel2, this.mVarLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 0, 1, 3, n2, null);
        insets3.set(0, 0, 0, 5 * n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayPanel, gridBagConstraints, 0, 2, 2, 1, n2, insets3);
    }

    public static String getValueOutOfRangeMessage(int n, int n2) {
        return MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), n, n2);
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new DataObserver();
    }

    public class DataObserver
    extends BaseProcedureDialog.DataViewObserverAdapter {
        public DataObserver() {
            super(AutoCorrelationDlg.this);
        }

        @Override
        public void notifyTrendsInfo() {
            AutoCorrelationDlg.this.seasonCheckEnableDisable();
            AutoCorrelationDlg.this.mSrcVarList.requestFocus();
            AutoCorrelationDlg.this.mSrcVarList.setSelectedIndex(0);
        }
    }
}

