/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models.ApplyModelsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class OptionsTab
extends BaseProcedureTab {
    static final String MIN_WIDTH_KEY = "IDS_TS_APPLY_MODEL_OPTION_MIN_WIDTH";
    public static final int ACF_PACF_MIN_VALUE = 1;
    public static final int ACF_PACF_MAX_VALUE = 999;
    public static final double FLOAT_FIELD_MIN_VALUE = 0.0;
    public static final double FLOAT_FIELD_MAX_VALUE = 100.0;
    private JRadioButton mInvalidRadio;
    private JRadioButton mValidRadio;
    private SpssButtonGroup mUserMissingButtonGrp;
    private JLabel mCIWidthLabel;
    private FloatTextField mCIWidthEdit;
    private JLabel mMaxLagsLabel;
    private IntTextField mMaxLagsEdit;

    public OptionsTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_options";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    protected void generateAuxiliarySyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        String string = "\n   /AUXILIARY ";
        String string2 = dialogDataModel.getString(MIN_WIDTH_KEY).trim();
        String string3 = dialogDataModel.getString("IDS_TS_APPLY_MODEL_MAX_LAG_EDIT").trim();
        Double d = Double.parseDouble(string2);
        Integer n = Integer.parseInt(string3);
        String string4 = string2;
        int n2 = string4.indexOf(".");
        if (n2 != -1) {
            String string5 = string4.substring(n2);
            if (string5.length() > 4) {
                string4 = String.format("%g", d);
            } else if (string5.length() == 2 && string5.equals(".0")) {
                string4 = String.format("%d", Math.round(d));
            }
        } else {
            string4 = string4.indexOf(69) != -1 || string4.indexOf(101) != -1 ? String.format("%g", d) : String.format("%d", Math.round(d));
        }
        string = string + " CILEVEL=" + string4;
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_APPLY_MODELS_MODELS_TAB_REESTIMATE_RADIO");
        string = bl != null && bl != false ? string + String.format(" MAXACFLAGS=%d REESTIMATE=YES", n) : string + " REESTIMATE=NO";
        stringBuffer.append(string);
    }

    protected void generateMissingSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        String string = "\n   /MISSING USERMISSING=";
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_USER_MISSING_INVALID_RADIO_BUTTON");
        string = bl == null || bl != false ? string + "EXCLUDE" : string + "INCLUDE";
        stringBuffer.append(string);
    }

    private void initVars() {
        this.mInvalidRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_USER_MISSING_INVALID_RADIO_BUTTON"));
        this.mValidRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_USER_MISSING_VALID_DATE_RADIO_BUTTON"));
        this.mUserMissingButtonGrp = new SpssButtonGroup();
        this.mUserMissingButtonGrp.add(this.mInvalidRadio);
        this.mUserMissingButtonGrp.add(this.mValidRadio);
        this.mCIWidthEdit = new FloatTextField(0.0, 100.0, 4);
        this.mCIWidthEdit.setIncludeMinRange(false);
        this.mCIWidthEdit.setIncludeMaxRange(false);
        this.mCIWidthEdit.setAction((Action)new TextFieldAction(this.mParent, MIN_WIDTH_KEY));
        this.mCIWidthEdit.setColumns(4);
        this.mCIWidthLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_CI_WIDTH_LABEL");
        this.mCIWidthLabel.setLabelFor((Component)this.mCIWidthEdit);
        this.mMaxLagsEdit = new IntTextField(1, 999, true);
        this.mMaxLagsEdit.setColumns(10);
        this.mMaxLagsEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_TS_APPLY_MODEL_MAX_LAG_EDIT"));
        this.mMaxLagsLabel = DialogUtil.createMultiLineLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_MAX_LAGS_LABEL", 180);
        this.mMaxLagsLabel.setLabelFor((Component)this.mMaxLagsEdit);
    }

    private void setDefaults() {
        this.mInvalidRadio.setSelected(true);
        this.mValidRadio.setSelected(false);
        this.mCIWidthEdit.setText("95");
        this.mMaxLagsEdit.setText("24");
    }

    private void setupPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        int n = 23;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_USER_MISSING_GROUP_BOX")));
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mInvalidRadio, gridBagConstraints2, 0, 1, 1, 1, n, insets);
        gridBagConstraints2.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mValidRadio, gridBagConstraints2, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, this.mCIWidthLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mCIWidthEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets3 = new Insets(DialogUtil.getComponentGroupGap(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel2, this.mMaxLagsLabel, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        insets3.top = DialogUtil.getComponentGroupGap() * 2;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMaxLagsEdit, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        jPanel.setPreferredSize(new Dimension(200, 80));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top += 10;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
    }

    @Override
    protected boolean validateTab() {
        boolean bl = super.validateTab();
        if (bl) {
            if (this.mCIWidthEdit.getText().trim().length() == 0) {
                String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MSG_INCLUDE_NONE"), 0.0, 100.0);
                SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsTab.this.mCIWidthEdit.requestFocus();
                    }
                });
                return false;
            }
            if (!this.mCIWidthEdit.checkRange()) {
                return false;
            }
            if (this.mMaxLagsEdit.getText().trim().length() == 0) {
                String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 999);
                SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsTab.this.mMaxLagsEdit.requestFocus();
                    }
                });
                return false;
            }
            if (!this.mMaxLagsEdit.checkRange()) {
                return false;
            }
        }
        return bl;
    }

    @Override
    protected void aboutToShowTab() {
        boolean bl = ((ApplyModelsDlg)this.mParent).getModelsTab().isLoadFromFile();
        this.mMaxLagsLabel.setForeground(bl ? Color.gray : Color.black);
        this.mMaxLagsEdit.setEnabled(!bl);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mUserMissingButtonGrp);
        this.mComponentOrder.add(this.mCIWidthEdit);
        this.mComponentOrder.add(this.mMaxLagsEdit);
    }
}

