/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.DateFactory;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models.ApplyModelsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

public class ModelsTab
extends BaseProcedureTab {
    public static final String MODEL_TAB_DATE_FIELDS = "modeltabFields";
    public static final String MODEL_TAB_DATE__LABELS = "modeltabLabels";
    static final String MIN_WIDTH_KEY = "IDS_MIN_WIDTH";
    public final int XML_FILE_TEXT_FIELD_SIZE = 25;
    public static final String XML_FILE_PATH = "IDS_TS_APPLY_MODEL_MODEL_TAB_SAVE_XML_FILE_PATH";
    private JLabel mFileLabel;
    private FileTextField mFilePathField;
    private JButton mBrowseButton;
    private JRadioButton mFirstToLastRadio;
    private JRadioButton mFirstToDateRadio;
    private SpssButtonGroup mForecastButtonGrp;
    private JLabel mStartLabel;
    private JLabel mStartCaseLabel;
    private JLabel mEndLabel;
    private JLabel mEndCaseLabel;
    private JRadioButton mLoadFromFileRadio;
    private JRadioButton mReestimateFromDataRadio;
    private SpssButtonGroup mParamsButtonGrp;
    private JLabel mForecastLabel;
    private PlainTable mForecastPeriodTable;
    private JScrollPane mForecastPeriodScrollPane;
    private boolean mDialogIsInitializing;
    private DateFactory.DatePanel mDatesPanel;
    private boolean mIsSetValueInvalid;

    public ModelsTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_apply_models";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void aboutToShowTab() {
        Vector vector;
        DialogDataModel dialogDataModel = ((ApplyModelsDlg)this.mParent).getModel();
        if (dialogDataModel != null && (vector = (Vector)dialogDataModel.getObject("IDS_TS_APPLY_MODEL_FORECAST_TABLE_MODEL")) != null) {
            if (!DateFactory.hasDateFormatChanged(dialogDataModel, MODEL_TAB_DATE__LABELS, ((ApplyModelsDlg)this.mParent).getSrcList())) {
                Pair<ITrendsInfo.DateVarTypes, String>[] pairArray = ((ApplyModelsDlg)this.mParent).getDateVars();
                Vector<Object> vector2 = new Vector<Object>(pairArray.length);
                for (int i = 0; i < pairArray.length; ++i) {
                    vector2.add(i, pairArray[i].getSecond());
                }
                ((DefaultTableModel)this.mForecastPeriodTable.getModel()).setDataVector(vector, vector2);
            } else {
                this.mFirstToLastRadio.setSelected(true);
            }
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.mDialogIsInitializing = true;
    }

    protected String getForecastEndSyntax() {
        String string = "";
        if (this.mFirstToDateRadio.isSelected()) {
            ITrendsInfo iTrendsInfo = ((ApplyModelsDlg)this.mParent).getTrendsInfo();
            if (iTrendsInfo.getNDateVars() == 0) {
                string = string + this.mForecastPeriodTable.getModel().getValueAt(0, 0);
            } else {
                Pair<ITrendsInfo.DateVarTypes, String>[] pairArray = ((ApplyModelsDlg)this.mParent).getDateVars();
                Hashtable<ITrendsInfo.DateVarTypes, String> hashtable = ((ApplyModelsDlg)this.mParent).getDateSyntaxList();
                for (int i = 0; i < this.mForecastPeriodTable.getColumnCount(); ++i) {
                    String string2;
                    Object object = this.mForecastPeriodTable.getModel().getValueAt(0, i);
                    if (object == null || (string2 = object.toString()).trim().length() <= 0) continue;
                    if (i > 0) {
                        string = string + " ";
                    }
                    string = string + hashtable.get(pairArray[i].getFirst());
                    string = string + " ";
                    string = string + string2;
                }
            }
        } else {
            string = "END";
        }
        string = string.toUpperCase();
        return string;
    }

    protected void generateSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append("\n   /MODEL FILE=");
        stringBuffer.append(CharacterUtil.smartQuote((String)dialogDataModel.getString(XML_FILE_PATH)));
        Boolean bl = dialogDataModel.getBoolean("IDS_TIME_SERIES_APPLY_MODELS_MODELS_TAB_REESTIMATE_RADIO");
        String string = dialogDataModel.getSafeString("EXPORT_XML_FILE_PATH");
        String string2 = dialogDataModel.getSafeString("EXPORT_PMMML_FILE_PATH");
        if (bl != null && bl.booleanValue()) {
            if (string.length() != 0) {
                stringBuffer.append("\n      OUTFILE=").append(CharacterUtil.smartQuote((String)string));
            }
            if (string2.length() != 0) {
                stringBuffer.append("\n      OUTPMML=").append(CharacterUtil.smartQuote((String)string2));
            }
        }
    }

    private void setDefaults() {
        this.mFilePathField.setText("");
        this.mLoadFromFileRadio.setSelected(true);
        this.mReestimateFromDataRadio.setSelected(false);
        this.mStartLabel.setEnabled(false);
        this.mStartCaseLabel.setEnabled(false);
        this.mEndLabel.setEnabled(false);
        this.mEndCaseLabel.setEnabled(false);
        this.mFirstToLastRadio.setSelected(true);
        this.mFirstToDateRadio.setSelected(false);
        for (int i = 0; i < this.mForecastPeriodTable.getModel().getColumnCount(); ++i) {
            this.mForecastPeriodTable.getModel().setValueAt("", 0, i);
        }
        this.mForecastPeriodTable.changeSelection(0, 0, false, false);
    }

    private void initVars() {
        this.mDatesPanel = DateFactory.getPanel(((ApplyModelsDlg)this.mParent).getSrcList());
        this.mFilePathField = new FileTextField();
        this.mFilePathField.setColumns(25);
        this.mFilePathField.setAction(new TextFieldAction(this.mParent, XML_FILE_PATH));
        this.mFileLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_APPLY_MODELS_MODELS_FILE_LABEL");
        this.mFileLabel.setLabelFor((Component)((Object)this.mFilePathField));
        this.mBrowseButton = DialogUtil.createButton(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_SAVE_EXPORT_BROWSE_BUTTON", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelsTab.this.openFileDialog();
            }
        });
        RadioButtonListener radioButtonListener = new RadioButtonListener();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_APPLY_MODELS_MODELS_TAB_LOAD_FROM_FILE_RADIO");
        this.mLoadFromFileRadio = new JRadioButton(toggleButtonAction);
        this.mLoadFromFileRadio.addItemListener(radioButtonListener);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_APPLY_MODELS_MODELS_TAB_REESTIMATE_RADIO");
        this.mReestimateFromDataRadio = new JRadioButton(toggleButtonAction);
        this.mReestimateFromDataRadio.addItemListener(radioButtonListener);
        this.mParamsButtonGrp = new SpssButtonGroup();
        this.mParamsButtonGrp.add(this.mLoadFromFileRadio);
        this.mParamsButtonGrp.add(this.mReestimateFromDataRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_FORECAST_THROUGH_LAST_CASE_RADIO_BUTTON");
        this.mFirstToLastRadio = new JRadioButton(toggleButtonAction);
        this.mFirstToLastRadio.addItemListener(radioButtonListener);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OPTIONS_FORECAST_THROUGH_SPECIFIED_DATE_RADIO_BUTTON");
        this.mFirstToDateRadio = new JRadioButton(toggleButtonAction);
        this.mFirstToDateRadio.addItemListener(radioButtonListener);
        this.mForecastButtonGrp = new SpssButtonGroup();
        this.mForecastButtonGrp.add(this.mFirstToLastRadio);
        this.mForecastButtonGrp.add(this.mFirstToDateRadio);
        this.mStartLabel = new JLabel(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_START_DEFAULT_LABEL"));
        this.mStartCaseLabel = new JLabel(this.getResString("IDS_TIME_SERIES_START_LABEL"));
        this.mEndLabel = new JLabel(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_ESTIMATION_END_DEFAULT_LABEL"));
        this.mEndCaseLabel = new JLabel(this.getResString("IDS_TIME_SERIES_END_LABEL"));
        Pair<ITrendsInfo.DateVarTypes, String>[] pairArray = ((ApplyModelsDlg)this.mParent).getDateVars();
        Object[][] objectArray = new String[1][pairArray.length];
        Object[] objectArray2 = new String[pairArray.length];
        for (int i = 0; i < pairArray.length; ++i) {
            objectArray2[i] = (String)pairArray[i].getSecond();
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2);
        this.mForecastPeriodTable = new PlainTable(defaultTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                return bl;
            }
        };
        this.mForecastPeriodTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mForecastPeriodTable.setRowSelectionAllowed(false);
        this.mForecastPeriodTable.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.mForecastPeriodTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new HeaderRenderer());
        this.mForecastPeriodTable.setDefaultRenderer(Object.class, new DateCellRenderer());
        this.mForecastPeriodScrollPane = new JScrollPane(this.mForecastPeriodTable, 21, 31);
        Dimension dimension = this.mForecastPeriodScrollPane.getSize();
        dimension.height = 50;
        this.mForecastPeriodScrollPane.setPreferredSize(dimension);
        this.mForecastLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_FORECAST_DATE_LABEL");
        this.mForecastLabel.setLabelFor(this.mForecastPeriodTable);
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets3 = new Insets(insets.top, 30, insets.bottom, insets.right);
        int n = DialogUtil.getComponentGroupGap();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_APPLY_MODELS_MODELS_TAB_PARAMS_GROUP_BOX")));
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_ESTIMATION_GROUP_BOX")));
        JPanel jPanel4 = new JPanel(new GridBagLayout(), true);
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_FORECAST_GROUP_BOX")));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFileLabel, gridBagConstraints, 0, 1, 1, 1, n2, new Insets(3, 2, 0, 0));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePathField), gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(-3, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left += 10;
        DialogUtil.addUsingGBL(jPanel3, this.mStartCaseLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mStartLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mEndCaseLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mEndLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mLoadFromFileRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mReestimateFromDataRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        insets3.set(insets.top, 30, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 2, 1, 1, n2, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel4, this.mFirstToLastRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mFirstToDateRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets3.set(insets.top, 30, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel4, this.mForecastLabel, gridBagConstraints, 0, 2, 0, 1, n2, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets3.set(insets.top, 30, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel4, this.mForecastPeriodScrollPane, gridBagConstraints, 0, 3, 1, 1, n2, insets3);
        Dimension dimension = jPanel4.getPreferredSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + 30.0);
        jPanel4.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets4 = new Insets(insets2.top + 2, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets4);
        insets4.set(n, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets4.set(n, insets2.left, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(this, jPanel4, gridBagConstraints, 0, 2, 1, 1, n2, insets4);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mFilePathField);
        this.mComponentOrder.add(this.mBrowseButton);
        this.mComponentOrder.add(this.mParamsButtonGrp);
        this.mComponentOrder.add(this.mForecastButtonGrp);
        this.mComponentOrder.add(this.mForecastPeriodTable);
    }

    @Override
    protected boolean validateTab() {
        int n;
        if (this.mDialogIsInitializing) {
            this.mDialogIsInitializing = false;
            return true;
        }
        if (this.mForecastPeriodTable.isEditing()) {
            this.mForecastPeriodTable.getCellEditor().stopCellEditing();
        }
        boolean bl = super.validateTab();
        if (this.mFilePathField.getText().trim().length() > 0 && (n = FileValidator.evaluateOpenFile((Component)this.mParent, this.mFilePathField.getText(), false, true)) == 5) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, String.format(this.mParent.getResString("ERR_TIME_SERIES_APPLY_MODELS_MODELS_TAB_BAD_FILE_ERROR"), this.mFilePathField.getText()), VersionInfo.getAppVersionString());
            this.mFilePathField.requestFocus();
            this.mFilePathField.selectAll();
            return false;
        }
        if (bl && this.mFirstToDateRadio.isSelected()) {
            this.validateTable();
            if (this.mIsSetValueInvalid) {
                this.mIsSetValueInvalid = false;
                return false;
            }
        }
        if (bl && this.mFirstToDateRadio.isSelected()) {
            int n2;
            Object object;
            n = -1;
            if (this.mForecastPeriodTable.getColumnCount() == 1) {
                object = this.mForecastPeriodTable.getModel().getValueAt(0, 0);
                if (object == null || object.toString().trim().length() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_ENTER_A_VALUE_MSG"), VersionInfo.getAppVersionString());
                    n = 0;
                }
            } else {
                ITrendsInfo iTrendsInfo;
                int n3;
                object = this.mForecastPeriodTable.getModel().getValueAt(0, 0);
                if (object == null || object.toString().trim().length() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_ENTER_A_VALUE_MSG"), VersionInfo.getAppVersionString());
                    n = 0;
                } else {
                    for (n2 = 0; n2 < this.mForecastPeriodTable.getColumnCount() - 1; ++n2) {
                        object = this.mForecastPeriodTable.getModel().getValueAt(0, n2);
                        Object object2 = this.mForecastPeriodTable.getModel().getValueAt(0, n2 + 1);
                        if ((object != null || object2 == null) && (object == null || object.toString().trim().length() != 0 || object2.toString().trim().length() == 0)) continue;
                        SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_ENTER_A_VALUE_MSG"), VersionInfo.getAppVersionString());
                        n = n2;
                        break;
                    }
                }
                if (n == -1 && (n3 = (iTrendsInfo = ((ApplyModelsDlg)this.mParent).getTrendsInfo()).getNDateVars()) == 3 && iTrendsInfo.getDateVarType(1).value() == 3 && iTrendsInfo.getDateVarType(2).value() == 4) {
                    object = this.mForecastPeriodTable.getModel().getValueAt(0, 1);
                    Object object3 = this.mForecastPeriodTable.getModel().getValueAt(0, 2);
                    if (object != null && object3 != null && object.toString().trim().length() != 0 && object3.toString().trim().length() != 0) {
                        int n4 = Integer.parseInt(object.toString());
                        int n5 = Integer.parseInt(object3.toString());
                        if (n5 < n4 * 3 - 2 || n5 > n4 * 3) {
                            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_OPTIONS_MONTHS_QUARTER_MUST_BE_CONSISTENT_MSG"), VersionInfo.getAppVersionString());
                            n = 2;
                        }
                    }
                }
            }
            if (n > -1) {
                this.mForecastPeriodTable.requestFocus();
                object = this.mForecastPeriodTable;
                n2 = n;
                SwingUtilities.invokeLater(new Runnable((JTable)object, n2){
                    final /* synthetic */ JTable val$tab;
                    final /* synthetic */ int val$c;
                    {
                        this.val$tab = jTable;
                        this.val$c = n;
                    }

                    @Override
                    public void run() {
                        this.val$tab.requestFocus();
                        this.val$tab.changeSelection(0, this.val$c, false, false);
                    }
                });
                return false;
            }
        }
        if (this.mForecastPeriodTable.getModel() != null) {
            Vector<Vector> vector = ((DefaultTableModel)this.mForecastPeriodTable.getModel()).getDataVector();
            ((ApplyModelsDlg)this.mParent).getModel().putObject("IDS_TS_APPLY_MODEL_FORECAST_TABLE_MODEL", vector);
            this.mDatesPanel.saveState(((ApplyModelsDlg)this.mParent).getModel(), MODEL_TAB_DATE_FIELDS, MODEL_TAB_DATE__LABELS, ((ApplyModelsDlg)this.mParent).getSrcList());
        }
        return bl;
    }

    private void openFileDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OPEN_FILE_DIALOG_TITLE"));
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_SAVE_SAVE_FILE_DIALOG_FILTER"), this.getResString("IDS_TIME_SERIES_CREATE_MODELS_SAVE_SAVE_FILE_DIALOG_EXTENSION"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter, true);
        int n = remoteFileChooser.showOpenDialog((Component)this.mParent);
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            this.mFilePathField.setText(remoteFileChooser.getSelectedFilePath());
        }
    }

    private String appendXMLExt(String string) {
        try {
            int n = string.lastIndexOf(".");
            String string2 = "";
            if (n > 0) {
                string2 = string.substring(n, string.length());
            }
            if (string2.length() > 0 && !string2.equalsIgnoreCase("xml") || n == -1) {
                if (n > 0) {
                    string = string.substring(0, n);
                }
                string = string + ".xml";
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    protected String getSaveFile() {
        return CharacterUtil.smartQuote((String)this.mFilePathField.getText());
    }

    protected void setForecastEndValue(String string) {
        if (string.length() > 0) {
            if (ComponentState.isBtdRtlOrLtr()) {
                this.mEndLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                this.mEndLabel.setText(string);
            }
        } else {
            this.mEndLabel.setText(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_VARS_FORECAST_END_DEFAULT_LABEL"));
        }
    }

    protected FileTextField getFilePath() {
        return this.mFilePathField;
    }

    public boolean isLoadFromFile() {
        return this.mLoadFromFileRadio.isSelected();
    }

    protected boolean isReestimate() {
        return this.mReestimateFromDataRadio.isSelected();
    }

    private void validateTable() {
        ITrendsInfo iTrendsInfo = ((ApplyModelsDlg)this.mParent).getTrendsInfo();
        block2: for (int i = 0; i < this.mForecastPeriodTable.getRowCount(); ++i) {
            for (int j = 0; j < this.mForecastPeriodTable.getColumnCount(); ++j) {
                Object object;
                boolean bl;
                block11: {
                    Object object2 = this.mForecastPeriodTable.getValueAt(i, j);
                    if (!(object2 instanceof String)) continue;
                    bl = false;
                    String string = object2.toString();
                    if (string.trim().length() <= 0) continue;
                    try {
                        Integer n = new Integer(object2.toString());
                        if (iTrendsInfo.getNDateVars() > 0) {
                            Integer n2 = ((ApplyModelsDlg)this.mParent).getPeriodMinVal(iTrendsInfo.getDateVarType(j));
                            Integer n3 = iTrendsInfo.getDateVarPeriodicity(j);
                            if (n3 > 0) {
                                if (!(n2 != 0 ? n < n2 : n < n2 || n >= n3)) {
                                    if (n2 != 1 || n3 == 1 || n >= n2 && n <= n3) break block11;
                                }
                                object = String.format(this.getResString("ERR_TIME_SERIES_ENTER_VALUE_BETEWEEN_TWO_VALUES_WARNING"), n2, n2 == 0 ? n3 - 1 : n3);
                                SpssAlertOptionPane.showWarningMessageDialog(this, (String)object, VersionInfo.getAppVersionString());
                                this.mForecastPeriodTable.changeSelection(i, j, false, false);
                                bl = true;
                                break block11;
                            }
                            if (n < 1 || n > 9999) {
                                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_ENTER_VALUE_BETEWEEN_1_AND_9999_WARNING"), VersionInfo.getAppVersionString());
                                this.mForecastPeriodTable.changeSelection(i, j, false, false);
                                bl = true;
                            }
                            break block11;
                        }
                        if (n < 0 || n > Integer.MAX_VALUE) {
                            this.mForecastPeriodTable.setValueAt(n.toString(), i, j);
                            this.mForecastPeriodTable.changeSelection(i, j, false, false);
                            bl = true;
                        } else {
                            this.mForecastPeriodTable.setValueAt(n.toString(), i, j);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.mIsSetValueInvalid = bl;
                if (!bl) continue;
                object = this.mForecastPeriodTable;
                int n = i;
                int n4 = j;
                SwingUtilities.invokeLater(new Runnable((JTable)object, n, n4){
                    final /* synthetic */ JTable val$tab;
                    final /* synthetic */ int val$ro;
                    final /* synthetic */ int val$c;
                    {
                        this.val$tab = jTable;
                        this.val$ro = n;
                        this.val$c = n2;
                    }

                    @Override
                    public void run() {
                        this.val$tab.requestFocus();
                        this.val$tab.changeSelection(this.val$ro, this.val$c, false, false);
                    }
                });
                continue block2;
            }
        }
    }

    class DateCellRenderer
    extends DefaultTableCellRenderer {
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        DateCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (ModelsTab.this.mFirstToLastRadio.isSelected()) {
                component.setForeground(Color.gray);
            } else {
                component.setForeground(Color.black);
            }
            if (component.hasFocus() && component instanceof JLabel) {
                ((JLabel)component).setBorder(this.mHighLightBorder);
            }
            if (bl) {
                if (component.hasFocus()) {
                    component.setBackground(jTable.getSelectionBackground());
                }
            } else {
                component.setBackground(jTable.getBackground());
            }
            if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(4);
            }
            return component;
        }
    }

    class HeaderRenderer
    extends DefaultTableCellRenderer {
        HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (ModelsTab.this.mFirstToLastRadio.isSelected()) {
                component.setForeground(Color.gray);
            } else {
                component.setForeground(Color.black);
            }
            component.setBackground(jTable.getTableHeader().getBackground());
            ((JLabel)component).setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            ((JLabel)component).setHorizontalAlignment(0);
            return component;
        }
    }

    class RadioButtonListener
    implements ItemListener {
        RadioButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object instanceof JRadioButton) {
                boolean bl = ((JRadioButton)object).isSelected();
                if (object == ModelsTab.this.mFirstToLastRadio) {
                    ModelsTab.this.mForecastPeriodTable.setEnabled(!bl);
                    ModelsTab.this.mForecastPeriodTable.setOpaque(!bl);
                } else if (object == ModelsTab.this.mFirstToDateRadio) {
                    ModelsTab.this.mForecastPeriodTable.setEnabled(bl);
                    ModelsTab.this.mForecastPeriodTable.setOpaque(bl);
                } else if (object == ModelsTab.this.mLoadFromFileRadio) {
                    if (((ApplyModelsDlg)ModelsTab.this.mParent).getPlotsTab() != null) {
                        ((ApplyModelsDlg)ModelsTab.this.mParent).getPlotsTab().setComponentEnableState(ModelsTab.this.mLoadFromFileRadio.isSelected());
                    }
                    if (((ApplyModelsDlg)ModelsTab.this.mParent).getSaveTab() != null) {
                        ((ApplyModelsDlg)ModelsTab.this.mParent).getStatisticsTab().setComponentsEnableState(ModelsTab.this.mLoadFromFileRadio.isSelected());
                    }
                    if (((ApplyModelsDlg)ModelsTab.this.mParent).getSaveTab() != null) {
                        ((ApplyModelsDlg)ModelsTab.this.mParent).getSaveTab().setComponentsEnableState(ModelsTab.this.mLoadFromFileRadio.isSelected());
                    }
                    ModelsTab.this.mStartLabel.setEnabled(!bl);
                    ModelsTab.this.mStartCaseLabel.setEnabled(!bl);
                    ModelsTab.this.mEndLabel.setEnabled(!bl);
                    ModelsTab.this.mEndCaseLabel.setEnabled(!bl);
                } else if (object == ModelsTab.this.mReestimateFromDataRadio) {
                    if (((ApplyModelsDlg)ModelsTab.this.mParent).getPlotsTab() != null) {
                        ((ApplyModelsDlg)ModelsTab.this.mParent).getPlotsTab().setComponentEnableState(ModelsTab.this.mLoadFromFileRadio.isSelected());
                    }
                    if (((ApplyModelsDlg)ModelsTab.this.mParent).getSaveTab() != null) {
                        ((ApplyModelsDlg)ModelsTab.this.mParent).getStatisticsTab().setComponentsEnableState(ModelsTab.this.mLoadFromFileRadio.isSelected());
                    }
                    if (((ApplyModelsDlg)ModelsTab.this.mParent).getSaveTab() != null) {
                        ((ApplyModelsDlg)ModelsTab.this.mParent).getSaveTab().setComponentsEnableState(ModelsTab.this.mLoadFromFileRadio.isSelected());
                    }
                    ModelsTab.this.mStartLabel.setEnabled(bl);
                    ModelsTab.this.mStartCaseLabel.setEnabled(bl);
                    ModelsTab.this.mEndLabel.setEnabled(bl);
                    ModelsTab.this.mEndCaseLabel.setEnabled(bl);
                }
            }
            ModelsTab.this.mForecastPeriodTable.repaint();
            ModelsTab.this.mForecastPeriodTable.getTableHeader().repaint();
        }
    }
}

