/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.GlobalParameterErrorChecking;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.DateFactory;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesOutputFilterTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesPlotsTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesSaveTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesStatisticsTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models.ModelsTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models.OptionsTab;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.trends.res.TrendsResBundle;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.canvas.tables.BaseTableCanvas;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class ApplyModelsDlg
extends BaseTabbedDialog {
    private ModelsTab mModelsTab;
    private TimeSeriesStatisticsTab mStatisticsTab;
    private TimeSeriesPlotsTab mPlotsTab;
    private TimeSeriesOutputFilterTab mOutputFilterTab;
    private TimeSeriesSaveTab mSaveTab;
    private OptionsTab mOptionsTab;
    private ITrendsInfo mTrendsInfo;
    private boolean mIsSplitFileOn;
    private Vector<ISpssVariable> mSplitVars;
    private boolean mShowOKPasteSplit;
    private DialogDataModel mDataModel = null;
    private SrcVariableList mSrcVarList;
    Hashtable<ITrendsInfo.DateVarTypes, String> mSyntaxLabels;
    Pair<ITrendsInfo.DateVarTypes, String>[] mDateTypeLabels;

    public ApplyModelsDlg(JFrame jFrame) {
        super(jFrame, false, TrendsResBundle.getDefaultResourceBundleName(), TrendsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TIME_SERIES_APPLY_MODELS_WINDOW_TITLE"));
        this.pack();
        this.setLocationRelativeTo(jFrame);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings/apply_models");
        boolean bl = preferences2.getBoolean("dont_show_apply_models_warning", false);
        if (!bl && !this.AreDateVarsDefined()) {
            this.launchAlert();
        }
    }

    public SrcVariableList getSrcList() {
        return this.mSrcVarList;
    }

    private boolean AreDateVarsDefined() {
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        return iTrendsInfo.getNDateVars() > 0;
    }

    @Override
    public String getIActionKey() {
        return "analyze_time_series_apply_models";
    }

    @Override
    public String getDialogHelpID() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        return baseProcedureTab.getDialogHelpID();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        BaseTableCanvas.setClipboard(null);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mDataModel = this.getDialogDataModel();
    }

    public DialogDataModel getModel() {
        return this.mDataModel;
    }

    @Override
    protected void init() {
        super.init();
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mTrendsInfo = iSpssDataSrc.getTrendsInfo();
        this.mDateTypeLabels = this.loadDateVars();
        this.mIsSplitFileOn = GlobalParameterErrorChecking.isSplitFileON((LocallyUniqueId)locallyUniqueId);
        if (this.mIsSplitFileOn) {
            int n = iSpssDataSrc.getNSplitVars();
            this.mSplitVars = null;
            this.mSplitVars = new Vector();
            for (int i = 0; i < n; ++i) {
                int n2 = iSpssDataSrc.getSplitVarIndex(i);
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
                this.mSplitVars.add(iSpssVariable);
            }
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_TIME_SERIES_APPLY_MODELS_OPEN_SPLIT_FILE_MSG"), VersionInfo.getAppVersionString());
        }
        this.mModelsTab = new ModelsTab(this, true);
        this.mStatisticsTab = new TimeSeriesStatisticsTab(this, true, true);
        this.mPlotsTab = new TimeSeriesPlotsTab(this, true, true);
        this.mOutputFilterTab = new TimeSeriesOutputFilterTab(this, true);
        this.mSaveTab = new TimeSeriesSaveTab(this, true, true);
        this.mOptionsTab = new OptionsTab(this, true);
        this.addTab(this.getResString("IDS_TIME_SERIES_APPLY_MODELS_MODELS_TAB_TITLE"), this.mModelsTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_STATISTICS_TAB_TITLE"), this.mStatisticsTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_PLOTS_TAB_TITLE"), this.mPlotsTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_OUTPUT_FILTER_TAB_TITLE"), this.mOutputFilterTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_SAVE_TAB_TITLE"), this.mSaveTab);
        this.addTab(this.getResString("IDS_TIME_SERIES_OPTIONS_TAB_TITLE"), this.mOptionsTab);
        this.mTabbedPane.addChangeListener(this);
        super.enableOkPaste(true);
    }

    public ITrendsInfo getTrendsInfo() {
        return this.mTrendsInfo;
    }

    public int getPeriodNum() {
        return this.getTrendsInfo().getPeriod();
    }

    public String getPeriodText() {
        String string = this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_PREFIX");
        string = this.getPeriodNum() > 1 ? string + Integer.toString(this.getPeriodNum()) : string + this.getResString("IDS_TIME_SERIES_CURRENT_PERIODICITY_NONE_VALUE");
        return string;
    }

    public int getPeriodMinVal(ITrendsInfo.DateVarTypes dateVarTypes) {
        int n = 0;
        switch (dateVarTypes) {
            case e_CYCKEY: 
            case e_DATKEY: 
            case e_DAYKEY: 
            case e_MONKEY: 
            case e_NONE: 
            case e_OBSKEY: 
            case e_QTRKEY: 
            case e_WKKEY: 
            case e_YRKEY: {
                n = 1;
                break;
            }
            case e_HRKEY: 
            case e_MINKEY: 
            case e_SECKEY: {
                n = 0;
            }
        }
        return n;
    }

    public boolean getIsSplitFileOn() {
        return this.mIsSplitFileOn;
    }

    public Vector<ISpssVariable> getSplitFileVars() {
        return this.mSplitVars;
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (this.mIsSplitFileOn) {
            stringBuffer.append("SPLIT FILE OFF ");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append("PREDICT THRU ");
        stringBuffer.append(this.mModelsTab.getForecastEndSyntax()).append(SyntaxUtil.terminateSyntax());
        stringBuffer.append("* ").append(this.getResString("IDS_TIME_SERIES_APPLY_MODELS_SYNTAX_TITLE")).append(".\n");
        stringBuffer.append("TSAPPLY");
        this.mStatisticsTab.generateModelSyntax(stringBuffer, this.getDialogDataModel());
        this.mPlotsTab.generateModelPlotSyntax(stringBuffer, this.getDialogDataModel());
        this.mStatisticsTab.generateModelStatsSyntax(stringBuffer, this.getDialogDataModel());
        StringBuffer stringBuffer2 = new StringBuffer();
        this.mStatisticsTab.generateModelDetailsSyntax(stringBuffer2, this.getDialogDataModel());
        this.mPlotsTab.generateModelDetailsSyntax(stringBuffer2, this.getDialogDataModel());
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n   /MODELDETAILS").append(stringBuffer2);
        }
        this.mPlotsTab.generateSeriesPlotSyntax(stringBuffer, this.getDialogDataModel());
        this.mOutputFilterTab.generateSyntax(stringBuffer, this.getDialogDataModel());
        this.mSaveTab.generateSyntax(stringBuffer, this.getDialogDataModel());
        this.mOptionsTab.generateAuxiliarySyntax(stringBuffer, this.getDialogDataModel());
        this.mOptionsTab.generateMissingSyntax(stringBuffer, this.getDialogDataModel());
        this.mModelsTab.generateSyntax(stringBuffer, this.getDialogDataModel());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile((String)this.getDialogDataModel().getString("EXPORT_XML_FILE_PATH"));
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected String buildBracketedNumList(Integer n) {
        if (n == null) {
            return "[]";
        }
        String string = "[";
        if (n >= 1) {
            for (int i = n.intValue(); i >= 1; --i) {
                String string2 = i == n ? String.format("%d", i) : String.format(",%d", i);
                string = string + string2;
            }
        } else {
            String string3 = "0";
            string = string + string3;
        }
        string = string + "]";
        return string;
    }

    public ModelsTab getModelsTab() {
        return this.mModelsTab;
    }

    public TimeSeriesPlotsTab getPlotsTab() {
        return this.mPlotsTab;
    }

    public TimeSeriesSaveTab getSaveTab() {
        return this.mSaveTab;
    }

    public TimeSeriesStatisticsTab getStatisticsTab() {
        return this.mStatisticsTab;
    }

    public Pair<ITrendsInfo.DateVarTypes, String>[] getDateVars() {
        return this.mDateTypeLabels;
    }

    public Hashtable<ITrendsInfo.DateVarTypes, String> getDateSyntaxList() {
        return this.mSyntaxLabels;
    }

    private void launchAlert() {
        new Thread(){

            @Override
            public void run() {
                SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction("analyze_time_series_alert");
                try {
                    ProcedureAction procedureAction = (ProcedureAction)spssAction;
                    Class<?> clazz = Class.forName(procedureAction.getDlgLaunchPath());
                    Constructor<?> constructor = clazz.getConstructor(BaseProcedureDialog.class, String.class, String.class, String.class, String.class);
                    constructor.newInstance(ApplyModelsDlg.this, ApplyModelsDlg.this.getResString("IDS_TIME_SERIES_APPLY_MODELS_DEFINE_DATES_SUBDLG_LINE_1") + ApplyModelsDlg.this.getResString("IDS_TIME_SERIES_DEFINE_DATES_SUBDLG_LINE_2") + ApplyModelsDlg.this.getResString("IDS_TIME_SERIES_DEFINE_DATES_SUBDLG_LINE_3"), ApplyModelsDlg.this.getResString("IDS_TIME_SERIES_APPLY_MODELS_WINDOW_TITLE"), "apply_models", "dont_show_apply_models_warning");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    private Pair<ITrendsInfo.DateVarTypes, String>[] loadDateVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.loadFromActiveDataset();
        int n = this.mTrendsInfo.getNDateVars();
        Pair[] pairArray = new Pair[n];
        if (n == 0) {
            pairArray = new Pair[]{new Pair((Object)ITrendsInfo.DateVarTypes.e_NONE, (Object)this.getColumnString(ITrendsInfo.DateVarTypes.e_NONE))};
        } else {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                ITrendsInfo.DateVarTypes dateVarTypes = this.mTrendsInfo.getDateVarType(i);
                if (dateVarTypes == ITrendsInfo.DateVarTypes.e_DATKEY) continue;
                String string = this.getColumnString(dateVarTypes);
                pairArray[n2] = new Pair((Object)dateVarTypes, (Object)string);
                ++n2;
            }
        }
        this.mSyntaxLabels = DateFactory.getDateVariableSyntax();
        return pairArray;
    }

    private String getColumnString(ITrendsInfo.DateVarTypes dateVarTypes) {
        String string = "";
        ResourceBundle resourceBundle = ResUtil.getBundle(DataResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_CYCKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_CYCLE_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_YRKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_YEAR_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_QTRKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_QUARTER_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_MONKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_MONTH_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_WKKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_WEEK_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_DAYKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_DAY_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_HRKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_HOUR_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_MINKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_MINUTE_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_SECKEY) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_SECOND_LABEL");
        }
        if (dateVarTypes == ITrendsInfo.DateVarTypes.e_NONE) {
            string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_OBSERVATION_LABEL");
        }
        if (string.length() > 0 && string.substring(string.length() - 1).equals(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (this.mIsSplitFileOn && this.mShowOKPasteSplit && SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_TIME_SERIES_APPLY_MODELS_OKPASTE_SPLIT_FILE_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 2) {
            return false;
        }
        String string = this.mModelsTab.getFilePath().getText().trim();
        if (string.length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_TIME_SERIES_APPLY_MODELS_MODELS_TAB_EMPTY_FILE_ERROR"), VersionInfo.getAppVersionString());
            bl = false;
        }
        if (!bl) {
            final FileTextField fileTextField = this.mModelsTab.getFilePath();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    fileTextField.requestFocus();
                }
            });
        }
        if (bl) {
            bl = super.okPastePressed();
        }
        return bl;
    }
}

