/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models.ApplyModelsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class TimeSeriesStatisticsTab
extends BaseProcedureTab
implements ItemListener {
    private JCheckBox mDisplayFitCheck;
    private JCheckBox mStationaryRsquareCheck;
    private JCheckBox mRsquareCheck;
    private JCheckBox mRMSErrCheck;
    private JCheckBox mMeanAbsPctErrCheck;
    private JCheckBox mMeanAbsErrCheck;
    private JCheckBox mMaxAbsPctErrCheck;
    private JCheckBox mMaxAbsErrCheck;
    private JCheckBox mNormalizedBICCheck;
    private JCheckBox mGoodnessOfFitCheck;
    private JCheckBox mComparingACFCheck;
    private JCheckBox mComparingPACFCheck;
    private JCheckBox mParamEstCheck;
    private JCheckBox mIndivACFCheck;
    private JCheckBox mIndivPACFCheck;
    private JCheckBox mDispForecastsCheck;
    private boolean mIsApplyModel;

    public TimeSeriesStatisticsTab(BaseDialog baseDialog, boolean bl, boolean bl2) {
        super(baseDialog, bl);
        this.mIsApplyModel = bl2;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mDisplayFitCheck)) {
            this.setDisplayFitEnables(this.mDisplayFitCheck.isSelected());
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_stats";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public void generateModelSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mGoodnessOfFitCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_COMPARING_GOODNESS_CHECK_BOX").booleanValue()) {
            stringBuilder.append("MODELFIT");
        }
        if (this.mComparingACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_COMPARING_ACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDACF");
        }
        if (this.mComparingPACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_COMPARING_PACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDPACF");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("NONE");
        }
        stringBuffer.append("\n   /MODELSUMMARY  PRINT=[" + stringBuilder.toString() + "]");
    }

    public void generateModelStatsSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder("\n   /MODELSTATISTICS  DISPLAY=");
        if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_DISPLAY_FIT_CHECK_BOX").booleanValue()) {
            stringBuilder.append("YES ");
            stringBuilder.append("MODELFIT=[");
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_STATIONARY_RSQUARE_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" SRSQUARE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_RSQUARE_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" RSQUARE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_RMS_ERROR_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" RMSE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MEAN_ABS_PCT_ERR_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" MAPE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MEAN_ABS_ERR_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" MAE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MAX_ABS_PCT_ERR_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" MAXAPE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MAX_ABS_ERR_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" MAXAE");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_NORMALIZED_BIC_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" NORMBIC");
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("NO ");
        }
        stringBuffer.append(stringBuilder.toString());
    }

    public void generateModelDetailsSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder("  PRINT=[");
        int n = stringBuilder.length();
        if (this.mParamEstCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_INDIVIDUAL_PARAMETER_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" PARAMETERS");
        }
        if (this.mIndivACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_INDIVIDUAL_ACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDACF");
        }
        if (this.mIndivPACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_INDIVIDUAL_PACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDPACF");
        }
        if (this.mDispForecastsCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_STATS_DISPLAY_FORECASTS_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" FORECASTS");
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append("]");
            stringBuffer.append(stringBuilder.toString());
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected boolean validateTab() {
        boolean bl = true;
        if (!(!this.mDisplayFitCheck.isSelected() || this.mStationaryRsquareCheck.isSelected() || this.mMeanAbsErrCheck.isSelected() || this.mRsquareCheck.isSelected() || this.mMaxAbsPctErrCheck.isSelected() || this.mRMSErrCheck.isSelected() || this.mMaxAbsErrCheck.isSelected() || this.mMeanAbsPctErrCheck.isSelected() || this.mNormalizedBICCheck.isSelected())) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_STATS_SELECT_FIT_MEASURE_WARNING"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl && super.validateTab();
    }

    public void setComponentsEnableState(boolean bl) {
        if (this.mIsApplyModel) {
            this.enableACFPACFCheckBoxes();
        }
    }

    @Override
    protected void aboutToShowTab() {
        if (this.mIsApplyModel) {
            this.enableACFPACFCheckBoxes();
        }
    }

    private void setDefaults() {
        this.mDisplayFitCheck.setSelected(true);
        this.setDisplayFitEnables(true);
        this.mStationaryRsquareCheck.setSelected(true);
        this.mRsquareCheck.setSelected(false);
        this.mRMSErrCheck.setSelected(false);
        this.mMeanAbsPctErrCheck.setSelected(false);
        this.mMeanAbsErrCheck.setSelected(false);
        this.mMaxAbsPctErrCheck.setSelected(false);
        this.mMaxAbsErrCheck.setSelected(false);
        this.mNormalizedBICCheck.setSelected(false);
        this.mGoodnessOfFitCheck.setSelected(true);
        this.mComparingACFCheck.setSelected(false);
        this.mComparingPACFCheck.setSelected(false);
        this.mParamEstCheck.setSelected(false);
        this.mIndivACFCheck.setSelected(false);
        this.mIndivPACFCheck.setSelected(false);
        this.mDispForecastsCheck.setSelected(false);
        if (this.mIsApplyModel) {
            this.enableACFPACFCheckBoxes();
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_DISPLAY_FIT_CHECK_BOX");
        this.mDisplayFitCheck = new JCheckBox(toggleButtonAction);
        this.mDisplayFitCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_STATIONARY_RSQUARE_CHECK_BOX");
        this.mStationaryRsquareCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_RSQUARE_CHECK_BOX");
        this.mRsquareCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_RMS_ERROR_CHECK_BOX");
        this.mRMSErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MEAN_ABS_PCT_ERR_CHECK_BOX");
        this.mMeanAbsPctErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MEAN_ABS_ERR_CHECK_BOX");
        this.mMeanAbsErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MAX_ABS_PCT_ERR_CHECK_BOX");
        this.mMaxAbsPctErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MAX_ABS_ERR_CHECK_BOX");
        this.mMaxAbsErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_NORMALIZED_BIC_CHECK_BOX");
        this.mNormalizedBICCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_COMPARING_GOODNESS_CHECK_BOX");
        this.mGoodnessOfFitCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_COMPARING_ACF_CHECK_BOX");
        this.mComparingACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_COMPARING_PACF_CHECK_BOX");
        this.mComparingPACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_INDIVIDUAL_PARAMETER_CHECK_BOX");
        this.mParamEstCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_INDIVIDUAL_ACF_CHECK_BOX");
        this.mIndivACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_INDIVIDUAL_PACF_CHECK_BOX");
        this.mIndivPACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_STATS_DISPLAY_FORECASTS_CHECK_BOX");
        this.mDispForecastsCheck = new JCheckBox(toggleButtonAction);
    }

    private void setupPanel() {
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)UIToolDialogUtil.getStandardDialogInsets().clone();
        insets2.top = DialogUtil.getComponentGroupGap();
        insets2.bottom = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(this, this.mDisplayFitCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_STATS_FIT_MEASURES_GROUP_BOX")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_STATS_COMPARING_MODELS_GROUP_BOX")));
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_STATS_INDIVIDUAL_MODELS_GROUP_BOX")));
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mDispForecastsCheck, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mStationaryRsquareCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRsquareCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRMSErrCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMeanAbsPctErrCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        n = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = insets.left;
        insets.left = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel, this.mMeanAbsErrCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMaxAbsPctErrCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMaxAbsErrCheck, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNormalizedBICCheck, gridBagConstraints, 1, 3, 1, 1, n, insets);
        insets.left = n2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mGoodnessOfFitCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mComparingACFCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mComparingPACFCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel3, this.mParamEstCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mIndivACFCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mIndivPACFCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        DialogUtil.createButtonGroup(jPanel2);
        DialogUtil.createButtonGroup(jPanel3);
    }

    private void setDisplayFitEnables(boolean bl) {
        this.mStationaryRsquareCheck.setEnabled(bl);
        this.mRsquareCheck.setEnabled(bl);
        this.mRMSErrCheck.setEnabled(bl);
        this.mMeanAbsPctErrCheck.setEnabled(bl);
        this.mMeanAbsErrCheck.setEnabled(bl);
        this.mMaxAbsPctErrCheck.setEnabled(bl);
        this.mMaxAbsErrCheck.setEnabled(bl);
        this.mNormalizedBICCheck.setEnabled(bl);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mDisplayFitCheck);
        this.mComponentOrder.add(this.mStationaryRsquareCheck);
        this.mComponentOrder.add(this.mRsquareCheck);
        this.mComponentOrder.add(this.mRMSErrCheck);
        this.mComponentOrder.add(this.mMeanAbsPctErrCheck);
        this.mComponentOrder.add(this.mMeanAbsErrCheck);
        this.mComponentOrder.add(this.mMaxAbsPctErrCheck);
        this.mComponentOrder.add(this.mMaxAbsErrCheck);
        this.mComponentOrder.add(this.mNormalizedBICCheck);
        this.mComponentOrder.add(this.mGoodnessOfFitCheck);
        this.mComponentOrder.add(this.mComparingACFCheck);
        this.mComponentOrder.add(this.mComparingPACFCheck);
        this.mComponentOrder.add(this.mParamEstCheck);
        this.mComponentOrder.add(this.mIndivACFCheck);
        this.mComponentOrder.add(this.mIndivPACFCheck);
        this.mComponentOrder.add(this.mDispForecastsCheck);
    }

    private void enableACFPACFCheckBoxes() {
        boolean bl = ((ApplyModelsDlg)this.mParent).getModelsTab().isLoadFromFile();
        this.mComparingACFCheck.setEnabled(!bl);
        this.mComparingPACFCheck.setEnabled(!bl);
        this.mIndivACFCheck.setEnabled(!bl);
        this.mIndivPACFCheck.setEnabled(!bl);
    }
}

