/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.apply_models.ApplyModelsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TimeSeriesPlotsTab
extends BaseProcedureTab
implements ItemListener {
    private JCheckBox mStationaryRsquareCheck;
    private JCheckBox mRsquareCheck;
    private JCheckBox mRMSErrCheck;
    private JCheckBox mMeanAbsPctErrCheck;
    private JCheckBox mMeanAbsErrCheck;
    private JCheckBox mMaxAbsPctErrCheck;
    private JCheckBox mMaxAbsErrCheck;
    private JCheckBox mNormalizedBICCheck;
    private JCheckBox mComparingACFCheck;
    private JCheckBox mComparingPACFCheck;
    private JCheckBox mSeriesCheck;
    private JCheckBox mIndivACFCheck;
    private JCheckBox mIndivPACFCheck;
    private JCheckBox mObservedValsCheck;
    private JCheckBox mForecastsCheck;
    private JCheckBox mFitValsCheck;
    private JCheckBox mCIForecastsCheck;
    private JCheckBox mCIFitValsCheck;
    private boolean mIsApplyModel;

    public TimeSeriesPlotsTab(BaseDialog baseDialog, boolean bl, boolean bl2) {
        super(baseDialog, bl);
        this.mIsApplyModel = bl2;
        if (this.mIsApplyModel) {
            this.setSeriesEnable(this.mSeriesCheck.isSelected());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mSeriesCheck)) {
            this.setSeriesEnable(this.mSeriesCheck.isSelected());
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_plots";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public void generateModelPlotSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder(" PLOT=[");
        int n = stringBuilder.length();
        if (this.mStationaryRsquareCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_STATIONARY_RSQUARE_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" SRSQUARE");
        }
        if (this.mRsquareCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_RSQUARE_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RSQUARE");
        }
        if (this.mRMSErrCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_RMS_ERR_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RMSE");
        }
        if (this.mMeanAbsPctErrCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MEAN_ABS_PCT_ERR_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" MAPE");
        }
        if (this.mMeanAbsErrCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MEAN_ABS_ERR_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" MAE");
        }
        if (this.mMaxAbsPctErrCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MAX_ABS_PCT_ERR_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" MAXAPE");
        }
        if (this.mMaxAbsErrCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MAX_ABS_ERR_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" MAXAE");
        }
        if (this.mNormalizedBICCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_NORMALIZED_BIC_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" NORMBIC");
        }
        if (this.mComparingACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_ACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDACF");
        }
        if (this.mComparingPACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_PACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDPACF");
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append("]");
            stringBuffer.append((CharSequence)stringBuilder);
        }
    }

    public void generateModelDetailsSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder("  PLOT=[");
        int n = stringBuilder.length();
        if (this.mIndivACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_INDIVIDUAL_ACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDACF");
        }
        if (this.mIndivPACFCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_INDIVIDUAL_PACF_CHECK_BOX").booleanValue()) {
            stringBuilder.append(" RESIDPACF");
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append("]");
            stringBuffer.append((CharSequence)stringBuilder);
        }
    }

    public void generateSeriesPlotSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        if (this.mSeriesCheck.isSelected()) {
            StringBuilder stringBuilder = new StringBuilder("\n   /SERIESPLOT");
            int n = stringBuilder.length();
            if (this.mObservedValsCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_OBSERVED_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" OBSERVED");
            }
            if (this.mForecastsCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_FORECASTS_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" FORECAST");
            }
            if (this.mFitValsCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_FIT_VALUES_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" FIT");
            }
            if (this.mCIForecastsCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_CONFIDENCE_FORECASTS_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" FORECASTCI");
            }
            if (this.mCIFitValsCheck.isEnabled() && dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_CONFIDENCE_FITVALS_CHECK_BOX").booleanValue()) {
                stringBuilder.append(" FITCI");
            }
            if (stringBuilder.length() > n) {
                stringBuffer.append(stringBuilder.toString());
            }
        }
    }

    public void setComponentEnableState(boolean bl) {
        boolean bl2 = bl;
        this.mComparingACFCheck.setEnabled(!bl2);
        this.mComparingPACFCheck.setEnabled(!bl2);
        this.mIndivACFCheck.setEnabled(!bl2);
        this.mIndivPACFCheck.setEnabled(!bl2);
        this.mObservedValsCheck.setEnabled(this.mSeriesCheck.isSelected() && !bl2);
        this.mFitValsCheck.setEnabled(this.mSeriesCheck.isSelected() && !bl2);
        this.mCIFitValsCheck.setEnabled(this.mSeriesCheck.isSelected() && !bl2);
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        if (this.mIsApplyModel) {
            this.setSeriesEnable(this.mSeriesCheck.isSelected());
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected boolean validateTab() {
        boolean bl = true;
        if (this.mSeriesCheck.isSelected()) {
            if (this.mIsApplyModel) {
                boolean bl2 = ((ApplyModelsDlg)this.mParent).getModelsTab().isLoadFromFile();
                if (!(bl2 || this.mObservedValsCheck.isSelected() || this.mForecastsCheck.isSelected() || this.mFitValsCheck.isSelected() || this.mCIForecastsCheck.isSelected() || this.mCIFitValsCheck.isSelected())) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_PLOTS_SERIES_WARNING"), VersionInfo.getAppVersionString());
                    bl = false;
                    this.mObservedValsCheck.requestFocus();
                } else if (bl2 && !this.mForecastsCheck.isSelected() && !this.mCIForecastsCheck.isSelected()) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_PLOTS_SERIES_WARNING"), VersionInfo.getAppVersionString());
                    bl = false;
                    this.mForecastsCheck.requestFocus();
                }
            } else if (!(this.mObservedValsCheck.isSelected() || this.mForecastsCheck.isSelected() || this.mFitValsCheck.isSelected() || this.mCIForecastsCheck.isSelected() || this.mCIFitValsCheck.isSelected())) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_PLOTS_SERIES_WARNING"), VersionInfo.getAppVersionString());
                bl = false;
            }
        }
        return bl && super.validateTab();
    }

    @Override
    protected void aboutToShowTab() {
        if (this.mIsApplyModel) {
            this.setComponentEnableState(((ApplyModelsDlg)this.mParent).getModelsTab().isLoadFromFile());
        }
    }

    private void setDefaults() {
        this.mStationaryRsquareCheck.setSelected(false);
        this.mRsquareCheck.setSelected(false);
        this.mRMSErrCheck.setSelected(false);
        this.mMeanAbsPctErrCheck.setSelected(false);
        this.mMeanAbsErrCheck.setSelected(false);
        this.mMaxAbsPctErrCheck.setSelected(false);
        this.mMaxAbsErrCheck.setSelected(false);
        this.mNormalizedBICCheck.setSelected(false);
        this.mComparingACFCheck.setSelected(false);
        this.mComparingPACFCheck.setSelected(false);
        this.mSeriesCheck.setSelected(true);
        this.setSeriesEnable(true);
        this.mIndivACFCheck.setSelected(false);
        this.mIndivPACFCheck.setSelected(false);
        this.mObservedValsCheck.setSelected(true);
        this.mForecastsCheck.setSelected(true);
        this.mFitValsCheck.setSelected(false);
        this.mCIForecastsCheck.setSelected(false);
        this.mCIFitValsCheck.setSelected(false);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_STATIONARY_RSQUARE_CHECK_BOX");
        this.mStationaryRsquareCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_RSQUARE_CHECK_BOX");
        this.mRsquareCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_RMS_ERR_CHECK_BOX");
        this.mRMSErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MEAN_ABS_PCT_ERR_CHECK_BOX");
        this.mMeanAbsPctErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MEAN_ABS_ERR_CHECK_BOX");
        this.mMeanAbsErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MAX_ABS_PCT_ERR_CHECK_BOX");
        this.mMaxAbsPctErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_MAX_ABS_ERR_CHECK_BOX");
        this.mMaxAbsErrCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_NORMALIZED_BIC_CHECK_BOX");
        this.mNormalizedBICCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_ACF_CHECK_BOX");
        this.mComparingACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_PACF_CHECK_BOX");
        this.mComparingPACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_INDIVIDUAL_SERIES_CHECK_BOX");
        this.mSeriesCheck = new JCheckBox(toggleButtonAction);
        this.mSeriesCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_INDIVIDUAL_ACF_CHECK_BOX");
        this.mIndivACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_INDIVIDUAL_PACF_CHECK_BOX");
        this.mIndivPACFCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_OBSERVED_CHECK_BOX");
        this.mObservedValsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_FORECASTS_CHECK_BOX");
        this.mForecastsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_FIT_VALUES_CHECK_BOX");
        this.mFitValsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_CONFIDENCE_FORECASTS_CHECK_BOX");
        this.mCIForecastsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_CONFIDENCE_FITVALS_CHECK_BOX");
        this.mCIFitValsCheck = new JCheckBox(toggleButtonAction);
    }

    private void setupPanel() {
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left = 10;
        Insets insets2 = (Insets)UIToolDialogUtil.getStandardDialogInsets().clone();
        insets2.top = DialogUtil.getComponentGroupGap();
        insets2.bottom = 0;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_COMPARING_GROUP_BOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_INDIVIDUAL_GROUP_BOX")));
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mStationaryRsquareCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRsquareCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRMSErrCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMeanAbsPctErrCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMeanAbsErrCheck, gridBagConstraints, 0, 4, 0, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxAbsPctErrCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMaxAbsErrCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNormalizedBICCheck, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mComparingACFCheck, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mComparingPACFCheck, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mSeriesCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mIndivACFCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mIndivPACFCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mObservedValsCheck, this.mForecastsCheck, this.mFitValsCheck, this.mCIForecastsCheck, this.mCIFitValsCheck};
        JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_TIME_SERIES_CREATE_MODELS_PLOTS_DISPLAYS_GROUP_BOX"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 1, 1, 5, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        DialogUtil.createButtonGroup(jPanel3);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSeriesCheck);
        spssButtonGroup.add(this.mIndivACFCheck);
        spssButtonGroup.add(this.mIndivPACFCheck);
    }

    private void setSeriesEnable(boolean bl) {
        if (this.mIsApplyModel) {
            if (((ApplyModelsDlg)this.mParent).getModelsTab().isLoadFromFile()) {
                this.mObservedValsCheck.setEnabled(false);
                this.mFitValsCheck.setEnabled(false);
                this.mCIFitValsCheck.setEnabled(false);
            } else {
                this.mObservedValsCheck.setEnabled(bl);
                this.mFitValsCheck.setEnabled(bl);
                this.mCIFitValsCheck.setEnabled(bl);
            }
        } else {
            this.mObservedValsCheck.setEnabled(bl);
            this.mFitValsCheck.setEnabled(bl);
            this.mCIFitValsCheck.setEnabled(bl);
        }
        this.mForecastsCheck.setEnabled(bl);
        this.mCIForecastsCheck.setEnabled(bl);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mStationaryRsquareCheck);
        this.mComponentOrder.add(this.mRsquareCheck);
        this.mComponentOrder.add(this.mRMSErrCheck);
        this.mComponentOrder.add(this.mMeanAbsPctErrCheck);
        this.mComponentOrder.add(this.mMeanAbsErrCheck);
        this.mComponentOrder.add(this.mMaxAbsPctErrCheck);
        this.mComponentOrder.add(this.mMaxAbsErrCheck);
        this.mComponentOrder.add(this.mNormalizedBICCheck);
        this.mComponentOrder.add(this.mComparingACFCheck);
        this.mComponentOrder.add(this.mComparingPACFCheck);
        this.mComponentOrder.add(this.mSeriesCheck);
        this.mComponentOrder.add(this.mObservedValsCheck);
        this.mComponentOrder.add(this.mForecastsCheck);
        this.mComponentOrder.add(this.mFitValsCheck);
        this.mComponentOrder.add(this.mCIForecastsCheck);
        this.mComponentOrder.add(this.mCIFitValsCheck);
        this.mComponentOrder.add(this.mIndivACFCheck);
        this.mComponentOrder.add(this.mIndivPACFCheck);
    }
}

