/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.time_series;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class TimeSeriesOutputFilterTab
extends BaseProcedureTab
implements ItemListener {
    public static final double FLOAT_FIELD_MIN_VALUE = 0.0;
    public static final double FLOAT_FIELD_MAX_VALUE = 100.0;
    static final String GOODNESS_COMBO_KEY = "IDS_TS_OUTPUT_FILTER_GOODNESS_COMBO";
    public static final int INT_FIELD_MIN_VALUE = 1;
    public static final int INT_FIELD_MAX_VALUE = 999;
    private JRadioButton mIncludeAllRadio;
    private JRadioButton mFilterRadio;
    private JCheckBox mBestFitCheck;
    private JRadioButton mBestFixedRadio;
    private JLabel mBestFixedNumLabel;
    private IntTextField mBestFixedNumEdit;
    private JRadioButton mBestPctRadio;
    private JLabel mBestPctLabel;
    private FloatTextField mBestPctEdit;
    private JCheckBox mPoorestFitCheck;
    private JRadioButton mPoorestFixedRadio;
    private JLabel mPoorestFixedNumLabel;
    private IntTextField mPoorestFixedNumEdit;
    private JRadioButton mPoorestPctRadio;
    private JLabel mPoorestPctLabel;
    private FloatTextField mPoorestPctEdit;
    private JLabel mGoodnessOfFitLabel;
    private JComboBox mGoodnessOfFitCombo;
    private SpssButtonGroup mIncludeFilterButtonGrp;
    private SpssButtonGroup mBestFixPctButtonGrp;
    private SpssButtonGroup mPoorestFixPctButtonGrp;

    public TimeSeriesOutputFilterTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tab_output";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.setFilterEnables();
    }

    public void generateSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer2 = new StringBuffer("\n   /OUTPUTFILTER DISPLAY=");
        if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_INCLUDE_ALL_RADIO_BUTTON").booleanValue()) {
            stringBuffer2.append("ALLMODELS");
        } else {
            stringBuffer2.append(" [");
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_BEST_FIT_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" BESTFIT(");
                if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_BEST_FIXED_RADIO_BUTTON").booleanValue()) {
                    stringBuffer2.append("N=" + dialogDataModel.getString("IDS_TS_OUTPUTFILTER_BEST_FIXED_NUM_EDIT").trim());
                } else {
                    stringBuffer2.append("PCT=" + dialogDataModel.getString("IDS_TS_OUTPUTFILTER_BEST_PCT_NUM_EDIT").trim());
                }
                stringBuffer2.append(")");
            }
            if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_POOREST_FIT_CHECK_BOX").booleanValue()) {
                stringBuffer2.append(" WORSTFIT(");
                if (this.mPoorestFixedRadio.isSelected()) {
                    stringBuffer2.append("N=" + dialogDataModel.getString("IDS_TS_OUTPUTFILTER_POOREST_FIXED_NUM_EDIT").trim());
                } else if (this.mPoorestPctRadio.isSelected()) {
                    stringBuffer2.append("PCT=" + dialogDataModel.getString("IDS_TS_OUTPUTFILTER_POOREST_PCT_NUM_EDIT").trim());
                }
                stringBuffer2.append(")");
            }
            stringBuffer2.append("]");
        }
        if (dialogDataModel.getBoolean("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_FILTER_MODELS_RADIO_BUTTON").booleanValue()) {
            stringBuffer2.append("   MODELFIT=");
            switch (dialogDataModel.getInteger(GOODNESS_COMBO_KEY)) {
                case 0: {
                    stringBuffer2.append("SRSQUARE");
                    break;
                }
                case 1: {
                    stringBuffer2.append("RSQUARE");
                    break;
                }
                case 2: {
                    stringBuffer2.append("RMSE");
                    break;
                }
                case 3: {
                    stringBuffer2.append("MAPE");
                    break;
                }
                case 4: {
                    stringBuffer2.append("MAE");
                    break;
                }
                case 5: {
                    stringBuffer2.append("MAXAPE");
                    break;
                }
                case 6: {
                    stringBuffer2.append("MAXAE");
                    break;
                }
                case 7: {
                    stringBuffer2.append("NORMBIC");
                }
            }
        }
        stringBuffer.append(stringBuffer2);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected boolean validateTab() {
        if (this.mFilterRadio.isSelected()) {
            if (!this.mBestFitCheck.isSelected() && !this.mPoorestFitCheck.isSelected()) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_TIME_SERIES_CREATE_MODELS_OUTPUT_SELECT_MODEL_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
            if (this.mBestFitCheck.isSelected() && this.mBestFixedRadio.isSelected()) {
                if (this.mBestFixedNumEdit.getText().trim().length() == 0) {
                    String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 999);
                    SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TimeSeriesOutputFilterTab.this.mBestFixedNumEdit.requestFocus();
                        }
                    });
                    return false;
                }
                if (!this.mBestFixedNumEdit.checkRange()) {
                    return false;
                }
            } else if (this.mBestFitCheck.isSelected() && this.mBestPctRadio.isSelected()) {
                if (this.mBestPctEdit.getText().trim().length() == 0) {
                    String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MSG_INCLUDE_NONE"), 0.0, 100.0);
                    SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TimeSeriesOutputFilterTab.this.mBestPctEdit.requestFocus();
                        }
                    });
                    return false;
                }
                if (!this.mBestPctEdit.checkRange()) {
                    return false;
                }
            }
            if (this.mPoorestFitCheck.isSelected() && this.mPoorestFixedRadio.isSelected()) {
                if (this.mPoorestFixedNumEdit.getText().trim().length() == 0) {
                    String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 999);
                    SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TimeSeriesOutputFilterTab.this.mPoorestFixedNumEdit.requestFocus();
                        }
                    });
                    return false;
                }
                if (!this.mPoorestFixedNumEdit.checkRange()) {
                    return false;
                }
            } else if (this.mPoorestFitCheck.isSelected() && this.mPoorestPctRadio.isSelected()) {
                if (this.mPoorestPctEdit.getText().trim().length() == 0) {
                    String string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MSG_INCLUDE_NONE"), 0.0, 100.0);
                    SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TimeSeriesOutputFilterTab.this.mPoorestPctEdit.requestFocus();
                        }
                    });
                    return false;
                }
                if (!this.mPoorestPctEdit.checkRange()) {
                    return false;
                }
            }
        }
        return super.validateTab();
    }

    private void initVars() {
        ToggleButtonActionListener toggleButtonActionListener = new ToggleButtonActionListener();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_INCLUDE_ALL_RADIO_BUTTON");
        this.mIncludeAllRadio = new JRadioButton(toggleButtonAction);
        this.mIncludeAllRadio.addItemListener(toggleButtonActionListener);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_FILTER_MODELS_RADIO_BUTTON");
        this.mFilterRadio = new JRadioButton(toggleButtonAction);
        this.mIncludeAllRadio.addItemListener(toggleButtonActionListener);
        this.mIncludeFilterButtonGrp = new SpssButtonGroup();
        this.mIncludeFilterButtonGrp.add(this.mIncludeAllRadio);
        this.mIncludeFilterButtonGrp.add(this.mFilterRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_BEST_FIT_CHECK_BOX");
        this.mBestFitCheck = new JCheckBox(toggleButtonAction);
        this.mBestFitCheck.addItemListener(toggleButtonActionListener);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_BEST_FIXED_RADIO_BUTTON");
        this.mBestFixedRadio = new JRadioButton(toggleButtonAction);
        this.mBestFixedRadio.addItemListener(toggleButtonActionListener);
        this.mBestFixedNumEdit = new IntTextField(1, 999, true);
        this.mBestFixedNumEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_TS_OUTPUTFILTER_BEST_FIXED_NUM_EDIT"));
        this.mBestFixedNumLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_BEST_NUMBER_LABEL");
        this.mBestFixedNumLabel.setLabelFor((Component)this.mBestFixedNumEdit);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_BEST_PERCENT_RADIO_BUTTON");
        this.mBestPctRadio = new JRadioButton(toggleButtonAction);
        this.mBestPctRadio.addItemListener(toggleButtonActionListener);
        this.mBestPctEdit = new FloatTextField(0.0, 100.0, 4, true);
        this.mBestPctEdit.setIncludeMinRange(false);
        this.mBestPctEdit.setIncludeMaxRange(false);
        this.mBestPctEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_TS_OUTPUTFILTER_BEST_PCT_NUM_EDIT"));
        this.mBestPctLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_BEST_PERCENTAGE_LABEL");
        this.mBestPctLabel.setLabelFor((Component)this.mBestPctEdit);
        this.mBestFixPctButtonGrp = new SpssButtonGroup();
        this.mBestFixPctButtonGrp.add(this.mBestFixedRadio);
        this.mBestFixPctButtonGrp.add(this.mBestPctRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_POOREST_FIT_CHECK_BOX");
        this.mPoorestFitCheck = new JCheckBox(toggleButtonAction);
        this.mPoorestFitCheck.addItemListener(toggleButtonActionListener);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mBestFitCheck);
        spssButtonGroup.add(this.mPoorestFitCheck);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_POOREST_FIXED_RADIO_BUTTON");
        this.mPoorestFixedRadio = new JRadioButton(toggleButtonAction);
        this.mPoorestFixedRadio.addItemListener(toggleButtonActionListener);
        this.mPoorestFixedNumEdit = new IntTextField(1, 999, true);
        this.mPoorestFixedNumEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_TS_OUTPUTFILTER_POOREST_FIXED_NUM_EDIT"));
        this.mPoorestFixedNumLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_POOREST_NUMBER_LABEL");
        this.mPoorestFixedNumLabel.setLabelFor((Component)this.mPoorestFixedNumEdit);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_POOREST_PERCENT_RADIO_BUTTON");
        this.mPoorestPctRadio = new JRadioButton(toggleButtonAction);
        this.mPoorestPctRadio.addItemListener(toggleButtonActionListener);
        this.mPoorestPctEdit = new FloatTextField(0.0, 100.0, 4, true);
        this.mPoorestPctEdit.setIncludeMinRange(false);
        this.mPoorestPctEdit.setIncludeMaxRange(false);
        this.mPoorestPctEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_TS_OUTPUTFILTER_POOREST_PCT_NUM_EDIT"));
        this.mPoorestPctLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_POOREST_PERCENTAGE_LABEL");
        this.mPoorestPctLabel.setLabelFor((Component)this.mPoorestPctEdit);
        this.mPoorestFixPctButtonGrp = new SpssButtonGroup();
        this.mPoorestFixPctButtonGrp.add(this.mPoorestFixedRadio);
        this.mPoorestFixPctButtonGrp.add(this.mPoorestPctRadio);
        Vector<ComboItem> vector = new Vector<ComboItem>();
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_0"), 0));
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_1"), 1));
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_2"), 2));
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_3"), 3));
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_4"), 4));
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_5"), 5));
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_6"), 6));
        vector.add(new ComboItem(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_COMBO_ITEM_7"), 7));
        this.mGoodnessOfFitCombo = new JComboBox(vector);
        this.mGoodnessOfFitCombo.setAction(new ComboboxAction(this.mParent, GOODNESS_COMBO_KEY));
        this.mGoodnessOfFitLabel = DialogUtil.createLabel(this.mParent, "IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_GOODNESS_OF_FIT_LABEL");
        this.mGoodnessOfFitLabel.setLabelFor(this.mGoodnessOfFitCombo);
        this.mIncludeAllRadio.addItemListener(this);
        this.mBestFixedRadio.addItemListener(this);
        this.mPoorestFixedRadio.addItemListener(this);
        this.mBestPctRadio.addItemListener(this);
        this.mPoorestPctRadio.addItemListener(this);
    }

    private void setDefaults() {
        this.mIncludeAllRadio.setSelected(true);
        this.mFilterRadio.setSelected(false);
        this.mBestFitCheck.setSelected(false);
        this.mBestFixedRadio.setSelected(true);
        this.mBestFixedNumEdit.setText("");
        this.mBestPctRadio.setSelected(false);
        this.mBestPctEdit.setText("");
        this.mPoorestFitCheck.setSelected(false);
        this.mPoorestFixedRadio.setSelected(true);
        this.mPoorestFixedNumEdit.setText("");
        this.mPoorestPctRadio.setSelected(false);
        this.mPoorestPctEdit.setText("");
        this.mGoodnessOfFitCombo.setSelectedIndex(0);
        this.setFilterEnables();
    }

    private void setFilterEnables() {
        if (this.mIncludeAllRadio.isSelected()) {
            this.mBestFitCheck.setEnabled(false);
            this.mBestFixedRadio.setEnabled(false);
            this.mBestFixedNumEdit.setEnabled(false);
            this.mBestFixedNumEdit.setOpaque(false);
            this.mBestPctRadio.setEnabled(false);
            this.mBestPctEdit.setEnabled(false);
            this.mBestPctEdit.setOpaque(false);
            this.mPoorestFitCheck.setEnabled(false);
            this.mPoorestFixedRadio.setEnabled(false);
            this.mPoorestFixedNumEdit.setEnabled(false);
            this.mPoorestFixedNumEdit.setOpaque(false);
            this.mPoorestPctRadio.setEnabled(false);
            this.mPoorestPctEdit.setEnabled(false);
            this.mPoorestPctEdit.setOpaque(false);
            this.mGoodnessOfFitCombo.setEnabled(false);
            this.mBestFixedNumLabel.setEnabled(false);
            this.mBestPctLabel.setEnabled(false);
            this.mPoorestFixedNumLabel.setEnabled(false);
            this.mPoorestPctLabel.setEnabled(false);
            this.mGoodnessOfFitLabel.setEnabled(false);
        } else {
            this.mBestFitCheck.setEnabled(true);
            this.mPoorestFitCheck.setEnabled(true);
            this.mBestFixedRadio.setEnabled(this.mBestFitCheck.isSelected());
            this.mBestFixedNumLabel.setEnabled(this.mBestFitCheck.isSelected() && this.mBestFixedRadio.isSelected());
            this.mBestFixedNumEdit.setEnabled(this.mBestFitCheck.isSelected() && this.mBestFixedRadio.isSelected());
            this.mBestFixedNumEdit.setOpaque(this.mBestFitCheck.isSelected() && this.mBestFixedRadio.isSelected());
            this.mBestPctRadio.setEnabled(this.mBestFitCheck.isSelected() && this.mBestFitCheck.isSelected());
            this.mBestPctLabel.setEnabled(this.mBestFitCheck.isSelected() && this.mBestPctRadio.isSelected());
            this.mBestPctEdit.setEnabled(this.mBestFitCheck.isSelected() && this.mBestPctRadio.isSelected());
            this.mBestPctEdit.setOpaque(this.mBestFitCheck.isSelected() && this.mBestPctRadio.isSelected());
            this.mPoorestFixedRadio.setEnabled(this.mPoorestFitCheck.isSelected());
            this.mPoorestFixedNumLabel.setEnabled(this.mPoorestFitCheck.isSelected() && this.mPoorestFixedRadio.isSelected());
            this.mPoorestFixedNumEdit.setEnabled(this.mPoorestFitCheck.isSelected() && this.mPoorestFixedRadio.isSelected());
            this.mPoorestFixedNumEdit.setOpaque(this.mPoorestFitCheck.isSelected() && this.mPoorestFixedRadio.isSelected());
            this.mPoorestPctRadio.setEnabled(this.mPoorestFitCheck.isSelected() && this.mPoorestFitCheck.isSelected());
            this.mPoorestPctLabel.setEnabled(this.mPoorestFitCheck.isSelected() && this.mPoorestPctRadio.isSelected());
            this.mPoorestPctEdit.setEnabled(this.mPoorestFitCheck.isSelected() && this.mPoorestPctRadio.isSelected());
            this.mPoorestPctEdit.setOpaque(this.mPoorestFitCheck.isSelected() && this.mPoorestPctRadio.isSelected());
            this.mGoodnessOfFitLabel.setEnabled(true);
            this.mGoodnessOfFitCombo.setEnabled(true);
        }
    }

    private void setupPanel() {
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        int n = 20;
        int n2 = DialogUtil.getComponentGroupGap();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mIncludeAllRadio, gridBagConstraints, 0, 0, 1, 1, n3, new Insets(insets2.top, insets2.left, insets.bottom, insets2.right));
        DialogUtil.addUsingGBL(this, this.mFilterRadio, gridBagConstraints, 0, 1, 1, 1, n3, new Insets(0, insets2.left, 0, insets2.right));
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TIME_SERIES_CREATE_MODELS_OUTPUT_FILTER_DISPLAY_GROUP_BOX")));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.left += 20;
        gridBagConstraints.insets.top = 5;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 2, 1, 1, n3, new Insets(0, insets.left + n + 10, insets2.bottom, insets2.right));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets3 = (Insets)insets.clone();
        insets3.left = gridBagConstraints.insets.left = 10;
        DialogUtil.addUsingGBL(jPanel, this.mBestFitCheck, gridBagConstraints, 0, 0, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mPoorestFitCheck, gridBagConstraints, 0, 5, 1, 1, n3, insets3);
        insets3 = (Insets)insets.clone();
        gridBagConstraints = new GridBagConstraints();
        insets3.top = 0;
        insets3.left += n;
        DialogUtil.addUsingGBL(jPanel, this.mBestFixedRadio, gridBagConstraints, 0, 1, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mBestPctRadio, gridBagConstraints, 0, 3, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mPoorestFixedRadio, gridBagConstraints, 0, 6, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mPoorestPctRadio, gridBagConstraints, 0, 8, 1, 1, n3, insets3);
        insets3.left = gridBagConstraints.insets.left = n * 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mBestFixedNumLabel, gridBagConstraints2, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mBestFixedNumEdit, gridBagConstraints2, 1, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n3, insets3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel3, this.mBestPctLabel, gridBagConstraints2, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mBestPctEdit, gridBagConstraints2, 1, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 1, 1, n3, insets3);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel4, this.mPoorestFixedNumLabel, gridBagConstraints2, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel4, (JComponent)this.mPoorestFixedNumEdit, gridBagConstraints2, 1, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 7, 1, 1, n3, insets3);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel5, this.mPoorestPctLabel, gridBagConstraints2, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel5, (JComponent)this.mPoorestPctEdit, gridBagConstraints2, 1, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 9, 1, 1, n3, insets3);
        insets3.top = n2;
        insets3.left = n;
        JSeparator jSeparator = new JSeparator();
        jSeparator.setPreferredSize(new Dimension(340, 10));
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 10, 2, 1, n3, insets3);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        int n4 = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel6, this.mGoodnessOfFitLabel, gridBagConstraints2, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel6, this.mGoodnessOfFitCombo, gridBagConstraints2, 1, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 11, 1, 1, n3, new Insets(n4, n4, n4, n4));
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mIncludeFilterButtonGrp);
        this.mComponentOrder.add(this.mBestFitCheck);
        this.mComponentOrder.add(this.mBestFixPctButtonGrp);
        this.mComponentOrder.add(this.mBestFixedNumEdit);
        this.mComponentOrder.add(this.mBestPctEdit);
        this.mComponentOrder.add(this.mPoorestFitCheck);
        this.mComponentOrder.add(this.mPoorestFixPctButtonGrp);
        this.mComponentOrder.add(this.mPoorestFixedNumEdit);
        this.mComponentOrder.add(this.mPoorestPctEdit);
        this.mComponentOrder.add(this.mGoodnessOfFitCombo);
    }

    class ComboItem {
        String mText;
        int mNum;

        ComboItem(String string, int n) {
            this.mText = string;
            this.mNum = n;
        }

        public String toString() {
            return this.mText;
        }
    }

    class ToggleButtonActionListener
    implements ItemListener {
        ToggleButtonActionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            TimeSeriesOutputFilterTab.this.setFilterEnables();
        }
    }

    static enum UnitType {
        points,
        inches,
        centimeters;

    }
}

