/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.survival.life_tables;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.survival.life_tables.LifeTablesDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LifeTablesOptions
extends BaseSubDialog
implements ActionListener {
    private JCheckBox mLifeTablesCheckbox;
    private JCheckBox mSurvivalCheckbox;
    private JCheckBox mLogSurvivalCheckbox;
    private JCheckBox mHazardCheckbox;
    private JCheckBox mDensityCheckbox;
    private JCheckBox mOneMinusCheckbox;
    private JRadioButton mNoneRadio;
    private JRadioButton mOverallRadio;
    private JRadioButton mPairwiseRadio;
    private GridBagConstraints mGridConstraints;

    public LifeTablesOptions(LifeTablesDlg lifeTablesDlg) {
        super(lifeTablesDlg, lifeTablesDlg.getResString("IDS_LIFE_TABLES_OPTIONS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_surv_opt";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mLifeTablesCheckbox.isSelected() || this.getPlotPanelComponentState() || this.getCompareFactorComponentState()) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupPlotPanel();
        DialogUtil.createButtonGroup(jPanel2);
        JPanel jPanel3 = this.setupComparePanel();
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mLifeTablesCheckbox, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weighty = 1.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 1, 1, 1, n, insets);
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 0, 2, 1, 1, n, insets);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (((LifeTablesDlg)this.mParentDlg).getDialogDataModel().getBoolean("TARGET_SIZE").booleanValue()) {
            this.mNoneRadio.setEnabled(true);
            this.mOverallRadio.setEnabled(true);
            this.mPairwiseRadio.setEnabled(true);
        } else {
            this.mNoneRadio.setEnabled(false);
            this.mOverallRadio.setEnabled(false);
            this.mPairwiseRadio.setEnabled(false);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_LIFETABLES_CHECKBOX");
        this.mLifeTablesCheckbox = new JCheckBox(toggleButtonAction);
        this.mLifeTablesCheckbox.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_SURVIVAL_CHECKBOX");
        this.mSurvivalCheckbox = new JCheckBox(toggleButtonAction);
        this.mSurvivalCheckbox.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_LOGSURVIVAL_CHECKBOX");
        this.mLogSurvivalCheckbox = new JCheckBox(toggleButtonAction);
        this.mLogSurvivalCheckbox.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_HAZARD_CHECKBOX");
        this.mHazardCheckbox = new JCheckBox(toggleButtonAction);
        this.mHazardCheckbox.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_DENSITY_CHECKBOX");
        this.mDensityCheckbox = new JCheckBox(toggleButtonAction);
        this.mDensityCheckbox.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_ONEMINUS_CHECKBOX");
        this.mOneMinusCheckbox = new JCheckBox(toggleButtonAction);
        this.mOneMinusCheckbox.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_NONE_RADIO");
        this.mNoneRadio = new JRadioButton(toggleButtonAction);
        this.mNoneRadio.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_OVERALL_RADIO");
        this.mOverallRadio = new JRadioButton(toggleButtonAction);
        this.mOverallRadio.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_OPTIONS_PAIRWISE_RADIO");
        this.mPairwiseRadio = new JRadioButton(toggleButtonAction);
        this.mPairwiseRadio.addActionListener(this);
        this.mGridConstraints = new GridBagConstraints();
        this.mLifeTablesCheckbox.setSelected(true);
        this.mNoneRadio.setSelected(true);
    }

    private JPanel setupPlotPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LIFE_TABLES_OPTIONS_PLOT_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSurvivalCheckbox, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mHazardCheckbox, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        insets2.set(insets.top, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLogSurvivalCheckbox, this.mGridConstraints, 1, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDensityCheckbox, this.mGridConstraints, 1, 1, 1, 1, n, insets2);
        insets2.set(insets.top, n2, 0, 0);
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOneMinusCheckbox, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupComparePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LIFE_TABLES_OPTIONS_COMPARE_LEVELS_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mOverallRadio, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mPairwiseRadio, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private boolean getPlotPanelComponentState() {
        return this.mSurvivalCheckbox.isSelected() || this.mLogSurvivalCheckbox.isSelected() || this.mHazardCheckbox.isSelected() || this.mDensityCheckbox.isSelected() || this.mOneMinusCheckbox.isSelected();
    }

    private boolean getCompareFactorComponentState() {
        return this.mOverallRadio.isSelected() || this.mPairwiseRadio.isSelected();
    }

    private Vector<Object> setTabTraversal() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNoneRadio);
        spssButtonGroup.add(this.mOverallRadio);
        spssButtonGroup.add(this.mPairwiseRadio);
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mLifeTablesCheckbox);
        vector.add(this.mSurvivalCheckbox);
        vector.add(this.mHazardCheckbox);
        vector.add(this.mLogSurvivalCheckbox);
        vector.add(this.mDensityCheckbox);
        vector.add(this.mOneMinusCheckbox);
        vector.add(spssButtonGroup);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

