/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.survival.life_tables;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.ISpssVarFormatter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.AnalyzeDefineRange;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.base.analyze.survival.life_tables.LifeTablesDefineEvent;
import com.spss.java_client.ui.dialogs.base.analyze.survival.life_tables.LifeTablesOptions;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LifeTablesDlg
extends BaseProcedureDialog
implements ListDataListener,
FocusListener,
DocumentListener,
IVarMoveHandler {
    protected DecimalFormatSymbols mSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
    private static final double MIN_VALUE = 1.0E-4;
    private static final double MAX_VALUE = 99999.0;
    private static final int PRECISION_VALUE = 4;
    static final String TIME_LIST = "LIFE_TABLES_TIME_LIST_IDENTIFIER";
    static final String STATUS_LIST = "LIFE_TABLES_STATUS_LIST_IDENTIFIER";
    static final String FACTOR_LIST = "LIFE_TABLES_FACTOR_LIST_IDENTIFIER";
    static final String FACTOR_BY_LIST = "LIFE_TABLES_FACTOR_BY_LIST_IDENTIFIER";
    private static boolean sStatusValueEntered = true;
    private static boolean sFactorValueEntered = true;
    private static boolean sFactorByValueEntered = true;
    private JButton mOptionsButton;
    private JButton mBootstrappingButton;
    private JButton mDefineEventButton;
    private JButton mDefineRangeButton;
    private JButton mByFactorDefineButton;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTimeList;
    private ArrowButton mTimeListArrow;
    private TargetVariableList mFactorList;
    private ArrowButton mFactorListArrow;
    private TargetVariableList mStatusList;
    private ArrowButton mStatusListArrow;
    private TargetVariableList mByFactorList;
    private ArrowButton mByFactorListArrow;
    private FloatTextField mByTextField;
    private FloatTextField mThroughTextField;
    private GridBagConstraints mGridConstraints;
    private StatusListFormatter mFormatter;
    private FactorListFormatter mFactorFormatter;
    private FactorByListFormatter mFactorByFormatter;
    private boolean mIsBootstrapOK;

    public LifeTablesDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_LIFE_TABLES_TITLE"));
    }

    @Override
    public String generateSyntax() {
        String string;
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            object = "";
            string = this.mStatusList.getVariablesStringList() + " " + this.mTimeList.getVariablesStringList() + " " + this.mFactorList.getVariablesStringList() + " " + this.mByFactorList.getVariablesStringList();
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax((String)object, string, dialogDataModel));
        }
        object = this.getDialogDataModel();
        string = ((DialogDataModel)object).getString("IDS_DEFINE_RANGE_MINIMUM");
        String string2 = ((DialogDataModel)object).getString("IDS_DEFINE_RANGE_MAXIMUM");
        stringBuffer.append(SyntaxUtil.getMainCommand("SURVIVAL"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("TABLE="));
        stringBuffer.append(this.mTimeList.getVariablesStringList());
        if (this.mFactorList.getModel().getSize() == 1) {
            stringBuffer.append(" BY " + this.mFactorList.getVariablesStringList() + "(" + string + " " + string2 + ")");
        }
        string = ((DialogDataModel)object).getString("IDS_DEFINE_RANGE_MINIMUM_1");
        string2 = ((DialogDataModel)object).getString("IDS_DEFINE_RANGE_MAXIMUM_1");
        if (this.mByFactorList.getModel().getSize() == 1) {
            stringBuffer.append(" BY " + this.mByFactorList.getVariablesStringList() + "(" + string + " " + string2 + ")");
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/INTERVAL=THRU ") + ((DialogDataModel)object).getString("IDS_LIFE_TABLES_THROUGH") + " BY " + ((DialogDataModel)object).getString("IDS_LIFE_TABLES_BY"));
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATUS="));
        if (((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE").booleanValue()) {
            stringBuffer.append(this.mStatusList.getVariablesStringList() + "(" + ((DialogDataModel)object).getString("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE") + ")");
        } else {
            stringBuffer.append(this.mStatusList.getVariablesStringList() + "(" + ((DialogDataModel)object).getString("IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE") + " " + ((DialogDataModel)object).getString("IDS_LIFE_TABLES_DEFINE_EVENT_THROUGH") + ")");
        }
        Boolean bl = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_LIFETABLES_CHECKBOX");
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PRINT="));
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("TABLE");
        } else {
            stringBuffer.append("NOTABLE");
        }
        Boolean bl2 = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_SURVIVAL_CHECKBOX");
        Boolean bl3 = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_HAZARD_CHECKBOX");
        Boolean bl4 = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_ONEMINUS_CHECKBOX");
        Boolean bl5 = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_LOGSURVIVAL_CHECKBOX");
        Boolean bl6 = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_DENSITY_CHECKBOX");
        if (bl2 != null && bl2 != false || bl3 != null && bl3 != false || bl4 != null && bl4 != false || bl5 != null && bl5 != false || bl6 != null && bl6.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PLOTS ("));
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("SURVIVAL ");
            }
            if (bl3 != null && bl3.booleanValue()) {
                stringBuffer.append("HAZARD ");
            }
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("OMS ");
            }
            if (bl5 != null && bl5.booleanValue()) {
                stringBuffer.append("LOGSURV ");
            }
            if (bl6 != null && bl6.booleanValue()) {
                stringBuffer.append("DENSITY ");
            }
            int n = stringBuffer.length();
            stringBuffer.delete(n - 1, n);
            stringBuffer.append(")=" + this.mTimeList.getVariablesStringList());
            if (this.mFactorList.getModel().getSize() == 1) {
                stringBuffer.append(" BY " + this.mFactorList.getVariablesStringList());
            }
            if (this.mByFactorList.getModel().getSize() == 1) {
                stringBuffer.append(" BY " + this.mByFactorList.getVariablesStringList());
            }
        }
        bl3 = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_PAIRWISE_RADIO");
        bl6 = ((DialogDataModel)object).getBoolean("IDS_LIFE_TABLES_OPTIONS_OVERALL_RADIO");
        if (bl3 != null && (bl3.booleanValue() || bl6.booleanValue())) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/COMPARE=") + this.mTimeList.getVariablesStringList());
            if (this.mFactorList.getModel().getSize() == 1) {
                stringBuffer.append(" BY " + this.mFactorList.getVariablesStringList());
            }
            if (this.mByFactorList.getModel().getSize() == 1) {
                stringBuffer.append(" BY " + this.mByFactorList.getVariablesStringList());
            }
            if (bl3.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CALCULATE PAIRWISE"));
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_survival_life_tables";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_surv";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTimeList.removeAll();
        this.mStatusList.removeAll();
        this.mFactorList.removeAll();
        this.mByFactorList.removeAll();
        this.mThroughTextField.setText("");
        this.mByTextField.setText("");
        this.setDefaults();
    }

    public boolean canEnableOkPaste() {
        boolean bl = false;
        if (this.mTimeList.getModel().getSize() > 0 && this.mThroughTextField.getText().length() > 0 && this.mByTextField.getText().length() > 0 && this.mStatusList.getModel().getSize() > 0 && sStatusValueEntered && sFactorValueEntered && sFactorByValueEntered) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean okPastePressed() {
        if (Float.parseFloat(this.mByTextField.getText().toString()) > Float.parseFloat(this.mThroughTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_LIFE_TABLES_ERRMSG_SMALLER_VALUE_IN_ASSOCIATED_TEXT_BOX"), VersionInfo.getAppVersionString());
            this.mByTextField.requestFocus();
            this.mByTextField.selectAll();
            return false;
        }
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mStatusList.getModel()) {
            this.mDefineEventButton.setEnabled(true);
            sStatusValueEntered = false;
        }
        if (listDataEvent.getSource() == this.mFactorList.getModel()) {
            this.mDefineRangeButton.setEnabled(true);
            sFactorValueEntered = false;
        }
        if (listDataEvent.getSource() == this.mByFactorList.getModel()) {
            this.mByFactorDefineButton.setEnabled(true);
            sFactorByValueEntered = false;
        }
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mStatusList.getModel()) {
            this.mDefineEventButton.setEnabled(false);
            sStatusValueEntered = true;
            this.getDialogDataModel().putBoolean("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE", null);
            this.getDialogDataModel().putString("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE", null);
            this.getDialogDataModel().putBoolean("IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE", null);
            this.getDialogDataModel().putString("IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE", null);
            this.getDialogDataModel().putString("IDS_LIFE_TABLES_DEFINE_EVENT_THROUGH", null);
        }
        if (listDataEvent.getSource() == this.mFactorList.getModel()) {
            this.mDefineRangeButton.setEnabled(false);
            sFactorValueEntered = true;
            this.getDialogDataModel().putString("IDS_DEFINE_RANGE_MINIMUM", null);
            this.getDialogDataModel().putString("IDS_DEFINE_RANGE_MAXIMUM", null);
        }
        if (listDataEvent.getSource() == this.mByFactorList.getModel()) {
            this.mByFactorDefineButton.setEnabled(false);
            sFactorByValueEntered = true;
            this.getDialogDataModel().putString("IDS_DEFINE_RANGE_MINIMUM_1", null);
            this.getDialogDataModel().putString("IDS_DEFINE_RANGE_MAXIMUM_1", null);
        }
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mStatusList && this.mStatusList.getModel().getSize() == 1) {
            this.mDefineEventButton.setEnabled(true);
            this.mDefineRangeButton.setEnabled(false);
            this.mByFactorDefineButton.setEnabled(false);
        }
        if (focusEvent.getSource() == this.mFactorList && this.mFactorList.getModel().getSize() == 1) {
            this.mDefineRangeButton.setEnabled(true);
            this.mDefineEventButton.setEnabled(false);
            this.mByFactorDefineButton.setEnabled(false);
        }
        if (focusEvent.getSource() == this.mByFactorList && this.mByFactorList.getModel().getSize() == 1) {
            this.mByFactorDefineButton.setEnabled(true);
            this.mDefineEventButton.setEnabled(false);
            this.mDefineRangeButton.setEnabled(false);
        }
        if (focusEvent.getSource() == this.mSrcVarList || focusEvent.getSource() == this.mTimeList) {
            this.mDefineEventButton.setEnabled(false);
            this.mDefineRangeButton.setEnabled(false);
            this.mByFactorDefineButton.setEnabled(false);
        }
        if (focusEvent.getSource().equals(this.mThroughTextField)) {
            this.mThroughTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mByTextField)) {
            this.mByTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (variableList.equals(this.mStatusList)) {
            this.getDialogDataModel().putBoolean("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE", null);
            this.getDialogDataModel().putString("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE", null);
            this.getDialogDataModel().putBoolean("IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE", null);
            this.getDialogDataModel().putString("IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE", null);
            this.getDialogDataModel().putString("IDS_LIFE_TABLES_DEFINE_EVENT_THROUGH", null);
        } else if (variableList.equals(this.mFactorList)) {
            dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM", null);
            dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM", null);
        } else if (variableList.equals(this.mByFactorList)) {
            dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM_1", null);
            dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM_1", null);
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setFocusTraversalPolicy(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mDefineEventButton.setEnabled(false);
        this.mDefineRangeButton.setEnabled(false);
        this.mByFactorDefineButton.setEnabled(false);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_LIFE_TABLES_OPTIONS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LifeTablesDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        this.mIsBootstrapOK = false;
        if (this.mIsBootstrapOK) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON_CROSS_TABLE"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LifeTablesDlg.this.runSubDialog(new BootstrapDlg(LifeTablesDlg.this));
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        sStatusValueEntered = true;
        sFactorValueEntered = true;
        sFactorByValueEntered = true;
        this.enableOkPaste(this.canEnableOkPaste());
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mTimeList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTimeList.setIdentifier(TIME_LIST);
        this.mTimeList.addVarFilter(spssVarFilter);
        this.mTimeList.getModel().addListDataListener(this);
        this.mTimeList.addFocusListener(this);
        this.mStatusList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mStatusList.setIdentifier(STATUS_LIST);
        this.mStatusList.addVarFilter(spssVarFilter);
        this.mStatusList.getModel().addListDataListener(this);
        this.mStatusList.addFocusListener(this);
        this.mFactorList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mFactorList.setIdentifier(FACTOR_LIST);
        this.mFactorList.addVarFilter(spssVarFilter);
        this.mFactorList.getModel().addListDataListener(this);
        this.mFactorList.addFocusListener(this);
        this.mByFactorList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mByFactorList.setIdentifier(FACTOR_BY_LIST);
        this.mByFactorList.addVarFilter(spssVarFilter);
        this.mByFactorList.getModel().addListDataListener(this);
        this.mByFactorList.addFocusListener(this);
        this.mFormatter = new StatusListFormatter();
        this.mStatusList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        this.mFactorFormatter = new FactorListFormatter();
        this.mFactorList.setCellRenderer(new CustomVarListCellRenderer(this.mFactorFormatter));
        this.mFactorByFormatter = new FactorByListFormatter();
        this.mByFactorList.setCellRenderer(new CustomVarListCellRenderer(this.mFactorByFormatter));
        this.mTimeListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTimeListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTimeListArrow.registerVariableList(this.mTimeList, SpssArrowButton.ButtonOrientation.left);
        this.mVarMoveHandler = this;
        this.mStatusListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStatusListArrow.setVarMoveHandler(this.mVarMoveHandler);
        this.mStatusListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mStatusListArrow.registerVariableList(this.mStatusList, SpssArrowButton.ButtonOrientation.left);
        this.mFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorListArrow.setVarMoveHandler(this.mVarMoveHandler);
        this.mFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorListArrow.registerVariableList(this.mFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mByFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mByFactorListArrow.setVarMoveHandler(this.mVarMoveHandler);
        this.mByFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mByFactorListArrow.registerVariableList(this.mByFactorList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_LIFE_TABLES_DEFINE_EVENT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LifeTablesDlg.this.runSubDialog(new LifeTablesDefineEvent(LifeTablesDlg.this));
                String string = LifeTablesDlg.this.mFormatter.getDisplayText(LifeTablesDlg.this.mStatusList.getModel().getElementAt(0));
                if (string.contains("?")) {
                    sStatusValueEntered = false;
                    LifeTablesDlg.this.enableOkPaste(LifeTablesDlg.this.canEnableOkPaste());
                } else {
                    sStatusValueEntered = true;
                    LifeTablesDlg.this.enableOkPaste(LifeTablesDlg.this.canEnableOkPaste());
                }
                LifeTablesDlg.this.mStatusList.repaint();
            }
        };
        this.mDefineEventButton = new JButton(toggleButtonAction);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, "IDS_LIFE_TABLES_DEFINE_RANGE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LifeTablesDlg.this.getDialogDataModel().putBoolean("IDS_BUTTON", true);
                LifeTablesDlg.this.runSubDialog(new AnalyzeDefineRange(LifeTablesDlg.this, LifeTablesDlg.this.getResString("IDS_LIFE_TABLES_FACTOR_DEFINE_RANGE_TITLE"), "idh_surv_def_rang", -999, 9999, false, false, false));
                String string = LifeTablesDlg.this.mFactorFormatter.getDisplayText(LifeTablesDlg.this.mFactorList.getModel().getElementAt(0));
                if (string.contains("?")) {
                    sFactorValueEntered = false;
                    LifeTablesDlg.this.enableOkPaste(LifeTablesDlg.this.canEnableOkPaste());
                } else {
                    sFactorValueEntered = true;
                    LifeTablesDlg.this.enableOkPaste(LifeTablesDlg.this.canEnableOkPaste());
                }
                LifeTablesDlg.this.mFactorList.repaint();
            }
        };
        this.mDefineRangeButton = new JButton(toggleButtonAction2);
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, "IDS_LIFE_TABLES_BY_FACTOR_DEFINE_RANGE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LifeTablesDlg.this.getDialogDataModel().putBoolean("IDS_BUTTON", false);
                LifeTablesDlg.this.runSubDialog(new AnalyzeDefineRange(LifeTablesDlg.this, LifeTablesDlg.this.getResString("IDS_LIFE_TABLES_FACTOR_DEFINE_RANGE_TITLE"), "idh_surv_def_rang", -999, 9999, false, false, false));
                String string = LifeTablesDlg.this.mFactorByFormatter.getDisplayText(LifeTablesDlg.this.mByFactorList.getModel().getElementAt(0));
                if (string.contains("?")) {
                    sFactorByValueEntered = false;
                    LifeTablesDlg.this.enableOkPaste(LifeTablesDlg.this.canEnableOkPaste());
                } else {
                    sFactorByValueEntered = true;
                    LifeTablesDlg.this.enableOkPaste(LifeTablesDlg.this.canEnableOkPaste());
                }
                LifeTablesDlg.this.mByFactorList.repaint();
            }
        };
        this.mByFactorDefineButton = new JButton(toggleButtonAction3);
        this.mThroughTextField = new FloatTextField(1.0E-4, 99999.0, 4, true);
        this.mThroughTextField.setColumns(6);
        TextFieldAction textFieldAction = new TextFieldAction(this, "IDS_LIFE_TABLES_THROUGH");
        this.mThroughTextField.setAction((Action)textFieldAction);
        this.mThroughTextField.getDocument().addDocumentListener(this);
        this.mThroughTextField.addFocusListener((FocusListener)this);
        this.mByTextField = new FloatTextField(1.0E-4, 99999.0, 4, true);
        this.mByTextField.setColumns(6);
        textFieldAction = new TextFieldAction(this, "IDS_LIFE_TABLES_BY");
        this.mByTextField.setAction((Action)textFieldAction);
        this.mByTextField.getDocument().addDocumentListener(this);
        this.mByTextField.addFocusListener((FocusListener)this);
        this.mGridConstraints = new GridBagConstraints();
    }

    private JPanel setupDisplayTimePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LIFE_TABLES_OPTIONS_DISPLAY_TIME_INTERVAL")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_THROUGH");
        jLabel.setLabelFor((Component)this.mThroughTextField);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_BY");
        jLabel2.setLabelFor((Component)this.mByTextField);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        Insets insets2 = new Insets(n, n, 0, 0);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 2, 0, 1, 1, n2, insets2);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weightx = 1.0;
        insets2.set(insets.left, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThroughTextField, this.mGridConstraints, 3, 0, 1, 1, n2, insets2);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.fill = 0;
        insets2.set(n, n * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mGridConstraints, 4, 0, 1, 1, n2, insets2);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weightx = 1.0;
        insets2.set(insets.left, n, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mByTextField, this.mGridConstraints, 5, 0, 1, 1, n2, insets2);
        return jPanel;
    }

    private void setupViewPanel(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mTimeList);
        jScrollPane2.setPreferredSize(this.mTimeList.getMinimumSize());
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_BY_FACTOR");
        jLabel.setLabelFor(this.mByFactorList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_FACTOR");
        jLabel2.setLabelFor(this.mFactorList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_STATUS");
        jLabel3.setLabelFor(this.mStatusList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_TIME");
        jLabel4.setLabelFor(this.mTimeList);
        JScrollPane jScrollPane3 = new JScrollPane(this.mByFactorList);
        jScrollPane3.setPreferredSize(this.mByFactorList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane4 = new JScrollPane(this.mStatusList);
        jScrollPane4.setPreferredSize(this.mStatusList.getMinimumSize());
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane5 = new JScrollPane(this.mFactorList);
        jScrollPane5.setPreferredSize(this.mFactorList.getMinimumSize());
        jScrollPane5.setHorizontalScrollBarPolicy(31);
        jScrollPane5.setVerticalScrollBarPolicy(21);
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        int n3 = 23;
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_SRCLIST_LABEL");
        jLabel5.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel5, this.mGridConstraints, 0, 0, 1, 1, n3, null);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mGridConstraints, 0, 1, 1, 10, n3, null);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        n3 = 20;
        this.mGridConstraints.fill = 0;
        Insets insets3 = new Insets(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTimeListArrow, this.mGridConstraints, 1, 0, 1, 2, n3, insets3);
        this.mGridConstraints.weightx = 1.0;
        n3 = 23;
        this.mGridConstraints.fill = 2;
        insets3.set(0, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel4, this.mGridConstraints, 2, 0, 1, 1, n3, insets3);
        insets3.set(0, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, this.mGridConstraints, 2, 1, 1, 1, n3, insets3);
        JPanel jPanel2 = this.setupDisplayTimePanel();
        this.mGridConstraints.fill = 1;
        this.mGridConstraints.weighty = 1.0;
        insets3.set(n2, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 1, 2, 2, 1, n3, insets3);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        n3 = 20;
        this.mGridConstraints.fill = 0;
        insets3.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStatusListArrow, this.mGridConstraints, 1, 3, 1, 2, n3, insets3);
        this.mGridConstraints.weightx = 1.0;
        n3 = 23;
        this.mGridConstraints.fill = 2;
        insets3.set(n2, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel3, this.mGridConstraints, 2, 3, 1, 1, n3, insets3);
        insets3.set(0, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, this.mGridConstraints, 2, 4, 1, 1, n3, insets3);
        this.mGridConstraints.fill = 0;
        insets3.set(insets2.left, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mDefineEventButton, this.mGridConstraints, 2, 5, 1, 1, n3, insets3);
        n3 = 20;
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.fill = 0;
        insets3.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFactorListArrow, this.mGridConstraints, 1, 6, 1, 2, n3, insets3);
        this.mGridConstraints.weightx = 1.0;
        n3 = 23;
        this.mGridConstraints.fill = 2;
        insets3.set(n2, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mGridConstraints, 2, 6, 1, 1, n3, insets3);
        insets3.set(0, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane5, this.mGridConstraints, 2, 7, 1, 1, n3, insets3);
        this.mGridConstraints.fill = 0;
        insets3.set(insets2.left, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mDefineRangeButton, this.mGridConstraints, 2, 8, 1, 1, n3, insets3);
        n3 = 20;
        this.mGridConstraints.weightx = 0.0;
        insets3.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mByFactorListArrow, this.mGridConstraints, 1, 9, 1, 2, n3, insets3);
        this.mGridConstraints.weightx = 1.0;
        n3 = 23;
        this.mGridConstraints.fill = 2;
        insets3.set(n2, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 2, 9, 1, 1, n3, insets3);
        insets3.set(0, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, this.mGridConstraints, 2, 10, 1, 1, n3, insets3);
        insets3.set(insets2.left, insets.left, 0, n);
        this.mGridConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mByFactorDefineButton, this.mGridConstraints, 2, 11, 1, 1, n3, insets3);
    }

    private void runOptionsSubDialog() {
        if (this.mFactorList.getModel().getSize() == 1 || this.mByFactorList.getModel().getSize() == 1) {
            this.getDialogDataModel().putBoolean("TARGET_SIZE", true);
        } else {
            this.getDialogDataModel().putBoolean("TARGET_SIZE", false);
        }
        this.runSubDialog(new LifeTablesOptions(this));
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTimeListArrow);
        vector.add(this.mStatusListArrow);
        vector.add(this.mFactorListArrow);
        vector.add(this.mByFactorListArrow);
        vector.add(this.mTimeList);
        vector.add(this.mThroughTextField);
        vector.add(this.mByTextField);
        vector.add(this.mStatusList);
        vector.add(this.mDefineEventButton);
        vector.add(this.mFactorList);
        vector.add(this.mDefineRangeButton);
        vector.add(this.mByFactorList);
        vector.add(this.mByFactorDefineButton);
        vector.add(this.mOptionsButton);
        if (VersionInfo.allowBootstrapping()) {
            vector.add(this.mBootstrappingButton);
        }
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private String addLocale(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string;
            if (this.mSymbol.getDecimalSeparator() != '.') {
                string2 = string.replace('.', this.mSymbol.getDecimalSeparator());
            }
            if (this.mSymbol.getMinusSign() != '-') {
                string2 = string2.replace('-', this.mSymbol.getMinusSign());
            }
            string2 = string2.trim();
        }
        return string2;
    }

    class FactorByListFormatter
    implements ISpssVarFormatter {
        FactorByListFormatter() {
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            DialogDataModel dialogDataModel = LifeTablesDlg.this.getDialogDataModel();
            String string = dialogDataModel.getString("IDS_DEFINE_RANGE_MINIMUM_1");
            String string2 = dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM_1");
            string2 = LifeTablesDlg.this.addLocale(string2);
            if ((string = LifeTablesDlg.this.addLocale(string)) != null && string2 != null) {
                return iSpssVariable.getName() + "(" + string + " " + string2 + ")";
            }
            return iSpssVariable.getName() + "(? ?)";
        }

        @Override
        public boolean getShowIcons() {
            return false;
        }

        @Override
        public TargetVariableList getVarList() {
            return LifeTablesDlg.this.mByFactorList;
        }
    }

    class FactorListFormatter
    implements ISpssVarFormatter {
        FactorListFormatter() {
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            DialogDataModel dialogDataModel = LifeTablesDlg.this.getDialogDataModel();
            String string = dialogDataModel.getString("IDS_DEFINE_RANGE_MINIMUM");
            String string2 = dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM");
            string2 = LifeTablesDlg.this.addLocale(string2);
            if ((string = LifeTablesDlg.this.addLocale(string)) != null && string2 != null) {
                return iSpssVariable.getName() + "(" + string + " " + string2 + ")";
            }
            return iSpssVariable.getName() + "(? ?)";
        }

        @Override
        public boolean getShowIcons() {
            return false;
        }

        @Override
        public TargetVariableList getVarList() {
            return LifeTablesDlg.this.mFactorList;
        }
    }

    class StatusListFormatter
    implements ISpssVarFormatter {
        StatusListFormatter() {
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            DialogDataModel dialogDataModel = LifeTablesDlg.this.getDialogDataModel();
            Boolean bl = dialogDataModel.getBoolean("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE");
            Boolean bl2 = dialogDataModel.getBoolean("IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE");
            String string = dialogDataModel.getString("IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE");
            String string2 = dialogDataModel.getString("IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE");
            String string3 = dialogDataModel.getString("IDS_LIFE_TABLES_DEFINE_EVENT_THROUGH");
            string3 = LifeTablesDlg.this.addLocale(string3);
            string2 = LifeTablesDlg.this.addLocale(string2);
            string = LifeTablesDlg.this.addLocale(string);
            if (bl != null && bl.booleanValue()) {
                return iSpssVariable.getName() + "(" + string + ")";
            }
            if (bl2 != null && bl2.booleanValue()) {
                return iSpssVariable.getName() + "(" + string2 + " " + string3 + ")";
            }
            return iSpssVariable.getName() + "(? ?)";
        }

        @Override
        public boolean getShowIcons() {
            return false;
        }

        @Override
        public TargetVariableList getVarList() {
            return LifeTablesDlg.this.mStatusList;
        }
    }
}

